/*
 * Copyright (C) 2013 Mentor Graphics, Inc. All Rights Reserved.
 * Copyright 2008-2012 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */

#ifndef __MXC_ASRC_CORE_H__
#define __MXC_ASRC_CORE_H__

#include <linux/types.h>

#define MAX_BUFFER	(1024*1024) /* 1MB */

#define ASRC_MAX_CLKNAME_LEN 30

typedef int __bitwise asrc_format_t;
/* note: These formats are correlated to asound.h for alsa compatibility */
#define	ASRC_SND_FORMAT_S8	((asrc_format_t) 0)
#define	ASRC_SND_FORMAT_S16_LE	((asrc_format_t) 2)
#define	ASRC_SND_FORMAT_S24_LE	((asrc_format_t) 6)
#define	ASRC_SND_FORMAT_S32_LE	((asrc_format_t) 10)

#define _ASRC_FMTBIT(fmt)	(1ULL << (int)ASRC_SND_FORMAT_##fmt)
#define ASRC_FMTBIT_S8		_ASRC_FMTBIT(S8)
#define ASRC_FMTBIT_S16_LE	_ASRC_FMTBIT(S16_LE)
#define ASRC_FMTBIT_S24_LE	_ASRC_FMTBIT(S24_LE)
#define ASRC_FMTBIT_S32_LE	_ASRC_FMTBIT(S32_LE)

/* the order is important for assigning the irq request # */
enum asrc_section_direction {
	SECTION_OUTPUT = 0,
	SECTION_INPUT,
	SECTION_CNT
};

enum filter_settings {
	FILT_START = 0,
	FILT_TABLE = 0,
	FILT_FORMULA,
	UP2_UP2,
	UP2_DIRECT,
	UP2_DOWN2,
	DIRECT_UP2,
	DIRECT_DIRECT,
	DIRECT_DOWN2,
	DOWN2_UP2,
	DOWN2_DIRECT,
	DOWN2_DOWN2,
	PASSTHROUGH,
	FILT_CNT
};

/* note if states updated update string names in c file */
enum asrc_section_state {
	SECTION_STATE_TOP,
	SECTION_CLOSED,
	SECTION_OPENED,
	SECTION_SETUP,
	SECTION_PREPARE,
	SECTION_READY,
	SECTION_RUN,
	SECTION_SOFT_XRUN,
	SECTION_HARD_XRUN,
	SECTION_IRQ_ERR,
	SECTION_STATE_BOT
};

struct section_config {
	unsigned int rate;
	unsigned int channels;
	__u64 format;
};

struct asrc_section_capabilities {
	__u64 formats;				/* ASRC_SND_FORMAT */
	unsigned int rate_min;		/* min rate */
	unsigned int rate_max;		/* max rate */
	unsigned int channels_min;	/* min channels */
	unsigned int channels_max;	/* max channels */
};

struct buffer_capabilities {
	unsigned long bufbytes_min;
	unsigned long bufbytes_max;
	unsigned int periodbytes_min;
	unsigned int periodbytes_max;
	unsigned int periods_min;
	unsigned int periods_max;
};

struct asrc_req {
	unsigned char pair_mask;
	int uid;
};

#endif				/* __MXC_ASRC_CORE_H__ */
