/**
* \file: bdclErrorCodes.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Baidu CarLife
*
* \author: P. Govindaraju / RBEB/GM / Pradeepa.Govindaraju@in.bosch.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef PLATFORM_BDCL_ADIT_COMMON_BDCL_COMMON_INCLUDE_BDCLERRORCODES_H_
#define PLATFORM_BDCL_ADIT_COMMON_BDCL_COMMON_INCLUDE_BDCLERRORCODES_H_

namespace adit { namespace bdcl {

/**
 * @brief defined error values to notify upper layer in case of an error.
 * */
enum bdclErrorCodes {
    /* Audio Errors */
    AUDIO_SINK_CONFIGURATION_ERROR  = 101,
    AUDIO_SINK_START_ERROR          = 102,
    AUDIO_SINK_WRITE_ERROR          = 103,
    AUDIO_SOURCE_READ_ERROR         = 151,
    /* Video Errors */
    VIDEO_SINK_CONFIGURATION_ERROR  = 201,
    VIDEO_SINK_START_ERROR          = 202,
    VIDEO_SINK_RENDER_ERROR         = 203,
    /* Input Touch Errors */
    ATTACHED_TOUCH_INIT_ERROR       = 301,
    INPUT_EVENT_DISPATCH_ERROR      = 302,
    /* AOAP Errors */
    AOAP_NO_ERROR                   = 400,
    AOAP_IO_ERROR                   = 401,
    AOAP_INVALID_PARAM_ERROR        = 402,
    AOAP_ACCESS_ERROR               = 403,
    AOAP_NO_DEVICE_ERROR            = 404,
    AOAP_NOT_FOUND_ERROR            = 405,
    AOAP_BUSY_ERROR                 = 406,
    AOAP_TIMEOUT_ERROR              = 407,
    AOAP_OVERFLOW_ERROR             = 408,
    AOAP_PIPE_ERROR                 = 409,
    AOAP_INTERRUPTED_ERROR          = 410,
    AOAP_NO_MEM_ERROR               = 411,
    AOAP_NOT_SUPPORTED_ERROR        = 412,
    AOAP_READ_TIMEOUT_ERROR         = 413,
    AOAP_WRITE_TIMEOUT_ERROR        = 414
};

enum carlifeConnectException {
    TYPE_ENCORDER_ERROR = 1,
    TYPE_PERMISSION_DENIED = 2,
    TYPE_SCREENSHARE_REQUEST =3,
};

// todo merge with BdclErrorCodes
/** @enum bdclInitStatus
 *  @brief error value to send when MC calls the Init function
 *
 */
typedef enum
{
    BDCLInit_NoError             =  0,
    BDCLInit_HUVersionError      = -1,
    BDCLInit_StatisticInfoError  = -2,
    BDCLInit_TimeoutError        = -3,
    BDCLInit_ParamError          = -4,
    BDCLInit_NoMemory            = -5,
    BDCLInit_FileIOError         = -6,
    BDCLInit_HBThreadFail        = -7,
    BDCLInit_EAEndpointError     = -8,
}bdclInitStatus;

} } /* namespace adit { namespace bdcl { */




#endif /* PLATFORM_BDCL_ADIT_COMMON_BDCL_COMMON_INCLUDE_BDCLERRORCODES_H_ */
