#ifndef PLATFORM_BAIDU_BAIDU_CORE_INCLUDE_IPROTOCOLSOCKETCONNECTOR_H_
#define PLATFORM_BAIDU_BAIDU_CORE_INCLUDE_IPROTOCOLSOCKETCONNECTOR_H_

#include <queue>
#include <mutex>              // std::mutex, std::unique_lock
#include <condition_variable> // std::condition_variable
#include "CommonUtil.h"

class IProtocolSocketConnector{

public:
	virtual ~IProtocolSocketConnector() {};

    // Client initialization
    virtual bool connect (int ingAccId, int inDevId) = 0;

    // Data Transimission
    virtual bool send(u8* data, u32 len, int inChannelId) = 0;

    virtual bool getData(u32 inLen, u8 inChannelId, u8* outData) = 0;

    virtual void wakeupThreads(){}; // modified by ADIT
};


#endif /* PLATFORM_BAIDU_BAIDU_CORE_INCLUDE_IPROTOCOLSOCKETCONNECTOR_H_ */
