/*******************************************************************************//**
 * \file iap2_parameter_free.h
 * \brief iAP2 Control session, freeing of parameters
 *
 * \version $ $
 *
 * This header file declares functions required for freeing the memory 
 * allocated while parsing the parameters.
 *
 * \component global definition file
 *
 * \author Konrad Gerhards/ADITG/ kgerhards@de.adit-jv.com
 *
 * \copyright (c) 2010 - 2016 ADIT Corporation
 *
 * \warning CAUTION: CODES IN THIS FILE ARE AUTOMATCALLY GENERATED BY ENTERPRISE ARCHITECHT,
 *          DO NOT CHANGE THE CODE MANUALLY
 **********************************************************************************/

#ifndef IAP2_PARAMETER_FREE_H
#define IAP2_PARAMETER_FREE_H

#ifdef __cplusplus
extern "C" {
#endif

#include "iap2_init.h"

/**
 * \addtogroup ControlSessionFreeAPIs
 * @{
 */

 /***************************************************************************//**
 * Free iAP2AccessoryAuthenticationSerialNumberParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2AccessoryAuthenticationSerialNumberParameter structure once AccessoryAuthenticationSerialNumber message is sent to device
 * 
 * \param[in] theiAP2AccessoryAuthenticationSerialNumberParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2AccessoryAuthenticationSerialNumberParameter(iAP2AccessoryAuthenticationSerialNumberParameter* theiAP2AccessoryAuthenticationSerialNumberParameter);

 /***************************************************************************//**
 * Free iAP2AuthenticationCertificateParameter structure
 * 
 * Control Session Library must call this API to de-allocate 
 * iAP2AuthenticationCertificateParameter structure once AuthenticationCertificate message is sent to device
 * 
 * \param[in] theiAP2AuthenticationCertificateParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2AuthenticationCertificateParameter(iAP2AuthenticationCertificateParameter* theiAP2AuthenticationCertificateParameter);

 /***************************************************************************//**
 * Free iAP2AuthenticationResponseParameter structure
 * 
 * Control Session Library must call this API to de-allocate 
 * iAP2AuthenticationResponseParameter structure once AuthenticationResponse message is sent to device
 * 
 * \param[in] theiAP2AuthenticationResponseParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2AuthenticationResponseParameter(iAP2AuthenticationResponseParameter* theiAP2AuthenticationResponseParameter);

 /***************************************************************************//**
 * Free iAP2IdentificationInformationParameter structure
 * 
 * Control Session Library must call this API to de-allocate 
 * iAP2IdentificationInformationParameter structure once IdentificationInformation message is sent to device
 * 
 * \param[in] theiAP2IdentificationInformationParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2IdentificationInformationParameter(iAP2IdentificationInformationParameter* theiAP2IdentificationInformationParameter);

 /***************************************************************************//**
 * Free iAP2IdentificationInformationUpdateParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2IdentificationInformationUpdateParameter structure once IdentificationInformationUpdate message is sent to device
 * 
 * \param[in] theiAP2IdentificationInformationUpdateParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2IdentificationInformationUpdateParameter(iAP2IdentificationInformationUpdateParameter* theiAP2IdentificationInformationUpdateParameter);

 /***************************************************************************//**
 * Free iAP2RequestAppLaunchParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2RequestAppLaunchParameter structure once RequestAppLaunch message is sent to device
 * 
 * \param[in] theiAP2RequestAppLaunchParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2RequestAppLaunchParameter(iAP2RequestAppLaunchParameter* theiAP2RequestAppLaunchParameter);

 /***************************************************************************//**
 * Free iAP2OOBBTPairingAccessoryInformationParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2OOBBTPairingAccessoryInformationParameter structure once OOBBTPairingAccessoryInformation message is sent to device
 * 
 * \param[in] theiAP2OOBBTPairingAccessoryInformationParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2OOBBTPairingAccessoryInformationParameter(iAP2OOBBTPairingAccessoryInformationParameter* theiAP2OOBBTPairingAccessoryInformationParameter);

 /***************************************************************************//**
 * Free iAP2OOBBTPairingCompletionInformationParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2OOBBTPairingCompletionInformationParameter structure once OOBBTPairingCompletionInformation message is sent to device
 * 
 * \param[in] theiAP2OOBBTPairingCompletionInformationParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2OOBBTPairingCompletionInformationParameter(iAP2OOBBTPairingCompletionInformationParameter* theiAP2OOBBTPairingCompletionInformationParameter);

 /***************************************************************************//**
 * Free iAP2StartRouteGuidanceUpdateParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2StartRouteGuidanceUpdateParameter structure once StartRouteGuidanceUpdate message is sent to device
 * 
 * \param[in] theiAP2StartRouteGuidanceUpdateParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2StartRouteGuidanceUpdateParameter(iAP2StartRouteGuidanceUpdateParameter* theiAP2StartRouteGuidanceUpdateParameter);

 /***************************************************************************//**
 * Free iAP2StopRouteGuidanceUpdateParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2StopRouteGuidanceUpdateParameter structure once StopRouteGuidanceUpdate message is sent to device
 * 
 * \param[in] theiAP2StopRouteGuidanceUpdateParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2StopRouteGuidanceUpdateParameter(iAP2StopRouteGuidanceUpdateParameter* theiAP2StopRouteGuidanceUpdateParameter);

 /***************************************************************************//**
 * Free iAP2BluetoothComponentInformationParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2BluetoothComponentInformationParameter structure once BluetoothComponentInformation message is sent to device
 * 
 * \param[in] theiAP2BluetoothComponentInformationParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2BluetoothComponentInformationParameter(iAP2BluetoothComponentInformationParameter* theiAP2BluetoothComponentInformationParameter);

 /***************************************************************************//**
 * Free iAP2BluetoothConnectionUpdateParameter structure
 * 
 * iAP2 Library must call this API to de-allocate 
 * iAP2BluetoothConnectionUpdateParameter structure once BluetoothConnectionUpdate message received from device
 * 
 * \param[in] theiAP2BluetoothConnectionUpdateParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2BluetoothConnectionUpdateParameter(iAP2BluetoothConnectionUpdateParameter* theiAP2BluetoothConnectionUpdateParameter);

 /***************************************************************************//**
 * Free iAP2StartBluetoothConnectionUpdatesParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2StartBluetoothConnectionUpdatesParameter structure once StartBluetoothConnectionUpdates message is sent to device
 * 
 * \param[in] theiAP2StartBluetoothConnectionUpdatesParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2StartBluetoothConnectionUpdatesParameter(iAP2StartBluetoothConnectionUpdatesParameter* theiAP2StartBluetoothConnectionUpdatesParameter);

 /***************************************************************************//**
 * Free iAP2AcceptCallParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2AcceptCallParameter structure once AcceptCall message is sent to device
 * 
 * \param[in] theiAP2AcceptCallParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2AcceptCallParameter(iAP2AcceptCallParameter* theiAP2AcceptCallParameter);

 /***************************************************************************//**
 * Free iAP2EndCallParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2EndCallParameter structure once EndCall message is sent to device
 * 
 * \param[in] theiAP2EndCallParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2EndCallParameter(iAP2EndCallParameter* theiAP2EndCallParameter);

 /***************************************************************************//**
 * Free iAP2HoldStatusUpdateParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2HoldStatusUpdateParameter structure once HoldStatusUpdate message is sent to device
 * 
 * \param[in] theiAP2HoldStatusUpdateParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2HoldStatusUpdateParameter(iAP2HoldStatusUpdateParameter* theiAP2HoldStatusUpdateParameter);

 /***************************************************************************//**
 * Free iAP2InitiateCallParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2InitiateCallParameter structure once InitiateCall message is sent to device
 * 
 * \param[in] theiAP2InitiateCallParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2InitiateCallParameter(iAP2InitiateCallParameter* theiAP2InitiateCallParameter);

 /***************************************************************************//**
 * Free iAP2ListUpdateParameter structure
 * 
 * iAP2 Library must call this API to de-allocate 
 * iAP2ListUpdateParameter structure once ListUpdate message received from device
 * 
 * \param[in] theiAP2ListUpdateParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2ListUpdateParameter(iAP2ListUpdateParameter* theiAP2ListUpdateParameter);

 /***************************************************************************//**
 * Free iAP2MuteStatusUpdateParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2MuteStatusUpdateParameter structure once MuteStatusUpdate message is sent to device
 * 
 * \param[in] theiAP2MuteStatusUpdateParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2MuteStatusUpdateParameter(iAP2MuteStatusUpdateParameter* theiAP2MuteStatusUpdateParameter);

 /***************************************************************************//**
 * Free iAP2SendDTMFParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2SendDTMFParameter structure once SendDTMF message is sent to device
 * 
 * \param[in] theiAP2SendDTMFParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2SendDTMFParameter(iAP2SendDTMFParameter* theiAP2SendDTMFParameter);

 /***************************************************************************//**
 * Free iAP2StartCallStateUpdatesParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2StartCallStateUpdatesParameter structure once StartCallStateUpdates message is sent to device
 * 
 * \param[in] theiAP2StartCallStateUpdatesParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2StartCallStateUpdatesParameter(iAP2StartCallStateUpdatesParameter* theiAP2StartCallStateUpdatesParameter);

 /***************************************************************************//**
 * Free iAP2StartCommunicationsUpdatesParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2StartCommunicationsUpdatesParameter structure once StartCommunicationsUpdates message is sent to device
 * 
 * \param[in] theiAP2StartCommunicationsUpdatesParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2StartCommunicationsUpdatesParameter(iAP2StartCommunicationsUpdatesParameter* theiAP2StartCommunicationsUpdatesParameter);

 /***************************************************************************//**
 * Free iAP2StartListUpdatesParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2StartListUpdatesParameter structure once StartListUpdates message is sent to device
 * 
 * \param[in] theiAP2StartListUpdatesParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2StartListUpdatesParameter(iAP2StartListUpdatesParameter* theiAP2StartListUpdatesParameter);

 /***************************************************************************//**
 * Free iAP2RequestDeviceAuthenticationChallengeResponseParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2RequestDeviceAuthenticationChallengeResponseParameter structure once RequestDeviceAuthenticationChallengeResponse message is sent to device
 * 
 * \param[in] theiAP2RequestDeviceAuthenticationChallengeResponseParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2RequestDeviceAuthenticationChallengeResponseParameter(iAP2RequestDeviceAuthenticationChallengeResponseParameter* theiAP2RequestDeviceAuthenticationChallengeResponseParameter);

 /***************************************************************************//**
 * Free iAP2StatusExternalAccessoryProtocolSessionParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2StatusExternalAccessoryProtocolSessionParameter structure once StatusExternalAccessoryProtocolSession message is sent to device
 * 
 * \param[in] theiAP2StatusExternalAccessoryProtocolSessionParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2StatusExternalAccessoryProtocolSessionParameter(iAP2StatusExternalAccessoryProtocolSessionParameter* theiAP2StatusExternalAccessoryProtocolSessionParameter);

 /***************************************************************************//**
 * Free iAP2AccessoryHIDReportParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2AccessoryHIDReportParameter structure once AccessoryHIDReport message is sent to device
 * 
 * \param[in] theiAP2AccessoryHIDReportParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2AccessoryHIDReportParameter(iAP2AccessoryHIDReportParameter* theiAP2AccessoryHIDReportParameter);

 /***************************************************************************//**
 * Free iAP2StartHIDParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2StartHIDParameter structure once StartHID message is sent to device
 * 
 * \param[in] theiAP2StartHIDParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2StartHIDParameter(iAP2StartHIDParameter* theiAP2StartHIDParameter);

 /***************************************************************************//**
 * Free iAP2StopHIDParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2StopHIDParameter structure once StopHID message is sent to device
 * 
 * \param[in] theiAP2StopHIDParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2StopHIDParameter(iAP2StopHIDParameter* theiAP2StopHIDParameter);

 /***************************************************************************//**
 * Free iAP2LocationInformationParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2LocationInformationParameter structure once LocationInformation message is sent to device
 * 
 * \param[in] theiAP2LocationInformationParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2LocationInformationParameter(iAP2LocationInformationParameter* theiAP2LocationInformationParameter);

 /***************************************************************************//**
 * Free iAP2MediaLibraryInformationParameter structure
 * 
 * iAP2 Library must call this API to de-allocate 
 * iAP2MediaLibraryInformationParameter structure once MediaLibraryInformation message received from device
 * 
 * \param[in] theiAP2MediaLibraryInformationParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2MediaLibraryInformationParameter(iAP2MediaLibraryInformationParameter* theiAP2MediaLibraryInformationParameter);

 /***************************************************************************//**
 * Free iAP2MediaLibraryUpdateParameter structure
 * 
 * iAP2 Library must call this API to de-allocate 
 * iAP2MediaLibraryUpdateParameter structure once MediaLibraryUpdate message received from device
 * 
 * \param[in] theiAP2MediaLibraryUpdateParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2MediaLibraryUpdateParameter(iAP2MediaLibraryUpdateParameter* theiAP2MediaLibraryUpdateParameter);

 /***************************************************************************//**
 * Free iAP2PlayMediaLibraryCollectionParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2PlayMediaLibraryCollectionParameter structure once PlayMediaLibraryCollection message is sent to device
 * 
 * \param[in] theiAP2PlayMediaLibraryCollectionParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2PlayMediaLibraryCollectionParameter(iAP2PlayMediaLibraryCollectionParameter* theiAP2PlayMediaLibraryCollectionParameter);

 /***************************************************************************//**
 * Free iAP2PlayMediaLibraryCurrentSelectionParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2PlayMediaLibraryCurrentSelectionParameter structure once PlayMediaLibraryCurrentSelection message is sent to device
 * 
 * \param[in] theiAP2PlayMediaLibraryCurrentSelectionParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2PlayMediaLibraryCurrentSelectionParameter(iAP2PlayMediaLibraryCurrentSelectionParameter* theiAP2PlayMediaLibraryCurrentSelectionParameter);

 /***************************************************************************//**
 * Free iAP2PlayMediaLibraryItemsParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2PlayMediaLibraryItemsParameter structure once PlayMediaLibraryItems message is sent to device
 * 
 * \param[in] theiAP2PlayMediaLibraryItemsParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2PlayMediaLibraryItemsParameter(iAP2PlayMediaLibraryItemsParameter* theiAP2PlayMediaLibraryItemsParameter);

 /***************************************************************************//**
 * Free iAP2PlayMediaLibrarySpecialParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2PlayMediaLibrarySpecialParameter structure once PlayMediaLibrarySpecial message is sent to device
 * 
 * \param[in] theiAP2PlayMediaLibrarySpecialParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2PlayMediaLibrarySpecialParameter(iAP2PlayMediaLibrarySpecialParameter* theiAP2PlayMediaLibrarySpecialParameter);

 /***************************************************************************//**
 * Free iAP2StartMediaLibraryUpdatesParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2StartMediaLibraryUpdatesParameter structure once StartMediaLibraryUpdates message is sent to device
 * 
 * \param[in] theiAP2StartMediaLibraryUpdatesParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2StartMediaLibraryUpdatesParameter(iAP2StartMediaLibraryUpdatesParameter* theiAP2StartMediaLibraryUpdatesParameter);

 /***************************************************************************//**
 * Free iAP2StopMediaLibraryUpdatesParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2StopMediaLibraryUpdatesParameter structure once StopMediaLibraryUpdates message is sent to device
 * 
 * \param[in] theiAP2StopMediaLibraryUpdatesParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2StopMediaLibraryUpdatesParameter(iAP2StopMediaLibraryUpdatesParameter* theiAP2StopMediaLibraryUpdatesParameter);

 /***************************************************************************//**
 * Free iAP2NowPlayingUpdateParameter structure
 * 
 * iAP2 Library must call this API to de-allocate 
 * iAP2NowPlayingUpdateParameter structure once NowPlayingUpdate message received from device
 * 
 * \param[in] theiAP2NowPlayingUpdateParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2NowPlayingUpdateParameter(iAP2NowPlayingUpdateParameter* theiAP2NowPlayingUpdateParameter);

 /***************************************************************************//**
 * Free iAP2SetNowPlayingInformationParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2SetNowPlayingInformationParameter structure once SetNowPlayingInformation message is sent to device
 * 
 * \param[in] theiAP2SetNowPlayingInformationParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2SetNowPlayingInformationParameter(iAP2SetNowPlayingInformationParameter* theiAP2SetNowPlayingInformationParameter);

 /***************************************************************************//**
 * Free iAP2StartNowPlayingUpdatesParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2StartNowPlayingUpdatesParameter structure once StartNowPlayingUpdates message is sent to device
 * 
 * \param[in] theiAP2StartNowPlayingUpdatesParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2StartNowPlayingUpdatesParameter(iAP2StartNowPlayingUpdatesParameter* theiAP2StartNowPlayingUpdatesParameter);

 /***************************************************************************//**
 * Free iAP2PowerSourceUpdateParameter structure
 * 
 * Control Session Library must call this API to de-allocate 
 * iAP2PowerSourceUpdateParameter structure once PowerSourceUpdate message is sent to device
 * 
 * \param[in] theiAP2PowerSourceUpdateParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2PowerSourceUpdateParameter(iAP2PowerSourceUpdateParameter* theiAP2PowerSourceUpdateParameter);

 /***************************************************************************//**
 * Free iAP2StartPowerUpdatesParameter structure
 * 
 * Control Session Library must call this API to de-allocate 
 * iAP2StartPowerUpdatesParameter structure once StartPowerUpdates message is sent to device
 * 
 * \param[in] theiAP2StartPowerUpdatesParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2StartPowerUpdatesParameter(iAP2StartPowerUpdatesParameter* theiAP2StartPowerUpdatesParameter);

 /***************************************************************************//**
 * Free iAP2StartTelephonyCallStateInformationParameter structure
 * CAUTION: The structure iAP2StartTelephonyCallStateInformationParameter is Deprecated, Don't use it. Kindly refer the Apple Specificaiton.
 * 
 * Application must call this API to de-allocate 
 * iAP2StartTelephonyCallStateInformationParameter structure once StartTelephonyCallStateInformation message is sent to device
 * 
 * \param[in] theiAP2StartTelephonyCallStateInformationParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2StartTelephonyCallStateInformationParameter(iAP2StartTelephonyCallStateInformationParameter* theiAP2StartTelephonyCallStateInformationParameter);

 /***************************************************************************//**
 * Free iAP2StartTelephonyUpdatesParameter structure
 * CAUTION: The structure iAP2StartTelephonyUpdatesParameter is Deprecated, Don't use it. Kindly refer the Apple Specificaiton.
 * 
 * Application must call this API to de-allocate 
 * iAP2StartTelephonyUpdatesParameter structure once StartTelephonyUpdates message is sent to device
 * 
 * \param[in] theiAP2StartTelephonyUpdatesParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2StartTelephonyUpdatesParameter(iAP2StartTelephonyUpdatesParameter* theiAP2StartTelephonyUpdatesParameter);

 /***************************************************************************//**
 * Free iAP2VehicleStatusUpdateParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2VehicleStatusUpdateParameter structure once VehicleStatusUpdate message is sent to device
 * 
 * \param[in] theiAP2VehicleStatusUpdateParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2VehicleStatusUpdateParameter(iAP2VehicleStatusUpdateParameter* theiAP2VehicleStatusUpdateParameter);

 /***************************************************************************//**
 * Free iAP2RequestVoiceOverConfigurationParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2RequestVoiceOverConfigurationParameter structure once RequestVoiceOverConfiguration message is sent to device
 * 
 * \param[in] theiAP2RequestVoiceOverConfigurationParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2RequestVoiceOverConfigurationParameter(iAP2RequestVoiceOverConfigurationParameter* theiAP2RequestVoiceOverConfigurationParameter);

 /***************************************************************************//**
 * Free iAP2RequestVoiceOverMoveCursorParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2RequestVoiceOverMoveCursorParameter structure once RequestVoiceOverMoveCursor message is sent to device
 * 
 * \param[in] theiAP2RequestVoiceOverMoveCursorParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2RequestVoiceOverMoveCursorParameter(iAP2RequestVoiceOverMoveCursorParameter* theiAP2RequestVoiceOverMoveCursorParameter);

 /***************************************************************************//**
 * Free iAP2RequestVoiceOverScrollPageParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2RequestVoiceOverScrollPageParameter structure once RequestVoiceOverScrollPage message is sent to device
 * 
 * \param[in] theiAP2RequestVoiceOverScrollPageParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2RequestVoiceOverScrollPageParameter(iAP2RequestVoiceOverScrollPageParameter* theiAP2RequestVoiceOverScrollPageParameter);

 /***************************************************************************//**
 * Free iAP2RequestVoiceOverSpeakTextParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2RequestVoiceOverSpeakTextParameter structure once RequestVoiceOverSpeakText message is sent to device
 * 
 * \param[in] theiAP2RequestVoiceOverSpeakTextParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2RequestVoiceOverSpeakTextParameter(iAP2RequestVoiceOverSpeakTextParameter* theiAP2RequestVoiceOverSpeakTextParameter);

 /***************************************************************************//**
 * Free iAP2StartVoiceOverCursorUpdatesParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2StartVoiceOverCursorUpdatesParameter structure once StartVoiceOverCursorUpdates message is sent to device
 * 
 * \param[in] theiAP2StartVoiceOverCursorUpdatesParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2StartVoiceOverCursorUpdatesParameter(iAP2StartVoiceOverCursorUpdatesParameter* theiAP2StartVoiceOverCursorUpdatesParameter);

 /***************************************************************************//**
 * Free iAP2StartVoiceOverUpdatesParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2StartVoiceOverUpdatesParameter structure once StartVoiceOverUpdates message is sent to device
 * 
 * \param[in] theiAP2StartVoiceOverUpdatesParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2StartVoiceOverUpdatesParameter(iAP2StartVoiceOverUpdatesParameter* theiAP2StartVoiceOverUpdatesParameter);

 /***************************************************************************//**
 * Free iAP2AccessoryWiFiConfigurationInformationParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2AccessoryWiFiConfigurationInformationParameter structure once AccessoryWiFiConfigurationInformation message is sent to device
 * 
 * \param[in] theiAP2AccessoryWiFiConfigurationInformationParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2AccessoryWiFiConfigurationInformationParameter(iAP2AccessoryWiFiConfigurationInformationParameter* theiAP2AccessoryWiFiConfigurationInformationParameter);

 /***************************************************************************//**
 * Free iAP2BluetoothComponentProfiles structure
 * 
 * Application must call this API to de-allocate 
 * iAP2BluetoothComponentProfiles structure once BluetoothComponentProfiles message is sent to device
 * 
 * \param[in] theiAP2BluetoothComponentProfiles structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2BluetoothComponentProfiles(iAP2BluetoothComponentProfiles* theiAP2BluetoothComponentProfiles);

 /***************************************************************************//**
 * Free iAP2BluetoothComponentStatus structure
 * 
 * Application must call this API to de-allocate 
 * iAP2BluetoothComponentStatus structure once BluetoothComponentStatus message is sent to device
 * 
 * \param[in] theiAP2BluetoothComponentStatus structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2BluetoothComponentStatus(iAP2BluetoothComponentStatus* theiAP2BluetoothComponentStatus);

 /***************************************************************************//**
 * Free iAP2BluetoothHIDComponent structure
 * 
 * Application must call this API to de-allocate 
 * iAP2BluetoothHIDComponent structure once BluetoothHIDComponent message is sent to device
 * 
 * \param[in] theiAP2BluetoothHIDComponent structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2BluetoothHIDComponent(iAP2BluetoothHIDComponent* theiAP2BluetoothHIDComponent);

 /***************************************************************************//**
 * Free iAP2BluetoothTransportComponent structure
 * 
 * Application must call this API to de-allocate 
 * iAP2BluetoothTransportComponent structure once BluetoothTransportComponent message is sent to device
 * 
 * \param[in] theiAP2BluetoothTransportComponent structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2BluetoothTransportComponent(iAP2BluetoothTransportComponent* theiAP2BluetoothTransportComponent);

 /***************************************************************************//**
 * Free iAP2ExternalAccessoryProtocol structure
 * 
 * Application must call this API to de-allocate 
 * iAP2ExternalAccessoryProtocol structure once ExternalAccessoryProtocol message is sent to device
 * 
 * \param[in] theiAP2ExternalAccessoryProtocol structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2ExternalAccessoryProtocol(iAP2ExternalAccessoryProtocol* theiAP2ExternalAccessoryProtocol);

 /***************************************************************************//**
 * Free iAP2FavoritesList structure
 * 
 * Application must call this API to de-allocate 
 * iAP2FavoritesList structure once FavoritesList message is sent to device
 * 
 * \param[in] theiAP2FavoritesList structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2FavoritesList(iAP2FavoritesList* theiAP2FavoritesList);

 /***************************************************************************//**
 * Free iAP2FavoritesListProperties structure
 * 
 * Application must call this API to de-allocate 
 * iAP2FavoritesListProperties structure once FavoritesListProperties message is sent to device
 * 
 * \param[in] theiAP2FavoritesListProperties structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2FavoritesListProperties(iAP2FavoritesListProperties* theiAP2FavoritesListProperties);

 /***************************************************************************//**
 * Free iAP2iAP2HIDComponent structure
 * 
 * Application must call this API to de-allocate 
 * iAP2iAP2HIDComponent structure once iAP2HIDComponent message is sent to device
 * 
 * \param[in] theiAP2iAP2HIDComponent structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2iAP2HIDComponent(iAP2iAP2HIDComponent* theiAP2iAP2HIDComponent);

 /***************************************************************************//**
 * Free iAP2LocationInformationComponent structure
 * 
 * Application must call this API to de-allocate 
 * iAP2LocationInformationComponent structure once LocationInformationComponent message is sent to device
 * 
 * \param[in] theiAP2LocationInformationComponent structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2LocationInformationComponent(iAP2LocationInformationComponent* theiAP2LocationInformationComponent);

 /***************************************************************************//**
 * Free iAP2MediaItem structure
 * 
 * Application must call this API to de-allocate 
 * iAP2MediaItem structure once MediaItem message is sent to device
 * 
 * \param[in] theiAP2MediaItem structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2MediaItem(iAP2MediaItem* theiAP2MediaItem);

 /***************************************************************************//**
 * Free iAP2MediaItemAttributes structure
 * 
 * Application must call this API to de-allocate 
 * iAP2MediaItemAttributes structure once MediaItemAttributes message is sent to device
 * 
 * \param[in] theiAP2MediaItemAttributes structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2MediaItemAttributes(iAP2MediaItemAttributes* theiAP2MediaItemAttributes);

 /***************************************************************************//**
 * Free iAP2MediaItemProperties structure
 * 
 * Application must call this API to de-allocate 
 * iAP2MediaItemProperties structure once MediaItemProperties message is sent to device
 * 
 * \param[in] theiAP2MediaItemProperties structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2MediaItemProperties(iAP2MediaItemProperties* theiAP2MediaItemProperties);

 /***************************************************************************//**
 * Free iAP2MediaLibraryInformationSubParameter structure
 * 
 * Application must call this API to de-allocate 
 * iAP2MediaLibraryInformationSubParameter structure once MediaLibraryInformationSub message is sent to device
 * 
 * \param[in] theiAP2MediaLibraryInformationSubParameter structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2MediaLibraryInformationSubParameter(iAP2MediaLibraryInformationSubParameter* theiAP2MediaLibraryInformationSubParameter);

 /***************************************************************************//**
 * Free iAP2MediaPlayList structure
 * 
 * Application must call this API to de-allocate 
 * iAP2MediaPlayList structure once MediaPlayList message is sent to device
 * 
 * \param[in] theiAP2MediaPlayList structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2MediaPlayList(iAP2MediaPlayList* theiAP2MediaPlayList);

 /***************************************************************************//**
 * Free iAP2MediaPlaylistContentTransferInfoRequest structure
 * 
 * Application must call this API to de-allocate 
 * iAP2MediaPlaylistContentTransferInfoRequest structure once MediaPlaylistContentTransferInfoRequest message is sent to device
 * 
 * \param[in] theiAP2MediaPlaylistContentTransferInfoRequest structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2MediaPlaylistContentTransferInfoRequest(iAP2MediaPlaylistContentTransferInfoRequest* theiAP2MediaPlaylistContentTransferInfoRequest);

 /***************************************************************************//**
 * Free iAP2MediaPlaylistProperties structure
 * 
 * Application must call this API to de-allocate 
 * iAP2MediaPlaylistProperties structure once MediaPlaylistProperties message is sent to device
 * 
 * \param[in] theiAP2MediaPlaylistProperties structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2MediaPlaylistProperties(iAP2MediaPlaylistProperties* theiAP2MediaPlaylistProperties);

 /***************************************************************************//**
 * Free iAP2PlaybackAttributes structure
 * 
 * Application must call this API to de-allocate 
 * iAP2PlaybackAttributes structure once PlaybackAttributes message is sent to device
 * 
 * \param[in] theiAP2PlaybackAttributes structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2PlaybackAttributes(iAP2PlaybackAttributes* theiAP2PlaybackAttributes);

 /***************************************************************************//**
 * Free iAP2PlaybackQueueListContentTransferInfoRequest structure
 * 
 * Application must call this API to de-allocate 
 * iAP2PlaybackQueueListContentTransferInfoRequest structure once PlaybackQueueListContentTransferInfoRequest message is sent to device
 * 
 * \param[in] theiAP2PlaybackQueueListContentTransferInfoRequest structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2PlaybackQueueListContentTransferInfoRequest(iAP2PlaybackQueueListContentTransferInfoRequest* theiAP2PlaybackQueueListContentTransferInfoRequest);

 /***************************************************************************//**
 * Free iAP2RecentsList structure
 * 
 * Application must call this API to de-allocate 
 * iAP2RecentsList structure once RecentsList message is sent to device
 * 
 * \param[in] theiAP2RecentsList structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2RecentsList(iAP2RecentsList* theiAP2RecentsList);

 /***************************************************************************//**
 * Free iAP2RecentsListProperties structure
 * 
 * Application must call this API to de-allocate 
 * iAP2RecentsListProperties structure once RecentsListProperties message is sent to device
 * 
 * \param[in] theiAP2RecentsListProperties structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2RecentsListProperties(iAP2RecentsListProperties* theiAP2RecentsListProperties);

 /***************************************************************************//**
 * Free iAP2RouteGuidanceDisplayComponent structure
 * 
 * Application must call this API to de-allocate 
 * iAP2RouteGuidanceDisplayComponent structure once RouteGuidanceDisplayComponent message is sent to device
 * 
 * \param[in] theiAP2RouteGuidanceDisplayComponent structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2RouteGuidanceDisplayComponent(iAP2RouteGuidanceDisplayComponent* theiAP2RouteGuidanceDisplayComponent);

 /***************************************************************************//**
 * Free iAP2SerialTransportComponent structure
 * 
 * Application must call this API to de-allocate 
 * iAP2SerialTransportComponent structure once SerialTransportComponent message is sent to device
 * 
 * \param[in] theiAP2SerialTransportComponent structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2SerialTransportComponent(iAP2SerialTransportComponent* theiAP2SerialTransportComponent);

 /***************************************************************************//**
 * Free iAP2StartNowPlayingPlaybackAttributes structure
 * 
 * Application must call this API to de-allocate 
 * iAP2StartNowPlayingPlaybackAttributes structure once StartNowPlayingPlaybackAttributes message is sent to device
 * 
 * \param[in] theiAP2StartNowPlayingPlaybackAttributes structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2StartNowPlayingPlaybackAttributes(iAP2StartNowPlayingPlaybackAttributes* theiAP2StartNowPlayingPlaybackAttributes);

 /***************************************************************************//**
 * Free iAP2USBDeviceTransportComponent structure
 * 
 * Application must call this API to de-allocate 
 * iAP2USBDeviceTransportComponent structure once USBDeviceTransportComponent message is sent to device
 * 
 * \param[in] theiAP2USBDeviceTransportComponent structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2USBDeviceTransportComponent(iAP2USBDeviceTransportComponent* theiAP2USBDeviceTransportComponent);

 /***************************************************************************//**
 * Free iAP2USBHostHIDComponent structure
 * 
 * Application must call this API to de-allocate 
 * iAP2USBHostHIDComponent structure once USBHostHIDComponent message is sent to device
 * 
 * \param[in] theiAP2USBHostHIDComponent structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2USBHostHIDComponent(iAP2USBHostHIDComponent* theiAP2USBHostHIDComponent);

 /***************************************************************************//**
 * Free iAP2USBHostTransportComponent structure
 * 
 * Application must call this API to de-allocate 
 * iAP2USBHostTransportComponent structure once USBHostTransportComponent message is sent to device
 * 
 * \param[in] theiAP2USBHostTransportComponent structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2USBHostTransportComponent(iAP2USBHostTransportComponent* theiAP2USBHostTransportComponent);

 /***************************************************************************//**
 * Free iAP2VehicleInformationComponent structure
 * 
 * Application must call this API to de-allocate 
 * iAP2VehicleInformationComponent structure once VehicleInformationComponent message is sent to device
 * 
 * \param[in] theiAP2VehicleInformationComponent structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2VehicleInformationComponent(iAP2VehicleInformationComponent* theiAP2VehicleInformationComponent);

 /***************************************************************************//**
 * Free iAP2VehicleStatusComponent structure
 * 
 * Application must call this API to de-allocate 
 * iAP2VehicleStatusComponent structure once VehicleStatusComponent message is sent to device
 * 
 * \param[in] theiAP2VehicleStatusComponent structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2VehicleStatusComponent(iAP2VehicleStatusComponent* theiAP2VehicleStatusComponent);

 /***************************************************************************//**
 * Free iAP2WirelessCarPlayTransportComponent structure
 * 
 * Application must call this API to de-allocate 
 * iAP2WirelessCarPlayTransportComponent structure once WirelessCarPlayTransportComponent message is sent to device
 * 
 * \param[in] theiAP2WirelessCarPlayTransportComponent structure to be freed
 * \return None 
 * 
 * \see
 * \note
 ******************************************************************************/
void iAP2FreeiAP2WirelessCarPlayTransportComponent(iAP2WirelessCarPlayTransportComponent* theiAP2WirelessCarPlayTransportComponent);

/** @} */ 

#ifdef __cplusplus
}
#endif

#endif
