/**
* \file: AditEndpointCommon.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: J. Harder / ADITG/SW1 / jharder@de.adit-jv.com
* 
* \copyright (c) 2015 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef AAUTO_ADITENDPOINTCOMMON_H
#define AAUTO_ADITENDPOINTCOMMON_H

#include <aauto/ProtocolEndpointBase.h>
#include <aauto/MessageRouter.h>

namespace adit { namespace aauto {

enum FactoryImplementationType
{
    FactoryVideoSink,           // uses VideoSinkCreatorFn
    FactoryAudioSink,           // uses AudioSinkCreatorFn
    FactoryAudioSource,         // uses AudioSourceCreatorFn
    FactoryInputSource,         // uses InputSourceCreatorFn
    FactoryMediaPlaybackStatus, // uses MediaPlaybackStatusCreatorFn
    FactoryMediaBrowser,        // uses MediaBrowserCreatorFn
    FactoryNavigationStatus,    // uses NavigationStatusCreatorFn
    FactorySensorSource,        // uses SensorSourceCreatorFn
    FactoryBluetooth,           // not yet implemented
    FactoryNotification,        // not yet implemented
    FactoryPhoneStatus,         // not yet implemented
    FactoryRadio,               // not yet implemented
    FactoryVendorExtension      // not yet implemented
};

class AditVideoSink;
typedef AditVideoSink* (*VideoSinkCreatorFn)(uint8_t inId, MessageRouter* inRouter,
        bool inAutoStartProjection);

class AditAudioSink;
typedef AditAudioSink* (*AudioSinkCreatorFn)(uint8_t inId, MessageRouter* inRouter);

class AditAudioSource;
typedef AditAudioSource* (*AudioSourceCreatorFn)(uint8_t inId, MessageRouter* inRouter,
        int inMediaCodecType);

class AditInputSource;
typedef AditInputSource* (*InputSourceCreatorFn)(uint8_t inId, MessageRouter* inRouter);

class AditMediaPlaybackStatus;
typedef AditMediaPlaybackStatus* (*MediaPlaybackStatusCreatorFn)(uint8_t inId, MessageRouter* inRouter);

class AditMediaBrowser;
typedef AditMediaBrowser* (*MediaBrowserCreatorFn)(uint8_t inId, MessageRouter* inRouter);

class AditNavigationStatus;
typedef AditNavigationStatus* (*NavigationStatusCreatorFn)(uint8_t inSessionId, MessageRouter* inMessageRouter,
                                                           int inMinIntervalMs, int inheight, int inWidth, int inColorDepthBits,
                                                           NavigationStatusService_InstrumentClusterType inType);

class AditSensorSource;
typedef AditSensorSource* (*SensorSourceCreatorFn)(uint8_t inSessionId, MessageRouter* inMessageRouter, uint32_t inLocationCharacterization);


typedef void* (*CreatorFn)();
typedef bool (*FactoryRegisterFn)(const char* inName, FactoryImplementationType inType,
        CreatorFn inCreator);

} } /* namespace adit { namespace aauto { */

#endif /* AAUTO_ADITENDPOINTCOMMON_H */
