/**
* \file: AditBaiduCore.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* Wrapper for Baidu core
*
* \component: Baidu CarLife
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef BDCL_ADITBAIDUCORE_H
#define BDCL_ADITBAIDUCORE_H

#include <string>
#include "bdclErrorCodes.h"

namespace adit { namespace bdcl {

/** @interface  IAditBaiduCoreCallbacks
 *  @brief      Callbacks to notify the MC application about an error or connection setup progress. This interface must
 *              be implemented by the MC application. MC has to return the callbacks immediately, because they are
 *              blocking the connection setup.
 */
class IAditBaiduCoreCallbacks
{
public:
    virtual ~IAditBaiduCoreCallbacks() { }

    /** @brief Callback initiated to inform MC about the protocol version match status.
     */
    virtual void onProtocolVersionMatchStatus(bool) { };

    /** @brief Callback initiated to inform MC about the authentication response.
     */
    virtual void onAuthenticationResponse(bool) { };

    /** @brief Callback initiated to inform MC application about an error.
     */
    virtual void onError(bdclErrorCodes inErrorCode) { (void) inErrorCode; };
};

} } /* namespace adit { namespace bdcl { */

#endif /* BDCL_ADITBAIDUCORE_H */
