/**
* \file: AditSensorSource.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: K. Kuroda / ADITJ/SW / kkuroda@jp.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/
#ifndef AAUTO_ADITSENSORSOURCE_H
#define AAUTO_ADITSENSORSOURCE_H

#include <aauto/SensorSource.h>
#include <aauto/MessageRouter.h>

namespace adit { namespace aauto {

/** 
 * @brief AditSensorSource provides a generic base class for SensorSource implementations.
 * It aims to break dependency between ADIT-PF and GalReceiver.
 **/
class AditSensorSource : public SensorSource
{
public:
/**
 * @brief  Constructor of AditSensorSource.
 * @param  inSessionId      inSessionId is Id that is used in GalReceiver as identification data on session.
 * @param  inMessageRouter    inMessageRouter is message router obtained from GalReceiver.
 */
    AditSensorSource(uint8_t inSessionId, MessageRouter* inMessageRouter, uint32_t inLocationCharacterization)
    : SensorSource(inSessionId, inMessageRouter, inLocationCharacterization) { }

/**
 * @brief  Set the configuration for the platform and Galreceiver. Must be called before init(). 
 * @param  inKey        The key string for configuration (e.g. "night-mode")
 * 
 * @param  inValue      Enable(1)/Disable(0) or the actual value for configuration (e.g. "1", "2" ,"800") */
 
    virtual void setConfigItem(string inKey, string inValue) = 0;

/**
 * @brief  Initialize the AditSensorSource library
 * @return true if initialization succeeds. Otherwise false. */

    virtual bool init() = 0;

/**
 * @brief  Shut down the AditSensorSource library, stop running threads and release allocated resources
 * @return true if initialization succeeds. Otherwise false. */

    virtual bool shutdown() = 0;
};

} } /* namespace adit { namespace aauto { */

#endif /* AAUTO_ADITSENSORSOURCE_H */
