Your File:ISky.h

    /* -*-c++-*-
    mapengine_oss
     
    * osgEarth - Dynamic map generation toolkit for OpenSceneGraph
    * Copyright 2008-2010 Pelican Mapping
    * http://osgearth.org
    *
    * osgEarth is free software; you can redistribute it and/or modify
    * it under the terms of the GNU Lesser General Public License as published by
    * the Free Software Foundation; either version 2 of the License, or
    * (at your option) any later version.
    *
    * This program is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    * GNU Lesser General Public License for more details.
    *
    * You should have received a copy of the GNU Lesser General Public License
    * along with this program. If not, see <http://www.gnu.org/licenses/>
     
    History:
    Copied from https://github.com/gwaldron/osgearth/blob/osgearth_2.0_T2011-02-24/src/osgEarthUtil/SkyNode
    List of changes:
    1. Added interfaces to obtain sun position and set date and time
    */
     
    #ifndef MAPENGINE_TYPES_ISKY_HEADER
    #define MAPENGINE_TYPES_ISKY_HEADER
     
    #include <osg/View>
    #include <osg/Vec3>
    #include "oss/Export.h"
     
    namespace mapengine {
    namespace oss {
     
    /**
    * Interface class for SkyNode
    */
    class MAPENGINE_OSS_EXPORT me_ISky
    {
    public:            
       virtual ~me_ISky() {}
       /** Sets the sky's position based on a julian date. */
       virtual void setDateTime( int year, int month, int date, double hoursUTC ) = 0;
       virtual void getSunPosition(osg::Vec3& pos) = 0; 
    };
     
    }
    }
     
    #endif //MAPENGINE_TYPES_ISKY_HEADER