/**
* \file: AditInputSource.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: M. Adachi / ADITJ/SW / madachi@jp.adit-jv.com
*
* \copyright (c) 2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/
#ifndef ADIT_INPUTSOURCE_H
#define ADIT_INPUTSOURCE_H

#include <aauto/InputSource.h>
#include <aauto/MessageRouter.h>
#include "aauto/AautoErrorCodes.h"

namespace adit { namespace aauto {

class IAditInputSourceCallbacks
{
public:
    virtual ~IAditInputSourceCallbacks() {}

    /**
     * @brief called when mobile device gets an input
     * @param inFeedback The feedback event sent by the MD
     **/
    virtual void onInputFeedback(const InputFeedback& inFeedback) {(void) inFeedback;}

    /** @brief Called when an error happens in the underlying layer.
    * The callback is introduced to inform the upper layer about error cases,
    * for which another notification, such as return values, is not possible.
    * @param inErrorCode  Error code
    * */
    virtual void notifyErrorCallback(aautoErrorCodes inErrorCode) {(void) inErrorCode;}
};

/** 
 * @brief AditInputSource provides a generic base class to input implementations provided by ADIT.
 * It hides some InputSource methods and replaces them by setConfigItem.
 **/
class AditInputSource : public InputSource
{
public:
/**
 * @brief  Constructor of AditInputSource. 
 * @param  inSessionId      inSessionId is Id that is used in GalReceiver as identification data on session.
 * @param  inMessageRouter    inMessageRouter is message router obtained from GalReceiver.
 */
    AditInputSource(uint8_t inSessionId, MessageRouter* inMessageRouter)
    : InputSource(inSessionId, inMessageRouter) { }

/**
 * @brief  Set the configuration for the platform and Galreceiver. Must be called before init(). 
 * @param  inKey        The key string for configuration (e.g. "touch-width")
 *     - touch-width [mandatory]:Maximum width of touch area to report for Galreceiver . 
 *     - touch-height [mandatory]:Maximum height of touch area to report for Galreceiver. 
 *     - enable-verbose-logging [optional, default=0]:Enable flag in order to get detail log data. 
 * 
 * @param  inValue      The actual value for configuration (e.g. "2" ,"800") */
 
    virtual void setConfigItem(string inKey, string inValue) = 0;

/**
 * @brief Register callback interface to receive input-related notifications.
 * See IAditInputSourceCallbacks for details.
 *
 * @param   inCallbacks object implementing the callback interface */
    virtual void registerCallbacks(IAditInputSourceCallbacks* inCallbacks) = 0;


/**
 * @brief  Initialize the AditInputSource library and set configured parameters to the
 *  platform and Galreceiver
 * @return true if initialization succeeds. Otherwise false. */

    virtual bool init() = 0;

/**
 * @brief  Shut down the AditInputSource library, stop running threads and release allocated resources
 * @return true if initialization succeeds. Otherwise false. */

    virtual bool shutdown() = 0;
};

} } /* namespace adit { namespace aauto { */

#endif /* ADIT_INPUTSOURCE_H */
