#ifndef SWU_CERTIFICATE_H
#define SWU_CERTIFICATE_H

#include "swu_singleton.hpp"
struct asn1_string_st;

namespace swu {

class CodeCert {
   bool validateCertificate(const std::string &CACert, const std::string &CodeCert);
   bool extractPublicKeyFromCertificate(const std::string &certificate, std::string &key);
   bool checkSignature(const unsigned char *msg, size_t msg_len, const unsigned char *signature, size_t signature_len, const std::string & key, bool & verify_result);
   bool checkSignatureAsserting(const unsigned char *msg, size_t msg_len, const unsigned char *signature, size_t signature_len, const std::string &key);
   time_t ASN1_GetTimeT(ASN1_TIME* time);

};
class TestSignature : public Singleton<TestSignature> {
public:
   void vInit();

   void testCheckSignature(const char *messageFile, const char *signatureFile, const char *keyFile);
   void testCheckSignatureWithSystemkey(const char *messageFile, const char *signatureFile);
};




}
#endif
