/**
* @file SimpleMemoryPool.cpp
* @addtogroup oss
* @{
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "SimpleMemoryPool.h"

using namespace mapengine::oss;

me_SimpleMemoryPool me_SimpleMemoryPool::_memPool;

me_SimpleMemoryPool::me_SimpleMemoryPool()
{
   _head = new MemNode;
   if(_head)
   {
      _head->mSize = BLOCK_SIZE;
      _head->next  = NULL;
      _head->mem   = (unsigned char *)malloc(_head->mSize);
   }
   _curPos.node = _head;
   _curPos.offset = 0;
} 

me_SimpleMemoryPool::~me_SimpleMemoryPool()
{
  dispose(_head);
}

void me_SimpleMemoryPool::cleanAndReset()
{
   _curPos.node = _head;
   _curPos.offset = 0;
}

void me_SimpleMemoryPool::dispose(MemNode *node)
{
  if(node == NULL)
      return;
  if(NULL != node->next)
     dispose(node->next);
  if(NULL != node->mem)
      delete [](node->mem);
  delete node;
}

void* me_SimpleMemoryPool::simpleMalloc(int tSize)
{
   if(_curPos.node->mSize - _curPos.offset > tSize)
   {
      _curPos.offset += tSize;
      return _curPos.node->mem + _curPos.offset - tSize;
   }
   else
   {
      if(_curPos.node->next)
      {
         MemNode *tNode = _curPos.node->next;
         if(tNode->mSize > tSize)
         {
            _curPos.node = tNode;
            _curPos.offset = tSize;
            return _curPos.node->mem + _curPos.offset - tSize;
         }
         else
         {
            dispose(_curPos.node->next);
            _curPos.node->next = NULL;
         }
      }
      if(NULL == _curPos.node->next)
      {
         int mSize = BLOCK_SIZE > 10 * tSize ? BLOCK_SIZE : 10 * tSize;
         _curPos.node->next = new MemNode;
         _curPos.node->next->mSize = mSize;
         _curPos.node->next->next  = NULL;
         _curPos.node->next->mem   = (unsigned char *)malloc(mSize);
         MemNode *tNode = _curPos.node->next;
         _curPos.node = tNode;
         _curPos.offset = tSize;
         return _curPos.node->mem + _curPos.offset - tSize;
      }
   }  
   return NULL;
}

void* me_SimpleMemoryPool::simpleRealloc(void *ptr,int preSize, int tSize )
{
   if(tSize <= preSize)
      return ptr;
   void *newPtr = simpleMalloc(tSize);
   memcpy(newPtr,ptr,preSize);
   return newPtr;
}

void me_SimpleMemoryPool::simpleFree(void* /*ptr*/)
{
   cleanAndReset();
}
