/*
 * Copyright (c) 1996-1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.  Silicon Graphics makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 */

/* NOTE: This is an internal header file, included by other STL headers.
 *   You should not attempt to use it directly.
 */

/*lint -save -e578 */
/* 
   remove lint warnings: since this is a common library I decided not 
   to alter the code with unknown side effects but to disable the lint 
   warning for that file. CM-AI/PJ-CF15 Wiedemann 
   
   Warning 578: Declaration of symbol 'xxx' hides symbol 'yyy' 
*/

#ifndef __SGI_STL_INTERNAL_ALLOC_H
#define __SGI_STL_INTERNAL_ALLOC_H
#include "bp_new"

_BP_STL_BEGIN_NAMESPACE
template <class _Ty> class allocator
{
public:
   typedef size_t size_type;
   typedef ptrdiff_t difference_type;
   typedef _Ty  *pointer;
   typedef const _Ty *const_pointer;
   typedef _Ty & reference;
   typedef const _Ty & const_reference;
   typedef _Ty value_type;

   pointer address(reference rfoObject) const
   {
      return (&rfoObject); 
   }
   
   const_pointer address(const_reference corfoObject) const
   {
      return (&corfoObject); 
   }

   static pointer allocate(size_type Size, const void * = NULL) 
   {
      void *pvMem = NULL;

      if (Size > 0)
      {
         pvMem = OSAL_pvMemoryAllocate(Size*sizeof(_Ty));

         if(pvMem == NULL)
         {
            _BP_THROW1(bpstl::bad_alloc);
         }
      }
      return (_Ty*) pvMem;
   }

   static tChar  *_Charalloc(size_type Size) 
   {
      void *pvMem = NULL;

      if (Size > 0)
      {
         pvMem = OSAL_pvMemoryAllocate(Size);

         if(pvMem == NULL)
         {
            _BP_THROW1(bpstl::bad_alloc);
         }
      }

      return  (tChar*) pvMem;
   }

   static void deallocate(void  *vpMem, size_type)
   { 
      OSAL_vMemoryFree(vpMem);
   }

   void construct(pointer pObject, const _Ty& rfoInit)
   {
      new ((void  *)pObject) _Ty(rfoInit); 
   }

   void destroy(pointer pObject)
   {
   
      (pObject)->~_Ty();
   }

   size_t max_size() const
   {
      size_t Size = (size_t)(-1) / sizeof (_Ty);
      return (0 < Size ? Size : 1); 
   }
};

template<>
class allocator<void> {
public:
  typedef size_t      size_type;
  typedef ptrdiff_t   difference_type;
  typedef void*       pointer;
  typedef const void* const_pointer;
  typedef void        value_type;

  template <class _Tp1> struct rebind {
    typedef allocator<_Tp1> other;
  };
};

template <class _Tp, class _Alloc> class simple_alloc : public allocator<_Tp>
{
};

_BP_STL_END_NAMESPACE

#endif

/*lint -restore */

