/**************************************************************** +MHDR * .MA *
    
 .FILE            [exh_tclStack]

 .SW-COMPONENT    [SXL\EXH]

 .DESCRIPTION                                                          
  This file specifies a template class for a stack with a static size.
   
 .AUTOR           [ CM-DI/ENS51 F. Wiedemann                            ]          
 .COPYRIGHT       [ (c) 2001 Robert Bosch GmbH, Hildesheim           ]

 .HISTORY 
   
  Initial revision.
   
**************************************************************** -MHDR * .ME */

// Template class for a stack with a static size

#ifndef EXHCLSTACK
#define EXHCLSTACK

template<typename T> class exh_tclStackAble
{
public:
   exh_tclStackAble()
    : pPrevStackAble(NULL)
   {
   }

   virtual ~exh_tclStackAble(){};

   T* pGetPrevStackAble(){return (T*)pPrevStackAble;}
   tVoid vSetPrevStackAble(T* pPrev){pPrevStackAble = pPrev;}

private:
   T* pPrevStackAble;
};

/**************************************************************** +FHDR * .FA *

 .CLASS                  [exh_tclIntrusiveStack]

 .DESCRIPTION
  class template for a stack with a static size.
    
 .COPYRIGHT            [ (c) 2001 Robert Bosch GmbH, Hildesheim           ]
 .AUTOR                [Wiedemann                                         ]

 .HISTORIE

  Date     | Name         Modification
 ----------|---------------------------------------------------------------
  26.11.01 | CM-DI/ENS51-Wn  new.
**************************************************************** -FHDR * .FE */

template<typename T> class exh_tclIntrusiveStack
{
private:
   T* pTop;      // pointer to the stacks memory
   tU32 u32Count;
public:

/**************************************************************** +FHDR * .FA *

 .METHOD               [exh_tclIntrusiveStack::exh_tclIntrusiveStack]

 .DESCRIPTION
  Constructor of this class. 
    
 .PARAMETER
     tU32 u32StackSize    Maximum number of elements the stack can hold
         
 .RETURNVALUE
     none

 .VALUE_REFERENCES 

 .FUNCTION_REFERENCES

 .COPYRIGHT            [ (c) 2001 Robert Bosch GmbH, Hildesheim           ]
 .AUTOR                [Wiedemann                                         ]

 .HISTORIE

  Date     | Name         Modification
 ----------|---------------------------------------------------------------
  26.11.01 | CM-DI/ENS51-Wn  new.
**************************************************************** -FHDR * .FE */

   exh_tclIntrusiveStack() 
    : pTop(NULL), u32Count(0)
   {
   }; 
   
/**************************************************************** +FHDR * .FA *

 .METHOD               [exh_tclIntrusiveStack::vPush]

 .DESCRIPTION
  Put an element on the stack
    
 .PARAMETER
     T Element         Element to put on the stack
         
 .RETURNVALUE
     none

 .VALUE_REFERENCES 

 .FUNCTION_REFERENCES

 .COPYRIGHT            [ (c) 2001 Robert Bosch GmbH, Hildesheim           ]
 .AUTOR                [Wiedemann                                         ]

 .HISTORIE

  Date     | Name         Modification
 ----------|---------------------------------------------------------------
  26.11.01 | CM-DI/ENS51-Wn  new.
**************************************************************** -FHDR * .FE */

   void vPush(T& Element)
   {
      Element.vSetPrevStackAble(pTop);
      pTop = &Element;

      u32Count++;
   };
   
/**************************************************************** +FHDR * .FA *

 .METHOD               [exh_tclIntrusiveStack::Pop]

 .DESCRIPTION
  Get an element from the stack
    
 .PARAMETER
     none
         
 .RETURNVALUE
     T                 Uppermost elment on the stack

 .VALUE_REFERENCES 

 .FUNCTION_REFERENCES

 .COPYRIGHT            [ (c) 2001 Robert Bosch GmbH, Hildesheim           ]
 .AUTOR                [Wiedemann                                         ]

 .HISTORIE

  Date     | Name         Modification
 ----------|---------------------------------------------------------------
  26.11.01 | CM-DI/ENS51-Wn  new.
**************************************************************** -FHDR * .FE */

   T* pPop(tVoid)
   {
      T* pTemp = pTop;
      ERR_M_ASSERT(u32Count != 0);

      if(NULL != pTop)
      {
         pTop = pTop->pGetPrevStackAble();
         u32Count--;
      }

      return pTemp;
   };
   
/**************************************************************** +FHDR * .FA *

 .METHOD               [exh_tclIntrusiveStack::pRemove]

 .DESCRIPTION
  Removes a given object from the stack
    
 .PARAMETER
     none
         
 .RETURNVALUE
     T*                != NULL: removed object
                       == NULL: object not found

 .VALUE_REFERENCES 

 .FUNCTION_REFERENCES

 .COPYRIGHT            [ (c) 2001 Robert Bosch GmbH, Hildesheim           ]
 .AUTOR                [Wiedemann                                         ]

 .HISTORIE

  Date     | Name         Modification
 ----------|---------------------------------------------------------------
  26.11.01 | CM-DI/ENS51-Wn  new.
**************************************************************** -FHDR * .FE */

   T* pRemove(const T* pSearch)
   {
      T* pPrev = NULL;
      T* pCurrent = pTop;
      T* pRet = NULL;

      if (NULL != pSearch)
      {
         while(    (pCurrent != NULL)
                && (pCurrent != pSearch) )
         { 
            pPrev = pCurrent;
            pCurrent = pCurrent->pGetPrevStackAble();
         }

         if(pCurrent == pSearch) //lint !e613 : Must be not NULL see above (pCurren==pSearch and pSearch != NULL
         {
            // if object found remove current from stack
            if(pCurrent == pTop)
            {
               pTop = pCurrent->pGetPrevStackAble();
            }
            else
            {
               pPrev->vSetPrevStackAble(pCurrent->pGetPrevStackAble());
            }

            pRet = pCurrent;
            u32Count--;
         }
      }

      return pRet;
   };
   
/**************************************************************** +FHDR * .FA *

 .METHOD               [exh_tclIntrusiveStack::bIsEmpty]

 .DESCRIPTION
  Check if the stack is empty
    
 .PARAMETER
     none
         
 .RETURNVALUE
     tBool             TRUE    The stack is empty
                       FALSE   The stack is not empty

 .VALUE_REFERENCES 

 .FUNCTION_REFERENCES

 .COPYRIGHT            [ (c) 2001 Robert Bosch GmbH, Hildesheim           ]
 .AUTOR                [Wiedemann                                         ]

 .HISTORIE

  Date     | Name         Modification
 ----------|---------------------------------------------------------------
  26.11.01 | CM-DI/ENS51-Wn  new.
**************************************************************** -FHDR * .FE */

   tBool bIsEmpty(void) const {return(u32Count == 0);}
   
/**************************************************************** +FHDR * .FA *

 .METHOD               [exh_tclIntrusiveStack::u32GetCount]

 .DESCRIPTION
  Gets the number of elements currently placed on the stack
    
 .PARAMETER
     none
         
 .RETURNVALUE
     tU32              Number of elements on the stack

 .VALUE_REFERENCES 

 .FUNCTION_REFERENCES

 .COPYRIGHT            [ (c) 2001 Robert Bosch GmbH, Hildesheim           ]
 .AUTOR                [Wiedemann                                         ]

 .HISTORIE

  Date     | Name         Modification
 ----------|---------------------------------------------------------------
  26.11.01 | CM-DI/ENS51-Wn  new.
**************************************************************** -FHDR * .FE */

   tU32 u32GetCount(tVoid){return u32Count;};
   
/**************************************************************** +FHDR * .FA *

 .METHOD               [exh_tclIntrusiveStack::~exh_tclIntrusiveStack]

 .DESCRIPTION
  Destructor of this class
    
 .PARAMETER
     none
         
 .RETURNVALUE
     none

 .VALUE_REFERENCES 

 .FUNCTION_REFERENCES

 .COPYRIGHT            [ (c) 2001 Robert Bosch GmbH, Hildesheim           ]
 .AUTOR                [Wiedemann                                         ]

 .HISTORIE

  Date     | Name         Modification
 ----------|---------------------------------------------------------------
  26.11.01 | CM-DI/ENS51-Wn  new.
**************************************************************** -FHDR * .FE */

   ~exh_tclIntrusiveStack()
   {
      pTop = NULL;
   }; 

   T* pGetTop() {return pTop;}
};

#endif
