

/**************************************************************** +MHDR * .MA *
    
 .FILE            [ExceptOSIF.h]

 .SW-COMPONENT    [SXL\EXH]

 .DESCRIPTION                                                          
  This file contains the OS depending implementation of the EXH. That are
  functions to initialize and release exception handling.
   
 .AUTOR           [ CM-DI/ENS51 F. Wiedemann                            ]          
 .COPYRIGHT       [ (c) 2001 Robert Bosch GmbH, Hildesheim           ]

 .HISTORY 
   
  Initial revision.
   
**************************************************************** -MHDR * .ME */

#ifndef EXCEPTOSIF_H
#define EXCEPTOSIF_H


#ifdef VARIANT_S_FTR_ENABLE_EXH_EXCEPTIONS

#define EXH_INITSTACKBOTTOM {tU8 exh_StackBottomObject; exh_vSetStackBottom(&exh_StackBottomObject);}
#define exh_bCreateExceptionContext(x,y) exh_bCreateExceptionContextX(x,y); EXH_INITSTACKBOTTOM

// forward declaration of tclDestroyMe
class tclDestroyMe;
class tclStackUnwindBase;

class exh_tclTryTrace
{
public:
   const tChar* coszFile;
   tU32   cou32Line;
};


// helper class which holds the beginning and the size of an object
class exh_tclObjectDesc
{
public:
   exh_tclObjectDesc()
      : pStart(NULL)
      , u32Size(0)
   {}
   tU8*  pStart;
   tU32  u32Size;
};


// Try context. Each _TRY_BEGIN macro opens a new try context
class exh_tclTryContext : public exh_tclStackAble<exh_tclTryContext>
{
public:
#ifndef STL_S_NDEBUG
   exh_tclTryTrace                         oTrace;
#endif

   /*****************************************************************/
   /* For ADITGen2 based products, eSOL has patched the setjmp.h in */
   /* a way that jmp_buf is compiled using the namespace 'std'      */
#if VARIANT_S_FTR_ENABLE_USE_SETJMP_NAMESPACE_STD || VARIANT_S_FTR_ENABLE_USE_SETJMP_NAMESPACE_NONE
#ifdef VARIANT_S_FTR_ENABLE_USE_SETJMP_NAMESPACE_STD
   std::jmp_buf                                 JumpBuffer;
#endif // #ifdef VARIANT_S_FTR_ENABLE_USE_SETJMP_NAMESPACE_STD
#ifdef VARIANT_S_FTR_ENABLE_USE_SETJMP_NAMESPACE_NONE
   jmp_buf                                 JumpBuffer;
#endif // #ifdef VARIANT_S_FTR_ENABLE_USE_SETJMP_NAMESPACE_NONE
#else
#error you have to define a namespace usage
#endif

   exh_tclIntrusiveStack<tclStackUnwindBase>     oDestroyStack;
   exh_tclObjectDesc oObjDesc;
};


// each thread holds its own exception context
class exh_tclExceptionContext
{
public:
   exh_tclExceptionContext()
      : poCurrentException(NULL)
      , pvThreadLocalExceptMem(NULL)
      , pu8StackBottom(NULL)
#ifndef STL_S_NDEBUG
      , poCurrentDestroyMe(NULL)
#endif
   {}

   exh_tclIntrusiveStack<exh_tclTryContext>  oTryStack;
   bpstl::exception*                poCurrentException;
   tVoid*                         pvThreadLocalExceptMem;
   tU8*  pu8StackBottom;

#ifndef STL_S_NDEBUG
   tclStackUnwindBase*                  poCurrentDestroyMe;
#endif
};

/**************************************************************** +FHDR * .FA *

 .FUNCTION             [exh_bInitExceptionHandling]

 .DESCRIPTION
  Function to initialize the exception handling as a process wide service. This 
  function has to be called only once per process.
      
 .PARAMETER
     none
         
 .RETURNVALUE
     tBool             TRUE    EXH initialized
                       FALSE   error, EXH not initialized

 .VALUE_REFERENCES 

 .FUNCTION_REFERENCES

 .COPYRIGHT            [ (c) 2001 Robert Bosch GmbH, Hildesheim           ]
 .AUTOR                [Wiedemann                                         ]

 .HISTORIE

  Date     | Name         Modification
 ----------|---------------------------------------------------------------
  26.11.01 | CM-DI/ENS51-Wn  new.
**************************************************************** -FHDR * .FE */

tBool exh_bInitExceptionHandling(tVoid);


/**************************************************************** +FHDR * .FA *

 .FUNCTION             [exh_vFreeExceptionHandling]

 .DESCRIPTION
  Function to free the exception handling. This 
  function has to be called only once per process.
      
 .PARAMETER
     none
         
 .RETURNVALUE
     none

 .VALUE_REFERENCES 

 .FUNCTION_REFERENCES

 .COPYRIGHT            [ (c) 2001 Robert Bosch GmbH, Hildesheim           ]
 .AUTOR                [Wiedemann                                         ]

 .HISTORIE

  Date     | Name         Modification
 ----------|---------------------------------------------------------------
  26.11.01 | CM-DI/ENS51-Wn  new.
**************************************************************** -FHDR * .FE */

tVoid exh_vFreeExceptionHandling(tVoid);


/**************************************************************** +FHDR * .FA *

 .FUNCTION             [exh_bCreateExceptionContext]

 .DESCRIPTION
  Function to create a thread local exception context to use EXH within the
  current thread.
      
 .PARAMETER
     tU32 u32SizeOfJumpStack      Size of JumpStack. This value has to be set
                                  to the number of possible levels of try-blocks.
                                  If you set the number to small, you will get
                                  an assertion at runtime.
     tU32 u32SizeOfDestroyStack   Maximum number of local tclDestroyMe-objects
                                  within a try-block.
         
 .RETURNVALUE
     tBool             TRUE    EXH initialized for the current thread
                       FALSE   error, EXH not initialized

 .VALUE_REFERENCES 

 .FUNCTION_REFERENCES

 .COPYRIGHT            [ (c) 2001 Robert Bosch GmbH, Hildesheim           ]
 .AUTOR                [Wiedemann                                         ]

 .HISTORIE

  Date     | Name         Modification
 ----------|---------------------------------------------------------------
  26.11.01 | CM-DI/ENS51-Wn  new.
**************************************************************** -FHDR * .FE */

tBool exh_bCreateExceptionContextX(tU32 u32SizeOfJumpStack, tU32 u32SizeOfDestroyStack);


/**************************************************************** +FHDR * .FA *

 .FUNCTION             [exh_vFreeExceptionContext]

 .DESCRIPTION
  Function to free the exception handling of the current task.
      
 .PARAMETER
     none
         
 .RETURNVALUE
     none

 .VALUE_REFERENCES 

 .FUNCTION_REFERENCES

 .COPYRIGHT            [ (c) 2001 Robert Bosch GmbH, Hildesheim           ]
 .AUTOR                [Wiedemann                                         ]

 .HISTORIE

  Date     | Name         Modification
 ----------|---------------------------------------------------------------
  26.11.01 | CM-DI/ENS51-Wn  new.
**************************************************************** -FHDR * .FE */

tVoid exh_vFreeExceptionContext(tVoid);

/**************************************************************** +FHDR * .FA *

 .FUNCTION             [exh_GetExceptionContext]

 .DESCRIPTION
  Function to retrieve the exception context of the current task.
      
 .PARAMETER
     none
         
 .RETURNVALUE
     tExceptionContext*    Pointer to the current tasks exception context.

 .VALUE_REFERENCES 

 .FUNCTION_REFERENCES

 .COPYRIGHT            [ (c) 2001 Robert Bosch GmbH, Hildesheim           ]
 .AUTOR                [Wiedemann                                         ]

 .HISTORIE

  Date     | Name         Modification
 ----------|---------------------------------------------------------------
  26.11.01 | CM-DI/ENS51-Wn  new.
**************************************************************** -FHDR * .FE */

exh_tclExceptionContext* exh_GetExceptionContext(tVoid);

// -- methods to check out stack
tVoid exh_vSetStackBottom(tU8* x);
tBool exh_bIsOnStack( const tVoid* ptr, const exh_tclExceptionContext* pECT);

#endif //#ifdef VARIANT_S_FTR_ENABLE_EXH_EXCEPTIONS

#endif
