/*
 * ecnr-service.h
 *
 ********************************
 * qwa-object.h
 *
 * Andy Lowe <alowe@mvista.com>
 *
 * 2010 (c) MontaVista Software, LLC. This file is licensed under
 * the terms of the AFL.
 **********************************
 * Author: Patrick Rey
 * Date: 15.08.2013
 * Version 0.1 :  adaption qwa-object.h as ecnr-object.h
 */


#ifndef __ECNR_SERVICE_H__
#define __ECNR_SERVICE_H__


#include "sse.h"

#define DEBUG
//#define DEBUG_DUMP_SND
//#define DEBUG_SESSION
#define DEBUG_WITH_AUDIO
//#define D_TRIGGER_PERFORMANCE_TEST


#ifdef DEBUG
#define  pr_debug(fmtstr, args...) \
         g_debug("%s: " fmtstr, __FUNCTION__, ##args)
#define  ecnr_debug(status, fmtstr, args...) \
         g_debug("%s: %s (%d): " fmtstr, __FUNCTION__, \
         ecnr_error_str(status), status, ##args)
#else
#define pr_debug(fmtstr, args...)
#define ecnr_debug(status, fmtstr, args...)
#endif

#define pr_message(fmtstr, args...) \
        g_message("%s: " fmtstr, __FUNCTION__, ##args)
#define pr_warning(fmtstr, args...) \
        g_warning("%s: " fmtstr, __FUNCTION__, ##args)
#define pr_critical(fmtstr, args...) \
        g_critical("%s: " fmtstr, __FUNCTION__, ##args)
#define pr_error(fmtstr, args...) \
        g_error("%s: " fmtstr, __FUNCTION__, ##args)

#define ecnr_message(status, fmtstr, args...) \
        g_message("%s: %s (%d): " fmtstr, __FUNCTION__, \
    ecnr_error_str(status), status, ##args)
#define ecnr_warning(status, fmtstr, args...) \
        g_warning("%s: %s (%d): " fmtstr, __FUNCTION__, \
    ecnr_error_str(status), status, ##args)
#define ecnr_critical(status, fmtstr, args...) \
        g_critical("%s: %s (%d): " fmtstr, __FUNCTION__, \
    ecnr_error_str(status), status, ##args)
#define ecnr_error(status, fmtstr, args...) \
        g_error("%s: %s (%d): " fmtstr, __FUNCTION__, \
    ecnr_error_str(status), status, ##args)

#define rcs_message(status, fmtstr, args...) \
        g_message("%s: %s (%d): " fmtstr, __FUNCTION__, \
    qwa_rcs_error_str(status), status, ##args)
#define rcs_warning(status, fmtstr, args...) \
        g_warning("%s: %s (%d): " fmtstr, __FUNCTION__, \
    qwa_rcs_error_str(status), status, ##args)
#define rcs_critical(status, fmtstr, args...) \
        g_critical("%s: %s (%d): " fmtstr, __FUNCTION__, \
    qwa_rcs_error_str(status), status, ##args)
#define rcs_error(status, fmtstr, args...) \
        g_error("%s: %s (%d): " fmtstr, __FUNCTION__, \
    qwa_rcs_error_str(status), status, ##args)


//#define ECNR_OBJECT_ERROR (ecnr_object_error_quark())

extern  GQuark ecnr_object_error_quark(void);

extern  const gchar *ecnr_error_str(int code); //(tQwaInt code);
extern  gboolean report_ecnr_error(int status, const gchar * dbus_msg,//tQwaInt status, const gchar * dbus_msg,
                                    GError ** error);
extern const gchar *qwa_rcs_error_str(int code);//(tQwaInt code);




struct EcnrError
{
    int     code; // tQwaInt code;
    const   gchar *str;
};


struct ecnr_instance_object
{
    gboolean    ecnr_is_initialized;
    gboolean    ecnr_is_audio_thread_prepared;
    gboolean    ecnr_is_audio_thread_started;
    gboolean    ecnr_Debug_intf_initialized;
    gint        ecnr_current_config_id;
    guchar      ecnr_current_app_id;
    guint8      ecnr_alsa_thread_ref;
};


extern void     ecnr_service_init(void);
extern void     ecnr_service_destroy(void);
extern  int     ecnr_service_create_new_instance(guchar app_id);
extern  int     ecnr_service_remove_instance(guchar app_id);
extern gboolean ecnr_service_finalize(void);
extern  struct  ecnr_instance_object* ecnr_service_get_this_instance(guchar app_id);
extern  struct  ecnr_instance_object* ecnr_service_get_curr_instance(void);
extern  int     ecnr_service_is_instance_active(guchar app_id, gboolean* state);
extern  int     ecnr_service_do_action_initialize(gint config_id);
extern  int     ecnr_service_do_action_destroy(void);
extern  int     ecnr_service_check_AppId_ConfigId_Matching(gint ecnrConfigurationId, guchar ecnrAppId);
extern int      ecnr_service_state_audio_prepare_cb(void);
extern int      ecnr_service_state_audio_active_cb(void);
extern gboolean ecnr_service_state_ist_audio_active(void);
extern int      ecnr_service_alsa_thread_create(void);
extern gboolean ecnr_service_handle_quit_loop (gpointer user_data);
extern int      ecnr_service_alsa_thread_unref(void);
extern int      ecnr_service_alsa_thread_ref(void);
extern void     ecnr_service_set_pass_through_mode_default_state(gboolean ptm_default_state);
extern gboolean ecnr_service_get_pass_through_mode_default_state(void);
extern void     ecnr_service_set_mic_gain_level(guint16 mic_gain_level);
extern gint16   ecnr_service_get_mic_gain_level(void);
extern void     ecnr_service_set_use_default_dp(void);
extern void     ecnr_service_set_use_default_dp_exit(void);
extern gboolean ecnr_service_is_use_default_dp(void);


/* function for testing */

#ifdef D_TRIGGER_PERFORMANCE_TEST
extern void ecnr_service_test_performance_initialize(void);
extern void ecnr_service_test_performance_start(void);
extern void ecnr_service_test_performance_stop(void);
#endif


#endif
