/*
 * ecnr-object.h
 *
 *
 ********************************
 * qwa-object.h
 *
 * Andy Lowe <alowe@mvista.com>
 *
 * 2010 (c) MontaVista Software, LLC. This file is licensed under
 * the terms of the AFL.
 **********************************
 * Author: Patrick Rey
 * Date: 15.08.2013
 * Version 0.1 :  adaption qwa-object.h as ecnr-object.h
 */

#ifndef __ECNR_OBJECT_H__
#define __ECNR_OBJECT_H__

#include <glib-object.h>
#include <dbus/dbus-glib.h>
#include "sse.h"



typedef struct EcnrObject EcnrObject;
typedef struct EcnrObjectClass EcnrObjectClass;

GType ecnr_object_get_type(void);

struct EcnrObject {
  GObject parent;
  gboolean ecnr_is_initialized;
  gboolean ecnr_Debug_intf_initialized;
  gint ecnr_current_configid;
  guchar ecnr_current_AppId;
};

struct EcnrObjectClass {
  GObjectClass parent;
};


#define ECNR_TYPE_OBJECT              (ecnr_object_get_type ())
#define ECNR_OBJECT(object)           (G_TYPE_CHECK_INSTANCE_CAST ((object), ECNR_TYPE_OBJECT, EcnrObject))
#define ECNR_OBJECT_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), ECNR_TYPE_OBJECT, EcnrObjectClass))
#define ECNR_IS_OBJECT(object)        (G_TYPE_CHECK_INSTANCE_TYPE ((object), ECNR_TYPE_OBJECT))
#define ECNR_IS_OBJECT_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), ECNR_TYPE_OBJECT))
#define ECNR_OBJECT_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), ECNR_TYPE_OBJECT, EcnrObjectClass))


extern   gboolean ecnr_object_ecnr_get_version(EcnrObject * qobj, GArray ** version,
      gchar ** version_string,
      gchar ** version_comment,
      GError ** error);
extern   gboolean ecnr_object_ecnr_get_status_message(EcnrObject * qobj,
      guchar ecnrAppId,
      gchar ** status_message,
      GError ** error);
extern   gboolean ecnr_object_ecnr_initialize(EcnrObject * qobj, guchar ecnrAppId, gint ecnrConfigurationId, GError ** error);
extern   gboolean ecnr_object_ecnr_initialize_sync(EcnrObject * qobj,
      guchar  ecnrAppId,
      gint  ecnrConfigurationId,
      gchar ** InDevices,
      gchar ** OutDevices,
      GArray ** DeviceProperties,
      GError ** error);
extern   gboolean ecnr_object_ecnr_reset(EcnrObject * qobj, guchar ecnrAppId, GError ** error);
extern   gboolean ecnr_object_ecnr_destroy(EcnrObject * qobj, guchar ecnrAppId, GError ** error);
extern   gboolean ecnr_object_ecnr_start_audio(EcnrObject * qobj, guchar ecnrAppId, GError ** error);
extern   gboolean ecnr_object_ecnr_start_audio_ext(EcnrObject * qobj, guchar ecnrAppId, guchar StartMode, GError ** error);
extern   gboolean ecnr_object_ecnr_stop_audio(EcnrObject * qobj, guchar ecnrAppId, GError ** error);
extern   gboolean ecnr_object_ecnr_frame_info(EcnrObject * qobj,
      guint * FrameCounter,
            gint * VoicePresent,
            gint * AboveBackgroundNoise,
            gint * PercentClipping,
            gint * InstantaneousSNR,
            gint * SmoothVNR,
            gint * ValidOutputCountdown,
            GError ** error);
extern   gboolean ecnr_object_ecnr_mic_clip_stats(EcnrObject * qobj, gint Channel,
            guint * ClipFrames,
            guint * ClipCount, gint * MaxAmp,
            gint * MinAmp, GError ** error);
extern   gboolean ecnr_object_ecnr_ref_clip_stats(EcnrObject * qobj,
            guint * ClipFrames,
            guint * ClipCount, gint * MaxAmp,
            gint * MinAmp, GError ** error);
extern   gboolean ecnr_object_ecnr_recv_clip_stats(EcnrObject * qobj,
            guint * ClipFrames,
            guint * ClipCount, gint * MaxAmp,
            gint * MinAmp, GError ** error);
extern   gboolean ecnr_object_ecnr_mic_out_clip_stats(EcnrObject * qobj,
            guint * ClipFrames,
            guint * ClipCount,
            gint * MaxAmp, gint * MinAmp,
            GError ** error);
extern   gboolean ecnr_object_ecnr_recv_out_clip_stats(EcnrObject * qobj,
      guint * ClipFrames,
            guint * ClipCount,
            gint * MaxAmp, gint * MinAmp,
            GError ** error);
extern   gboolean ecnr_object_ecnr_terminate(EcnrObject * qobj, GError ** error);
extern   gboolean ecnr_object_ecnr_set_configuration(EcnrObject * qobj,
      guchar ecnrAppId,
      gint ecnrConfigurationId,
      GError ** error);
extern   gboolean ecnr_object_ecnr_set_configuration_sync(EcnrObject * qobj,
      guchar  ecnrAppId,
      gint  ecnrConfigurationId,
    gchar ** InDevices,
    gchar ** OutDevices,
      GArray ** DeviceProperties,
      GError ** error);
extern   gboolean ecnr_object_ecnr_get_ecnr_configuration(EcnrObject * qobj,
      gchar ** DatasetName,
      GArray ** EcnrProperties,
      GError ** error);

extern   gboolean ecnr_object_ecnr_start_debug_data(EcnrObject * qobj,guchar ecnrDebugMode, GError ** error);
extern   gboolean ecnr_object_ecnr_end_debug_data(EcnrObject * qobj,guchar ecnrDebugMode, GError ** error);

/* new revision 1.1*/

extern   gboolean ecnr_object_ecnr_set_send_mute_switch(EcnrObject * qobj, guchar ecnrAppId, guchar ecnrSendMuteSwitch, GError ** error);
extern   gboolean ecnr_object_ecnr_set_send_gain_delta(EcnrObject * qobj, guchar ecnrAppId, gint16 ecnrLevel, GError ** error);
extern   gboolean ecnr_object_ecnr_set_mic_gain(EcnrObject * qobj, gint16 MicGainLevel, GError ** error);
extern   gboolean ecnr_object_ecnr_set_pass_through_mode(EcnrObject * qobj, guchar ecnrAppId, guchar ecnrPassThroughMode, GError ** error);
extern   gboolean ecnr_object_ecnr_set_nr_comb_floor(EcnrObject * qobj, guchar ecnrAppId, gint16 ecnrNRCombFloor, GError ** error);
extern   gboolean ecnr_object_ecnr_set_echo_cancellation(EcnrObject * qobj, guchar ecnrAppId, guchar EcnrECState, GError ** error);
extern   gboolean ecnr_object_ecnr_set_noise_reduction(EcnrObject * qobj, guchar ecnrAppId, guchar EcnrNRState, GError ** error);
extern   gboolean ecnr_object_ecnr_alsa_set_device (EcnrObject * qobj,
      guchar ecnrAppId,
      guint AlsaDeviceSelect,
      gchar * AlsaDeviceName,
      GError ** error);
extern   gboolean ecnr_object_ecnr_alsa_set_thread_priority(EcnrObject * qobj, guchar ecnrAppId, gint priority, GError ** error);
extern   gboolean ecnr_object_ecnr_alsa_set_wide_band(EcnrObject * qobj, guchar ecnrAppId, GError ** error);
extern   gboolean ecnr_object_ecnr_alsa_set_device_properties(EcnrObject * qobj,
      guchar  ecnrAppId,
      guint  AlsaDeviceSelect,
      guchar  AlsaDeviceProperty,
      guint  PropertyValue,
      GError  **  error);




#endif
