/*
 * Common test data queue handling code for the D-bus Bluetooth Daemon
 *
 * Author: Dean Jenkins <djenkins@mvista.com>
 *
 * 2010 (c) MontaVista Software, LLC. This file is licensed under
 * the terms of the AFL.
 */

/* exported types */

struct test_queue_list {
	/* holds the test queue list (tql)*/
	GSList *cfm_tql;
};

/* record of cfm test queue entry */
struct cfm_test_queue_entry {
	struct test_queue_list *queue_info;
	enum node_cfm_number cfm_id;
	BD_ADDRESS bd_addr;
	gpointer test_data_struct;
};


/* exported functions */
extern void utils_test_queue_initialise(struct test_queue_list *queue_info);

extern void utils_test_queue_destroy(struct test_queue_list *queue_info);

extern void utils_test_queue_add_list_entry(struct test_queue_list *queue_info,
						enum node_cfm_number cfm_id,
						const BD_ADDRESS bd_addr,
						gpointer test_data_struct);

extern gpointer utils_test_queue_find_list_entry(
					struct test_queue_list *queue_info,
					enum node_cfm_number cfm_id,
					const BD_ADDRESS bd_addr);

