/**
* @file SimpleMemoryPool.h
* @addtogroup oss
* @{
*/

#ifndef MAPENGINE_OSS_SIMPLEMEMORYPOOL_
#define MAPENGINE_OSS_SIMPLEMEMORYPOOL_ 1 

#define BLOCK_SIZE 1000000

namespace mapengine {
namespace oss {

class me_SimpleMemoryPool
{
public:
   struct MemNode
   {
      int mSize;
      unsigned char *mem;
      MemNode *next;
   };

   struct MemPtr
   {
      MemNode *node;
      int offset;
   };

   static me_SimpleMemoryPool& getInstance()
   {
      return _memPool;
   }

   ~me_SimpleMemoryPool();

   void* simpleMalloc(int tSize);
   void* simpleRealloc(void *ptr,int preSize, int tSize);
   void  simpleFree(void *ptr);
   void cleanAndReset();

private:
   me_SimpleMemoryPool();

   void dispose(MemNode *node);

   MemNode* _head;
   MemPtr _curPos;
   static me_SimpleMemoryPool _memPool;
};

}
}

#endif // MAPENGINE_OSS_SIMPLEMEMORYPOOL_
