
#ifndef _STL_EXCEPTION_
#define _STL_EXCEPTION_

namespace bpstl
{

   class exception
   {
   public:
      class tclTypeInfo
      {
      public:
         tclTypeInfo()
            : pParent(NULL)
         {
         }

         tclTypeInfo* pParent;
      };

      exception(tU32 u32Error = 0)
         : szWhat("exception")
         , u32ErrorCode(u32Error)
      {
      }

      exception(const tChar* szDescription, tU32 u32Error = 0)
         : szWhat(szDescription)
         , u32ErrorCode(u32Error)
      {
      }

      virtual ~exception(){szWhat = NULL;}

      virtual const tChar* what() const
      {
         return szWhat;
      }

      tBool bIsOfType(exception::tclTypeInfo* poOtherType)
      {
         tBool bIsType = FALSE;
         tclTypeInfo* poOwnType = poGetTypeInfo();

         while(poOwnType != NULL)
         {
            if(poOtherType == poOwnType)
            {
               bIsType = TRUE;
            }
            poOwnType = poOwnType->pParent;
         }

         return bIsType;
      }


      tBool bIsOfType(exception& rfoOther)
      {
         return bIsOfType(rfoOther.poGetTypeInfo());
      }

      static tclTypeInfo* poGetClassTypeInfo()
      {
         return &oThisType;
      }

   tU32 u32GetErrorCode() const
      {
         return u32ErrorCode;
      }

#ifdef VARIANT_S_FTR_ENABLE_EXH_EXCEPTIONS
      void* operator new(tSize Size) throw();

      void operator delete(void* pvMem)
      {
      }
#endif

   protected:
      virtual tclTypeInfo* poGetTypeInfo()
      {
         return &oThisType;
      }

   const tChar* szWhat;
   tU32  u32ErrorCode;
      static tclTypeInfo oThisType;
   };

} // end namespace bpstl::

#endif /* _STL_EXCEPTION_ */


