/*
  $Log:   //hi230124/projects/Vasco/swnavi/archives/products/stl/Microsoft/include/clTLS.h-arc  $
 *
 *    Rev 1.2   Aug 14 2003 10:30:04   Wiedemann
 * changes for better performance
*/

#ifndef EMUL_TLS_HEADER
#define EMUL_TLS_HEADER

// Invalid handle
#define EXH_TLS_INDEX_INVALID 0xFFFFFFFF

class tclTLS
{
public:
   tBool  bInit();
   tU32   Alloc();
   tVoid* GetValue(tU32 index);
   tBool  SetValue(tU32 index, tVoid* data);
   tVoid  Free(tU32 index);

   tclTLS();
   ~tclTLS();

private:
   struct trThreadData
   {
      OSAL_tThreadID thread;
      tVoid*         pData;
   };

   enum { enMaxThreads = 100 };

   tBool bInsertEntry(tU32 index, const trThreadData& data);
   trThreadData* prFindEntry(tU32 index);

   tU32            m_u32Index;
   int             m_nEntries;
   OSAL_tSemHandle m_hLock;
   tChar           m_acName[32];
   tBool           m_bInitialised;
   trThreadData    m_arData[enMaxThreads];

   /*-- memorize the last found index */
   int             m_nLastHit;
};
#endif
