#ifndef BP_OSALWRAPPER_H
#define BP_OSALWRAPPER_H

/* inline wrapper functions to prevent OSAL error traces */

_BP_STL_BEGIN_NAMESPACE

inline void* bpstl_pvMemoryMove(void* pDest, const void* pSrc, tU32 u32Size)
{
   if(u32Size > 0)
   {
      return OSAL_pvMemoryMove(pDest, pSrc, u32Size);
   }

   return pDest;
}

inline tS32 bpstl_s32MemoryCompare(const void* pFirst, const void* pSecond, tU32 u32Len)
{
   if(u32Len > 0)
   {
      return OSAL_s32MemoryCompare(pFirst, pSecond, u32Len);
   }

   return u32Len;
}

inline void* bpstl_pvMemorySet(void* pDest, tU32 u32Char, tU32 u32NBytes)
{
   if(u32NBytes > 0)
   {
      return OSAL_pvMemorySet(pDest, u32Char, u32NBytes);
   }

   return pDest;
}

_BP_STL_END_NAMESPACE

#endif // BP_OSALWRAPPER_H
