/*
 * test node handling for the D-bus Bluetooth Daemon
 *
 * Author: Dean Jenkins <djenkins@mvista.com>
 *
 * 2010 (c) MontaVista Software, LLC. This file is licensed under
 * the terms of the AFL.
 */

/* exported functions */
extern gboolean test_object_creation(DBusGConnection *bus,
							gchar *node_name);

/* imported callback function handlers */
extern BTHRESULT BT_APPL_PBDL_Data_IND_Callback(IN const BD_ADDRESS bd_addr,
								IN u8 data_type,
								IN u32 data_len,
								IN u8 *data);

extern BTHRESULT BT_APPL_PBDL_Data_Complete_IND_Callback(
						IN const BD_ADDRESS bd_addr,
						IN u8 status,
						IN u16 pb_number);

extern BTHRESULT BT_APPL_PBDL_Calendar_Complete_IND_Callback(
						IN const BD_ADDRESS bd_addr,
						IN u8 status);

extern BTHRESULT BT_APPL_PBDL_Con_Lost_IND_Callback(
						IN const BD_ADDRESS bd_addr);

extern BTHRESULT BT_APPL_PBDL_Status_Chg_IND_Callback(
						IN const BD_ADDRESS bd_addr,
						IN u8 status);

extern BTHRESULT BT_APPL_MAP_List_Msg_IND_Callback(IN const BD_ADDRESS bd_addr,
					IN u8 service_name_len,
					IN const u8* service_name,
					IN const MsgListingPtr_t msg_listing);

extern BTHRESULT BT_APPL_MAP_List_Msg_Comp_IND_Callback(
						IN const BD_ADDRESS bd_addr,
						IN u8 service_name_len,
						IN const u8* service_name,
						IN u16 total_size,
						IN u8 status);

/* imported from the dummy API */
extern void dummy_set_test_node_queue(struct test_queue_list *list_info);

/*************************************/
/* cfm test data queue parms structs */
/*************************************/

struct pbdl_start_cfm_parms_s {
	guint8 status;
	guint32 pb_number;
	guint8 new_missed_call;
};

struct avp_get_metadata_attr_cfm_parms_s {
	u8 status;
	u8 num_attributes;
	GByteArray *data;
};

struct avp_get_media_player_item_cfm_parms_s {
	u8 status;
	u32 num_items;
};

struct avp_get_media_player_item_ind_parms_s {
	u8 status;
	GByteArray *data;
};

