/*
 * device node handling for the D-bus Bluetooth Daemon
 *
 * Author: Dean Jenkins <djenkins@mvista.com>
 *
 * 2010 (c) MontaVista Software, LLC. This file is licensed under
 * the terms of the AFL.
 */

/**********************/
/* exported functions */
/**********************/
extern gboolean device_object_creation(DBusGConnection *bus, gchar *node_name,
						BD_ADDRESS *our_address,
						DeviceObject **device_object);

extern void device_object_destroy(DBusGConnection *bus,
						DeviceObject **device_object);

/*********************************/
/* async method return functions */
/*********************************/
extern gboolean device_object_get_device_name_RTN(BD_ADDRESS device_address,
							gchar *device_name);

extern gboolean device_object_hf_dial_RTN(BD_ADDRESS device_address,
								guint8 status,
								guint8 code);

extern gboolean device_object_hf_redial_RTN(BD_ADDRESS device_address,
								guint8 status,
								guint8 code);

extern gboolean device_object_hf_mem_dial_RTN(BD_ADDRESS device_address,
								guint8 status,
								guint8 code);

extern gboolean device_object_hf_terminate_call_RTN(BD_ADDRESS device_address,
								guint8 status,
								guint8 code);

extern gboolean device_object_hf_terminate_all_RTN(BD_ADDRESS device_address,
								guint8 status,
								guint8 code);

extern gboolean device_object_hf_audio_transfer_RTN(BD_ADDRESS device_address,
								guint8 status,
								guint8 code);

extern gboolean device_object_hf_send_dtmf_RTN(BD_ADDRESS device_address,
								guint8 status,
								guint8 code);

extern gboolean device_object_hf_incoming_call_act_RTN(
						BD_ADDRESS device_address,
						guint8 status,
						guint8 code);

extern gboolean device_object_hf_release_inactive_call_RTN(
						BD_ADDRESS device_address,
						guint8 status,
						guint8 code);

extern gboolean device_object_hf_release_active_call_RTN(
						BD_ADDRESS device_address,
						guint8 status,
						guint8 code);

extern gboolean device_object_hf_swap_call_RTN(BD_ADDRESS device_address,
								guint8 status,
								guint8 code);

extern gboolean device_object_hf_add_call_RTN(BD_ADDRESS device_address,
								guint8 status,
								guint8 code);

extern gboolean device_object_hf_release_spec_call_RTN(
						BD_ADDRESS device_address,
						guint8 status,
						guint8 code);

extern gboolean device_object_hf_hold_excep_call_RTN(
						BD_ADDRESS device_address,
						guint8 status,
						guint8 code);

extern gboolean device_object_hf_exp_call_trans_RTN(
						BD_ADDRESS device_address,
						guint8 status,
						guint8 code);

extern gboolean device_object_hf_subscriber_RTN(BD_ADDRESS device_address,
						guint8 status,
						guint8 code,
						GPtrArray *subscriber_info);

extern gboolean device_object_hf_manufacturer_id_RTN(BD_ADDRESS device_address,
							guint8 status,
							guint8 code,
							gchar *manufacturer);

extern gboolean device_object_hf_model_id_RTN(BD_ADDRESS device_address,
								guint8 status,
								guint8 code,
								gchar *model);

extern gboolean device_object_hf_revision_id_RTN(BD_ADDRESS device_address,
							guint8 status,
							guint8 code,
							gchar *revision);

extern gboolean device_object_hf_voice_recognition_activation_RTN(
						BD_ADDRESS device_address,
						guint8 activation,
						guint8 status);

extern gboolean device_object_avp_ctrl_cmd_RTN(BD_ADDRESS device_address,
							guint8 command,
							guint8 status_flag,
							guint8 status);

extern gboolean device_object_appl_siri_xapl_RTN(BD_ADDRESS device_address,
							guint8 status_flag,
							gchar *parameter);

extern gboolean device_object_siri_nrstat_RTN(BD_ADDRESS device_address,
									guint8 status );

extern gboolean device_object_siri_efm_RTN(BD_ADDRESS device_address,
									guint8 status );

extern gboolean device_object_avp_get_capabilities_RTN(
						BD_ADDRESS device_address,
						guint8 status,
						guint8 capability_id,
						guint32 event_supported);

extern gboolean device_object_avp_list_attr_RTN(BD_ADDRESS device_address,
						guint8 status,
						guint8 attributes_bit);

extern gboolean device_object_avp_list_val_RTN(BD_ADDRESS device_address,
						guint8 status,
						GByteArray *setting_values,
						guint8 current_value);

extern gboolean device_object_avp_set_val_RTN(BD_ADDRESS device_address,
								guint8 status);

extern gboolean device_object_avp_set_player_RTN(BD_ADDRESS device_address,
							guint8 status,
							guint32 num_item,
							guint8 is_db_aware);

extern gboolean device_object_avp_get_metadata_attr_RTN(
						BD_ADDRESS device_address,
						guint8 status,
						guint8 num_attributes,
						gboolean network_order,
						GByteArray *data);

extern gboolean device_object_avp_get_folder_item_RTN(DeviceObject *object);

extern gboolean device_object_avp_get_media_player_item_RTN(
							DeviceObject *object);

extern gboolean device_object_avp_change_path_RTN(BD_ADDRESS device_address,
							guint8 status,
							guint32 num_items);

extern gboolean device_object_avp_play_item_RTN(BD_ADDRESS device_address,
							guint8 status);

extern gboolean device_object_pb_dl_get_capabilities_RTN(
						BD_ADDRESS device_address,
						guint8 status,
						guint8 type);

extern gboolean device_object_pb_dl_prepare_RTN(BD_ADDRESS device_address,
								guint8 type);

extern gboolean device_object_pb_dl_start_RTN(BD_ADDRESS device_address,
							guint8 status,
							guint32 pb_number,
							guint8 new_missed_call);

extern gboolean device_object_pb_dl_complete_RTN(BD_ADDRESS device_address,
							guint8 status);

extern gboolean device_object_pb_dl_stop_RTN(BD_ADDRESS device_address,
                      guint8 status);

extern gboolean device_object_map_get_capabilities_RTN(
	BD_ADDRESS device_address, guint8 status,
	GPtrArray *msg_capability);

extern gboolean device_object_map_start_RTN(BD_ADDRESS device_address,
	guint8 status);

extern gboolean device_object_map_stop_RTN(BD_ADDRESS device_address,
	guint8 status);

extern gboolean device_object_map_chg_instance_RTN(BD_ADDRESS device_address,
	guint8 status);

extern gboolean device_object_map_update_inbox_RTN(BD_ADDRESS device_address,
	guint8 status);

extern gboolean device_object_map_list_folder_RTN(BD_ADDRESS device_address,
	guint8 status, guint8 accessible, guint32 folder_num);

extern gboolean device_object_map_list_msg_RTN(BD_ADDRESS device_address,
	guint8 status, guint32 message_num);

#ifdef INCLUDE_CALLBACK_TYPES
extern gboolean device_object_map_read_msg_RTN(map_read_msg_cfm_t *parms);
#endif

extern gboolean device_object_map_set_msg_status_RTN(BD_ADDRESS device_address,
	guint8 status);

extern gboolean device_object_map_upload_RTN(BD_ADDRESS device_address,
	guint8 status);

extern gboolean device_object_map_abort_RTN(BD_ADDRESS device_address,
	guint8 status);

/*****************************/
/* signal emitting functions */
/*****************************/
extern gboolean emit_disconnection(BD_ADDRESS device_address, guint8 service,
							guint8 conn_loss_type);

extern gboolean emit_role_change(BD_ADDRESS device_address, gboolean status,
							guint8 role);

extern gboolean emit_call_status(BD_ADDRESS device_address, guint8 call_handle,
							guint8 call_total,
							guint8 call_direction,
							guint8 call_state,
							guint8 call_mode,
							gchar *call_number,
							guint8 call_type);

extern gboolean emit_phone_status(BD_ADDRESS device_address,
						guint8 phone_service,
						guint8 phone_signal,
						guint8 phone_roaming,
						guint8 phone_battery,
						gchar *phone_operator_name,
						guint32 phone_supp_feature,
						guint8 phone_AgThreeWayCallSuppFeatures);

extern gboolean emit_hf_ring(BD_ADDRESS device_address, guint8 ring_tone);

extern gboolean emit_hf_setup_audio(BD_ADDRESS device_address);

extern gboolean emit_hf_setup_audio_wbs_ind(BD_ADDRESS device_address, guint8 audiocodec);

extern gboolean emit_hf_release_audio(BD_ADDRESS device_address);

extern gboolean emit_hf_voice_recognition_activation_ind(
						BD_ADDRESS device_address,
						guint8 activation);

extern gboolean emit_siri_aplsiri_ind(BD_ADDRESS device_address,
                        u8 status);

extern gboolean emit_siri_nrstat_ind(BD_ADDRESS device_address,
                        u8 ucAplNrStat);

extern gboolean emit_avp_version(BD_ADDRESS device_address, guint8 version);

extern gboolean emit_avp_ctrl_cmd_ind(BD_ADDRESS device_address,
							guint8 command);

extern gboolean emit_avp_play_status(BD_ADDRESS device_address, guint8 status,
							guint32 song_length,
							guint32 song_position,
							guint8 play_status);

extern gboolean emit_avp_notify_set_complete(BD_ADDRESS device_address,
							guint32 event_id);

extern gboolean emit_avp_notify_chg(BD_ADDRESS device_address, guint8 event_id,
							gboolean network_order,
							GByteArray *data);

extern gboolean emit_avp_codec_and_bitrate(BD_ADDRESS device_address,
					   guint8 codec_type, guint32 bitrate);

extern gboolean emit_pb_dl_data_signal(DeviceObject *object);

extern gboolean emit_pb_dl_connection_lost(BD_ADDRESS device_address);

extern gboolean emit_pb_dl_status_chg(BD_ADDRESS device_address, guint8 status);

extern gboolean emit_map_active_instance(BD_ADDRESS device_address,
	gchar *sms_name, gchar *email_name);

extern gboolean emit_map_notify_status(BD_ADDRESS device_address,
	guint8 status);

extern gboolean emit_map_notify_regist_status(BD_ADDRESS device_address,
						gchar *service_name,
						guint8 status);

extern gboolean emit_map_list_folder_data(BD_ADDRESS device_address,
	gchar *service_name, gchar **folder_listing);

extern gboolean emit_map_list_folder_comp(BD_ADDRESS device_address,
	gchar *service_name, guint32 total_size, guint8 status);

extern gboolean emit_map_list_msg_data(DeviceObject *object);

extern gboolean emit_map_list_msg_comp(BD_ADDRESS aucBD_device_address,
	gchar *service_name, guint32 total_size, guint8 status);

extern gboolean emit_map_read_msg_data(BD_ADDRESS aucBD_device_address,
	gchar *service_name, guint8 data_flag, GByteArray *msg_data);

extern gboolean emit_map_read_msg_comp(BD_ADDRESS aucBD_device_address,
	gchar *service_name);

extern gboolean emit_map_upload_comp(BD_ADDRESS aucBD_device_address,
	gchar *service_name, guint8 status);

#ifdef INCLUDE_CALLBACK_TYPES
extern gboolean emit_map_notify(map_notify_ind_t *parms);
#endif

extern gboolean emit_map_error_report(BD_ADDRESS device_address,
	gchar *service_name, guint8 operation, guint8 error_code);

extern gboolean emit_nap_destroy_device_ind(BD_ADDRESS device_address,
							guint8 service);
