/*
 * manager node handling for the D-bus Bluetooth Daemon
 *
 * Author: Dean Jenkins <djenkins@mvista.com>
 *
 * 2010 (c) MontaVista Software, LLC. This file is licensed under
 * the terms of the AFL.
 */

/* exported functions */
extern gboolean adapter_object_creation(DBusGConnection *bus,
							gchar *node_name);

extern struct btd_audio *adapter_object_get_btd_audio(void);

extern gboolean adapter_add_device_to_list(BD_ADDRESS our_address);
extern gboolean adapter_remove_device_from_list(BD_ADDRESS our_address);

extern gboolean adapter_object_nap_create_device_RTN(BD_ADDRESS device_address,
							guint8 service,
							guint8 status,
							gchar *device_name);

extern gboolean adapter_object_nap_destroy_device_RTN(BD_ADDRESS device_address,
							guint8 service,
							guint8 status);

/* exported signal functions */
extern gboolean emit_connection_complete(BD_ADDRESS device_address,
							gboolean status,
							guint8 service);

extern gboolean emit_service_type(BD_ADDRESS device_address, guint service_type);

extern gboolean emit_versions(void);

extern gboolean emit_ssp_numeric_confirm_ind(BD_ADDRESS device_address,
						gchar *name,
						guint32 numeric_value);

extern gboolean emit_connection_request_ind(BD_ADDRESS device_address,
						guint8 service);

extern gboolean emit_nap_spp_capabilities(BD_ADDRESS *device_address,
					GPtrArray *spp_capabilities_payload);


extern gboolean emit_pnp_info_ind(BD_ADDRESS *bd_addr, GPtrArray* all_pnp_info_ind_data);

extern gboolean emit_inquiry_complete_ind(gboolean status);
extern gboolean emit_inquiry_ind(BD_ADDRESS bd_addr,guint8 rep_mode,
							guint8 major_device_class,guint8 minor_device_class,
							guint32 major_service_class,guint32 clock_offset,
							gint32 rssi,gchar* eir_data);

