/*
 * main handling for the D-bus Bluetooth Daemon
 *
 * Author: Dean Jenkins <djenkins@mvista.com>
 *
 * 2010 (c) MontaVista Software, LLC. This file is licensed under
 * the terms of the AFL.
 */


/* exported macros */
#define ARRAYSIZE(X)  (sizeof(X)/sizeof(X[0]))


#define D_BUS_BT_VERSION	"1.1.1.2.0"

/* to identify that the output messages are from this progam */
#define PROG_ID	"BTD: 1.1.1.2.0: "

/* D-bus API options bitmap */
#define DBUS_USE_ALT_SSP_NUMERIC_CONFIRM	(1 << 0)
#define DBUS_USE_ALT_CONNECTION_REQUEST		(1 << 1)

/* exported types */


/* exported functions */

extern gboolean test_alps_version_check(void);
extern guint get_audio_thread_priority(void);
extern guint get_alps_thread_priority(void);
extern guint16 get_alps_stack_version(void);
extern guint8 get_alps_stack_test_version(void);
extern guint8 get_alps_debug_level(void);
extern guint read_dbus_api_options(void);
extern gint read_max_init_count(void);
