/*
 * phonebook handling for the D-bus Bluetooth Daemon
 *
 * Author: Dean Jenkins <djenkins@mvista.com>
 *
 * 2010 (c) MontaVista Software, LLC. This file is licensed under
 * the terms of the AFL.
 */

#define PBDL_AGENT_SERVICE_NAME "com.data.agent"
#define PBDL_AGENT_SERVICE_OBJECT_PATH "/"
#define PBDL_AGENT_SERVICE_INTERFACE "com.data.agent.Pbdl"

/* exports globals */
extern gchar *phonebook_state_str[PBDL_TOTAL_STATES];

/* exported functions */
extern void handle_phonebook_set_wait_data(DeviceObject *object, guint8 pb_type,
						guint32 max_total_recs,
						guint32 current_total_recs,
						guint8 max_recs_per_trans,
						gboolean use_agent);

extern gboolean handle_phonebook_pb_dl_data(BD_ADDRESS device_address,
							guint8 data_type,
							GByteArray *data);

extern gboolean handle_phonebook_pb_dl_data_complete(BD_ADDRESS device_address,
							guint8 status,
							guint32 pb_number);

extern gboolean handle_phonebook_pb_dl_calendar_complete(
						BD_ADDRESS device_address,
						guint8 status);

extern gboolean create_pbdl_agent_dbus_proxy(DBusGConnection *bus);

extern gboolean send_pbdl_agent_data(DeviceObject* object);

