/*
 * bt_appl compatibility versioning for the D-bus Bluetooth Daemon
 *
 * Author: Dean Jenkins <djenkins@mvista.com>
 *
 * 2010 (c) MontaVista Software, LLC. This file is licensed under
 * the terms of the AFL.
 */

/********************************************************************
 * PLEASE CHECK THAT THE CONTENTS OF THE ALPS HEADER FILES IN       *
 * ./api/ ARE VALID FOR THE SPECIFIED RANGE OF ALPS LIBRARIES'      *
 * VERSIONS BEFORE ADJUSTING THESE SETTINGS                         *
 ********************************************************************/

/* convert to ALPS library version numbering */
#define ALPS_VERSION(x,y) ((x*256)+(y))

/*
 * The bt_appl header files are compatible with this minimum version
 * of the ALPS libraries.
 */
#define MIN_ALPS_LIB	ALPS_VERSION(2,53)	/*  */

/*
 * The bt_appl header files are compatible with this maximum version
 * of the ALPS libraries.
 */
#define MAX_ALPS_LIB	ALPS_VERSION(4,0)	/* v4.0 libraries to API specification v4.0.000// DIP,WBS and INquiry related changes are not implemented in bt_daemon */

