/* -*-c++-*-
mapengine_oss

* osgEarth - Dynamic map generation toolkit for OpenSceneGraph
* Copyright 2008-2010 Pelican Mapping
* http://osgearth.org
*
* osgEarth is free software; you can redistribute it and/or modify
* it under the terms of the GNU Lesser General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>

History:
Copied from https://github.com/gwaldron/osgearth/blob/osgearth_2.0_T2011-02-24/src/osgEarthUtil/StarData
List of changes:
1. Optimized star data to be stored as binary data instead of strings
*/

#ifndef MAPENGINE_OSS_STARDATA_
#define MAPENGINE_OSS_STARDATA_

namespace mapengine {
namespace oss {

static const double  s_defaultStarData[] =  {
    0.0351079691843475,0.789397876266602,6.7,
    0.0269183473096049,0.0087799757648937,6.29,
    0.0897502003814007,-0.0253266667011622,6.43,
    0.104988267312274,0.444409308925867,6.23,
    0.0424920544812466,-0.94244385911926,6.33,
    0.0835072919031133,0.997727163176181,6.74,
    0.0954560844744591,-1.2701730594125,6.64,
    0.120024950098687,0.657872772718396,6.73,
    0.0889446638035572,0.471015883745159,6.3,
    0.116064395257623,-0.448816265287153,6.31,
    0.0641744140348684,0.579555970671962,6.25,
    0.136404193848172,0.388932079396503,6.24,
    0.0748477736912953,0.550404124026845,6.45,
    0.0796809931583565,0.476179149448975,6.35,
    0.088609023562789,1.34304540382007,6.35,
    0.139559212111393,-1.29309020211854,6.49,
    0.126872011010357,-0.345390962696056,6.47,
    0.135598657270329,-1.3477335521164,6.77,
    0.117943980605924,-0.330720500705681,6.45,
    0.134658864596178,-0.138705194165438,6.46,
    0.135732913366636,-0.746385206478564,6.33,
    0.138753675533549,0.710867756200479,6.33,
    0.0942477796076938,0.85285998712384,6.52,
    0.160436035087171,0.191583822364055,6.56,
    0.130228413418038,0.235314016400135,6.23,
    0.165537766746847,-0.205784015083754,6.39,
    0.117272700124388,-0.5404218103328,6.55,
    0.107404877045805,0.673299544051301,7.39,
    0.150501083960434,-0.343218997404685,6.43,
    0.19816199814951,0.644026493985908,6.26,
    0.18003742514803,-0.863365899593484,6.26,
    0.204740546868566,1.34424289361241,6.21,
    0.192187601863837,-0.556469143177525,6.57,
    0.175606973969891,0.759126110018122,6.7,
    0.169901089876833,1.23886379188644,6.42,
    0.18594469338555,0.481371503973658,6.67,
    0.205546083446409,0.493583960600807,6.3,
    0.181782754400025,1.16501212384303,6.48,
    0.222596607677431,0.233369913538886,6.4,
    0.226154394229573,0.230499816546718,6.41,
    0.183930851940941,0.475684639494244,6.5,
    0.161107315568707,-0.227353375756317,6.45,
    0.171109394743598,0.419126275456005,6.47,
    0.233672735622779,1.43978997388548,6.4,
    0.207291412698403,-1.13228720036813,6.42,
    0.202391065183189,0.0547209201868333,6.39,
    0.185743309241089,-0.935598289941994,6.41,
    0.220582766232822,-1.27169537437118,6.85,
    0.247903881831348,-0.559174403518117,6.69,
    0.212930168743308,-0.270230297713644,6.49,
    0.253072741539178,1.20994950394507,6.33,
    0.220985534521744,0.965259190952275,6.52,
    0.252334333009488,-0.27184957540855,6.47,
    0.257637448813624,1.039770205602,6.39,
    0.27864852788571,0.365214994116625,6.54,
    0.285562716845534,-0.79067293624792,6.27,
    0.284690052219537,0.483645280138062,7,
    0.285227076604766,0.48363558386444,7.1,
    0.258644369535929,-0.39511345383065,6.28,
    0.295229155779656,0.898985160744601,6.39,
    0.22313363206266,-0.743602375948995,6.48,
    0.267773784084822,0.90008568780072,6.21,
    0.247098345253505,0.0590793951800081,6.37,
    0.292476905805357,-0.738114285078835,6.9,
    0.298585558187338,0.672800185959758,6.69,
    0.295162027731503,0.919599438465379,6.27,
    0.247903881831348,-0.405318781818005,6.46,
    0.259517034161926,-1.19547296742714,6.22,
    0.246964089157198,0.849602039186784,6.27,
    0.261665131702842,1.01223278851498,6.21,
    0.318992484826041,1.20036958560634,6.37,
    0.321878990896647,0.239037385471057,6.32,
    0.278447143741249,0.373578030115764,6.37,
    0.303418777654399,1.2388880325705,6.39,
    0.283146107112003,-1.03504327221118,6.23,
    0.266364095073596,0.780356101113909,6.84,
    0.473454123627539,1.55361452993637,6.46,
    0.295229155779656,0.890728783755306,6.47,
    0.276903198633716,0.826869125679558,6.45,
    0.298518430139184,-0.496967960094952,6.29,
    0.342084533390889,0.890292451442307,6.54,
    0.328121899374934,-1.1265033731525,6.21,
    0.328121899374934,0.697976560419777,6.72,
    0.349737130880402,1.52097202478727,6.25,
    0.318589716537119,1.09539772737251,6.54,
    0.317582795814814,1.39646702334153,6.29,
    0.349670002832249,0.085666577452055,6.35,
    0.352623636951008,0.0856859699992994,7.25,
    0.292611161901665,0.993703209622971,6.43,
    0.30509697885824,0.9337220609961,6.38,
    0.323557192100487,-0.59933152072442,6.61,
    0.309930198325301,-0.384035461217297,6.37,
    0.29845130209103,0.558718678657874,6.25,
    0.321543350655878,-0.123811717881753,6.4,
    0.315367570225745,-0.982717331609029,6.41,
    0.331813942023383,1.07696995935353,6.41,
    0.37282917944525,1.39469260526867,6.26,
    0.345575191894877,-0.509597356487855,6.52,
    0.379340600116152,0.132266868480304,6.3,
    0.329598716434314,0.497937587457171,6.43,
    0.347857545532101,1.25216707929609,7.83,
    0.3645053014742,0.839193089453362,6.61,
    0.342822941920578,0.783686771103132,6.34,
    0.368331600218957,0.554049922908789,6.73,
    0.375245789178781,1.35386159704562,6.31,
    0.354033325962234,0.8276302831589,6.25,
    0.403439569403305,0.652510733405325,6.46,
    0.34080910047597,-1.14496992626596,6.24,
    0.43277452644644,1.33061962917323,6.38,
    0.360410490536829,1.12850080551867,6.34,
    0.395384203624869,-0.0480498839347661,6.23,
    0.391155136591191,1.01478775661443,6.45,
    0.404513618173763,0.00784913349716339,6.49,
    0.398740606032551,-0.330192053793272,6.35,
    0.412501855904044,0.597702546755892,6.29,
    0.433311550831669,1.23883470306558,6.49,
    0.369875545326491,-0.139495440465647,6.21,
    0.386926069557512,0.603530007202828,6.31,
    0.42277244727155,-0.758723714662802,6.26,
    0.387932990279816,0.600000563604351,6.27,
    0.411897703470662,0.00695707632392184,6.41,
    0.415321233926497,0.717340018843292,6.46,
    0.447072800703163,0.0617022371948106,6.58,
    0.442709477573177,0.703988250065535,6.6,
    0.442105325139794,-0.562631125064428,6.58,
    0.429149611846144,-0.789649979380779,6.31,
    0.411629191278047,0.607374579694027,6.39,
    0.410488014459436,-0.156822681428502,6.59,
    0.45016069091823,-0.842509215032151,6.28,
    0.453449965277758,1.29679417864222,6.58,
    0.485000147909963,0.716918230940726,6.38,
    0.47681052603522,0.255889509026424,6.22,
    0.470164849268011,0.792379480405426,6.36,
    0.47385689191646,-0.150030441756157,6.24,
    0.453919861614833,0.940179779228479,6.39,
    0.494733714892239,-0.435949310190506,6.7,
    0.492317105158708,-0.917364447395464,6.84,
    0.449086642147772,1.06531988659647,6.71,
    0.468956544401246,1.02324775534979,6.37,
    0.523464519501992,1.07201031539578,6.34,
    0.471574538279237,0.791022002098319,6.34,
    0.477817446757525,1.00419942581899,6.21,
    0.495874891710851,-0.871985886843612,6.64,
    0.515677665916171,0.996393925553129,6.25,
    0.516550330542168,0.561850575037841,6.34,
    0.489363471039949,0.805290068733372,6.35,
    0.528700507257975,0.350515443305383,6.27,
    0.509904653774959,0.303915152277135,6.55,
    0.469292184642014,-1.3762212040184,6.33,
    0.46385481274157,-0.465144790066922,6.39,
    0.531318501135966,0.806860865060168,6.32,
    0.531049988943352,-0.642984144571522,6.32,
    0.50178215994837,-0.539781856273735,6.34,
    0.541119196166396,-0.656175924834513,6.37,
    0.556894287482498,0.89840338432727,6.26,
    0.558169720397417,0.97036912715117,6.45,
    0.569648616631688,0.71038294251937,6.24,
    0.574616092195056,0.648011662444628,6.26,
    0.586229244525634,0.727705335345413,6.78,
    0.550718507052365,-0.574795100323466,6.35,
    0.550785635100518,1.28893534887143,6.23,
    0.582470073829031,-1.12705121261215,6.37,
    0.594888762737452,1.13626752069004,6.52,
    0.570051384920609,-0.494539043552593,6.42,
    0.593881842015147,0.318580766130698,6.21,
    0.566292214224006,0.143946030058232,6.31,
    0.58911575059624,0.000610865238198015,6.28,
    0.603615408997424,0.775963689163057,6.42,
    0.577703982410123,0.939738598778669,6.31,
    0.593881842015147,0.300623267382401,6.43,
    0.608784268705253,1.29202846015691,6.29,
    0.610529597957247,1.00610959172256,6.36,
    0.609589805283096,-0.412843090148825,6.48,
    0.605159354104957,0.550239287375268,6.23,
    0.573810555617213,-0.736257448680186,6.32,
    0.636038256255626,1.02208420251512,6.44,
    0.666782902309987,0.834466156062544,6.33,
    0.662822347468923,0.995802452862176,6.48,
    0.62704309780304,-0.148954155384094,6.55,
    0.642616804974681,0.773302062053765,6.7,
    0.611737902824012,0.414825978104563,6.55,
    0.628184274621651,1.12289635936504,6.6,
    0.62113582956552,0.811098136633065,6.21,
    0.636978048929777,0.854430783450635,6.37,
    0.680007127796252,0.404354002592597,6.46,
    0.656579438990636,0.695251907531941,6.63,
    0.616772506435535,0.526885812356221,6.47,
    0.680678408277788,-0.419829255293614,6.34,
    0.66127840236139,-0.0637820878867705,6.5,
    0.639663170855922,-0.70077878349659,6.37,
    0.693499865475131,0.966291844093038,6.28,
    0.654162829257105,0.98803088955399,6.25,
    0.697191908123581,-0.307973042788022,6.22,
    0.635434103822243,-0.747000919853573,6.31,
    0.632681853847944,-0.635711939354879,6.53,
    0.655304006075717,-0.42154064758793,6.44,
    0.706724090961396,-0.0212930168743308,6.33,
    0.683699170444702,0.969292840779106,6.51,
    0.645771823237902,0.0342229977495221,6.45,
    0.667991207176753,-1.1432827746557,6.41,
    0.676784981484878,0.590512759865037,6.25,
    0.724513023722108,-0.37205571515708,6.77,
    0.727533785889021,0.308991151518352,6.23,
    0.673025810788275,-0.433079213198337,6.51,
    0.651679091475421,-1.1117795816572,6.37,
    0.683095018011319,-0.620857248165683,6.3,
    0.721559389603348,-0.349031913441188,6.21,
    0.713772536017527,0.692275151529929,6.36,
    0.740892267471593,-0.888484096411769,6.24,
    0.712966999439684,0.696313649493571,6.54,
    0.693634121571439,0.574072727938613,6.25,
    0.712698487247069,-1.07186002315464,6.77,
    0.758144175847075,0.430194571795736,7.09,
    0.685713011889311,0.430180027385302,6.5,
    0.726728249311177,0.664786215811018,6.3,
    0.690479103308218,0.134307934077775,6.39,
    0.738945554075138,0.060092655773527,6.21,
    0.72270056642196,-0.628483367369536,6.49,
    0.719209907917971,0.106673554254531,6.25,
    0.701488103205413,-0.512535327395379,6.52,
    0.713772536017527,0.842392859748685,6.48,
    0.7456583588905,0.187477450485058,6.3,
    0.736327560197146,-1.11208986241311,6.55,
    0.779960791497004,0.447468483253668,6.35,
    0.741227907712361,0.310038349069548,6.46,
    0.738475657738062,-0.688925088993462,6.36,
    0.743107493060663,-0.549342382065215,6.22,
    0.802582943724777,0.628032490646104,6.25,
    0.733373926078386,0.620551815546584,6.3,
    0.742100572338358,-0.797838482454719,6.85,
    0.746933791805419,-1.13944789843812,6.26,
    0.778752486630239,0.99630665909053,6.25,
    0.784995395108527,-0.355353883842857,6.49,
    0.743711645494045,-0.375497892292958,6.47,
    0.773785011066871,0.651463535854128,6.45,
    0.803858376639696,-0.201401299406523,6.9,
    0.773919267163178,-0.601251382901613,6.51,
    0.807214779047377,1.01778390516368,6.45,
    0.820304748437335,0.924985718462506,6.36,
    0.783317193904686,0.847696721420024,6.26,
    0.806073602228766,-0.664417757413375,6.36,
    0.770562864755496,0.287688438370399,6.31,
    0.820371876485488,-0.509384038468167,6.4,
    0.818290906992726,-0.14938079142347,6.32,
    0.801240382761705,1.12281394103925,6.24,
    0.835878455608977,0.894670318982727,6.22,
    0.767944870877505,-0.857456020820759,6.21,
    0.78727774874575,-1.10940884275657,6.56,
    0.789895742623742,-0.491218069836993,6.29,
    0.857090918825523,0.91371864851352,6.74,
    0.816209937499964,-0.659889597631812,6.41,
    0.832454925153142,-0.549652662821125,6.31,
    0.859977424896129,0.0931327081411419,6.25,
    0.839167729968504,0.493399731401986,6.36,
    0.857493687114445,0.276741345450945,6.49,
    0.843061156761415,0.440787750727979,6.8,
    0.843061156761415,0.440787750727979,7,
    0.825540736193318,0.911294580107973,6.31,
    0.879578814956988,0.825686180297651,6.41,
    0.848767040854473,0.328034632912334,6.27,
    0.872261857708243,0.147843932054353,6.28,
    0.840845931172345,0.485550597904822,6.42,
    0.873201650382394,0.832972929924727,6.33,
    0.876558052790075,-0.388539380314804,6.38,
    0.855949742006912,-0.278811499869283,6.26,
    0.9019995830403,1.14595894617542,6.36,
    0.844135205531873,-0.594391269313913,6.27,
    0.913948375611646,0.573452166426792,6.31,
    0.857762199307059,0.605430476832777,6.25,
    0.874879851586234,0.706567458849038,6.45,
    0.85111652253985,-0.45203542812972,6.25,
    0.870382272359941,-0.509156176038046,6.65,
    0.933348381528045,-0.443202122859904,6.39,
    0.903275015955219,-0.426073655506305,6.35,
    0.959461192259806,0.941110621496209,6.51,
    0.921735229197467,-0.806744509776701,6.39,
    0.938248729043259,0.085206004455001,6.38,
    0.907101314699976,0.720074368004749,6.51,
    0.945632814340158,-0.546162004317137,6.5,
    0.942477796076938,1.25426147439848,6.32,
    0.939255649765564,1.05165783706281,6.49,
    0.907504082988898,0.327360741895592,6.57,
    0.928313777916522,0.222267680241478,6.28,
    0.969396143386543,-0.594793664669234,6.39,
    0.947109631399538,0.819218765791649,6.24,
    0.914552528045029,-0.704468215609833,6.32,
    0.954762228889052,1.28014567683292,6.57,
    0.960132472741342,0.858871676769599,6.29,
    0.923010662112386,-0.59597176191433,6.5,
    0.986580923713872,0.862207194895632,6.39,
    0.97248403360161,1.02564273493447,6.4,
    0.98470133836557,1.01000264558187,6.37,
    0.977518637213132,0.782877132255679,6.41,
    0.93918852171741,1.04791507544464,6.46,
    0.988863277351095,1.32190752732369,6.27,
    0.99302521633662,-0.425613082509251,6.38,
    0.999805149200136,0.112011352883547,6.49,
    0.98396292983588,-0.141919508871194,6.25,
    0.977652893309439,0.993664424528483,6.3,
    0.978726942079897,-0.525785285300103,6.4,
    0.994300649251539,-1.06435510737106,6.41,
    0.951472954529524,0.743214525004108,6.42,
    1.01101553324179,0.269318847993158,6.39,
    0.955702021563203,0.365050157465047,6.5,
    0.966912405604858,-1.12112194129218,6.75,
    1.00698785035257,-0.04549976397213,6.23,
    0.975236283575909,-0.257843308161296,6.33,
    0.982821753017268,-0.1779702541985,6.49,
    0.994367777299692,-0.321407229891567,6.59,
    0.990004454169707,0.428095328556531,6.43,
    0.982754624969115,-1.35571843344427,6.29,
    0.985708259087874,-0.686607679597758,6.45,
    1.02551519164298,0.996898131781483,6.46,
    1.0610930571644,0.586430628670095,6.57,
    1.05612558160103,0.561908752679574,6.25,
    1.06404669128316,1.19568143731002,6.32,
    1.0453179658483,-0.836686602722026,6.49,
    1.02276294166868,-0.937697533181198,6.3,
    1.01745982586454,-0.490403582852729,6.55,
    1.05706537427518,-0.626471390592931,6.21,
    1.05706537427518,0.384525123035217,6.83,
    1.02914010624327,0.227692745333094,6.3,
    1.07028959976145,1.25352455760319,6.34,
    1.01806397829792,0.543990039025766,6.25,
    1.05404461210827,-0.620896033260172,6.86,
    1.03410758180664,-0.306576779386426,6.22,
    1.04263284392215,0.607626682808204,6.53,
    1.07753942896204,0.677890729611409,6.3,
    1.06666468516115,-0.895518742924668,6.46,
    1.09653666658951,0.677546511897821,6.38,
    1.09747645926367,0.180307056141447,6.37,
    1.07129652048375,0.645597290312703,6.41,
    1.09673805073398,0.301883782953286,6.32,
    1.06827575831684,-0.880261656380151,6.51,
    1.12251522122497,0.942628088318082,6.31,
    1.09344877637445,-0.346549667393907,6.46,
    1.10969376402763,-0.346302412416542,7.01,
    1.14634567831951,1.08786372276807,6.99,
    1.07633112409527,-0.268974630279571,6.39,
    1.12352214194727,1.04559281791213,6.28,
    1.01175394177148,-1.47895322304551,6.41,
    1.14486886126013,-0.12468438250775,6.26,
    1.13171176382202,-0.340125886119206,6.34,
    1.16883357445097,1.19557962643698,6.32,
    1.11143909327962,-0.717034586224193,6.59,
    1.12761695288464,-0.770305913504508,6.59,
    1.10674012990887,-1.11312736369068,6.38,
    1.15232007460518,-0.606084975302275,6.44,
    1.18393738528554,0.662648187477325,6.45,
    1.15064187340134,0.17823690172311,6.23,
    1.14594291003058,0.155169466775918,6.51,
    1.17091454394373,0.22258765727101,6.25,
    1.15520658067579,-0.0148401467787629,6.44,
    1.14198235518952,-0.761516241465993,6.71,
    1.17480797073664,0.268790401080749,6.32,
    1.14728547099366,0.108205565486837,6.93,
    1.1518501782681,0.107977703056716,6.31,
    1.1518501782681,-0.691887300585041,6.37,
    1.13674636743354,0.735501139337655,6.22,
    1.15863011113162,0.165573568372529,6.54,
    1.18044672678155,0.176651560985882,6.31,
    1.1453387575972,-1.03064116398671,6.37,
    1.13412837355555,-0.56016342342758,6.37,
    1.20024950098687,0.161016319770099,6.53,
    1.18642112306722,-0.100434002178651,6.27,
    1.19575192176058,0.740509264663516,6.23,
    1.22783912877801,0.424134400781866,6.36,
    1.16621558057298,1.00505269789775,6.32,
    1.15789170260193,-0.601353193774646,6.39,
    1.20635815336885,0.278220027178329,6.46,
    1.22763774463355,-0.580186228457404,6.55,
    1.16594706838037,0.0362931521678599,6.23,
    1.18192354384093,-0.765137799663881,6.39,
    1.16829655006574,-0.993591702476316,6.29,
    1.23904951281967,0.529906201589534,6.4,
    1.22951732998185,0.566499938239682,6.21,
    1.231329787282,0.18363772613067,6.79,
    1.2146820313399,0.698311081859742,6.26,
    1.18131939140755,0.179114414485918,6.48,
    1.18199067188908,-0.698829832498529,6.44,
    1.19112008643798,-0.216556575078008,6.24,
    1.19326818397889,0.0944223125328932,6.39,
    1.21723289716974,-0.215635429083899,6.21,
    1.23535747017122,0.314450153567645,6.25,
    1.2572412138693,0.347000544117339,6.36,
    1.21870971422912,-0.144222373856465,6.37,
    1.206425281417,-0.0416794321649868,6.33,
    1.24831318346487,1.3371161325001,6.49,
    1.25274363464301,0.470191700487272,6.47,
    1.27261353689648,-0.511090582625673,6.3,
    1.24838031151302,0.440142948532103,6.22,
    1.21152701307668,-1.41547656777783,6.76,
    1.2591207992176,1.03883451519746,6.5,
    1.22314016540726,-0.878375731160635,6.44,
    1.29966614030239,0.573607306804747,6.45,
    1.24629934202026,-0.99582184540942,6.53,
    1.2812730551083,-0.125775213290247,6.82,
    1.28194433558984,-0.125731580058947,6.7,
    1.31423292675173,1.23816566018564,6.37,
    1.30060593297654,0.412387365288582,6.35,
    1.26603498817743,0.970446697340147,6.26,
    1.2941616403538,-0.71445537744069,6.25,
    1.28026613438599,-0.0182483869569629,6.33,
    1.31013811581436,-0.593324679215472,6.86,
    1.31886476207433,-0.523244861611089,6.37,
    1.31691804867788,-1.09554801961365,6.46,
    1.31765645720757,-0.213458615655718,6.26,
    1.29161077452396,0.922246521164237,6.41,
    1.30201562198777,-0.733387351688017,6.72,
    1.34094988991687,-0.917000837134632,6.42,
    1.3533685788253,0.0273919729826888,6.61,
    1.36108830436296,0.340082252887906,6.37,
    1.31248759749974,0.429215248159894,6.37,
    1.36558588358926,0.0942332351972605,6.5,
    1.32772566443061,-0.423630194553512,6.72,
    1.34390352403563,1.28742273018637,6.66,
    1.31899901817064,-0.0162800434116582,6.23,
    1.31476995113696,-0.0311977603793986,6.35,
    1.31940178645956,-1.14012663759167,6.41,
    1.34014435333903,0.692110314878351,6.58,
    1.28583776238275,-1.24952484473404,6.28,
    1.35363709101791,-0.230281650390219,7.71,
    1.35276442639191,0.0630985005964061,7.03,
    1.35450975564391,0.0631130450068394,6.66,
    1.36243086532604,-0.0337624247524681,6.32,
    1.3747824261863,-0.0741183155680259,6.22,
    1.50870288225279,1.49991171847987,6.51,
    1.31772358525572,0.0280804084098643,6.24,
    1.37599073105307,0.564095262381378,6.62,
    1.36471321896326,0.949560923957948,7.24,
    1.37733329201614,0.483388328887074,6.6,
    1.39753883451038,1.21543759481523,6.41,
    1.33638518264243,0.627208307388218,6.52,
    1.39190007846548,-0.237898073320449,6.41,
    1.37390976156031,0.345686699041532,6.44,
    1.40801081002235,1.1330580541211,6.41,
    1.41787863310093,1.33470176036817,6.37,
    1.39458520039162,-0.702582290390317,6.31,
    1.36149107265188,-0.598555818834644,6.34,
    1.33161909122352,-0.935365579375061,6.27,
    1.40774229782973,1.0941711487593,6.5,
    1.36377342628911,-0.598327956404523,6.52,
    1.32671874370831,-1.35611598066278,6.29,
    1.43049870615381,-0.0304753879945454,6.25,
    1.4125755172968,0.0089835975109597,6.67,
    1.41237413315233,-0.420459513079056,6.41,
    1.4051914319999,-0.638872924555713,6.57,
    1.34766269473224,-1.27343100734955,6.27,
    1.42908901714259,0.00977869194797934,6.32,
    1.41042741975588,-0.137047131376044,6.37,
    1.4070710173482,0.935254072228406,6.5,
    1.44613954137361,-0.233757764483774,6.21,
    1.41163572462264,0.388941775670125,6.27,
    1.56200255248677,1.49518963322586,6.6,
    1.42814922446844,-0.59645657559544,6.98,
    1.4339893646578,0.0339854390457785,6.42,
    1.43754715120994,-0.577238561276258,6.66,
    1.44338729139931,-0.294233423065377,6.56,
    1.39935129181053,0.775372216472103,6.62,
    1.42358451719399,0.593159842563895,6.49,
    1.44902604744422,0.819674490651893,6.54,
    1.42667240740906,-0.904395681425784,6.49,
    1.4700371265163,1.36096411747388,6.56,
    1.43915822436563,-0.0102586574922778,6.34,
    1.47587726670567,0.487945577489504,6.33,
    1.41539489531925,-0.305083553248609,6.36,
    1.41646894408971,-0.305262934310619,6.54,
    1.43170701102058,-0.0808669220090706,6.39,
    1.42653815131275,0.0700216399626503,6.57,
    1.42392015743476,-0.581214033461356,6.34,
    1.44009801703978,0.505040107885426,6.46,
    1.46909733384215,-0.213696174359461,6.56,
    1.46513677900109,0.544959666387985,6.28,
    1.45110701693698,0.0928951494373982,6.35,
    1.43553330976534,0.608339358919435,6.55,
    1.42546410254229,-0.441466489881532,6.49,
    1.46231740097863,0.0410637187899777,6.32,
    1.46171324854525,-0.639895881422854,6.82,
    1.43009593786489,0.291474833219864,6.25,
    1.45996791929326,0.00949750001293581,6.57,
    1.42566548668675,-0.0782198393102125,6.23,
    1.47453470574259,0.119889575201577,6.42,
    1.39586063330654,-1.40426282733377,6.51,
    1.43325095612811,-0.176263710040994,6.35,
    1.47574301060936,-0.902049183209214,6.27,
    1.47789110815028,0.23874164912558,6.35,
    1.43331808417627,0.0226601914550597,6.41,
    1.49004128486608,0.509398582878601,6.24,
    1.50044613232989,0.695091919017175,6.37,
    1.50729319324156,-0.0469929901099473,6.39,
    1.49400183970715,0.9986967905384,6.48,
    1.49816377869267,0.392044583229226,6.29,
    1.46647933996416,0.0733765506359283,6.21,
    1.44452846821792,-0.521562558137639,6.75,
    1.46768764483092,-0.114585713530239,6.33,
    1.49151810192546,0.734938755467568,6.55,
    1.47231948015352,-0.0923570062513666,6.22,
    1.48990702876977,0.572487387201384,6.48,
    1.44929455963683,0.00496449209456165,6.85,
    1.492189382407,1.16406673716486,6.26,
    1.50400391888204,0.606080127165464,6.27,
    1.4626530412194,-0.00491601072645069,6.46,
    1.4588938705228,-1.07661604536632,6.59,
    1.53031811375826,0.0245703573586313,6.59,
    1.46258591317125,-0.0168327310081231,6.22,
    1.53622538199578,0.48279685619612,6.27,
    1.52293402846136,-0.491329576983648,6.53,
    1.50662191276003,0.452728711693707,6.49,
    1.49098107754023,-0.0612028791032678,6.56,
    1.49192087021438,-0.0623906726219862,6.24,
    1.4830599678581,-0.0805081598850495,6.73,
    1.48332848005072,-0.0805420968427272,7.96,
    1.48493955320641,-0.0804984636114273,6.7,
    1.50346689449681,-0.063447566446805,6.38,
    1.50977693102325,-0.0479480730617331,6.4,
    1.53179493081764,0.585717952558864,6.33,
    1.48621498612133,-0.075955759419431,6.54,
    1.5125963090457,-0.9267310477145,6.43,
    1.47990494959488,-0.476339137963741,6.26,
    1.55186621721557,0.464567861786402,6.37,
    1.51514717487554,0.933421476513812,6.23,
    1.51541568706815,0.379832126602077,6.34,
    1.46493539485663,-0.997087209117116,6.75,
    1.53803783929593,-0.0245364204009536,6.65,
    1.53468143688824,-1.06158197311512,6.32,
    1.52051741872783,-0.144745972632063,6.5,
    1.50105028476328,-0.281880370470706,6.38,
    1.51608696754969,0.514653963181828,6.43,
    1.53360738811779,-0.0205076187109334,6.22,
    1.56119701590893,0.407122288711733,6.59,
    1.49749249821113,0.395496456638726,6.36,
    1.54528766849652,-0.167386771539878,6.52,
    1.54199839413699,-0.019266495687293,6.42,
    1.53951465635531,-1.14213861436828,6.31,
    1.52279977236505,0.404989108514851,6.21,
    1.54360946729268,-0.266589346968512,6.21,
    1.52414233332813,-0.568967639876529,6.34,
    1.50910565054171,-0.00675345457785584,6.31,
    1.5718032475172,0.706984398614792,6.58,
    1.55824338179017,0.361195888700227,6.95,
    1.53380877226225,0.742230353231455,6.29,
    1.53911188806638,-0.346859948149817,6.34,
    1.53716517466993,-0.673575887849534,6.25,
    1.55179908916742,-0.770858601100973,6.39,
    1.5134689736717,-0.0651298699202551,6.34,
    1.57281016823951,0.993422017687928,6.54,
    1.60288353381233,0.899101516028068,6.29,
    1.52038316263152,-0.477536627756082,6.22,
    1.53904476001823,-0.599089113883865,6.32,
    1.5920759180596,-0.686743427428469,6.61,
    1.56603023537599,0.560687022203178,6.25,
    1.58892089979638,0.690704355203134,6.45,
    1.56858110120583,-0.752668391785744,6.38,
    1.56589597927968,0.354287293744416,6.71,
    1.60469599111248,1.1535947616529,6.25,
    1.61140879592784,-0.498315742128437,6.45,
    1.56556033903891,-0.894170960891184,6.35,
    1.5726759121432,0.904148426448418,6.49,
    1.58784685102592,0.205294353265833,6.59,
    1.56569459513522,0.0562917165136282,6.31,
    1.56428490612399,0.855725235979198,6.47,
    1.59992989969357,-0.654047592774442,6.7,
    1.5912032534336,-0.0686980986132213,6.57,
    1.61731606416536,-0.320471539487026,6.69,
    1.57865030842887,-1.24438097157747,6.53,
    1.59872159482681,0.505137070621648,6.32,
    1.55804199764571,0.243041946477021,6.6,
    1.5635464975943,-0.503566274294853,6.36,
    1.57099771093936,-0.716957016035215,6.55,
    1.59650636923774,-0.0560541578098846,6.28,
    1.56240532077569,-1.11642409672223,6.36,
    1.6050987594014,1.31922165953035,6.4,
    1.62778803967733,0.965530686613696,6.44,
    1.55898179031986,-0.866347503732308,6.52,
    1.59966138750096,-0.397663573793286,6.36,
    1.63047316160347,0.0213705870633083,6.22,
    1.59630498509328,0.778276250421949,6.22,
    1.57777764380287,0.0173514816469103,6.22,
    1.61912852146551,-0.524015715364053,6.44,
    1.56059286347555,-1.10859435577231,6.63,
    1.61704755197275,-0.00969627362219072,6.63,
    1.57703923527318,-0.917587461688774,6.45,
    1.65148424067556,0.757099588831085,6.42,
    1.6310101859887,0.390968296857163,6.37,
    1.59455965584128,-0.193736395108182,6.22,
    1.60375619843833,1.03660437226435,6.34,
    1.65349808212017,0.569602745798783,6.24,
    1.62731814334025,0.900124472895209,6.45,
    1.64960465532726,1.10747443616895,6.39,
    1.60248076552341,0.0295736345476817,6.59,
    1.59610360094881,0.662599706109214,6.34,
    1.63826001518929,0.586416084259661,6.23,
    1.59187453391514,-1.04550555144953,6.45,
    1.63658181398545,0.716554620679894,6.36,
    1.65396797845724,-0.415465932163628,6.95,
    1.6263783506661,-0.784758209338384,6.35,
    1.66665517955828,-0.188956132212442,6.66,
    1.65121572848294,-0.82975376708216,6.58,
    1.66907178929181,0.151320046147908,6.55,
    1.68055068552608,0.918867369806903,6.3,
    1.66779635637689,0.85020320815136,6.82,
    1.60389045453464,-0.783803126386598,6.51,
    1.63732022251514,-0.311958211246742,6.35,
    1.62120949095827,0.31641849711295,6.33,
    1.65215552115709,-0.761729559485681,6.27,
    1.68780051472667,0.381679266727104,6.56,
    1.67343511242179,-0.441553756344132,6.27,
    1.64879911874941,0.399825842811034,6.39,
    1.64134790540436,-0.845389008297942,6.49,
    1.67236106365134,0.326032352409352,6.58,
    1.64443579561943,0.185484866255697,6.45,
    1.68276591111515,-0.0261023685909374,6.62,
    1.66799774052135,-0.780477304534187,6.31,
    1.68531677694499,-0.283388141018957,6.52,
    1.68860605130451,0.630912283911895,6.92,
    1.68806902691928,-0.386381959433867,6.39,
    1.67222680755503,-0.499232039985734,6.54,
    1.69155968542327,0.810254560827934,6.52,
    1.69934653900909,0.0747631177639015,6.64,
    1.6725624477958,0.299871806176681,6.39,
    1.7087444657506,0.0204058078379004,6.37,
    1.67202542341057,0.809144337498193,6.38,
    1.71941782540703,0.414355708833887,6.25,
    1.66907178929181,0.0188544040583499,6.63,
    1.71901505711811,0.123099041770522,6.57,
    1.68968010007497,0.245364204009536,6.59,
    1.71304066083243,-0.492386470808467,6.67,
    1.69223096590481,-0.161874439985663,6.75,
    1.65611607599816,0.302378292908018,6.32,
    1.70370986213908,0.157903815937376,6.24,
    1.6643056978729,-0.129391923351324,6.22,
    1.67867110017778,0.515589653586369,6.43,
    1.66544687469151,-1.02601604146892,6.43,
    1.72827872776331,0.205187694255989,6.54,
    1.69719844146818,0.310033500932737,6.35,
    1.71438322179551,-0.894776977992571,6.41,
    1.69706418537187,0.0395947333362158,6.31,
    1.71216799620644,-0.866395985100418,7.04,
    1.64416728342681,-1.2269179827839,6.64,
    1.66625241126936,-0.824823211945276,6.6,
    1.69599013660141,0.0657019500639643,6.4,
    1.70162889264632,-0.0578188796091233,6.67,
    1.74613478857217,0.518488839399404,6.71,
    1.73358184356744,0.0802075754027616,6.72,
    1.67860397212962,0.155067655902885,6.26,
    1.74653755686109,0.280246548365367,6.33,
    1.73291056308591,-0.260548568501887,6.24,
    1.73505866062682,-0.317906875113956,6.6,
    1.69048563665282,-0.527263967027487,6.34,
    1.71760536810688,0.256946402851243,6.24,
    1.70458252676508,0.0261993313271593,6.66,
    1.75721091651752,0.827378180044723,6.56,
    1.74244274592372,0.03965775911476,6.51,
    1.74311402640526,-0.0368409916275136,6.35,
    1.73445450819344,-0.475078622392857,6.39,
    1.73626696549359,0.568332533954276,6.43,
    1.75882198967321,-0.106566895244687,6.4,
    1.73526004477129,-0.693172056839981,6.31,
    1.76305105670689,0.0146753101271857,6.71,
    1.74452371541649,-0.113247627770377,6.27,
    1.72002197784041,-0.609750166731464,6.25,
    1.76459500181442,0.357724622743482,6.22,
    1.73411886795267,-1.00279831428059,6.48,
    1.67289808803656,-1.08763586033794,6.27,
    1.76895832494441,0.470676514168382,6.47,
    1.73056108140053,0.283412381703013,6.23,
    1.74022752033465,-0.893497069874442,6.51,
    1.76788427617395,1.38927238831386,6.54,
    1.71552439861412,0.0333745738075805,6.48,
    1.80332788559906,1.43318196341195,6.65,
    1.69733269756449,0.192325587296153,6.59,
    1.69867525852756,-0.630141430158931,6.48,
    1.71082543524336,-1.0920719055201,6.46,
    1.75016247146139,-1.08510998105936,6.27,
    1.70908010599137,0.157588687044655,6.57,
    1.80594587947706,1.28623008853084,6.24,
    1.74975970317247,-0.714285692652302,6.32,
    1.75627112384337,0.277565528708832,6.4,
    1.7586877335769,0.20581310390462,6.65,
    1.76318531280319,0.966093070483784,6.45,
    1.77211334320763,0.576380441060694,6.42,
    1.77338877612255,-0.18908218376953,6.24,
    1.753048977532,-0.611912435749212,6.34,
    1.75049811170216,-0.332940947365163,6.4,
    1.78144414190098,0.132165057607271,6.45,
    1.72861436800408,-0.65231195979607,6.44,
    1.70572370358369,-1.12454472588081,6.29,
    1.72787595947439,0.078496183108445,6.55,
    1.76875694079995,0.429191007475839,6.44,
    1.78177978214175,0.189421553346307,6.38,
    1.79601092835032,-0.626767126938408,6.35,
    1.78278670286405,-0.373238660538987,6.35,
    1.81883446472255,0.76818727771806,6.41,
    1.78312234310482,0.429350995990605,6.38,
    1.80305937340645,0.0820401711173557,6.57,
    1.78775417842742,0.0281628267356529,6.21,
    1.79674933688001,-0.705864479011429,6.34,
    1.80030712343215,0.62713073719924,6.46,
    1.77788635534884,0.492119823283857,6.42,
    1.78802269062004,0.111206562172905,6.51,
    1.7789604041193,0.28619036409577,6.28,
    1.77835625168591,0.930197465534433,6.27,
    1.81735764766317,-0.660451981501899,6.58,
    1.82930644023452,0.11074114103904,6.37,
    1.77969881264899,0.630233544758341,6.31,
    1.81151750747381,-0.808528624123184,6.65,
    1.77607389804869,-0.656268039433923,6.29,
    1.79755487345785,0.972225963549819,6.33,
    1.79674933688001,0.972225963549819,6.28,
    1.78970089182388,-0.677304105057266,6.3,
    1.83991267184279,0.221545307856625,6.46,
    1.83246145849774,-0.465280537897633,6.45,
    1.77036801395563,-0.513369206926888,6.54,
    1.82292927565992,-1.2256477709394,6.51,
    1.77593964195238,-0.671253630317019,6.62,
    1.78775417842742,-0.632235825261324,6.21,
    1.80218670878045,-0.904061159985818,6.57,
    1.82722547074176,-0.930352605912389,6.46,
    1.84367184253939,-0.41755547912921,6.33,
    1.80782546482536,-1.27202989581115,6.37,
    1.8122559160035,0.782595940320635,6.26,
    1.84575281203216,-0.138908815911504,6.29,
    1.79701784907262,-0.465411437591532,7.04,
    1.82004276958932,0.670870627508943,6.3,
    1.84608845227293,0.0530870980814942,6.38,
    1.83850298283157,-0.422752681790704,6.33,
    1.8621991838298,-0.777544181763474,6.55,
    1.87857842757928,0.672039028480417,6.48,
    1.82843377560852,-0.08174928290869,6.3,
    1.83226007435328,0.191923191940832,6.24,
    1.83118602558282,0.799821370410457,6.34,
    1.83736180601295,-0.832652952895195,6.42,
    1.80218670878045,-0.43707407793068,6.4,
    1.81782754400025,-0.0723875307264648,6.41,
    1.85098879978814,-0.724234069388669,6.52,
    1.86293759235949,-0.00425181598333063,6.21,
    1.87629607394206,-0.409468786928303,6.21,
    1.86092375091488,-0.733460073740184,6.46,
    1.82386906833407,-0.385223254736015,6.91,
    1.85723170826643,0.145293812091717,6.29,
    1.86065523872226,-0.940906999750143,6.57,
    1.84226215352817,-0.726658137794217,6.32,
    1.85864139727765,-1.02379074667263,6.41,
    1.8095036660292,-0.861989028739133,6.26,
    1.85400956195505,0.207825080681225,6.27,
    1.88435143972049,-0.527263967027487,6.36,
    1.8196400013004,-0.136504140053201,6.34,
    1.83937564745756,-0.380423599293031,6.61,
    1.87649745808652,-0.604902029920368,6.29,
    1.86568984233378,0.452287531243897,6.4,
    1.8762289458939,0.133028025959646,6.27,
    1.87643033003837,-0.461857753308999,6.23,
    1.84313481815417,-0.602007692244144,6.23,
    1.85521786682182,0.127704771741063,6.35,
    1.83407253165343,-0.468363952909489,6.37,
    1.92395698813113,1.23450531689327,6.5,
    1.86005108628888,0.56573878076034,6.59,
    1.88267323851665,-0.506184268172844,6.42,
    1.85676181192935,-0.0808620738722595,6.3,
    1.88099503731281,-0.35598898976511,6.26,
    1.84347045839493,-0.346292716142919,6.31,
    1.87998811659051,-0.77199306511477,6.22,
    1.8853583604428,-0.153535644670579,6.49,
    1.85850714118135,-0.381887736609981,6.53,
    1.89254106159524,0.084090932988449,6.63,
    1.91079989069302,0.0969966731795849,6.59,
    1.87703448247175,-0.947199881330945,6.27,
    1.88978881162094,-0.480149773497262,6.27,
    1.8724697751973,-0.970495178708258,6.45,
    1.89945525055506,-0.567838023999544,6.4,
    1.86052098262596,1.04374082965029,6.44,
    1.86649537891163,0.833831050140291,6.38,
    1.87716873856805,0.0259763170338489,6.57,
    1.92261442716806,-0.172365808044873,6.45,
    1.86226631187795,-0.743437539297418,6.43,
    1.92462826861267,-0.73981598109953,6.79,
    1.89670300058076,0.491785301843891,6.48,
    1.92113761010868,-0.162994359589026,6.49,
    1.8918697811137,0.396252765981257,7.68,
    1.8853583604428,0.590483671044171,6.28,
    1.90697359194827,-0.202564852241186,6.48,
    1.8595811899518,-0.512157172724114,6.34,
    1.96732170723838,1.25343729114059,6.35,
    1.87656458613467,-0.866376592553174,6.46,
    1.86327323260025,-0.442305217549852,6.62,
    1.88522410434649,0.370829136543873,6.43,
    1.89911961031429,-0.168472754185564,6.21,
    1.93369055511341,-0.418108166725675,6.65,
    1.88871476285048,-0.302198911846007,6.23,
    1.97108087793498,1.41821091693929,6.31,
    1.95074107934443,0.475161040718645,6.43,
    1.87770576295328,-1.1722116070075,6.47,
    1.92939436003158,0.431285402578232,6.89,
    1.91731131136392,-0.462963128501929,6.59,
    1.95416460980027,-0.368152965024148,6.36,
    1.95255353664458,-0.539587930801291,6.6,
    1.96611340237161,-0.517664656141518,6.33,
    1.92395698813113,0.0028167674872464,6.41,
    1.96181720728978,-0.388500595220316,6.32,
    1.91664003088239,0.540281214365278,6.24,
    1.9306697929465,0.116597690306843,6.65,
    1.94933139033321,-0.0928515162060983,6.29,
    1.97920337176157,-0.507948989972083,6.32,
    1.95168087201858,1.04548615890228,6.35,
    1.97108087793498,-0.439866604733871,6.46,
    1.92838743930927,0.744479888711803,6.35,
    1.92912584783896,0.264291330120052,6.45,
    1.99692517647413,0.964895580691443,6.53,
    1.94657914035891,0.680610534362433,6.4,
    1.93389193925787,-0.563266230986681,6.3,
    2.03424837124754,1.41191318722168,6.41,
    1.94691478059967,-0.124296531562863,6.55,
    1.99128642042922,-0.369108047975934,6.61,
    1.93127394537988,-0.122536657900435,6.43,
    1.95342620127058,-0.0178217509175865,6.23,
    1.98504351195094,1.15770598166871,6.47,
    1.94899575009244,-0.90216553849268,6.6,
    1.97450440839082,0.270826618541409,6.41,
    2.00585320687856,-0.519812380748833,6.6,
    2.01122345073085,-0.596243257575752,6.31,
    2.00538331054148,-0.331399239859234,6.24,
    2.01343867631992,0.375871198827412,6.54,
    1.9834995668434,0.185150344815732,6.37,
    1.95074107934443,-0.0604320253503037,6.76,
    2.00148988374857,0.192146206234142,6.41,
    2.00068434717073,-0.640710368407118,6.97,
    2.00081860326704,-0.640695823996685,6.84,
    1.99940891425581,-0.52816087233754,6.31,
    1.8503175193066,-1.51800011692207,6.47,
    2.00068434717073,-0.388995105175047,6.56,
    2.01827189578698,0.263709553702721,6.22,
    1.9853791521917,-0.631629808159937,6.58,
    2.02364213963927,-0.526245858297157,6.38,
    2.02391065183189,-0.526270098981212,7.13,
    2.04263937726675,0.67887005324725,6.54,
    2.03210027370663,-0.0833152310986738,6.24,
    2.04015563948506,0.399467080687013,6.54,
    2.0204199933279,-0.639842551917932,6.65,
    2.00249680447088,-0.625652055471856,6.68,
    2.02364213963927,-1.1081095420912,6.39,
    2.02532034084311,-0.595370592949755,6.61,
    1.98779576192523,0.184452213114934,6.28,
    2.00216116423011,-0.594085836694814,6.3,
    2.00625597516748,-0.238441064643292,6.21,
    2.06049543807561,0.751034569680404,6.3,
    2.0427065053149,0.0475602221168455,6.55,
    1.99470995088506,-0.69710389579378,6.26,
    1.99444143869244,-0.748983807809311,6.52,
    2.01961445675005,-0.451749388057866,6.65,
    2.01793625554621,0.698572881247541,6.38,
    2.05512519422332,-0.664868634136807,6.76,
    2.01196185926054,-0.134191578794308,6.27,
    2.0001473227855,-0.381170212361939,6.34,
    2.03397985905493,-0.881832452706946,6.28,
    2.01786912749806,0.42516705392263,6.27,
    2.04626429186704,-0.236647254023187,6.53,
    2.01659369458314,-0.38789942625574,6.37,
    1.99195770091076,-0.944441291485431,6.39,
    2.05418540154917,-0.606026797660542,6.6,
    2.0547224259344,-0.663040886559024,6.38,
    2.01229749950131,-0.302305570855851,6.72,
    2.03089196883986,-0.663375407998989,6.59,
    2.07063177334681,0.240346382410052,6.24,
    2.03888020657015,-0.438722444446452,6.5,
    2.06539578559083,-0.454730992196689,6.76,
    2.0778816025474,-0.529518350644646,6.56,
    2.07009474896158,1.09660006530166,6.49,
    2.05002346256365,0.390944056173108,6.21,
    2.01444559704222,-1.2867342947592,7.16,
    2.01457985313853,-1.2867342947592,7.26,
    2.04075979191845,-0.756910511495452,6.41,
    2.08936049878167,-0.65399426326952,6.54,
    2.04337778579644,0.224439645532849,6.43,
    2.03451688344016,0.0419751685104636,6.47,
    2.04143107239998,0.354587878226704,6.33,
    2.07271274283957,-0.427537792823255,6.55,
    2.02961653592494,-0.648142562138528,6.89,
    2.10016811453441,1.40089822038687,6.56,
    2.07781447449925,-0.659700520296179,6.4,
    2.02948227982864,-0.837884092514367,6.57,
    2.02954940787679,-1.00128084745871,6.43,
    2.06747675508359,-0.232371197355801,6.89,
    2.08741378538522,-1.00827670887712,6.21,
    2.03512103587354,-0.630277177989641,6.54,
    2.09358956581535,-0.197653689651547,6.39,
    2.07815011474002,-0.697089351383346,6.57,
    2.08936049878167,-0.244506083793972,6.34,
    2.09835565723426,-0.279000577204916,6.43,
    2.0454587552892,-0.674894581062152,6.31,
    2.12111206555834,0.0756212379794654,6.53,
    2.08352035859231,-1.15066163888218,6.38,
    2.10862624860176,0.963586583752447,6.38,
    2.08479579150723,-0.22072597273555,6.23,
    2.10708230349423,-0.3454539884746,6.56,
    2.06781239532436,-0.969161941085207,6.33,
    2.084258767122,-0.75482096452987,6.32,
    2.05512519422332,-0.409657864263936,6.45,
    2.06915495628743,0.0571983180973031,6.31,
    2.11003593761299,-0.195137506646588,6.36,
    2.10755219983131,0.827043658604757,6.25,
    2.10768645592761,-0.757826809352749,6.45,
    2.08264769396631,-0.748823819294545,6.32,
    2.11997088873973,-1.04630549402336,6.72,
    2.1129224436836,0.986188597565774,6.72,
    2.12735497403663,0.618069569499303,6.23,
    2.10795496812023,0.767552171795806,6.34,
    2.09097157193736,-0.507585379711251,6.44,
    2.10305462060501,0.0196688910426139,6.35,
    2.10755219983131,-0.518619739093304,6.33,
    2.0732497672248,-0.897394971870562,6.38,
    2.09345530971904,0.125901264847335,6.41,
    2.10956604127592,-0.685279290111518,6.78,
    2.23643805228627,1.46708498413194,6.49,
    2.1444726263158,1.10113307322003,6.4,
    2.10815635226469,-0.804766469957774,6.22,
    2.15118543113116,0.999613088395697,6.49,
    2.15883802862068,0.345856383829921,6.25,
    2.14500965070103,-1.02753835642761,6.25,
    2.09969821819733,0.411601967125185,6.34,
    2.17273353458848,0.618074417636114,6.34,
    2.15756259570576,0.437898261188566,6.31,
    2.11439926074298,-0.882288177567189,6.44,
    2.1536020408647,-0.0195185988014699,6.51,
    2.106545279109,-0.83816528444941,6.32,
    2.10802209616838,-0.838218613954332,6.34,
    2.16682626635096,0.15557671026805,6.22,
    2.12070929726942,-0.777422978343196,6.61,
    2.13802833369305,-0.09883411703099,6.33,
    2.14400272997873,-1.04357599299871,6.33,
    2.11144562662422,-0.644889462338283,6.34,
    2.14104909585997,-0.951989840500307,6.28,
    2.16588647367681,0.480484294937228,6.21,
    2.14709062019379,-0.716481898627728,6.29,
    2.13822971783751,0.755034282549558,6.26,
    2.11164701076868,-1.26981914542529,6.34,
    2.18280274181152,0.0100114025149119,6.41,
    2.15749546765761,-0.152803576012104,6.23,
    2.16467816881004,0.740552897894816,6.27,
    2.18622627226736,0.23807745438246,6.27,
    2.16944426022895,-1.06751124443509,6.3,
    2.20569340623191,-0.186056946399407,6.32,
    2.18770308932674,-0.342729335586764,6.36,
    2.17139097362541,0.675990259981459,6.58,
    2.17978197964461,-0.633879343640285,6.37,
    2.14266016901565,-0.517970088760617,6.65,
    2.24328511319794,1.43868944682936,6.32,
    2.21697091832172,0.255331973293148,6.23,
    2.19770516850163,-0.721858482351232,6.26,
    2.17642557723693,0.244413969194561,6.54,
    2.16219443102836,-1.08557540219323,6.28,
    2.14453975436396,-0.64067158331263,6.44,
    2.22764427797815,1.0538394986278,6.45,
    2.20710309524314,0.403830403816999,6.56,
    2.1703840529031,0.308501489700431,6.47,
    2.20851278425436,-0.490248442474774,6.52,
    2.18367540643752,0.227736378564393,6.38,
    2.21589686955126,-0.629637223930577,6.43,
    2.20629755866529,-0.566024820832194,6.37,
    2.19414738194949,0.944984282808274,6.27,
    2.20972108912113,0.204664095480391,7.13,
    2.23032939990429,-0.507439935606918,6.21,
    2.21113077813235,0.154742830736542,6.29,
    2.2369750766715,-0.360929241175616,6.6,
    2.19112661978257,-0.864820340636813,6.44,
    2.22073008901832,0.93505045048234,6.49,
    2.24684289975008,-0.523540597956566,6.45,
    2.24959514972438,1.05821251803141,6.41,
    2.19757091240532,-0.171638587523209,6.32,
    2.18985118686765,-0.639241382953356,6.7,
    2.21676953417726,-0.583109654954494,6.43,
    2.2434864973424,-1.02683052845319,6.42,
    2.21314461957696,-0.00694253191348855,6.5,
    2.21784358294772,-0.658236382979228,6.32,
    2.26161107034388,0.796796133040333,6.32,
    2.27067335684462,0.47009473775105,6.32,
    2.27094186903724,0.470109282161484,6.3,
    2.26127543010311,0.428201987566376,7.02,
    2.26167819839204,0.42822138011362,7.81,
    2.2563750825879,-0.289036220403883,6.44,
    2.23529687546766,-0.0975687533232941,6.59,
    2.2314705767229,-0.679640907000214,6.53,
    2.23227611330075,-0.679626362589781,7.25,
    2.27604360069691,-0.502388177049757,6.73,
    2.30571419798082,1.20986223748247,6.31,
    2.25691210697313,-0.334337210766758,6.56,
    2.2342228266972,-0.529305032624958,6.33,
    2.25577093015452,-0.025879354297627,6.39,
    2.24301660100533,-0.125382514208548,6.43,
    2.28403183842719,-0.451473044259633,6.62,
    2.2647660886071,-0.400174908661433,6.51,
    2.28812664936457,-0.332480374368109,6.67,
    2.248990997291,-0.959727466850815,6.53,
    2.27899723481567,0.927026784059977,6.24,
    2.31685745397432,1.30417304286871,6.31,
    2.25798615574359,-0.465435678275588,6.7,
    2.30296194800652,0.171294369809621,6.83,
    2.26503460079972,-0.615732767556355,6.69,
    2.26765259467771,0.635934953648189,6.24,
    2.26966643612232,-0.956595570470848,6.36,
    2.23851902177903,0.420357702206023,6.36,
    2.27792318604521,-0.755077915780858,6.3,
    2.28758962497934,0.175686781760474,6.46,
    2.26268511911434,-0.679558488674425,6.31,
    2.27872872262306,-0.261285485297173,6.38,
    2.24415777782394,-0.805178561586717,6.39,
    2.2989342651173,0.231382177446337,6.28,
    2.2693979239297,-0.935598289941994,6.34,
    2.30316333215098,-0.532310877447837,6.38,
    2.31269551498879,-0.582348497475152,6.36,
    2.27315709462631,0.341910000465689,6.58,
    2.26510172884787,-0.656748004978222,6.49,
    2.27919861896013,-0.785902369625802,6.24,
    2.28054117992321,0.0478850472831889,6.33,
    2.26181245448834,0.267272934258876,6.32,
    2.31598478934832,0.115584429713324,7.25,
    2.28530727134211,-0.548057625810275,6.43,
    2.28208512503074,-0.635101074116681,6.3,
    2.27825882628598,1.04614065737178,6.48,
    2.26402768007741,-0.663748714533444,6.47,
    2.26456470446264,0.923715506617999,6.42,
    2.26718269834063,0.167110427741646,6.53,
    2.28745536888303,-0.0931569488251973,6.51,
    2.29571211880593,-0.562941405820338,6.48,
    2.28255502136782,-0.69555734015104,6.55,
    2.29759170415423,0.139926924641834,6.45,
    2.31430658814448,-0.318750450919087,6.33,
    2.27752041775629,0.349201598229577,6.39,
    2.29859862487653,0.343306263867285,6.44,
    2.30517717359559,0.341124602302292,6.3,
    2.32048236857461,-0.923444010956578,6.47,
    2.2822865091752,0.818578811732585,6.22,
    2.27543944826353,-0.156173031095815,6.63,
    2.2822865091752,-1.04166097895833,6.36,
    2.29081177129071,-0.175124397890387,6.45,
    2.2999411858396,0.644341622878629,6.33,
    2.32746368558259,-0.985320781076588,6.34,
    2.36216888647802,0.0756551749371431,6.37,
    2.35418064874774,-0.594400965587536,6.42,
    2.30571419798082,-0.946419331304359,6.29,
    2.31866991127447,-0.0244200651174873,6.41,
    2.34881040489545,0.50204880747298,6.57,
    2.30437163701774,-0.191874710572721,6.25,
    2.32706091729367,-0.71339363547906,6.21,
    2.29786021634684,-0.999637329079752,6.21,
    2.36116196575571,-0.582542422947596,6.37,
    2.35491905727743,-1.18312961110609,6.32,
    2.35384500850697,-0.702718038221028,6.36,
    2.35579172190342,0.580937689663124,6.25,
    2.31564914910755,-0.724941897363089,6.43,
    2.30410312482513,-0.892726216121477,6.3,
    2.33357233796457,1.0307235823125,6.25,
    2.36847892300446,-0.365670718976867,6.47,
    2.31893842346708,0.267917736454752,6.38,
    2.3785481302275,-0.67820585850413,6.39,
    2.35968514869633,0.493215502203164,6.23,
    2.35377788045881,0.0932005820564972,6.33,
    2.3543820328922,-0.724234069388669,6.55,
    2.35632874628865,-0.549618725863448,6.5,
    2.37311075832706,-0.618796790020967,6.42,
    2.36512252059678,0.300744470802678,6.64,
    2.37606439244582,-0.905316827419892,6.39,
    2.39371906911022,-0.690321352395057,6.47,
    2.37398342295306,-0.105238505758447,6.91,
    2.37411767904936,-0.105223961348014,6.67,
    2.40942703237817,-0.387143116913209,6.39,
    2.36028930112972,-0.784670942875784,6.26,
    2.42191284933475,0.52767605865643,6.29,
    2.38438827041687,0.62487150544527,6.51,
    2.40251284341835,-1.00810217595192,6.38,
    2.35847684382957,0.0269071593015792,6.59,
    2.36633082546354,0.316510611712361,6.38,
    2.39754536785498,0.656321368938846,6.44,
    2.45010662955927,1.46923755687607,6.33,
    2.3729093741826,-0.474622897532614,6.25,
    2.41506578842308,0.693128423608682,6.36,
    2.38693913624671,0.486917772485551,6.38,
    2.37351352661598,-0.673653458038511,6.27,
    2.44775714787389,0.565084282290842,6.46,
    2.38109899605734,-0.427528096549633,6.74,
    2.44023880648069,1.03575594832241,6.45,
    2.37626577659028,-0.915430040807837,6.4,
    2.4228526420089,0.401096054655541,6.4,
    2.39660557518083,0.567939834872577,6.5,
    2.43809070893977,-0.979958741763516,6.44,
    2.40647339825941,-0.886418790130242,6.73,
    2.39257789229161,-1.10828892315321,6.37,
    2.42157720909398,1.25063021992697,6.55,
    2.45775922704878,0.201837631719522,6.48,
    2.43070662364287,-0.398342312946839,6.53,
    2.45601389779679,-0.847798532293057,6.48,
    2.47883743416902,0.0954404212632233,6.35,
    2.43218344070225,0.261731513883794,6.51,
    2.46299521480477,0.371464242466126,6.48,
    2.51401253140152,1.29182968654766,6.5,
    2.44769001982574,-0.652467100174025,6.31,
    2.43788932479531,-0.728262871078689,6.29,
    2.45507410512264,-0.261367903622962,6.35,
    2.44124572720299,-0.775701889775258,6.25,
    2.49937861690403,0.200732256526592,6.41,
    2.46863397084967,-0.984748700932878,6.32,
    2.48716131214007,-0.933833568142755,6.33,
    2.48434193411762,-0.186502974986027,6.62,
    2.50340629979325,-0.591608438784345,6.39,
    2.46849971475336,0.268276498578773,6.53,
    2.51797308624259,-0.251017131531273,6.33,
    2.50280214735987,-0.527777869529463,6.82,
    2.48286511705824,-0.956673140659825,6.28,
    2.54328036039651,1.31071317942687,6.29,
    2.5246187630098,1.11597806813561,6.28,
    2.49924436080773,0.439527235157094,6.41,
    2.52052395207243,-0.142438259509982,6.53,
    2.53569489095515,0.900134169168831,6.31,
    2.49112186698114,0.638562643799803,6.67,
    2.5014595863968,-0.667156954711643,6.54,
    2.51669765332767,-0.632555802290856,6.48,
    2.50891079974185,0.289472552716882,6.29,
    2.49333709257021,-1.04191793020931,6.3,
    2.49360560476282,-0.153176882546558,6.54,
    2.54663676280419,0.972943487797861,6.45,
    2.52555855568395,-0.610729490367305,6.65,
    2.48568449508069,-0.0129687659696801,6.27,
    2.52622983616548,-0.0654983283178983,6.26,
    2.54972465301925,-0.395399493902504,6.24,
    2.52240353742073,1.2970899149877,6.46,
    2.509850592416,0.862866541501941,6.76,
    2.54804645181541,-0.525494397091437,7,
    2.52475301910611,0.495115971833114,6.53,
    2.53086167148808,0.818598204279829,6.52,
    2.52065820816873,-0.477730553228526,6.46,
    2.57952950639947,0.409347583508026,6.25,
    2.52716962883964,-0.118856922060814,6.24,
    2.5930893721265,1.27549631363108,6.42,
    2.53898416531467,0.697491746738667,6.76,
    2.51065612899384,-0.67842887279744,6.43,
    2.53562776290699,-1.13936063197552,6.27,
    2.57993227468839,0.250973498299974,6.36,
    2.55415510419739,-0.321426622438811,6.31,
    2.52475301910611,-0.596485664416306,6.49,
    2.55851842732738,-0.406613234346568,6.53,
    2.58677933560006,-0.149671679632136,6.4,
    2.5201211837835,-1.1004203971088,6.56,
    2.59389490870434,1.36370816290896,6.23,
    2.57664300032886,-0.669959177788457,6.7,
    2.59000148191143,-0.164579700326254,6.31,
    2.55771289074954,-0.16110843436951,6.37,
    2.58677933560006,0.452263290559842,6.24,
    2.59731843916018,0.845282349288098,6.39,
    2.55321531152324,0.948824007162662,6.47,
    2.62692190839593,1.11096024653612,6.34,
    2.59503608552295,-0.602109503117177,6.41,
    2.5884575368039,0.329232122704675,6.5,
    2.56939317112827,-0.670710638994176,6.82,
    2.58181186003669,-0.520059635726199,6.45,
    2.59604300624526,0.201905505634877,6.45,
    2.60691775004615,-0.991599118246956,6.46,
    2.60617934151646,1.14481963402481,6.31,
    2.62692190839593,-0.99843014301379,6.22,
    2.57026583575426,-1.13319865008862,6.26,
    2.61477173168012,0.0758103153150981,6.24,
    2.58140909174777,0.228046659320304,6.46,
    2.63887070096727,-0.623630382421629,6.37,
    2.60772328662399,-0.101549073645203,6.42,
    2.59919802450848,0.00131869321261794,6.35,
    2.60074196961601,1.06667736490358,6.27,
    2.66095582880982,-0.465440526412399,6.3,
    2.58745061608159,-0.953415192722769,6.48,
    2.63437312174098,-0.375449410924847,6.24,
    2.68129562740037,0.792631583519603,6.3,
    2.60779041467214,-0.68373758260559,6.41,
    2.66296967025442,-0.444181446495746,6.28,
    2.67303887747747,-0.462948584091496,6.32,
    2.69895030406477,1.46465121945278,6.37,
    2.62994267056284,-0.884251672975683,6.37,
    2.64430807286772,0.484484007806382,6.3,
    2.61356342681335,-1.23238668110682,6.35,
    2.67149493236994,0.059074547043197,6.7,
    2.62182017673625,-0.384840251927939,6.21,
    2.62531083524024,-1.10846830421522,6.58,
    2.66417797512119,-0.960861930864612,6.52,
    2.69290877973094,-0.513519499168032,6.54,
    2.64672468260125,0.0558699286110629,6.45,
    2.68666587125266,-0.430805437033934,6.7,
    2.69304303582725,-1.07937463521184,6.42,
    2.66686309704734,-0.66364690366041,6.43,
    2.69472123703109,0.275020256883006,6.37,
    2.66021742028013,-0.621618405645025,6.27,
    2.70781120642105,0.0979372117209374,6.21,
    2.65370599960922,-0.90428902241594,6.52,
    2.67424718234423,0.551596765682375,6.24,
    2.6551828166686,-0.639949210927776,6.36,
    2.7142554990438,-0.159091609456094,6.53,
    2.70056137722046,-0.251123790541117,6.27,
    2.74070395001633,0.70967511454495,6.32,
    2.73311848057497,-0.207766903039492,6.24,
    2.64565063383079,-1.40384103943121,6.6,
    2.71727626121071,0.233088721603843,6.44,
    2.68988801756403,-0.116646171674954,6.25,
    2.67424718234423,-0.478108707899791,6.28,
    2.72110255995547,-0.328931538222387,6.44,
    2.71324857832149,-0.997838670322836,6.4,
    2.69378144435694,1.04694544808242,6.25,
    2.70076276136492,-0.470734691810115,6.25,
    2.70801259056551,-0.575401117424853,6.38,
    2.69190185900864,0.549221178644938,6.46,
    2.69801051139062,1.27537026207399,6.4,
    2.75070602919122,-0.692711483842927,6.35,
    2.76010395593273,1.24024066274079,6.66,
    2.70317937109845,-1.05315106320062,6.41,
    2.72553301113361,0.500604062703274,6.49,
    2.70942227957674,0.309626257440605,6.55,
    2.74902782798738,-0.337362448136882,6.57,
    2.71036207225089,0.478486862571057,6.52,
    2.69196898705679,-1.01397811776697,6.22,
    2.77574479115252,0.816130502642982,6.43,
    2.74177799878678,-0.886539993550519,6.3,
    2.70183681013538,0.431299946988665,6.4,
    2.72513024284468,0.938623527312117,6.45,
    2.74728249873538,-0.614273478376215,6.3,
    2.74412748047216,-0.0854193224746891,6.37,
    2.78064513866773,-0.156051827675537,6.32,
    2.71230878564734,0.0399631917338591,6.66,
    2.72009563923316,-0.279514479706892,6.51,
    2.74815516336138,-0.389019345859103,6.5,
    2.75795585839181,-0.374751279224049,6.51,
    2.7744693582376,0.516893802388554,6.39,
    2.73795170004203,0.0993819564906438,6.54,
    2.73593785859742,-0.520767463700619,6.27,
    2.7403011817274,0.0413303663145879,6.32,
    2.7725897728893,-0.698946187781996,6.27,
    2.78668666300156,-0.978189171827466,6.35,
    2.74526865729077,0.851454027448623,6.44,
    2.78917040078325,0.789102139921125,6.35,
    2.81743130905592,1.14539171416852,6.32,
    2.77735586430821,1.40489308511921,6.52,
    2.817901205393,-0.445340151193598,6.51,
    2.80152196164351,-1.05843553232472,6.43,
    2.82051919927099,0.933707516585667,6.45,
    2.80380431528074,0.634024787744618,6.28,
    2.78366590083465,-1.02995757669634,6.23,
    2.82293580900452,-0.304225433033045,6.49,
    2.79843407142845,-0.164351837896133,6.57,
    2.78124929110112,-0.442004633067564,6.29,
    2.79501054097261,-0.178920489013474,6.52,
    2.82172750413776,-1.39764027244981,7.07,
    2.8040056994252,-1.32105425524494,6.3,
    2.82938010162727,-0.00450876723431868,6.26,
    2.86180294888547,-0.597920712912391,6.37,
    2.82051919927099,-1.01792934926802,6.42,
    2.84327560759507,-0.209875842552318,6.24,
    2.82944722967542,0.344852819510024,6.27,
    2.82696349189374,0.0434247614169811,6.28,
    2.84891436363997,1.00122266981698,6.34,
    2.82635933946036,0.111230802856961,6.37,
    2.81917663830792,-1.01780329771093,6.21,
    2.83602577839448,-1.20672064482888,6.26,
    2.8530763026255,-1.20680791129148,6.46,
    2.84555796123229,-1.24888973881179,6.27,
    2.89456143638444,1.1367717269184,6.39,
    2.84126176615046,-1.0366673980429,6.25,
    2.87408738169759,-0.257227594786287,6.67,
    2.87502717437174,-0.986673411246883,6.36,
    2.85502301602196,-0.0693913821772079,6.61,
    2.88623755841339,0.91743716944763,6.65,
    2.88771437547277,0.916360883075567,6.44,
    2.86327976594485,0.017894472969753,6.38,
    2.89335313151768,0.00351489918804414,6.31,
    2.89342025956583,-0.254022976354153,6.38,
    2.90805417406332,0.431949597321352,6.3,
    2.87355035731236,-0.337459410873104,6.44,
    2.88180710723525,-1.36904596153797,6.33,
    2.9085240704004,0.445058959258554,6.35,
    2.93060919824294,0.20430533335637,6.55,
    2.9141628264453,0.898878501734757,6.43,
    2.89194344250645,1.10690720416205,6.39,
    2.95658775287839,-0.247962805340283,6.34,
    2.92127839954959,-0.439275132042917,6.23,
    2.89274897908429,-1.40401072421959,6.71,
    2.91449846668607,-0.524282362888663,6.46,
    2.94188671033275,-0.21931031678671,6.34,
    2.91376005815638,-0.88640909385662,6.3,
    2.95793031384147,-0.475990072113342,6.77,
    2.94275937495875,-0.855967642819752,6.32,
    2.96363619793453,0.407073807343622,6.46,
    2.92161403979035,-0.54825639941953,6.59,
    2.93846317987691,-1.10235480369643,6.41,
    2.98337184409169,-0.52054929754412,6.54,
    2.93591231404708,-0.4891673079659,6.49,
    2.94692131394427,1.19157021729421,6.4,
    2.98645973430676,0.251332260423995,6.3,
    2.99686458177057,-1.00434486992333,6.88,
    2.9918971062072,0.958083948471854,6.63,
    2.97538360636141,0.625065430917713,6.41,
    2.95202304560395,-0.550932570939255,6.38,
    2.97860575267278,-0.353443717939285,6.4,
    2.96739536863113,-1.23156734598574,6.35,
    2.99048741719598,0.717131548960415,6.33,
    2.95497667972271,0.92106357578233,6.5,
    3.01337808161636,-0.737677952765837,6.21,
    3.02284313640603,0.224182694281861,6.67,
    2.98679537454753,-0.770039265979898,6.31,
    2.96981197836466,-0.662973012643668,6.27,
    3.00659814875285,-0.580544990581425,6.45,
    3.01169988041252,-0.618990715493411,6.68,
    2.98652686235491,0.209172862714709,6.66,
    3.03928950820366,1.17112562436182,6.21,
    3.00438292316378,-1.36714064377121,6.35,
    3.01143136821991,-1.30650984481166,6.27,
    3.03761130699982,0.996146670575764,6.43,
    2.97229571614634,-1.22182743913225,6.41,
    3.04808328251179,-1.33328610441933,6.43,
    3.05600439219392,0.0673697091269811,6.37,
    3.02747497172863,0.583822331065725,6.32,
    3.05405767879746,0.0525877399899514,6.5,
    3.06969851401726,-0.00523598775598299,6.25,
    3.07614280664001,-0.605129892350489,6.45,
    3.06473103845389,0.990256184350283,6.28,
    3.02801199611385,0.948790070204984,6.41,
    3.04425698376703,0.814326995749254,6.35,
    3.08171443463676,0.836521766070449,6.42,
    3.02875040464354,0.8515315976376,6.56,
    3.03519469726629,-1.05979301063182,6.38,
    3.07896218466246,-0.335510459875043,6.24,
    3.09936911130116,0.642552660395335,6.4,
    3.04157186184089,0.192398309348319,6.55,
    3.03761130699982,0.356769539791696,6.45,
    3.0907767211375,0.190434813939826,6.56,
    3.09164938576349,-0.641621818127604,6.31,
    3.04284729475581,-0.541260538001119,6.29,
    3.11165354411327,1.12306604415343,6.46,
    3.08883000774104,0.586876657256716,6.27,
    3.07795526394015,-0.0272950102464669,6.22,
    3.10588053197206,0.787293784890586,6.44,
    3.05049989224532,-0.406293257317036,6.42,
    3.1185677330731,-0.236167288478888,6.21,
    3.09111236137826,1.01177706365474,6.37,
    3.06996702620987,-0.502717850352911,6.44,
    3.11722517211003,0.962941781556572,6.27,
    3.07003415425803,0.387652171278374,6.59,
    3.0677518006208,-0.343936521652727,6.22,
    3.06030058727575,-1.4468779499033,6.33,
    3.13743071460427,-1.37346261417288,6.39,
    3.09305907477472,-0.853994451137637,6.26,
    3.10594766002022,-0.518590650272437,6.48,
    3.12078295866217,-0.169064226876517,6.26,
    3.14776843401993,-0.466390761227374,6.48,
    3.17220304354785,0.214307039597659,6.35,
    3.1149428184728,0.582503637853107,6.27,
    3.13172483051121,-0.206162169755019,6.35,
    3.18562865317857,0.658313953168206,6.45,
    3.17858020812244,0.00963324784364648,6.3,
    3.15005078765715,-0.632701246395189,6.46,
    3.12742863542938,0.811175706822042,6.54,
    3.13481272072628,0.811049655264954,7.03,
    3.13870614751919,0.641520007254571,6.49,
    3.19556360430531,1.07423561019208,6.22,
    3.18307778734874,-0.819039384729639,6.26,
    3.1334701597632,-0.570456017877536,6.21,
    3.1481040742607,0.704128846033057,6.62,
    3.14253244626394,0.563285623533926,6.42,
    3.16052276316912,1.0727617766015,6.76,
    3.16011999488019,-0.681599554271897,6.79,
    3.20590132372097,-0.420469209352678,6.43,
    3.21402381754756,0.59402281091627,6.5,
    3.19865149452038,-0.351906858570168,6.28,
    3.14837258645331,-0.00404819423726462,6.31,
    3.18871654339364,-1.23065104812845,6.42,
    3.21959544554431,-0.110241782947497,6.22,
    3.21415807364387,-1.28781058113126,6.44,
    3.19677190917208,1.49377882541384,6.27,
    3.23483351247518,-1.12491318427846,6.33,
    3.23953247584594,-0.598754592443899,6.23,
    3.24369441483146,-0.0500618607113707,6.37,
    3.19435529943855,-1.17546470680775,6.23,
    3.18294353125243,-0.859341946040275,6.37,
    3.20952623832126,-1.03241073392276,6.22,
    3.244365695313,1.30308706022302,6.35,
    3.22765081132274,0.293375302849814,6.39,
    3.19348263481255,-0.778019299170961,6.61,
    3.23174562226012,-0.883844429483551,6.23,
    3.24987019526159,0.995787908451742,6.43,
    3.19556360430531,0.498049094603826,6.49,
    3.21576914679955,-0.591220587839457,6.5,
    3.27309649992275,-1.35134541404067,6.35,
    3.24758784162437,-0.562122070699263,6.33,
    3.22523420158921,-1.10987911202725,6.22,
    3.24799060991329,-0.699649167619605,6.26,
    3.27014286580399,-0.395254049798171,6.54,
    3.24295600630177,-1.24590813467296,6.22,
    3.26262452441078,1.26625091673232,6.29,
    3.27524459746367,0.264315570804108,6.34,
    3.2323497746935,-0.0357016794769062,6.99,
    3.23302105517503,-0.0358034903499392,6.54,
    3.26255739636263,0.527947554317851,6.23,
    3.2804134571715,1.50859473150854,6.33,
    3.22731517108198,0.453921353349236,6.48,
    3.25013870745421,0.402031745060083,6.27,
    3.23429648808995,1.53065375399903,6.28,
    3.26423559756647,0.491431387856681,6.33,
    3.26645082315554,-1.11975476671145,6.21,
    3.28430688396441,0.472193980990255,7.13,
    3.2805477132678,0.0925994130919214,6.4,
    3.30102176795466,-1.49835546656351,6.33,
    3.26047642686987,-1.15834593572777,6.36,
    3.29148958511684,-0.675389091016884,6.4,
    3.3063248837588,-0.70888002010793,6.25,
    3.28215878642349,0.44650370402826,6.42,
    3.27390203650059,-1.12101528228234,6.3,
    3.2592681220031,1.11356854414049,6.32,
    3.31975049338952,-0.821817367122397,6.26,
    3.28752903027578,1.25541048282271,6.24,
    3.31592419464477,0.150277696733523,6.37,
    3.3257248896752,-0.268223169073851,6.35,
    3.32867852379395,-0.059074547043197,6.22,
    3.29800100578775,-1.05077062802638,6.22,
    3.31491727392246,0.45774168515638,6.54,
    3.32364392018243,0.452025731856098,6.65,
    3.27893664011212,-0.220032689171563,6.35,
    3.27638577428228,0.8994651262889,6.21,
    3.29927643870267,-0.993422017687928,6.42,
    3.3397546517393,0.926362589316857,6.21,
    3.28726051808317,-0.549192089824071,6.46,
    3.28947574367224,0.179691342766438,6.26,
    3.31565568245215,-0.31779051983049,6.26,
    3.33149790181641,0.423819271889145,6.29,
    3.36506192589322,-0.839338533557695,6.38,
    3.34921970652896,0.582673322641496,6.24,
    3.3332432310684,-1.04995614104211,6.22,
    3.30276709720665,0.320743035148447,6.56,
    3.33122938962379,-1.30254891703699,6.49,
    3.31330620076677,0.0572904326967139,6.33,
    3.37788338309056,-1.16600114375249,6.25,
    3.34767576142143,0.121969425893537,7.08,
    3.36955950511951,0.71339363547906,6.37,
    3.31458163368169,0.395481912228293,6.38,
    3.38640864520607,-1.14298703831022,6.26,
    3.33445153593517,0.627479803049639,6.45,
    3.33169928596087,-1.19716496717421,6.33,
    3.36707576733783,-0.99652967338384,6.4,
    3.36452490150799,-0.695028893238631,6.44,
    3.40802387671154,-0.622224422746412,6.39,
    3.33485430422409,1.06736580033075,6.38,
    3.36996227340844,0.769743529634421,6.33,
    3.36848545634906,1.40710383550507,6.4,
    3.34975673091419,0.103861634904096,6.34,
    3.39151037686575,-0.0994498304059991,6.26,
    3.41876436441612,-0.404014633015821,6.44,
    3.41567647420106,0.0623567356643085,6.41,
    3.37023078560105,0.236545443150154,6.56,
    3.41413252909352,0.433544634332203,6.31,
    3.40715121208555,0.845907758936729,6.27,
    3.37586954164596,-1.04020168977819,6.75,
    3.38607300496531,-0.829734374534915,6.24,
    3.38311937084655,0.399040444647637,6.43,
    3.39486677927343,-0.168627894563519,6.41,
    3.37560102945334,-0.836114522578317,6.33,
    3.40151245604064,-0.910547967039064,6.24,
    3.38499895619485,0.297995577230787,6.32,
    3.40554013892986,0.281390708652786,6.3,
    3.40674844379662,-1.00477635409951,6.58,
    3.42400035217211,-0.0659055718100303,6.44,
    3.43957405934375,0.21674565241364,6.25,
    3.39479965122528,0.585286468382676,6.26,
    3.42634983385748,-0.445752242822541,6.62,
    3.43487509597299,-0.37081459213344,6.31,
    3.46635815055705,1.04224275537566,6.53,
    3.48951732717005,-0.0407825268549342,6.59,
    3.48542251623268,-0.71215251245542,6.26,
    3.46655953470151,-0.905564082397258,6.43,
    3.5024730404637,-0.595821469673186,6.54,
    3.4432661019922,0.506659385580332,6.54,
    3.48757061377359,1.27453153440567,6.31,
    3.46199482742706,-0.147683943539587,6.32,
    3.49904951000786,0.672543234708771,6.28,
    3.52267858295794,-1.09427295963233,6.33,
    3.51005850990506,1.08610384910564,6.54,
    3.50401698557123,-0.44415720581169,6.5,
    3.52408827196917,-0.720825829210469,6.22,
    3.46702943103858,0.423382939576147,6.33,
    3.50394985752308,0.327278323569803,6.53,
    3.4960958758891,-0.299731210209159,6.28,
    3.50334570508969,-1.19241379309934,6.37,
    3.50307719289708,1.27058030290463,6.59,
    3.50744051602707,-0.0106368121635432,6.68,
    3.49240383324065,0.332514311325786,6.45,
    3.48985296741082,1.40449068976389,6.25,
    3.51656993057596,0.345318240643889,6.45,
    3.51771110739457,0.0118100612718283,6.37,
    3.5505367229417,0.064363864304102,6.62,
    3.54650904005248,0.0513417688294999,6.26,
    3.53516439991451,-0.323079837091395,6.21,
    3.5072391318826,-0.827935715777999,6.38,
    3.51542875375735,-0.57264252757934,6.22,
    3.50448688190831,0.766252871130433,6.35,
    3.57396441174731,-0.840846304105946,6.48,
    3.54577063152279,-1.27946693767937,6.63,
    3.54905990588232,0.216978362980573,6.44,
    3.52965989996592,-0.852699998609074,6.31,
    3.54912703393047,-0.84856453790921,6.28,
    3.54093741205573,-0.695285844489619,6.4,
    3.59289452132663,1.10411467735886,6.5,
    3.52737754632869,1.12984858755215,6.66,
    3.53556716820344,1.12956739561711,7.04,
    3.60108414320138,0.920588458374842,6.34,
    3.56074018626105,0.710867756200479,6.47,
    3.54993257050831,-0.0110925370237862,6.43,
    3.54127305229649,0.88291358721582,6.8,
    3.56725160693195,-1.33398423612013,6.48,
    3.58692012504096,0.885201907790657,6.43,
    3.60725992363151,0.104952465686592,6.51,
    3.58336233848882,-0.486723847013108,6.47,
    3.59531113106017,-1.12342480627745,6.37,
    3.58933673477449,-0.496279524667776,6.45,
    3.54832149735263,-0.118769655598214,6.68,
    3.59054503964126,-0.833006866882405,6.33,
    3.61028068579842,-0.570533588066513,6.44,
    3.58101285680344,0.676998672438167,6.37,
    3.60081563100876,0.17810600202921,6.49,
    3.58953811891895,-1.29706082616683,6.34,
    3.57503846051777,0.771382199876572,6.84,
    3.6282710027036,-0.585247683288188,6.5,
    3.57940178364776,-1.00504784976093,6.42,
    3.57873050316622,-1.20797146412614,6.59,
    3.61390560039872,0.863705269170261,6.49,
    3.57980455193668,0.249611171856056,6.52,
    3.60920663702797,1.33599136475993,6.57,
    3.62256511861054,0.885138882012113,6.48,
    3.62833813075175,-0.667622375845509,6.27,
    3.57664953367346,0.318789236013575,6.48,
    3.59886891761231,0.541260538001119,6.21,
    3.63041910024451,0.48983150270902,6.23,
    3.6237734234773,-0.393576594461532,6.59,
    3.60907238093166,0.881730641833913,6.32,
    3.65995544143211,-0.858866828632787,6.41,
    3.60652151510182,0.998459231834656,6.29,
    3.61672497842117,-0.889890056086987,6.47,
    3.62531736858484,0.727351421358204,6.3,
    3.66391599627317,-0.0785592088869892,6.51,
    3.65673329512073,-0.427591122328177,6.21,
    3.62283363080315,-1.07180669364972,6.51,
    3.61746338695086,0.975280289740809,6.5,
    3.68076513635973,0.110838103775262,6.33,
    3.68680666069356,-0.5985800595187,6.53,
    3.64760388057184,-0.664951052462595,6.44,
    3.68962603871601,0.690151667606669,7.4,
    3.66787655111424,-0.315953075979085,6.53,
    3.67761011809651,0.639362586373634,6.38,
    3.67505925226668,-0.62075543729265,6.35,
    3.6533097646649,-0.412057691985428,6.45,
    3.63196304535205,0.606894614149728,6.65,
    3.65874713656534,1.02170604784386,6.46,
    3.70103780690213,1.19232652663674,6.4,
    3.70311877639489,-0.536077879750058,6.51,
    3.66183502678041,0.559072592645084,6.32,
    3.68841773384925,-1.05624902262291,6.49,
    3.69519766671276,1.07325143841942,6.37,
    3.72701636153758,-0.0427654148106722,6.4,
    3.68365164243034,0.477987504479514,6.23,
    3.69029731919755,0.79855115856595,6.27,
    3.7495713857172,-0.37661296375951,6.3,
    3.72164611768529,0.188262848648455,6.3,
    3.72768764201912,0.131709332747028,6.26,
    3.7531963003175,0.0855356777581554,6.24,
    3.70224611176889,-0.0806099707580826,6.39,
    3.71889386771099,-0.227387312713995,6.28,
    3.72506964814113,-1.01725545825127,6.42,
    3.73748833704955,1.19866788958565,6.34,
    3.73299075782326,0.0400989395645697,6.28,
    3.70580389832104,-0.273391282914478,6.56,
    3.71929663599992,-1.09592617428492,6.4,
    3.77568419644896,-1.0249155144128,6.34,
    3.70526687393581,-0.168695768478874,6.47,
    3.76185581852932,1.03563959303895,6.46,
    3.7670918062853,1.30190411484111,6.45,
    3.80871119614055,-1.33231647705712,6.47,
    3.7550758856658,0.0237752629216116,6.43,
    3.7504440503432,-0.412523113119293,6.34,
    3.73963643459047,-0.443100311986872,6.24,
    3.75910356855502,-0.916128172508635,6.39,
    3.75487450152134,-0.0707294679370702,6.36,
    3.78273264150509,-0.785383618987015,6.31,
    3.78092018420495,-1.01379388856815,6.39,
    3.80119285474734,-1.41635892867745,6.42,
    3.75910356855502,0.903867234513374,6.69,
    3.79743368405074,0.0582261231012553,6.45,
    3.78132295249387,0.381761685052893,6.39,
    3.7578281356401,0.724641312880801,6.24,
    3.75957346489209,-0.571745622269287,6.55,
    3.76386965997393,-0.0938647767996172,6.44,
    3.74446965405753,-0.303944241098001,6.22,
    3.75333055641381,0.916923266945654,6.58,
    3.77904059885665,0.351184486185315,6.25,
    3.76749457457422,0.693676263068335,6.38,
    3.77568419644896,-0.572109232530119,6.54,
    3.74453678210568,-0.112704636447534,6.47,
    3.80542192178102,0.837787129778145,6.32,
    3.81851189117098,0.676620517766902,6.86,
    3.81864614726729,0.957560349696256,6.53,
    3.81213472659638,0.677081090763956,6.33,
    3.76413817216654,0.531089146971441,6.44,
    3.8273056654791,-1.14889206894613,6.36,
    3.79991742183242,-0.17952165797805,6.21,
    3.78608904391278,0.0216711715455963,6.27,
    3.79588973894321,0.147393055330921,6.86,
    3.77467727572666,0.442232495497685,6.22,
    3.82482192769742,-0.180297359867825,6.49,
    3.8142828241373,-0.314687712271389,6.61,
    3.7966281474729,-0.72746777664167,6.32,
    3.8383146653763,-0.438906673645274,6.48,
    3.84563162262504,-0.665426169870083,6.35,
    3.81347728755946,0.670085229345545,6.27,
    3.84576587872135,-1.02629238526715,6.45,
    3.81965306798959,0.716021325630674,6.63,
    3.82965514716448,0.493739100978763,7.62,
    3.83207175689801,0.493768189799629,7.12,
    3.87194581750127,-0.68338366861838,6.39,
    3.84898802503273,-0.961889735868564,6.93,
    3.84113404339875,0.729474905281463,6.35,
    3.82428490331219,-0.731297804722435,6.6,
    3.84099978730244,-1.04692120739837,6.4,
    3.85791605543716,1.05113423828721,6.27,
    3.88161225643539,-0.341400946100524,6.5,
    3.836435080028,0.645063995263482,6.43,
    3.82925237887556,0.567833175862733,6.33,
    3.83489113492046,0.995976985787375,6.48,
    3.83153473251278,0.405793899225493,6.38,
    3.86852228704543,-0.854241706115003,6.39,
    3.88376035397631,-0.969690387997616,6.3,
    3.91886832316065,-1.0015377987097,6.22,
    3.91269254273052,-0.507309035913018,6.37,
    3.8606011773633,1.39033413027549,6.26,
    3.91685448171604,0.368676563799747,6.38,
    4.07480677902153,-1.5335674842225,6.48,
    3.85274719572933,1.0692226367294,6.25,
    3.93914099370305,-0.253775721376787,6.33,
    3.88053820766493,-0.363445424180575,6.4,
    3.91336382321205,-0.740761367777693,6.3,
    3.87993405523155,0.572264372908074,6.28,
    3.8882579332026,-0.965729460222951,6.23,
    3.94397421317011,-0.194783592659378,6.35,
    3.92235898166464,0.896658055075276,6.51,
    3.93652299982506,-0.513529195441654,6.29,
    3.92772922551693,0.274094262752087,6.4,
    3.91578043294559,-0.882317266388056,6.64,
    3.9576012069453,-0.673415899334768,6.36,
    3.93215967669507,-0.503391741369653,6.29,
    3.93007870720231,-0.822694879885205,6.35,
    3.91873406706435,0.376210568404189,6.49,
    3.93625448763244,-0.189280957378785,6.6,
    3.94128909124396,-0.630388685136296,6.47,
    4.00935693207174,-0.587148152918137,6.22,
    3.99734101145224,0.384767529875772,6.38,
    3.97894792625815,0.82515288524843,6.37,
    3.96921435927587,-1.22338369104861,6.52,
    3.99599845048917,-0.0518120381001761,6.61,
    4.002039974823,-0.683097628546525,6.41,
    3.95303649967085,0.0958622091657886,6.5,
    3.94894168873348,0.779192548279246,6.65,
    3.98908426152935,0.603292448499084,6.59,
    4.01284759057573,-0.422549060044638,6.67,
    3.97183235315386,-0.623707952610607,6.27,
    4.00049602971546,-1.08833884017555,6.28,
    4.000294645571,0.636269475088155,6.35,
    4.03050226724014,-1.05727682762686,6.3,
    4.02184274902832,-0.780554874723164,6.44,
    4.0178150661391,-0.780520937765486,7.39,
    3.98505657864013,-1.05166753333643,6.32,
    3.98807734080704,0.873624557085762,6.39,
    4.02137285269124,-0.833942557286946,6.33,
    4.00720883453083,-0.418733576374306,6.47,
    4.02224551731724,-0.430936336727833,6.45,
    4.03775209644073,0.33660129065754,6.68,
    4.02654171239907,0.40113483975003,6.3,
    4.05614518163482,-0.0784913349716339,6.28,
    4.01815070637987,-0.714523251356045,6.28,
    4.06889951078401,-1.16096877774257,6.28,
    4.05775625479051,1.2033221009243,6.51,
    4.05903168770543,-0.659399935813891,6.48,
    4.05043929754176,0.567498654422767,6.32,
    4.02050018806525,-0.252229165734047,6.3,
    4.07749190094768,-0.0276925574649767,6.35,
    4.02788427336214,0.435595396203296,6.39,
    4.05413134019021,0.219344253744387,6.28,
    4.04493479759317,-0.660267752303077,7.03,
    4.07319570586584,0.651841690525393,6.5,
    4.10763239456865,0.340004682698929,6.27,
    4.08407044966673,0.942826861927337,6.45,
    4.10662547384635,-0.336354035680174,6.22,
    4.07252442538431,-0.652350744890558,6.25,
    4.12978465045935,-0.543127070673391,6.46,
    4.09957702879022,1.08691348795309,6.5,
    4.12052097981415,-0.346190905269886,6.22,
    4.13226838824104,0.14973470541068,6.57,
    4.12542132732937,0.96333448063827,6.43,
    4.08836664474856,0.54604564903367,6.46,
    4.09534796175654,0.64235388678608,6.37,
    4.08319778504073,-0.410336603417489,7,
    4.10743101042419,-1.12375932771742,6.51,
    4.08198948017397,1.08384461735167,6.38,
    4.09232719958963,0.639076546301779,6.38,
    4.07963999848859,0.280232003954934,6.22,
    4.10340332753498,-0.674579452169431,6.36,
    4.10326907143867,-0.0751364242983559,6.51,
    4.14186769912701,0.299110648697339,6.45,
    4.09937564464576,-0.574339375463223,6.24,
    4.08588290696688,0.0291276059610609,6.56,
    4.11696319326201,-1.21775500421093,6.44,
    4.12931475412228,0.00980293263203482,6.51,
    4.13669883941918,-0.677871337064164,6.57,
    4.14589538201622,0.66975070790558,6.42,
    4.11387530304694,-0.485085176770957,6.32,
    4.15576320509481,0.523443635220344,6.52,
    4.14649953444961,-0.125760668879814,6.5,
    4.14663379054591,-0.125818846521547,6.48,
    4.08957494961533,0.908788093376636,6.74,
    4.12575696757013,-0.398802885943893,6.34,
    4.1797950463338,-0.807466882161554,6.23,
    4.12219918101799,-0.53732385091051,6.34,
    4.06829535835063,1.40409314254538,6.58,
    4.11548637620263,0.210365504370239,6.25,
    4.18858882064193,-1.04218457773393,6.48,
    4.10991474820588,1.01097227294409,6.45,
    4.14804347955714,-0.261043078456619,6.31,
    4.1288448577852,0.238547723653136,6.48,
    4.20416252781357,-1.12674093185624,6.39,
    4.14488846129392,-0.487615904186349,6.51,
    4.17664002807058,0.015557671026805,6.33,
    4.16616805255862,-0.694742853166776,6.42,
    4.18865594869008,-0.102620511880455,6.24,
    4.23000682635272,-1.13180238668702,6.54,
    4.13911544915271,0.553894782530834,6.44,
    4.22302550934474,-0.861926002960589,6.6,
    4.17106840007383,-0.490670230377339,6.4,
    4.22933554587118,0.303750315625558,6.36,
    4.20778744241387,-0.539592778938102,6.21,
    4.2167154728183,0.149754097957925,6.29,
    4.18080196705611,-0.834926729059598,6.31,
    4.18999850965316,-0.527336689079653,6.29,
    4.19066979013469,-0.237374474544851,6.37,
    4.22040751546675,0.324990002994966,6.26,
    4.22128018009275,-0.636991847473008,6.31,
    4.20751893022125,-1.08600203823261,6.41,
    4.26229541751461,-0.686738579291658,6.49,
    4.23369886900117,1.02820255117073,6.31,
    4.2158428081923,0.69281329471596,6.31,
    4.26786704551137,-1.07265026945485,6.25,
    4.26088572850339,-0.690534670414745,6.21,
    4.21933346669629,-0.525528334049115,6.33,
    4.27531825885642,-0.406201142717625,6.21,
    4.27035078329305,-0.0996292114680096,6.53,
    4.29089196602806,-0.10228599044049,6.41,
    4.26135562484046,0.141303795496185,6.29,
    4.22389817397074,-0.243109820392377,6.32,
    4.28901238067976,-0.410816568961787,6.33,
    4.26961237476336,-0.678840964426383,7.05,
    4.26988088695597,-0.679054282446071,6.65,
    4.23027533854533,0.297656207654011,6.25,
    4.30216947811787,-0.308210601491765,6.47,
    4.31546083165229,-0.323763424381759,6.3,
    4.27666081981949,0.169515103599949,6.53,
    4.23195353974917,1.01120498351103,6.33,
    4.26296669799615,0.97439792884119,6.49,
    4.31700477675982,-0.0659589013149524,6.25,
    4.30686844148862,-0.411514700662585,6.41,
    4.29008642945022,0.581936405846209,6.29,
    4.28854248434268,-0.364642913972915,6.41,
    4.30196809397341,0.465493855917321,6.5,
    4.30237086226233,-0.304816905723999,6.32,
    4.26800130160767,0.103008362825343,6.31,
    4.29102622212437,-0.923511884871933,6.33,
    4.3370089351096,-0.97913455850563,6.49,
    4.30465321589955,0.590939395904413,6.66,
    4.33754595949483,-0.361215281247471,6.61,
    4.27484836251934,1.17188678184116,6.21,
    4.28203106367178,-0.345264911138967,6.29,
    4.28438054535716,1.31267182669856,6.39,
    4.3370089351096,-0.0335151697751022,6.23,
    4.36526984338228,-0.572477690927762,6.47,
    4.36627676410458,-0.779304055425901,6.33,
    4.27995009417902,1.19650077243109,6.41,
    4.34667537404372,-0.493870000672662,6.63,
    4.36063800805968,0.564318276674689,6.4,
    4.3619134409746,0.329736328933029,6.7,
    4.59565330464553,-1.50855109827724,6.57,
    4.37661448352024,-0.137376804679198,6.48,
    4.45710101325644,-1.44445388149775,6.57,
    4.35983247148184,-0.113184601991832,6.5,
    4.36923039822334,0.897234983355796,6.29,
    4.3277452644644,0.854527746186857,6.45,
    4.32781239251255,0.614792229015003,6.25,
    4.35211274594417,-0.781126954866873,6.46,
    4.3768158676647,0.297704689022122,6.41,
    4.403599958878,0.270492097101443,6.3,
    4.36177918487829,1.26731750683076,6.3,
    4.41467608682335,0.238882245093102,6.31,
    4.3647999470452,0.923700962207566,6.53,
    4.41145394051198,-0.147402751604543,6.35,
    4.40964148321183,-0.341934241149745,6.26,
    4.37178126405318,1.35169932802788,6.34,
    4.41044701978967,0.0734298801408503,6.93,
    4.38097780665023,-0.801620029167373,6.23,
    4.38312590419114,-0.0174435962463211,6.24,
    4.42837020864669,-0.556653372376347,6.46,
    4.40400272716692,-0.46327825739465,6.58,
    4.45837644617136,-0.427106308647068,6.71,
    4.43904356830312,-1.15746842296496,6.32,
    4.45515429985999,-0.871869531560145,6.47,
    4.4212546355424,1.37738475685306,6.32,
    4.41017850759706,0.237199941619652,6.35,
    4.4368954707622,-0.0234940709865681,6.32,
    4.44132592194034,-0.700672124486746,6.49,
    4.49898891530431,-0.698223815397143,6.32,
    4.44025187316988,-0.700744846538912,6.45,
    4.4554228120526,0.731234778943891,6.29,
    4.45072384868185,-0.701273293451322,6.59,
    4.42226155626471,0.261348511075718,6.52,
    4.47274184847624,-0.513349814379643,6.35,
    4.44508509263694,-0.860883653546203,6.33,
    4.43864080001419,-0.00676799898828912,6.25,
    4.47851486061745,-0.178154483397321,6.57,
    4.50637300060121,-0.567105955341069,6.37,
    4.43555290979913,-0.265183387293294,6.37,
    4.45025395234477,0.237708995984817,6.34,
    4.44286986704787,-0.322187779918153,6.27,
    4.4804615740139,0.242324422228979,6.37,
    4.49771348238939,-0.229166578923667,6.59,
    4.49395431169278,-0.777515092942607,6.65,
    4.47911901305083,0.442489446748674,6.28,
    4.44172869022926,0.873343365150718,6.56,
    4.49428995193355,0.425535512320273,6.32,
    4.51684497611317,-0.887834446079082,6.45,
    4.50489618354183,0.741983098254089,6.34,
    4.49006088489987,0.114905690559771,6.59,
    4.46696883633503,1.13514760108668,6.41,
    4.52369203702484,-0.298703405205207,6.26,
    4.49925742749692,0.26091702689953,6.31,
    4.46784150096102,0.474666530763913,6.55,
    4.53429826863311,0.147490018067143,6.33,
    4.47952178133975,-0.77664242831661,6.28,
    4.45569132424522,1.27632049688896,6.3,
    4.48240828741036,0.556493383861581,6.36,
    4.47764219599145,0.253266667011622,6.52,
    4.52886089673267,-0.340431318738305,6.3,
    4.53443252472942,0.343665025991306,6.35,
    4.44971692795954,1.20753028367633,6.4,
    4.50422490306029,0.618093810183359,6.69,
    4.49261175072971,-0.356662880781852,6.3,
    4.54819377460092,-0.444831096828432,6.29,
    4.50268095795276,-1.05286017499196,6.39,
    4.52953217721421,-1.20914471323443,6.22,
    4.48979237270726,0.169878713860781,6.37,
    4.49435707998171,0.182459628885574,6.37,
    4.54779100631199,-0.00599714523532496,6.38,
    4.47911901305083,0.764667530393204,6.43,
    4.55866575011288,-0.0369524987741688,6.36,
    4.5681979329507,-1.28224007193531,6.25,
    4.54383045147093,0.707139538992747,6.34,
    4.50892386643104,1.31418444538362,6.21,
    4.52510172603607,-0.648874630797003,6.3,
    4.50845397009397,0.887364176808406,6.46,
    4.55571211599412,0.217594076355582,6.57,
    4.52120829924316,-0.431886571542808,6.54,
    4.55926990254626,0.137788896308141,6.33,
    4.54886505508245,-0.667292702542354,6.6,
    4.57598478653652,0.00614258933965782,6.65,
    4.53530518935542,0.914707668422984,6.29,
    4.55504083551259,-1.22093538195901,6.53,
    4.58518132913356,-0.519923887895489,6.21,
    4.55651765257197,-0.548847872110483,6.36,
    4.57417232923637,-0.871559250804235,6.27,
    4.52980068940682,-0.413919376520889,6.8,
    4.56638547565055,-0.764051817018195,6.65,
    4.55490657941628,-0.273808222680233,6.43,
    4.5729640243696,0.403011068695924,6.45,
    4.60001662777552,0.106208133120666,6.51,
    4.58565122547064,0.867273497863227,7.48,
    4.61337510935809,-0.0712579148494796,6.32,
    4.58377164012234,-0.32580448997923,6.52,
    4.55987405497965,1.05890095345858,6.32,
    4.60860901793918,-0.162383494350828,6.46,
    4.59947960339029,-0.631721922759348,6.41,
    4.59760001804199,-0.594982742004867,6.47,
    4.58706091448187,0.292008128269085,6.35,
    4.61545607885085,-0.0281288897779753,6.29,
    4.58410728036311,0.501922755915891,6.35,
    4.5829661035445,0.841045077715201,6.43,
    4.5831003596408,-1.09892232283417,6.24,
    4.60511835943519,-0.306378005777171,6.21,
    4.60068790825705,0.272378022320959,6.35,
    4.55826298182396,0.673396506787523,6.49,
    4.63740695059709,-0.00607956356111358,6.44,
    4.63814535912678,-0.419868040388103,6.44,
    4.59169274980447,0.644933095569582,6.28,
    4.57121869511761,-0.200494697822849,6.21,
    4.56524429883194,0.469125110388831,6.41,
    4.61162978010609,-0.654207581289208,6.39,
    4.57585053044021,-0.135990237551225,6.37,
    4.64076335300477,-0.0712142816181797,6.37,
    4.57061454268423,1.02366954325235,6.51,
    4.64948999926474,-0.563692867026057,6.44,
    4.5599411830278,1.17471809373884,6.43,
    4.61156265205794,0.208130513300324,6.39,
    4.65016127974628,-1.01497683395006,6.28,
    4.63559449329694,0.678622798269884,6.43,
    4.61035434719117,0.208222627899735,6.42,
    4.59169274980447,0.59813887906889,6.56,
    4.66103602354716,-0.638092374529127,6.48,
    4.64029345666769,1.01013354527577,6.4,
    4.65204086509458,0.259035949816825,6.48,
    4.62814327995189,-0.383206429822599,6.57,
    4.63546023720063,0.28804720049442,6.4,
    4.76253363235545,-1.4797822544402,6.45,
    4.64801318220536,-0.662080955470427,6.26,
    4.6182754568733,0.491916201537791,6.38,
    4.66902426127745,-1.2527827926711,6.49,
    4.6321709628411,0.0353962468578072,6.26,
    4.63908515180093,-0.863753750538371,6.24,
    4.68312115138971,0.571411100829321,6.37,
    4.64747615782013,-0.575066595984887,6.4,
    4.64425401150876,0.264907043495062,6.34,
    4.68043602946356,0.546069889717726,6.28,
    4.63686992621186,0.427838377305543,6.36,
    4.66211007231762,-0.455807278568752,6.36,
    4.66096889549901,1.21424010502289,6.42,
    4.6756028099965,0.758709170252368,6.59,
    4.70346094998026,-0.218015864258147,6.39,
    4.70131285243934,-0.12078648051163,6.3,
    4.66774882836253,0.249494816572589,6.24,
    4.6737232246482,1.00025304245476,6.77,
    4.69010246839768,0.0450101021542093,6.56,
    4.64573082856814,0.769418704468078,6.34,
    4.6654664747253,-0.661276164759785,6.43,
    4.70104434024673,0.549861132704003,6.23,
    4.69735229759828,-0.436768645311581,6.35,
    4.7190346571519,0.678608253859451,6.52,
    4.72547894977465,0.68630709511547,6.68,
    4.68714883427893,0.066395233627951,6.22,
    4.70654884019532,-1.12592644487198,6.49,
    4.68976682815692,0.0342278458863332,6.47,
    4.66654052349576,0.830990041968989,6.43,
    4.68990108425322,-0.513873413155242,6.66,
    4.77005197374866,-1.40522760655918,6.35,
    4.75253155318056,-0.610540413031672,6.45,
    4.75300144951763,-0.01332267995689,6.35,
    4.74293224229459,-0.579696566639483,6.38,
    4.72957376071202,-0.102213268388323,6.21,
    4.7598485104293,-0.578896624065652,6.42,
    4.67318620026297,0.844637547092223,6.68,
    4.75165888855456,0.267486252278564,6.46,
    4.69191492569783,0.699397064505428,6.46,
    4.67882495630788,0.814079740771888,6.38,
    4.70527340728041,0.194264842020591,6.38,
    4.7698505896042,-0.692798750305527,6.43,
    4.76441321770375,-0.300157846248536,6.52,
    4.77689903466033,-0.678288276829918,6.29,
    4.77011910179681,0.113233083359943,6.29,
    4.7154097425516,-0.51917727482658,7.04,
    4.73541390090138,0.19275707147234,6.36,
    4.71849763276667,0.418806298426473,6.3,
    4.712523236481,-0.343146275352519,6.21,
    4.78159799803108,-0.621725064654869,6.3,
    4.73319867531231,0.0109858780139421,6.37,
    4.74776546176165,-0.293966775540767,6.28,
    4.68285263919709,1.36670915959503,6.24,
    4.77387827249341,0.793707869891666,6.48,
    4.78341045533123,0.109403055279178,6.34,
    4.7495779190618,0.340441015011927,6.5,
    4.78918346747244,0.263428361767677,6.26,
    4.72776130341187,-0.37143515364526,6.74,
    4.78327619923492,-0.0810075179765924,6.76,
    4.7219211632225,1.31197854313457,6.36,
    4.80777793681099,-1.1074114103904,6.41,
    4.76152671163315,0.400082794062022,6.21,
    4.74521459593181,0.34231239582101,6.5,
    4.7375619984423,0.84586412570543,6.21,
    4.78381322362015,0.417875456158742,6.34,
    4.74850387029134,0.00779580399224134,6.34,
    4.79233848573566,0.209507384154675,7.04,
    4.82899040002754,-1.02904612697586,6.38,
    4.75823743727362,-0.358771820294679,6.28,
    4.78784090650937,0.699600686251494,6.52,
    4.73527964480508,0.732107443569888,6.34,
    4.78173225412739,-0.616581191498297,6.58,
    4.8199281135268,-0.428085632282909,6.61,
    4.80583122341454,-1.20861626632202,6.73,
    4.8079121929073,0.228133925782903,6.63,
    4.83207829024261,-0.545943838160637,6.43,
    4.79253986988012,0.249315435510579,6.37,
    4.80992603435191,-0.210583670526738,6.39,
    4.81039593068899,0.887024807231629,6.29,
    4.75139037636195,0.867612867440003,6.32,
    4.79522499180627,-1.08752435319129,6.47,
    4.78025543706801,-0.316913007067681,6.36,
    4.7653530103779,0.53179212680905,6.38,
    4.83852258286536,-0.472959986606408,6.51,
    4.80200492466978,0.671209997085719,6.4,
    4.7921371015912,-1.18282417848699,6.33,
    4.78253779070523,-0.0696095483337072,6.59,
    4.82194195497141,0.718149657690745,6.36,
    4.76991771765235,1.05434370485615,6.49,
    4.85570736319269,-0.0415824694287649,6.36,
    4.83254818657968,0.509762193139433,6.56,
    4.81838416841927,-0.483645280138062,6.4,
    4.84463123524734,-0.728005919827701,6.3,
    4.82482846104202,-0.306072573158072,6.54,
    4.81905544890081,-0.143839371048388,6.31,
    4.7930097662172,0.0175551033929763,6.63,
    4.84691358888456,-0.425777919160828,6.51,
    4.82160631473064,0.789053658553014,6.29,
    4.84906168642548,-0.303347920270237,6.84,
    4.82865475978677,0.987652734882725,6.37,
    4.79482222351735,0.240453041419897,6.3,
    4.80126651614009,0.406603538072946,6.63,
    4.87389906424232,-0.63726334313443,6.45,
    4.84617518035487,-0.402909257822891,6.25,
    4.81569904649312,-0.170717441529101,6.33,
    4.87060978988279,0.896187785804599,6.3,
    4.81355094895221,0.867874666827803,6.4,
    4.81663883916727,0.291261515200176,6.22,
    4.8218076988751,-0.0421787902565296,6.38,
    4.8736305520497,-0.120859202563796,6.31,
    4.8947758872181,-0.559460443589971,6.3,
    4.83328659510937,0.0887451443271006,6.74,
    4.88980841165473,0.67612600781217,6.36,
    4.89564855184409,0.478137796720658,6.27,
    4.89584993598856,0.261217611381818,6.37,
    4.88900287507689,-0.442707612905173,6.31,
    4.87691982640923,0.930275035723411,6.32,
    4.91457866142342,-1.39961831226874,6.27,
    4.84288590599534,-0.44056958457148,6.27,
    4.85624438757791,-0.735729001767776,6.36,
    4.8614803753339,-0.648370424568649,6.63,
    4.88074612515399,0.461629890878878,6.53,
    4.91162502730466,-0.443633607036092,6.5,
    4.86846169234188,-0.431857482721941,6.59,
    4.89598419208486,-0.999913672877985,6.44,
    4.8624872960562,-0.0746273699331909,6.28,
    4.85013573519593,0.0709524822303806,6.69,
    4.91921049674602,-0.32943089631393,6.68,
    4.85758694854099,-0.66510619284055,6.22,
    4.88698903363228,1.03932902515219,6.43,
    4.89913921034808,0.363295131939431,6.5,
    4.88766031411381,-0.650653897006675,6.32,
    4.90262986885207,-0.892003843736624,6.22,
    4.87994058857615,-0.233103266014276,6.37,
    4.86141324728574,0.0638742024861814,6.43,
    4.88712328972858,-0.0713597257225126,6.36,
    5.01265273977587,-1.44310125132746,7.16,
    4.90477796639299,-0.414995662892952,6.51,
    4.88766031411381,0.144309640319064,6.42,
    4.89370183844764,-0.33439054027168,6.48,
    4.8873918019212,0.539175839172348,6.59,
    4.94525617942963,-0.493942722724829,6.37,
    4.86732051552326,0.909588035950467,6.56,
    4.88705616168043,0.357205872104695,6.57,
    4.92451361255015,0.190095444363049,6.4,
    4.86752189966772,1.14207558858973,6.59,
    4.93652953316965,0.29627933679966,6.21,
    4.88437103975429,-0.244263676953418,6.47,
    4.89074820432888,0.199345689398619,6.42,
    4.98378767906981,-1.32876764091139,6.39,
    4.88591498486182,0.282714250002215,6.29,
    4.92585617351323,-1.10578728455869,6.37,
    4.91001395414897,-0.0489807262024964,6.49,
    4.90383817371884,-0.0154752527010164,6.66,
    4.90638903954868,0.154180446866455,6.4,
    4.93236759418413,-0.836099978167884,6.49,
    4.93209908199151,0.0918770407070682,6.38,
    4.95183472814868,0.128427144125916,6.28,
    4.96056137440865,-0.38688131752541,6.23,
    4.94834406964469,-0.234499529415871,6.42,
    4.88960702751027,0.538424377966628,6.36,
    4.92699735033184,0.714450529303879,6.25,
    4.90330114933361,0.669634352622113,6.45,
    4.94055721605887,-0.961996394878408,6.22,
    4.9697579170057,-0.326657762057983,6.35,
    4.91471291751972,-0.615776400787655,6.32,
    4.94673299648901,0.551834324386118,6.41,
    4.90652329564498,0.606443737426296,6.47,
    4.96901950847601,-0.0904322959373618,6.31,
    4.99244719728163,-0.871016259481392,6.54,
    4.93384441124351,-0.366494902234754,6.36,
    4.92243264305739,0.685919244170582,6.45,
    4.91471291751972,-0.321029075220301,6.42,
    4.95834614881958,0.411718322408651,6.31,
    4.95666794761574,0.383710636050953,6.51,
    4.94928386231884,-0.58034621697217,6.62,
    4.97875307545829,0.958127581703154,6.23,
    4.9826465022512,-0.303663049162958,6.47,
    4.9254534052243,0.0740262009686151,6.21,
    4.97385272794307,-0.329130311831642,6.75,
    4.99231294118532,0.808349243061174,6.52,
    4.91370599679742,1.2355670588549,6.44,
    4.97600082548399,0.0145880436645859,6.25,
    4.99835446551914,-0.381141123541073,6.61,
    4.95740635614543,-0.106334184677755,6.8,
    4.97116760601693,0.856520330416217,6.4,
    4.94552469162224,0.437141951846035,6.59,
    4.95989009392712,-0.873866963926316,6.31,
    4.98526449612919,0.552033097995373,6.64,
    4.99177591680009,0.191574126090433,6.55,
    4.97754477059152,-0.442436117243751,6.29,
    4.99526657530408,-0.510785150006574,6.63,
    4.99137314851117,-0.839876676743727,6.6,
    4.94619597210378,-0.147024596933278,6.34,
    5.03017316034396,-1.06812210967329,6.48,
    4.94881396598177,0.722275422116987,6.28,
    5.0076852642125,-0.666308530769702,6.31,
    4.96720705117586,0.719521680408285,7.3,
    4.98721120952564,-0.00349065850398866,6.22,
    4.96197106341988,0.31407199889638,6.63,
    5.0058056788642,1.00333645746662,6.22,
    4.99298422166686,-0.403578300702822,6.62,
    4.98472747174396,-0.67134574491643,6.49,
    4.95989009392712,1.39525983727557,6.39,
    4.99741467284499,0.108913393461257,6.21,
    5.0058056788642,-0.304264218127534,6.37,
    5.00748388006804,-0.402434140415404,6.36,
    4.98284788639566,-0.644710081276272,6.69,
    4.98432470345504,-0.644690688729028,6.4,
    5.02601122135844,0.345473381021844,6.5,
    4.99331986190762,0.176990930562658,6.75,
    4.99459529482254,-0.699702497124527,6.23,
    5.02802506280305,0.70998539530086,6.22,
    5.02930049571797,-0.37183270086377,6.24,
    5.04782783700837,0.398192020705695,6.29,
    4.99922713014514,1.01622280511051,6.46,
    4.98633854489965,0.684479347537687,6.41,
    5.02352748357676,-0.256868832662265,6.32,
    4.98445895955134,1.08902727560273,6.45,
    5.04547835532299,0.886792096664697,6.3,
    4.98593577661072,0.337018230423294,6.39,
    4.98821813024795,1.3227414068552,6.22,
    5.00889356907926,0.363615108968963,6.69,
    4.99969702648222,0.71007266176346,6.65,
    4.9966762643153,-0.329809050985195,6.37,
    5.02540706892506,0.436783189722014,6.72,
    5.04500845898592,0.388578165409293,6.4,
    5.01191433124618,0.146156780444092,6.3,
    5.04339738583023,0.586803935204549,6.39,
    5.00600706300866,0.0581291603650334,6.73,
    5.02413163601014,-0.0753109572235553,6.9,
    5.04433717850438,0.371192746804705,6.52,
    5.03608042858148,1.2135468214589,6.52,
    4.99231294118532,0.912128459639481,6.31,
    5.02097661774692,-0.00850363196666126,6.53,
    5.07904237939981,-0.947359869845711,6.49,
    5.01614339827986,-0.30128261398871,6.29,
    5.05923960519449,0.52223160101757,6.31,
    5.0169489348577,0.0111991960336303,6.56,
    5.02869634328459,-0.407413176920399,6.3,
    5.03789288588163,1.34479073307206,6.54,
    5.00929633736819,0.871326540237302,6.43,
    5.06675794658769,-0.666226112443913,6.46,
    5.06232749540955,-0.625443585588979,6.56,
    5.02319184333599,0.722808717166207,6.49,
    5.01392817269079,0.378717055135525,6.23,
    5.06306590393924,0.2941122196451,6.48,
    5.02460153234721,-0.680591141815189,6.36,
    5.08273442204826,0.00747097882589795,6.34,
    5.04755932481575,-0.497380051723895,6.3,
    5.01936554459123,0.60389361746366,6.74,
    5.03970534318178,-0.635600432208224,6.57,
    5.08226452571118,-1.20095136202368,6.27,
    5.0641399527097,-0.355033906813324,6.41,
    5.06367005637262,0.466628319931117,6.36,
    5.07273234287336,0.2940249531825,6.73,
    5.09011850734515,0.0962694526579206,6.49,
    5.07494756846243,1.1515439997818,6.25,
    5.08421123910764,-0.415751972235483,6.25,
    5.0327240261738,0.87011935417134,6.75,
    5.03326105055903,0.870153291129017,6.57,
    5.08803753785239,-0.566853852226892,6.25,
    5.06534825757647,-0.91827589711595,6.38,
    5.11616419002876,0.479189842408665,6.54,
    5.06554964172093,0.873900900883994,6.27,
    5.08615795250409,-1.18034678057652,6.34,
    5.12106453754398,0.00591957504634744,6.41,
    5.09662992801606,-0.526779153346377,6.58,
    5.05380223329404,0.54143991906313,6.68,
    5.12348114727751,0.167866737084177,6.32,
    5.1178423912326,0.34226876258971,6.58,
    5.10596072670941,-0.576239845093172,6.48,
    5.08307006228902,-0.732757093902575,6.34,
    5.06219323931325,0.582746044693662,6.6,
    5.05870258080926,0.653543386546088,6.22,
    5.11562716564353,-0.327525578547169,6.26,
    5.10334273283142,0.865154862076778,6.31,
    5.10931712911709,0.651541106043105,6.31,
    5.10589359866126,0.614113489861449,6.31,
    5.09797248897913,-0.136116289108313,6.31,
    5.10609498280572,0.949042173319161,6.26,
    5.08072058060365,-0.115186882494815,6.32,
    5.13516142765624,0.17301545837756,6.35,
    5.08555380007071,0.260422516944798,6.64,
    5.11898356805122,1.12383204976958,6.52,
    5.13751090934162,0.353681276643029,6.4,
    5.09991920237558,1.0082233793722,6.43,
    5.0854195439744,-0.0543815506100566,6.52,
    5.12019187291798,0.579837162607005,6.37,
    5.1085787205874,0.295619990193351,6.25,
    5.10898148887632,0.490224201790718,6.53,
    5.08709774517824,0.636206449309611,6.36,
    5.12066176925506,-0.234727391845993,6.7,
    5.10649775109464,0.877401255661605,6.51,
    5.11334481200631,0.353802480063306,6.31,
    5.15140641530942,-0.958011226419688,6.3,
    4.59666022536784,1.55400238088126,6.38,
    5.13751090934162,0.24927665041609,6.32,
    5.12482370824058,-0.556895779216902,6.6,
    5.14596904340897,1.0127660835642,6.6,
    5.12958979965949,-0.12140704202345,6.61,
    5.14100156784561,0.662197310753893,6.34,
    5.12489083628873,0.00429544921463049,6.25,
    5.12878426308164,0.353947924167639,6.33,
    5.12321263508489,1.09182949867954,6.38,
    5.16805417125152,0.63230854731349,6.25,
    5.05011019064559,1.45670027508258,6.53,
    5.12771021431119,0.972705929094117,6.37,
    5.16691299443291,-0.114139684943618,6.34,
    5.17201472609258,-0.205027705741223,6.27,
    5.21430539642937,-1.13995210466647,6.39,
    5.16704725052921,0.676528403167491,6.61,
    5.16073721400277,0.0508472588747681,6.38,
    5.14200848856791,0.194604211597368,6.68,
    5.1317378972004,1.04996583731573,6.29,
    5.15248046407988,0.251181968182851,6.38,
    5.14241125685683,0.394197155973353,6.32,
    5.17610953702995,0.840632986086258,6.67,
    5.18188254917116,0.354873918298558,7.14,
    5.1732901590075,-0.935191046449862,6.26,
    5.20074553070233,-0.780545178449542,6.25,
    5.21913861589643,-0.67311531485248,6.61,
    5.2019538355691,0.876829175517896,6.52,
    5.1482513970462,0.511968095388481,6.43,
    5.20725695137324,0.669925240830779,6.5,
    5.21068048182907,-0.393959597269609,6.34,
    5.20578013431386,0.0590212175382749,6.35,
    5.16348946397707,0.362727899932533,6.48,
    5.17845901871533,0.289225297739516,6.38,
    5.21175453059953,0.860175825571783,6.47,
    5.18671576863822,0.357385253166706,6.5,
    5.20202096361725,0.413948465341755,6.64,
    5.17308877486304,0.391874898440838,6.36,
    5.17463271997057,0.212813813459842,6.34,
    5.22054830490765,-1.40761288987024,6.39,
    5.23028187188993,0.702562897843073,6.23,
    5.16617458590322,1.05605024901366,6.51,
    5.22336768293011,0.511934158430803,6.49,
    5.23686042060899,0.473604788802284,6.28,
    5.16295243959184,0.968017780797788,6.48,
    5.21195591474399,0.232177271883357,6.26,
    5.25954970088491,-1.13773165800699,6.45,
    5.24061959130559,-0.0194895099806033,6.48,
    5.23155730480485,0.510765757459329,6.82,
    5.21746041469259,0.600635669526604,6.57,
    5.25760298748846,-0.892071717651979,6.25,
    5.18141265283409,1.01257700622857,6.22,
    5.23196007309377,0.710639893770358,6.34,
    5.2149766769109,0.995579438568865,6.27,
    5.2214880975818,-1.06357940548129,6.21,
    5.22370332317087,0.629908719591998,6.43,
    5.22793239020455,0.43866911494153,6.62,
    5.22444173170056,0.18664841909036,6.44,
    5.25344104850293,-0.925431747049127,6.5,
    5.24256630470204,0.616299999563253,6.53,
    5.25156146315463,0.583589620498793,6.44,
    5.2158493415369,0.137924644138852,6.51,
    5.26129503013691,0.496381335540809,6.38,
    5.26404728011121,-1.06166923957772,6.24,
    5.2204811768595,0.168080055103865,6.25,
    5.23491370721253,1.19447425124405,6.34,
    5.21403688423675,-0.233820790262318,6.48,
    5.22202512196703,0.180665818265469,6.54,
    5.23034899993808,0.325886908305019,6.23,
    5.23578637183853,0.0768041833613727,6.53,
    5.22101820124473,-0.575149014310676,6.46,
    5.29600023103233,-0.978683681782198,6.53,
    5.29841684076586,-1.1735206039465,6.39,
    5.26095938989614,-0.135486031322871,6.49,
    5.24048533520928,-0.0919061295279347,6.51,
    5.20705556722878,0.834398282147189,6.29,
    5.27834555436793,-0.662207007027515,6.55,
    5.22289778659303,0.527007015776499,6.57,
    5.22316629878565,0.366485205961132,6.48,
    5.30298154804031,-0.514207934595207,6.28,
    5.27908396289762,0.888416222496414,6.43,
    5.29834971271771,0.737590686303237,6.43,
    5.27579468853809,-0.683921811804411,6.29,
    5.27344520685271,0.665067407746061,6.32,
    5.30855317603706,-0.373578030115764,6.45,
    5.25505212165862,-0.113974848292041,6.72,
    5.29841684076586,-1.14572623560849,6.45,
    5.28351441407576,1.22813486512349,6.33,
    5.30090057854755,-0.575958653158129,6.53,
    5.26505420083351,-0.181523938481032,6.34,
    5.31365490769674,-0.959645048525027,6.26,
    5.29324798105803,-0.197828222576746,6.55,
    5.33211512093898,0.405095767524695,6.45,
    5.29338223715434,0.270530882195932,6.34,
    5.27854693851239,-0.0684459954990443,6.47,
    5.27196838979333,1.12808386575291,6.57,
    5.29365074934696,-0.985694087611042,6.37,
    5.28666943233898,0.983342741257661,6.21,
    5.33406183433544,0.164056101550656,6.43,
    5.31331926745597,1.1151005553728,6.26,
    5.27962098728285,0.290844575434422,6.42,
    5.32231442590855,0.187201106686825,6.31,
    5.28197046896822,0.876664338866319,6.54,
    5.3249995478347,1.18729900876363,6.28,
    5.35124661466277,0.365040461191425,6.48,
    5.32043484056025,-0.71941502139844,6.22,
    5.29754417613987,-0.124926789348305,6.49,
    5.36171859017473,-0.202589092925242,6.34,
    5.28868327378359,0.36887048927219,6.22,
    5.31231234673366,0.381800470147382,6.26,
    5.33560577944297,0.0151407312610508,6.27,
    5.29344936520249,0.833166855397171,6.92,
    5.34721893177355,0.423048418136181,6.56,
    5.36937118766425,-0.523506660998888,6.3,
    5.33761962088758,-0.620386978895006,6.39,
    5.34137879158418,-0.607413364788515,6.53,
    5.32291857834194,-1.0955237789296,6.27,
    5.30378708461815,0.638882620829335,6.45,
    5.32607359660516,0.734846640868157,6.71,
    5.33641131602082,-0.203558720287461,6.32,
    5.3897109862548,-0.807898366337742,6.31,
    5.31036563333721,0.678894293931305,6.27,
    5.35970474873013,0.876727364644863,6.31,
    5.34366114522141,0.646755995010554,6.48,
    5.36661893768995,-0.959043879560451,6.27,
    5.35245491952953,0.508729539998669,6.22,
    5.34923277321816,0.745638593409655,6.29,
    5.36098018164504,-0.502703305942478,6.3,
    5.39293313256617,-0.599108506431109,6.46,
    5.38266254119867,-0.8377677372309,6.27,
    5.35809367557444,0.230679197608728,6.21,
    5.3582950597189,-0.0984074809916136,6.63,
    5.38111859609113,0.808484990891884,6.45,
    5.38373658996912,0.648084384496794,6.57,
    5.34366114522141,0.687717902927499,6.23,
    5.39420856548109,0.817468588402844,6.5,
    5.33741823674312,-0.145652574215738,6.3,
    5.33600854773189,0.717878162029323,6.39,
    5.42058988840547,-0.638737176725003,6.25,
    5.40414351660783,0.175517096972085,6.33,
    5.35104523051831,0.346709655908674,6.41,
    5.3842064863062,0.934657751400641,6.51,
    5.3805815717059,0.30221345625644,6.22,
    5.3519178951443,1.04021623418862,6.44,
    5.41669646161256,-0.248854862513525,6.41,
    5.36823001084564,0.147262155637022,6.25,
    5.36413519990827,0.599152139662409,6.39,
    5.38071582780221,0.0512593505037112,6.21,
    5.38098433999483,0.988535095782344,6.36,
    5.43300857731389,-0.303920000413946,6.74,
    5.44314491258509,-0.504181987669862,6.39,
    5.39085216307341,0.350597861631172,6.55,
    5.38870406553249,0.196533770048184,7.11,
    5.44294352844062,0.80160548475694,6.41,
    5.44596429060754,-0.402405051594537,6.36,
    5.44938782106337,0.450372517203515,6.34,
    5.45885287585303,-0.661659167567861,6.44,
    5.44797813205215,-0.515332702335381,6.4,
    5.45193868689321,0.175575274613818,6.56,
    5.44583003451123,0.753836792757217,6.6,
    5.39776635203323,0.366262191667821,6.48,
    5.47355391839868,-1.30287859034015,6.55,
    5.44495736988523,0.72906281365252,6.49,
    5.36782724255671,1.26591639529235,6.27,
    5.47516499155437,-1.06626042513782,6.22,
    5.40421064465598,0.451734843647432,6.41,
    5.46737813796854,-0.434431843368633,6.36,
    5.42199957741669,0.00169199974707228,6.22,
    5.44012415041817,0.55104407808591,6.32,
    5.47073454037623,0.318857109928931,6.25,
    5.44119819918863,0.55016171718629,6.49,
    5.42387916276499,-0.0277022537385989,6.22,
    5.42622864445037,-0.387918818802984,6.37,
    5.45885287585303,-0.442528231843162,6.51,
    5.47570201593959,0.196344692712551,6.42,
    5.44723972352246,-0.453785605518526,6.28,
    5.43717051629941,0.797038539880888,6.58,
    5.4712044367133,0.347936234521881,6.45,
    5.49040305848524,-0.670928805150676,6.29,
    5.40642587024505,0.977471647579424,6.48,
    5.41542102869764,0.682113456773873,6.51,
    5.49302105236323,0.305805925633462,6.22,
    5.4490521808226,0.618825878841834,6.66,
    5.45005910154491,-0.466924056276594,6.5,
    5.45610062587873,0.621123895690293,6.47,
    5.46167225387549,-0.626219287478754,6.49,
    5.44173522357386,0.996830257866128,6.32,
    5.470197515991,0.315734909822585,6.38,
    5.44589716255938,-0.0264126493468475,6.27,
    5.50523835712719,0.0577122205992792,6.4,
    5.48838921704063,0.812130789773828,6.3,
    5.50993732049794,-1.07461376486334,6.28,
    5.51060860097948,-1.07461376486334,6.59,
    5.46516291237947,0.924942085231206,6.33,
    5.47731308909528,-0.313533855710348,6.21,
    5.46898921112423,0.795516224922204,6.4,
    5.47241274158007,1.21740109022372,6.41,
    5.517388533843,-0.557555125823211,6.36,
    5.51195116194255,0.914678579602117,6.27,
    5.5146362838687,0.137255601258921,6.33,
    5.52913594226988,0.0967736588862745,6.21,
    5.50275461934551,0.906010110983879,6.29,
    5.50382866811596,0.315056170669032,6.52,
    5.52322867403236,0.814390021527798,6.33,
    5.46885495502792,-0.387758830288218,6.33,
    5.50080790594905,-0.511056645667995,6.35,
    5.51859683870976,-0.859962507552095,6.24,
    5.47315115010976,1.11774763807166,6.45,
    5.47476222326544,-0.181974815204464,6.38,
    5.46328332703117,0.573326114869704,6.44,
    5.48073661955112,-0.455084906183899,6.41,
    5.54564944211567,-0.0891911729137213,6.44,
    5.47717883299897,0.517480426942696,6.34,
    5.50268749129735,0.740198983907606,6.66,
    5.4868452719331,-0.0109373966458311,6.55,
    5.50168057057505,0.49780183962646,6.56,
    5.50154631447874,0.710402335066614,6.7,
    5.50490271688642,-0.0425617930646062,6.57,
    5.53987642997446,-1.18316354806377,6.37,
    5.49765288768583,0.891426915456104,6.63,
    5.50315738763443,0.992874178228274,6.23,
    5.54189027141907,-0.330996844503913,6.25,
    5.56162591757624,0.293637102237613,6.66,
    5.54316570433399,-0.0570674184034035,6.21,
    5.52343005817682,-0.750457641399884,6.64,
    5.52457123499544,-0.458464057541233,6.25,
    5.5970023989532,-1.3227414068552,6.58,
    5.58653042344123,0.0161394474441365,6.5,
    5.51490479606131,0.0267374745131909,6.25,
    5.51329372290563,0.257086998818765,6.31,
    5.52141621673222,-0.0728965850916298,7.31,
    5.57162799675113,0.800214069492156,6.48,
    5.57122522846221,0.051346616966311,6.42,
    5.57619270402558,0.0396141258834602,6.33,
    5.58082453934818,0.726546630647562,6.33,
    5.54578369821198,0.878807215336823,6.37,
    5.56901000287314,0.817895224442221,6.32,
    5.57344045405128,0.273294320178257,6.34,
    5.58136156373341,-0.339355032366242,6.25,
    5.61532835609914,0.0513708576503664,6.45,
    5.6043864842501,-0.150903106382154,6.27,
    5.58438232590032,0.391908835398516,6.68,
    5.60123146598688,-0.236104262700344,6.48,
    5.61573112438806,0.79416844288872,6.63,
    5.55101968596797,0.633539974063508,6.54,
    5.58303976493725,0.832381457233773,6.46,
    5.57585706378481,1.10471584632343,6.54,
    5.59794219162735,-1.3029464642555,6.63,
    5.58001900277033,1.19538085282773,7.33,
    5.59317610020844,0.278947247699994,6.27,
    5.58297263688909,-0.689293547391105,6.21,
    5.58129443568525,-0.163968835088056,6.77,
    5.60854842323563,0.00160958142128366,6.38,
    5.5767297284108,-1.10511339354194,6.31,
    5.64305223998659,-1.45193940473408,6.45,
    5.62076572799958,-0.00684556917726665,6.48,
    5.61170344149884,1.1240599121997,6.39,
    5.59008820999338,-0.222025273400923,6.4,
    5.612643234173,0.837297467960224,6.46,
    5.60734011836886,0.73742584965166,6.43,
    5.59740516724212,-0.288638673185373,7.05,
    5.64936227651303,-0.475330725507033,6.4,
    5.64217957536059,-0.447623623631624,6.56,
    5.61143492930623,-0.838844023602964,6.38,
    5.59720378309766,1.02296656341474,6.42,
    5.62492766698511,-1.19146355828436,6.41,
    5.60384945986487,0.384433008435807,6.29,
    5.59129651486014,0.704162782990734,6.4,
    5.71481212346282,-1.41924841821687,6.38,
    5.63043216693371,-0.792117681017626,6.31,
    5.61311313051007,-0.370935795553717,6.38,
    5.65674636180993,0.674293412097576,6.63,
    5.62902247792248,0.652869495529346,6.58,
    5.63553389859338,0.17757270697999,6.35,
    5.67191730069265,-0.0454076493727191,6.36,
    5.66298927028822,0.651904716303938,6.47,
    5.63352005714877,0.428109872966965,6.32,
    5.66943356291097,-1.3955798143051,6.47,
    5.67601211163002,0.00932781522454747,6.46,
    5.67701903235232,0.860854564725337,6.58,
    5.62472628284065,-0.912705387920001,6.39,
    5.63862178880845,-0.182066929803875,6.61,
    5.6294252462114,-0.536887518597511,6.5,
    5.65325570330594,0.143039428474558,6.4,
    5.70037959310979,0.312515746980018,6.44,
    5.70434014795085,-0.32903334909542,6.57,
    5.66554013611805,-0.894699407803593,6.41,
    5.682120764012,-0.40857188161825,6.43,
    5.67379688604095,0.408310082230451,6.7,
    5.66896366657389,-0.716893990256671,6.32,
    5.7172958612445,-0.493996052229751,6.41,
    5.6718501726445,-0.393499024272555,6.4,
    5.66580864831067,0.800306184091567,6.25,
    5.69178720294612,0.397144823154499,6.47,
    5.67601211163002,0.49213436769429,6.31,
    5.67352837384834,0.524568402960518,6.36,
    5.70460866014347,0.00681163221958898,6.25,
    5.67614636772633,-0.564104958655001,6.28,
    5.74810763534702,-0.901302570140305,6.21,
    5.71743011734081,-0.947059285363423,6.33,
    5.7385754525092,-0.43455304678891,6.49,
    5.70353461137301,-0.320776972106124,6.22,
    5.99433331597452,-1.52160713070952,6.57,
    5.72937890991215,-0.653582171640577,6.3,
    5.71964534292988,-0.846508927901305,6.45,
    5.75388064748823,0.625826588397056,6.4,
    5.73072147087523,0.446164334451484,6.28,
    5.72078651974849,0.751553320319192,6.54,
    5.70917336741791,0.300094820469992,6.21,
    5.71836991001496,0.638451136653148,6.47,
    5.76676923273372,-0.196819810120038,6.31,
    5.73354084889768,-0.264509496276552,6.38,
    5.7477048670581,0.35713799818934,6.29,
    5.70420589185454,1.22436301468446,6.29,
    5.76542667177065,0.718183594648422,6.48,
    5.74911455606932,0.371284861404116,6.89,
    5.777375464342,-0.169093315697384,6.59,
    5.77039414733402,1.14760246455438,6.37,
    5.75676715355883,0.344149839672415,6.39,
    5.81241630547819,-0.513015292939678,6.41,
    5.83389728088735,-1.33234071774117,6.41,
    5.77435470217509,0.370703084986785,6.4,
    5.76871594613018,-0.0798536614155517,6.33,
    5.74945019631009,0.849427506261585,6.42,
    5.82470073829031,-0.0633021223424721,6.22,
    5.76139898888144,1.15464195920409,6.43,
    5.78610211060197,1.00632775787906,6.59,
    5.79556716539163,0.576065312167973,6.46,
    5.78428965330182,-0.280934983792543,6.28,
    5.81496717130803,1.30893876135401,6.35,
    5.80402529945899,-0.262424797447781,6.37,
    5.77019276318956,0.191530492859133,6.37,
    5.79576854953609,-0.49036479775824,7.1,
    5.81234917743004,1.09062231261358,6.66,
    5.80912703111867,-0.490146631601741,6.47,
    5.82322392123093,0.57494539256461,6.38,
    5.86027860381173,-1.29362834530457,6.55,
    5.84933673196269,0.787356810669131,6.44,
    5.76791040955234,1.44634950299089,6.98,
    5.85014226854053,0.841801387057732,6.27,
    5.80389104336268,0.983371830078527,6.39,
    5.83040662238337,0.314168961632602,6.35,
    5.85182046974437,-0.573767295319514,6.37,
    5.87672497560937,-0.835886660148195,6.43,
    5.80301837873668,1.0269662762839,6.32,
    5.81664537251187,0.869110941714632,6.42,
    5.80335401897745,-0.483587102496329,6.44,
    5.83154779920198,-0.0367537251649139,6.27,
    5.83302461626136,0.25534166956677,6.33,
    5.84376510396594,0.366136140110733,6.46,
    5.87249590857569,0.53325141598919,6.32,
    5.8707505793237,-0.0572322550549807,6.39,
    5.82376094561616,1.25857631616036,6.37,
    5.88397480480996,1.03122294040404,6.3,
    5.87249590857569,-0.70892365333923,6.23,
    5.90532152412281,0.149215954771893,6.21,
    5.86927376226432,0.48527425410659,6.37,
    5.84389936006225,0.00415000511029763,6.39,
    5.89545370104423,-0.985936494451597,6.34,
    5.8513505734073,0.470109282161484,6.47,
    5.90001840831868,0.889783397077142,6.42,
    5.91451806671986,-0.768856320597991,6.62,
    5.86551459156771,1.33496840789279,6.66,
    5.91955267033138,0.734405460418347,6.41,
    5.93270976776949,0.673236518272757,6.22,
    5.88739833526579,-0.389513855813834,6.29,
    5.92331184102799,0.321916284256732,6.26,
    5.918948517898,-0.266313003170279,6.57,
    5.91921703009061,-0.266293610623035,6.35,
    5.93438796897333,0.653519145862032,6.46,
    5.91539073134586,1.3656037844021,6.76,
    5.95251254197481,0.984947474542133,6.57,
    5.89250006692547,-0.193469747583571,6.4,
    5.91384678623832,-0.234121374744606,6.37,
    5.90820803019342,1.11850394741419,6.29,
    5.94506132862976,0.623528571548597,6.56,
    5.96258174919786,-0.452500849263585,6.43,
    5.89921287174083,0.861426644869046,6.4,
    5.95029731638574,-0.158727999195262,6.38,
    5.94076513354793,0.515618742407236,6.35,
    5.94687378592991,0.353080107678453,6.42,
    5.96217898090894,0.276867397008034,6.32,
    5.9244530178466,0.943132294546436,6.35,
    5.98332431607733,-0.979415750440674,6.23,
    5.90746962166373,1.22022270584778,6.6,
    5.92639973124305,1.22825606854376,6.34,
    5.9560032004788,-0.687960309768054,6.28,
    5.96553538331662,0.204150192978414,6.4,
    5.98399559655887,0.873905749020805,6.29,
    5.98184749901795,0.978606111593221,6.38,
    5.9273395239172,0.219513938532776,6.3,
    5.98204888316241,0.622253511567278,6.3,
    5.94103364574054,-0.895489654103802,6.65,
    5.95519766390096,-0.106503869466143,6.23,
    5.98540528557009,-0.475641006262944,6.47,
    5.94888762737452,0.78859308555596,6.4,
    5.98882881602593,-0.48301502235262,6.31,
    5.99285649891515,0.343500189339728,6.21,
    5.9985623830082,-0.0426878446216946,6.31,
    5.98063919415118,0.540455747290477,6.34,
    5.95190838954143,-0.134186730657497,6.45,
    5.97372500519136,-1.03848060121025,6.3,
    5.96640804794262,-0.0879161129324032,6.41,
    6.01735823649122,0.659782938621968,6.43,
    5.95325095050451,0.82324756748167,6.39,
    6.00453677929388,0.190924475757746,6.51,
    5.97103988326522,-0.820673206834978,6.62,
    5.99829387081559,-0.843241283690627,6.48,
    5.9937962915893,0.338012098469568,6.25,
    6.01762674868383,0.916598441779311,6.55,
    6.01896930964691,-0.786455057222267,6.56,
    6.02830010834026,-1.34302116313601,6.73,
    5.99030563308531,-0.590600026327637,6.28,
    5.99775684643036,-1.05270988275081,6.37,
    6.02789734005134,-0.65935145444578,6.71,
    5.99674992570806,-1.21566060910854,6.34,
    6.0401146448153,-0.420415879847756,6.3,
    5.9958101330339,1.02071702793439,6.36,
    6.05273471786818,-0.54445061202282,6.33,
    6.01675408405784,0.182891113061761,6.54,
    6.04239699845252,-1.01436112057505,6.46,
    6.03024682173672,0.334070563242148,6.4,
    5.99144680990392,0.884479535405804,6.21,
    6.05669527270924,0.879854412888019,6.46,
    6.00601359635326,0.701050279158011,6.34,
    6.01957346208029,-0.621535987319236,6.4,
    6.03615408997424,-0.531181261570852,6.48,
    6.07307451645873,0.206792427540462,6.51,
    6.03138799855533,-0.0556760031386191,6.31,
    6.05233194957926,0.066501892637795,6.28,
    6.04447796794528,-0.0102925944499554,6.37,
    6.05978316292431,0.163309488481747,6.43,
    6.06985237014736,0.128102318959573,6.33,
    6.0308509741701,0.918993421363992,6.29,
    6.0291056449181,1.0439638439436,6.43,
    6.05441291907202,-0.425394916352751,6.29,
    6.07226897988089,0.0032434035266228,6.21,
    6.07844476031102,0.54250166102476,6.6,
    6.06757001651013,0.791943148092427,6.5,
    6.05662814466109,-0.370169789937564,6.28,
    6.05743368123894,-0.121106457541162,6.21,
    6.0948240040605,0.675583016489327,6.54,
    6.07575963838488,-0.620973603449149,6.47,
    6.07455133351811,0.55467533255742,6.57,
    6.09079632117129,0.768972675881457,6.39,
    6.08891673582299,0.964056853023123,6.5,
    6.11140463195445,-0.0559329543896072,6.68,
    6.04018177286345,0.115482618840291,6.41,
    6.06629458359521,1.05496911450478,6.74,
    6.06347520557276,1.02214722829367,6.43,
    6.05166066909772,0.289079853635183,6.44,
    6.06683160798044,0.0228104836962037,6.39,
    6.06468351043953,-0.844623002681789,6.33,
    6.09039355288237,0.347509598482504,6.3,
    6.07622953472195,0.80403924943611,6.66,
    6.06589181530629,1.04244152898491,6.4,
    6.07280600426612,0.77774780350954,6.56,
    6.1159693392289,1.11061118068573,6.26,
    6.08072711394824,-1.13695110798041,6.47,
    6.08985652849714,-1.3803324240342,6.41,
    6.12872366837809,1.12089407886206,6.21,
    6.12724685131871,-0.235435219820413,6.42,
    6.12758249155948,-0.496982504505385,6.51,
    6.09824753451634,-0.844409684662101,6.8,
    6.08347936392254,0.513854020607997,6.35,
    6.10167106497218,0.883446882265041,6.31,
    6.11160601609891,0.519613607139578,6.41,
    6.13147591835239,0.420677679235555,6.36,
    6.14899633892048,0.493016728593909,6.49,
    6.16457004609213,0.43233744826624,6.6,
    6.15805862542122,-0.712191297549908,6.47,
    6.11516380265106,-1.37055858022304,6.33,
    6.12717972327055,1.08145933404061,6.53,
    6.1492648511131,-0.179541050525294,6.34,
    6.1178489245772,0.788263412252806,6.43,
    6.17088008261857,0.793930884184976,6.48,
    6.12093681479227,1.3142183823413,6.38,
    6.10751120516154,0.787793142982129,6.5,
    6.1622876924549,-0.563600752426647,6.37,
    6.14107522923836,0.60725822441056,6.32,
    6.16013959491399,0.84440483652529,6.32,
    6.12785100375209,1.08158053746089,6.45,
    6.15510499130246,1.08582265717059,6.39,
    6.19115275316096,0.464412721408447,6.62,
    6.17175274724456,0.363527842506363,6.29,
    6.16457004609213,0.00508569551483903,6.31,
    6.18551399711606,0.567779846357811,6.69,
    6.17309530820764,0.71755333686298,6.72,
    6.14886208282418,-1.14177500410745,6.45,
    6.15906554614353,0.0195913208536363,6.25,
    6.14449875969419,-0.601362890048268,6.32,
    6.15054028402802,-0.184137084222213,6.37,
    6.14899633892048,-0.759257009712022,6.43,
    6.15544063154323,0.402259607490204,6.35,
    6.19101849706465,-0.0605144436760923,6.25,
    6.15812575346938,-0.0996873891097428,6.39,
    6.19893960674678,-0.0682908551210892,6.49,
    6.21317075295535,-0.360071120960052,6.29,
    6.21451331391843,0.495736533344934,6.41,
    6.23398044788298,-0.0159552182453148,6.38,
    6.19403925923157,0.610036206803318,6.65,
    6.22270293579317,0.786411423990967,6.24,
    6.19115275316096,-1.10497764571123,7.4,
    6.21719843584457,-0.114066962891452,6.39,
    6.2491513867657,0.428672256837052,6.45,
    6.21941366143364,0.574286045958301,6.35,
    6.1900787043905,-0.525853159215458,6.52,
    6.2362628015202,0.293661342921668,6.26,
    6.26150294762596,0.806337266284569,6.58,
    6.19967801527647,0.657160096607165,6.53,
    6.25042681968062,0.640899445742751,6.23,
    6.20968009445136,-0.416081645538637,6.6,
    6.23639705761651,0.864151297756881,6.26,
    6.27345174019731,0.999375529691953,6.24,
    6.22451539309331,0.785257567429926,6.57,
    6.23257075887175,1.12600886319776,6.56,
    6.24693616117663,1.07650938635648,6.4,
    6.27546558164192,-0.256834895704588,6.36,
    6.27821783161622,0.973888874476025,6.51,
    6.22370985651547,-0.694946474912842,6.31,
    6.25774377692936,-1.1799443852212,6.89,
    6.29701368509923,0.0386444985212411,6.46,
    6.28318530717959,1.13230659291538,6.41,
    6.30318946552937,1.04682909279895,6.34,
    6.25129948430661,1.02909945648078,6.33,
    6.27761367918284,-0.246770163684754,6.24,
    6.29520122779909,-1.06745306679335,6.59,
    6.30177977651814,-0.430548485782946,6.42,
    6.26949118535625,0.90096804870034,6.44,
    6.32124691048269,1.35436580327398,6.55,
    6.28197700231282,1.31850413528231,6.39,
    6.25908633789243,0.0364870776403037,6.28,
    6.2805673133016,-0.414879307609485,6.24,
    6.28573617300942,-0.470501981243182,6.35,
    6.27184066704162,0.123414170663243,6.21,
    6.28365520351666,-0.525620448648526,6.83,
    6.29224759368033,0.453000207355128,6.54,
    6.30587458745551,-0.406012065381992,6.31,
    6.30292095333675,1.45195879728133,6.59,
    6.28123859378313,-0.442901538377617,6.26,
    6.31507113005256,1.04760964282554,6.47,
    6.30292095333675,-0.247007722388497,6.26,
    6.34051266030279,0.56516670061663,6.52,
    6.33688774570249,0.81006063535549,6.54,
    6.31802476417132,0.588602593961465,6.58,
    6.31802476417132,0.588602593961465,6.58,
    0.0257771704909932,-0.762873719773099,6.29,
    0.0320872070174342,0.469813545816007,6.46,
    0.0586699140862709,0.789819664169167,6.38,
    0.0302747497172863,0.872344648967632,6.22,
    0.063167493312564,0.739447522701887,6.25,
    0.0185273412904013,-0.232545730281,7.1,
    0.0412166215663276,0.15632817147377,6.32,
    0.0860581577329512,-0.348261059688224,6.25,
    0.0234276888056162,-0.416343444926436,6.44,
    0.0475937861409223,1.11076147292687,6.24,
    0.0827688833734234,1.16434792909991,6.29,
    0.0447072800703163,-0.501457334782026,6.4,
    0.0586699140862709,-1.24096788326246,7.31,
    0.0926367064520067,0.465110853109244,6.25};

}
}

#endif // MAPENGINE_OSS_STARDATA_
