/* -*-c++-*-
mapengine_oss

Copyright (C) 1998-2006 Robert Osfield
Copyright (C) 2015 Robert Bosch Car Multimedia GmbH

This library is open source and may be redistributed and/or modified under
the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
(at your option) any later version.  The full license is in LICENSE file
included with this distribution, and on the openscenegraph.org website.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
OpenSceneGraph Public License for more details.

History:
- Copied from https://github.com/openscenegraph/osg/blob/OpenSceneGraph-3.2.0/include/osg/Stats
- Some additional APIs are provided to enable storing and accessing of dynamically changing strings as stats for debugging purposes.
*/

#ifndef MAPENGINE_OSS_CUSTOMSTATS_
#define MAPENGINE_OSS_CUSTOMSTATS_ 1

#include <osg/Stats>
#include <osg/Notify>
#include "oss/Export.h"

const int noOfFrames = 25;

namespace mapengine {
namespace oss {

/**
* Class that contains utility functions for displaying enums as stats
*/

class MAPENGINE_OSS_EXPORT me_CustomStats :  public osg::Stats
{
public: 

   me_CustomStats(const std::string& name);

   /**  
   * Used to set the current value for stats which are enums (represented as strings)  
   * @param[in] frameNumber The current frame number
   * @param[in] attributeName The string which was registered as the one that will be used for setting the stats (has to be exactly same at both places)
   * @param[in] value The current value for the stats
   * @return return whether setCustomAttribute was successful or not
   */
   bool setCustomAttribute(unsigned int frameNumber, const std::string& attributeName, const std::string& value);
   
   /**  
   * Used to get the current value for stats which are enums (represented as strings)  
   * @param[in] frameNumber The current frame number
   * @param[in] attributeName The string which was registered as the one that will be used for setting the stats (has to be exactly same at both places)
   * @param[in] value The current value for the stats
   * @return return whether getCustomAttribute was successful or not
   */
   inline bool getCustomAttribute(unsigned int frameNumber, const std::string& attributeName, std::string& value) const
   {
      OpenThreads::ScopedLock<OpenThreads::Mutex> lock(_mutex);
      return getCustomAttributeNoMutex(frameNumber, attributeName, value);
   }

protected:

   typedef std::map<std::string,std::string> CustomAttributeMap;

   typedef std::vector<CustomAttributeMap> CustomAttributeMapList;

   CustomAttributeMapList  _customAttributeMapList;


   virtual ~me_CustomStats(){}

   /**  
   * Used to get the current value for stats which are enums (represented as strings)
   * called form within getCustomAttribute
   * @param[in] frameNumber The current frame number
   * @param[in] attributeName The string which was registered as the one that will be used for setting the stats (has to be exactly same at both places)
   * @param[in] value The current value for the stats
   * @return return whether getCustomAttributeNoMutex was successful or not 
   */
   bool getCustomAttributeNoMutex(unsigned int frameNumber, const std::string& attributeName, std::string& value) const;
   
   /**  
   * Used to set the  number of frames for which the stats have to be stored 
   * @param[in] numberOfFrames The number of frames for which the stats value is stored   
   */
   void customAllocate(unsigned int numberOfFrames);
   
};
}
}
#endif 
