/* -*-c++-*-
mapengine_oss

Copyright (C) 1998-2006 Robert Osfield
Copyright (C) 2015 Robert Bosch Car Multimedia GmbH

This library is open source and may be redistributed and/or modified under
the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
(at your option) any later version.  The full license is in LICENSE file
included with this distribution, and on the openscenegraph.org website.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
OpenSceneGraph Public License for more details.

History:
Copied from https://github.com/openscenegraph/osg/blob/OpenSceneGraph-3.2.0/include/osgTerrain/GeometryTechnique
List of changes:
1. Modified terrain technique to use morphing between detail levels
*/

#ifndef MAPENGINE_OSS_MORPHTERRAINTECHNIQUE_
#define MAPENGINE_OSS_MORPHTERRAINTECHNIQUE_ 1

#include <osgTerrain/Layer>
#include <osgTerrain/GeometryTechnique>
#include "oss/Export.h"

namespace mapengine {
namespace oss {

/**
* Technique for creating the geometry for the given tile
*/
class MAPENGINE_OSS_EXPORT me_MorphTerrainTechnique : public osgTerrain::GeometryTechnique
{
public:
   me_MorphTerrainTechnique();

protected:
   virtual ~me_MorphTerrainTechnique(){}

private:
   virtual void generateGeometry(BufferData& buffer, osgTerrain::Locator* masterLocator, const osg::Vec3d& centerModel);
   virtual void applyColorLayers(BufferData& buffer);

   static osg::ref_ptr<osg::DrawElements> _drawElements;

};

class MAPENGINE_OSS_EXPORT me_MorphTerrainTechniqueVNG
{
public:
   me_MorphTerrainTechniqueVNG(osgTerrain::Locator* masterLocator, const osg::Vec3d& centerModel, int numRows, int numColmns, float scaleHeight);
   ~me_MorphTerrainTechniqueVNG();
   void populateCenter(osgTerrain::Layer* elevationLayer);

   unsigned int capacity() const { return static_cast<unsigned int>(_vertices->capacity()); }

   inline void setVertex(int c, int r, const osg::Vec3d& v, const osg::Vec2d& t, const osg::Vec3d& up);
   inline int& index(int c, int r) { return _indices[(r+1)*(_numColumns+2)+c+1]; }
   inline int index(int c, int r) const { return _indices[(r+1)*(_numColumns+2)+c+1]; }
   inline bool vertex(int c, int r, osg::Vec3& v) const;
   inline int vertex_index(int c, int r) const { int i = _indices[(r+1)*(_numColumns+2)+c+1]; return i-1; }

   void computeNormals() const;
   inline bool computeNormal(int c, int r, osg::Vec3& n) const;
   inline bool computeNormalWithNoDiagonals(int c, int r, osg::Vec3& n) const;
   inline bool computeNormalWithDiagonals(int c, int r, osg::Vec3& n) const;

   osgTerrain::Locator*            _masterLocator;
   const osg::Vec3d                _centerModel;
   int                             _numRows;
   int                             _numColumns;
   float                           _scaleHeight;

   typedef std::vector<int>        Indices;
   Indices                         _indices;

   osg::ref_ptr<osg::Vec3Array>    _vertices;
   osg::ref_ptr<osg::Vec3Array>    _normals;
   osg::ref_ptr<osg::Vec2Array>    _texcoords;
   osg::ref_ptr<osg::Vec3Array>    _ups;
   osg::ref_ptr<osg::Vec3Array>    _verticesMorph;
   osg::ref_ptr<osg::Vec3Array>    _normalsMorph;
   osg::ref_ptr<osg::Vec2Array>    _texcoordsMorph;
   osg::ref_ptr<osg::Vec3Array>    _upsMorph;
};
}
}

#endif // MAPENGINE_OSS_MORPHTERRAINTECHNIQUE_
