/* -*-c++-*-
mapengine_oss

Copyright (C) 1998-2006 Robert Osfield
Copyright (C) 2015 Robert Bosch Car Multimedia GmbH

This library is open source and may be redistributed and/or modified under
the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
(at your option) any later version.  The full license is in LICENSE file
included with this distribution, and on the openscenegraph.org website.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
OpenSceneGraph Public License for more details.

History:
Copied from https://github.com/openscenegraph/osg/blob/OpenSceneGraph-3.2.0/src/osgPlugins/normals/Normals.h
List of changes:
1. Fixed crash with handling triangle-strips
*/

#ifndef NORMALS_DEF
#define NORMALS_DEF

//#define DEBUG 1
#ifdef DEBUG
#include  <iostream>
#endif

#include <stack>

#include <osg/Geode>
#include <osg/Geometry>
#include <osg/NodeVisitor>
#include <osg/MatrixTransform>
#include <osg/Version>

class Normals: public osg::Geode
{
public:
   enum Mode {
      SurfaceNormals,
      VertexNormals
   };

   Normals( osg::Node *node, float scale=1.0, Mode mode=SurfaceNormals, osg::Vec3d origin = osg::Vec3d() );

protected:
   virtual ~Normals(){}

private:
#if OSG_MIN_VERSION_REQUIRED(3,1,9)
   class MakeNormalsVisitor : public osg::NodeVisitor
   {
   public:
      MakeNormalsVisitor(float normalScale, Mode mode);

      void setMode( Mode mode ) { _mode = mode; }

      virtual void apply(osg::MatrixTransform& tx);

      virtual void apply( osg::Geode &geode );

      osg::Vec3Array *getCoords() { return _local_coords.get(); }

   protected:
      virtual ~MakeNormalsVisitor(){}

   private:
      osg::ref_ptr<osg::Vec3Array> _local_coords;
      float _normal_scale;
      Mode _mode;
      osg::Matrix _mat;
      std::stack<osg::Matrix> _matStack;


      void _processPrimitive(  unsigned int nv,
         osg::Vec3Array::iterator coords,
         osg::Vec3Array::iterator normals,
         osg::Array::Binding binding );

   };

#ifdef DEBUG
   static void _printPrimitiveType( osg::PrimitiveSet *pset );
#endif

#endif

};


class SurfaceNormals: public Normals
{
public:
   SurfaceNormals( osg::Node *node, float scale=1.0 ):
      Normals( node, scale, Normals::SurfaceNormals ) {}

   SurfaceNormals(const osg::Vec3d& origin, osg::Node *node, float scale = 1.0) :
      Normals(node, scale, Normals::SurfaceNormals, origin) {}

protected:
   virtual ~SurfaceNormals(){}
};

class VertexNormals: public Normals
{
public:
   VertexNormals( osg::Node *node, float scale=1.0 ):
      Normals( node, scale, Normals::VertexNormals ) {}

   VertexNormals(const osg::Vec3d& origin, osg::Node *node, float scale = 1.0) :
      Normals(node, scale, Normals::VertexNormals, origin) {}

protected:
   virtual ~VertexNormals(){}
};

#endif
