#ifndef TRC_STDTEXT_HEADER
#define TRC_STDTEXT_HEADER
/******************************************************************************

  FILE:           trc_stdtext.h
 
  PROJECT:        VASCO

  SW-COMPONENT:   general library

  DESCRIPTION:    default trace text
  
  AUTHOR:         CM-DI/ESA2 Frank Wiedemann

  COPYRIGHT:      (c) 2003 Blaupunkt Werke GmbH

  HISTORY:
  $Log:   //hi230124/projects/Vasco/swnavi/archives/components/trace/trc_stdtext.h-arc  $
 * 
 *    Rev 1.6   Jul 11 2003 13:34:20   Zombetzki
 * Bugfix: include protection and extern declaration
 * 
 *    Rev 1.5   Jul 01 2003 10:03:18   Stuebner
 * more strings
 * 
 *    Rev 1.4   Jun 24 2003 15:39:54   Pirklbauer
 * more string constants
 * 
 *    Rev 1.3   Jun 17 2003 14:10:46   Pirklbauer
 * 'Speech' and 'RouteGuidance' added
 * 
 *    Rev 1.2   Jun 17 2003 11:03:22   Pirklbauer
 * fcvd_voice added
 * 
 *    Rev 1.1   Jun 17 2003 09:42:44   Pirklbauer
 * some new trace textes
 * 
 *    Rev 1.0   Jun 13 2003 09:23:24   Wiedemann
 * Initial revision.

  Date     | Rev. | Author                | Modification
  ----------------------------------------------------------------------------
  12.06.03 | 1.0  | CM-DI/ESA2-Wiedmann   | Initial revision

******************************************************************************/

// general
extern const tChar trc_txtEnter[];
extern const tChar trc_txtLeave[];
extern const tChar trc_txtStarted[];
extern const tChar trc_txtFinished[];
extern const tChar trc_txtFailed[];
extern const tChar trc_txtStopped[];
extern const tChar trc_txtExceeded[];
extern const tChar trc_txtInit[];
extern const tChar trc_txtFree[];
extern const tChar trc_txtDelete[];
extern const tChar trc_txtShutDown[];
extern const tChar trc_txtProcess[];
extern const tChar trc_txtDatasetID[];
extern const tChar trc_txtParanthesis[];
extern const tChar trc_txtCreate[];
extern const tChar trc_txtFCVD_Voice[];
extern const tChar trc_txtSpeech[];
extern const tChar trc_txtRouteGuidance[];
extern const tChar trc_txtGenerating[];
extern const tChar trc_txtForwardingOf[];
extern const tChar trc_txtSpace[];
extern const tChar trc_txtOn[];
extern const tChar trc_txtOf[];
extern const tChar trc_txtFrom[];
extern const tChar trc_txtTo[];
extern const tChar trc_txtEqualSign[];
extern const tChar trc_txtNo[];
extern const tChar trc_txtPushBack[];
extern const tChar trc_txtMemoryAllocation[];
extern const tChar trc_txtInvalid[];
extern const tChar trc_txtTripHandle[];
extern const tChar trc_txtTripSegment[];
extern const tChar trc_txtTripDefinition[];
extern const tChar trc_txtDestination[];
extern const tChar trc_txtDescription[];
extern const tChar trc_txtVehicle[];
extern const tChar trc_txtPosition[];
extern const tChar trc_txtRoute[];
extern const tChar trc_txtOption[];
extern const tChar trc_txtAvailable[];
extern const tChar trc_txtLocation[];
extern const tChar trc_txtChannel[];

// message-handling, service register 
extern const tChar trc_txtOpenFailed[];
extern const tChar trc_txtCloseFailed[];
extern const tChar trc_txtOpened[];
extern const tChar trc_txtClosed[];
extern const tChar trc_txtServiceAvailable[];
extern const tChar trc_txtServiceUnavailable[];
extern const tChar trc_txtMsgSendFailed[];
extern const tChar trc_txtMsgSent[];
extern const tChar trc_txtSend[];
extern const tChar trc_txtMsgReceived[];
extern const tChar trc_txtPropRegistered[];
extern const tChar trc_txtPropUnRegistered[];
extern const tChar trc_txtUpReg[];
extern const tChar trc_txtRelUpReg[];
extern const tChar trc_txtMethodStart[];
extern const tChar trc_txtMethodAbort[];
extern const tChar trc_txtMethodResult[];
extern const tChar trc_txtSet[];
extern const tChar trc_txtGet[];
extern const tChar trc_txtStatus[];
extern const tChar trc_txtError[];
extern const tChar trc_txtAbort[];
extern const tChar trc_txtServiceDataMsg[];
extern const tChar trc_txtVisitorMsg[];
extern const tChar trc_txtProperty[];

// State-Machines
extern const tChar trc_txtStateChart[];
extern const tChar trc_txtState[];
extern const tChar trc_txtTransition[];
extern const tChar trc_txtGuard[];
extern const tChar trc_txtEvent[];
extern const tChar trc_txtSignal[];

// errors
extern const tChar trc_txtInvalidValue[];
extern const tChar trc_txtInvalidHandle[];
extern const tChar trc_txtAccessFailed[];
extern const tChar trc_txtMsgAccessFailed[];
extern const tChar trc_txtNullPointer[];
extern const tChar trc_txtExceptionCaught[];
extern const tChar trc_txtUnhandledException[];
extern const tChar trc_txtNotInitialized[];
extern const tChar trc_txtAllocationFailed[];
extern const tChar trc_txtCreationFailed[];
extern const tChar trc_txtTimeout[];
extern const tChar trc_txtDeleteFailed[];
extern const tChar trc_txtOutOfMemory[];
extern const tChar trc_txtOutOfRange[];

//#define OSAL_S_IMPORT_INTERFACE_GENERIC
//#include "osal_if.h"

// Macros
tCString trc_szGetFileName(tCString szFilePathName);

#if (OSAL_OS==OSAL_NUCLEUS)
   #define TRC_M_FILE __MODULE__
   #define TRC_M_LINE __LINE__
#else
   #define TRC_M_FILE trc_szGetFileName(__FILE__)
   #define TRC_M_LINE __LINE__
#endif


#endif
