 /******************************************************************************

  FILE:           trc_mfkt.cpp

  PROJECT:        VASCO

  SW-COMPONENT:   general library

  DESCRIPTION:    main functions of trace

  AUTHOR:         CM-DI/ESA2 Mathias Schubert

  COPYRIGHT:      (c) 2002 Blaupunkt Werke GmbH

  HISTORY:
  $Log:   //hi230124/projects/Vasco/swnavi/archives/components/trace/trc_mfkt.cpp-arc  $
 * 
 *    Rev 1.19   May 28 2004 14:01:26   Wiedemann
 * Bugfix for traces longer than 255 characters
 * 
 *    Rev 1.18   Aug 15 2003 08:59:18   Zombetzki
 * ARM-Compiler warnings reduced
 * 
 *    Rev 1.17   Jul 11 2003 13:33:32   Zombetzki
 * - new methods for trace for each level
 * 
 *    Rev 1.16   Jun 13 2003 09:22:32   Wiedemann
 * correction of osal inclusion and function GetFileName moved to trc_stdtest.cpp
 * 
 *    Rev 1.15   May 26 2003 13:52:18   Wiedemann
 * changes for global trace for rtf stream
 * 
 *    Rev 1.14   May 22 2003 10:57:32   Wiedemann
 * adding class hierarchy for trace objects and added global trace class
 * 
 *    Rev 1.13   May 07 2003 10:51:12   Wiedemann
 * test for invalid file handle for method bIsTraceActive added
 * 
 *    Rev 1.12   Apr 16 2003 14:52:02   Wiedemann
 * bugfix: Validation of bIsTraceActive
 * 
 *    Rev 1.11   Jan 24 2003 10:14:52   Wiedemann
 * Type changes
 * 
 *    Rev 1.10   12 Jun 2002 09:58:16   UNM2HI
 * bugfix
 * 
 *    Rev 1.9   03 Jun 2002 17:15:56   UNM2HI
 * tU16 -> tU32
 * 
 *    Rev 1.8   27 May 2002 14:52:18   SUM2HI
 * vTrace fuer Streaming Objekte implementiert
 * 
 *    Rev 1.7   27 May 2002 14:30:32   SUM2HI
 * vTrace fuer dinokonforme Traces entfernt
 * Input Channel Faehigkeit entfernt
 *
 *    Rev 1.6   24 May 2002 15:41:22   SUM2HI
 * same little changes
 * LineNumber and FileName at  vTrace added.
 *
 *    Rev 1.5   10 May 2002 10:46:24   IR62HI
 * auskommentiert
 *
 *    Rev 1.4   07 May 2002 15:13:52   SUM2HI
 * vTripTrace added
 *
 *    Rev 1.3   26 Apr 2002 15:29:42   SUM2HI
 * Bugfix Stringbehandlung
 * Bugfix Ueberladen vTrace
 *
 *    Rev 1.2   24 Apr 2002 14:35:56   SUM2HI
 * Fehlerkorrektur Memoryanforderung und Freigabe
 *
 *    Rev 1.1   24 Apr 2002 09:45:24   SUM2HI
 * Anpassung an Gesamtsystemkonzept Debug und Trace

  Date     | Rev. | Author                | Modification
  ----------------------------------------------------------------------------
  20.02.02 | 1.0  | CM-DI/ESA2-Schubert   | Initial revision
  24-09-12 | 2.2  | CM-AI/PJ-CB36 Hessling | Adding ETG_I functions

******************************************************************************/

/**************************************************************************/
/* includes                                                               */
/**************************************************************************/


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define TRACE_S_IMPORT_INTERFACE_GENERIC
#include "trace_if.h"

#include "trc_def.h"

#include "trc_cl.h"
#include "trc_stdtext.h"


/**************************************************************************/
/* status functions                                                       */
/**************************************************************************/

tBool trc_tclTraceBase::bIsTraceActive(TR_tenTraceClass enTraceClass,TR_tenTraceLevel enTraceLevel) const
{  
   tBool bReturnValue = FALSE;
   tS32 s32Error = OSAL_ERROR;
   OSAL_trIOCtrlActivTrace rtrIOCtrlActivTrace;

   rtrIOCtrlActivTrace.enTraceClass = enTraceClass;
   rtrIOCtrlActivTrace.enTraceLevel = enTraceLevel;
   rtrIOCtrlActivTrace.bIsActive = FALSE;

   if ((OSAL_ERROR != hGetTraceDevice()))
   {
      s32Error = OSAL_s32IOControl(hGetTraceDevice(), OSAL_C_S32_IOCTRL_ISACTIVE, (intptr_t)&rtrIOCtrlActivTrace);
      if ((OSAL_OK == s32Error)&&(TRUE == rtrIOCtrlActivTrace.bIsActive))
      {
         bReturnValue = TRUE;
      }
   }

   return bReturnValue;
}


/**************************************************************************/
/* Output functions                                                       */
/**************************************************************************/


tVoid trc_tclTraceBase::vTraceOutput(TR_tenTraceClass enTraceClass, TR_tenTraceLevel enTraceLevel,
                                     tU32 u32Linenumber, tCString coszFilename, tCString coszFormat, va_list argList) const
{
   tChar szBuffer[MAX_TRACE_SIZE]={0};       //Stringbuffer
   tChar* pzBuffer = &szBuffer[0];
   tU32  u32StringLength;
   // Formatierung
   if(coszFilename != NULL)
   {
      OSAL_s32PrintFormat(pzBuffer, "%s(%u) ",trc_szGetFileName(coszFilename),u32Linenumber);
   }

   u32StringLength = OSAL_u32StringLength(szBuffer);
   pzBuffer = pzBuffer + u32StringLength;
   OSAL_s32VarNPrintFormat(pzBuffer,(MAX_TRACE_SIZE-u32StringLength)-1, coszFormat, argList);

   // set string end 
   szBuffer[MAX_TRACE_SIZE-1] = 0;
   
   // Ausgabe ins Trace-Device
   if ((OSAL_ERROR != hGetTraceDevice()))
   {
      u32StringLength = OSAL_u32StringLength(szBuffer);
      vBinTrace(enTraceClass, enTraceLevel, (tPCS8)szBuffer, u32StringLength);
   }
}

// Comment out Symbol 'argList' not initialized is done in function OSAL_VarArgStart
//lint -save -e530

tVoid trc_tclTraceBase::vTrace(TR_tenTraceClass enTraceClass, TR_tenTraceLevel enTraceLevel,
                                 tU32 u32Linenumber, tCString coszFilename,tCString coszFormat,...) const
{
   if(TRUE == bIsTraceActive(enTraceClass, enTraceLevel))
   {
      va_list argList;
     //Ausgabe
      OSAL_VarArgStart(argList, coszFormat); //lint !e1773 !e416 hem2hi unchanged varg
      vTraceOutput(enTraceClass, enTraceLevel, u32Linenumber,coszFilename, coszFormat, argList); 
      OSAL_VarArgEnd(argList);
   }
}

tVoid trc_tclTraceBase::vTrace(TR_tenTraceClass enTraceClass, TR_tenTraceLevel enTraceLevel,tPCS8 pcos8Data,tU32 u32Length) const
{
   if(TRUE == bIsTraceActive(enTraceClass, enTraceLevel))
   {
      vBinTrace(enTraceClass, enTraceLevel, pcos8Data, u32Length);
   }
}

tVoid trc_tclTraceBase::vBinTrace(TR_tenTraceClass enTraceClass, TR_tenTraceLevel enTraceLevel,tPCS8 pcos8Data,tU32 u32Length) const
{
   OSALUTIL_s32TraceWrite(hGetTraceDevice(), (tU32)enTraceLevel, (tU32)enTraceClass, pcos8Data, u32Length);
}




/***********************************************************/
/*constructor                                              */
/***********************************************************/

trc_tclTraceData::trc_tclTraceData()
{
   hTraceDevice = OSAL_ERROR;

   // open trace device
   hTraceDevice = OSAL_IOOpen(OSAL_C_STRING_DEVICE_TRACE,OSAL_EN_WRITEONLY);
}



/***********************************************************/
/*destructor                                               */
/***********************************************************/

trc_tclTraceData::~trc_tclTraceData()
{
   if(OSAL_ERROR != hTraceDevice)
   {
      OSAL_s32IOClose(hTraceDevice);
   }
}


OSAL_tIODescriptor trc_tclGlobalTrace::hTheGlobalTrace = OSAL_ERROR;
trc_tclGlobalTrace trc_tclGlobalTrace::oTheGlobalTraceObject;
trc_tclGlobalTrace::trIOCtrlLaunchChannel trc_tclGlobalTrace::m_ClientList[trc_tclGlobalTrace::TRC_GLOBALTRACE_MAX_CLIENTS];
tU16 trc_tclGlobalTrace::m_u16MaxClientIdx = 0;

tS32  trc_tclGlobalTrace::s32Init()
{
   tS32 s32Ret = OSAL_OK;

   if(hTheGlobalTrace == OSAL_ERROR)
   {
      hTheGlobalTrace = OSAL_IOOpen(OSAL_C_STRING_DEVICE_TRACE,OSAL_EN_READWRITE);
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      ETG_pfvDoTrace = (&trc_tclGlobalTrace::vBinTraceEtg);
      ETG_pfbIsTraceActive = (&trc_tclGlobalTrace::bIsTraceActiveEtg);
      ETG_pfvDoErrMemTrace = (&trc_tclGlobalTrace::vDoTraceErrmemEtg);
      ETG_pfs32RegTraceCallback = (&trc_tclGlobalTrace::s32RegTraceCallbackEtg);
      ETG_pfs32UnregTraceCallback = (&trc_tclGlobalTrace::s32UnregTraceCallbackEtg);
      etg_vSetTraceDevice(hTheGlobalTrace);
      #endif

      if(hTheGlobalTrace == OSAL_ERROR)
      {
         s32Ret = OSAL_ERROR;
         #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
         etg_vSetTraceDevice(0);
         #endif
      }
   }

   return s32Ret;
}

tVoid trc_tclGlobalTrace::vFree()
{
   if(hTheGlobalTrace != OSAL_ERROR)
   {
      OSAL_s32IOClose(hTheGlobalTrace);
      hTheGlobalTrace = OSAL_ERROR;
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      etg_vSetTraceDevice(0);
      #endif
   }
}


OSAL_tIODescriptor trc_tclGlobalTrace::hGetTraceDevice() const 
{
   return hTheGlobalTrace;
}


//-- trace pure data
tVoid trc_tclGlobalTrace::vTracePure(TR_tenTraceClass enTraceClass, TR_tenTraceLevel enTraceLevel,
                                     tU32 u32Linenumber, tCString coszFilename,tCString coszFormat,va_list argList) const
{
   if(TRUE == bIsTraceActive(enTraceClass, enTraceLevel))
   {
      trc_tclTraceBase::vTraceOutput(enTraceClass, enTraceLevel, u32Linenumber,coszFilename, coszFormat, argList);
   }
}

etg_tBool trc_tclGlobalTrace::bIsTraceActiveEtg(etg_tU16 u16TraceClass,etg_tU16 enTraceLevel)
{  
   etg_tBool bReturnValue = FALSE;
   tS32 s32Error = OSAL_ERROR;
   OSAL_trIOCtrlActivTrace rtrIOCtrlActivTrace;

   rtrIOCtrlActivTrace.enTraceClass = (TR_tenTraceClass)u16TraceClass;
   rtrIOCtrlActivTrace.enTraceLevel = (TR_tenTraceLevel)enTraceLevel;
   rtrIOCtrlActivTrace.bIsActive = FALSE;

   if ((OSAL_ERROR != hTheGlobalTrace))
   {
      s32Error = OSAL_s32IOControl(hTheGlobalTrace, OSAL_C_S32_IOCTRL_ISACTIVE, (intptr_t)&rtrIOCtrlActivTrace);
      if ((OSAL_OK == s32Error)&&(TRUE == rtrIOCtrlActivTrace.bIsActive))
      {
         bReturnValue = TRUE;
      }
   }

   return bReturnValue;
}

etg_tVoid trc_tclGlobalTrace::vBinTraceEtg(etg_tU16 u16TraceClass, etg_tU16 enTraceLevel, const etg_tS8* pcos8Buffer, etg_tU32 u32Length) {
   OSALUTIL_s32TraceWrite(hTheGlobalTrace, (tU32)enTraceLevel, (tU32)u16TraceClass, pcos8Buffer, u32Length);
}


//-- add thread id and name to outputdata
tVoid trc_tclGlobalTrace::vTraceOutput(TR_tenTraceClass enTraceClass, 
                                       TR_tenTraceLevel enTraceLevel,
                                       tU32 u32Linenumber, 
                                       tCString coszFilename,
                                       tCString coszFormat, 
                                       va_list argList) const
{
   tChar szBuffer[MAX_TRACE_SIZE];        //Stringbuffer
   tChar const* szThreadName = "unknown";
   OSAL_trThreadControlBlock rTcb;
   OSAL_tThreadID TID = OSAL_ThreadWhoAmI();
   
   if(OSAL_s32ThreadControlBlock(TID, &rTcb) == OSAL_OK)
   {
      szThreadName = rTcb.szName;
   }
   
   szBuffer[0] = 0;
   OSALUTIL_s32NPrintFormat((tS8*)szBuffer, MAX_TRACE_SIZE - 1, "[%s %d]: %s", szThreadName, TID, coszFormat);
   szBuffer[MAX_TRACE_SIZE -1] = 0;
   

   trc_tclTraceBase::vTraceOutput(enTraceClass, enTraceLevel, u32Linenumber, coszFilename, szBuffer, argList);
}

etg_tVoid trc_tclGlobalTrace::vDoTraceErrmemEtg(etg_tU16 u16Entry, etg_tInt eEntryType, etg_tU16 u16EntryLength, const etg_tU8* pcou8Buffer) 
{
   OSAL_tIODescriptor fd_errmem;
   trErrmemEntry  rErrmemEntry = {0};

   fd_errmem = OSAL_IOOpen(OSAL_C_STRING_DEVICE_ERRMEM, OSAL_EN_WRITEONLY);

   if(fd_errmem != OSAL_ERROR)
   {
      rErrmemEntry.u16Entry = u16Entry;
      rErrmemEntry.eEntryType = (tenErrmemEntryType)eEntryType;
      rErrmemEntry.u16EntryCount = 1;
      rErrmemEntry.u16EntryLength = u16EntryLength;

      (tVoid) OSAL_s32ClockGetTime(&rErrmemEntry.rEntryTime);
      if(rErrmemEntry.u16EntryLength > ERRMEM_MAX_ENTRY_LENGTH) {
         // ensure no memory writer
         rErrmemEntry.u16EntryLength = ERRMEM_MAX_ENTRY_LENGTH;
      }
      (tVoid) OSAL_pvMemoryCopy(rErrmemEntry.au8EntryData, pcou8Buffer, rErrmemEntry.u16EntryLength);

      (tVoid) OSAL_s32IOWrite( fd_errmem, (tPCS8)&rErrmemEntry, sizeof(rErrmemEntry));

      (tVoid) OSAL_s32IOClose(fd_errmem);
   }
}

tS32 trc_tclGlobalTrace::s32RegTraceCallback(TR_tenTraceChan eChanId, OSAL_tpfCallback pfvCb) 
{
    OSAL_trIOCtrlLaunchChannel oTraceChannel;
    oTraceChannel.enTraceChannel = eChanId;
    oTraceChannel.pCallback = pfvCb;
    return OSAL_s32IOControl( hTheGlobalTrace , OSAL_C_S32_IOCTRL_CALLBACK_REG, (intptr_t) &oTraceChannel);
}

etg_tS32 trc_tclGlobalTrace::s32RegTraceCallbackEtg(etg_tU16 eChanId, ETG_tpfCallback pfvCb)
{
    OSAL_trIOCtrlLaunchChannel oTraceChannel;
    oTraceChannel.enTraceChannel = (TR_tenTraceChan)eChanId;
    oTraceChannel.pCallback = (OSAL_tpfCallback)pfvCb;
    return OSAL_s32IOControl( hTheGlobalTrace , OSAL_C_S32_IOCTRL_CALLBACK_REG, (intptr_t) &oTraceChannel);
}

tS32 trc_tclGlobalTrace::s32UnregTraceCallback(TR_tenTraceChan eChanId, OSAL_tpfCallback pfvCb)
{
    OSAL_trIOCtrlLaunchChannel oTraceChannel;
    oTraceChannel.enTraceChannel = eChanId;
    oTraceChannel.pCallback = pfvCb;
    return OSAL_s32IOControl( hTheGlobalTrace , OSAL_C_S32_IOCTRL_CALLBACK_UNREG, (intptr_t) &oTraceChannel);
}

etg_tS32 trc_tclGlobalTrace::s32UnregTraceCallbackEtg(etg_tU16 eChanId, ETG_tpfCallback pfvCb)
{
    OSAL_trIOCtrlLaunchChannel oTraceChannel;
    oTraceChannel.enTraceChannel = (TR_tenTraceChan)eChanId;
    oTraceChannel.pCallback = (OSAL_tpfCallback)pfvCb;
    return OSAL_s32IOControl( hTheGlobalTrace , OSAL_C_S32_IOCTRL_CALLBACK_UNREG, (intptr_t) &oTraceChannel);
}

/******************************************************************************

  FUNCTIONS:      trc_tclGlobalTrace::vTraceLevelX()
                                                 |
                                               Level
  DESCRIPTION:   
   This methods traces the given parameters on specific level. 

  PARAMETER:     
     TR_tenTraceClass enClass              traceclass
     tU32             u32Line              line (TRC_M_LINE)
     tCString         coszFile             specific file (TRC_M_FILE)
     tCString         coszFormat           formatstring
     ...                                   list of parameters
     
  RETURNVALUE:   none

 .MEMBER_STATUS
  public static 

  ERRORS:        

  HISTORY:

  Date     | Rev. | Author                | Modification
  ----------------------------------------------------------------------------
  10.07.03 | 1.0  | CM-DI/ESA2-Zombetzki  | Initial revision
******************************************************************************/

tVoid trc_tclGlobalTrace::vTraceLevel0(TR_tenTraceClass enTraceClass, tU32 u32Linenumber, tCString coszFilename,tCString coszFormat,...)
{
   va_list argList;

   OSAL_VarArgStart(argList, coszFormat); //lint !e1773 !e416 hem2hi unchanged varg
   trc_tclGlobalTrace::rfoGetTraceObject().vTracePure(enTraceClass, TR_tenTraceLevel(0), u32Linenumber,coszFilename, coszFormat, argList); 
   OSAL_VarArgEnd(argList);
}

tVoid trc_tclGlobalTrace::vTraceLevel1(TR_tenTraceClass enTraceClass, tU32 u32Linenumber, tCString coszFilename,tCString coszFormat,...)
{
   va_list argList;

   OSAL_VarArgStart(argList, coszFormat); //lint !e1773 !e416 hem2hi unchanged varg
   trc_tclGlobalTrace::rfoGetTraceObject().vTracePure(enTraceClass, TR_tenTraceLevel(1), u32Linenumber,coszFilename, coszFormat, argList); 
   OSAL_VarArgEnd(argList);
}

tVoid trc_tclGlobalTrace::vTraceLevel2(TR_tenTraceClass enTraceClass, tU32 u32Linenumber, tCString coszFilename,tCString coszFormat,...)
{
   va_list argList;

   OSAL_VarArgStart(argList, coszFormat); //lint !e1773 !e416 hem2hi unchanged varg
   trc_tclGlobalTrace::rfoGetTraceObject().vTracePure(enTraceClass, TR_tenTraceLevel(2), u32Linenumber,coszFilename, coszFormat, argList); 
   OSAL_VarArgEnd(argList);
}

tVoid trc_tclGlobalTrace::vTraceLevel3(TR_tenTraceClass enTraceClass, tU32 u32Linenumber, tCString coszFilename,tCString coszFormat,...)
{
   va_list argList;

   OSAL_VarArgStart(argList, coszFormat); //lint !e1773 !e416 hem2hi unchanged varg
   trc_tclGlobalTrace::rfoGetTraceObject().vTracePure(enTraceClass, TR_tenTraceLevel(3), u32Linenumber,coszFilename, coszFormat, argList); 
   OSAL_VarArgEnd(argList);
}

tVoid trc_tclGlobalTrace::vTraceLevel4(TR_tenTraceClass enTraceClass, tU32 u32Linenumber, tCString coszFilename,tCString coszFormat,...)
{
   va_list argList;

   OSAL_VarArgStart(argList, coszFormat); //lint !e1773 !e416 hem2hi unchanged varg
   trc_tclGlobalTrace::rfoGetTraceObject().vTracePure(enTraceClass, TR_tenTraceLevel(4), u32Linenumber,coszFilename, coszFormat, argList); 
   OSAL_VarArgEnd(argList);
}

tVoid trc_tclGlobalTrace::vTraceLevel5(TR_tenTraceClass enTraceClass, tU32 u32Linenumber, tCString coszFilename,tCString coszFormat,...)
{
   va_list argList;

   OSAL_VarArgStart(argList, coszFormat); //lint !e1773 !e416 hem2hi unchanged varg
   trc_tclGlobalTrace::rfoGetTraceObject().vTracePure(enTraceClass, TR_tenTraceLevel(5), u32Linenumber,coszFilename, coszFormat, argList); 
   OSAL_VarArgEnd(argList);
}

tVoid trc_tclGlobalTrace::vTraceLevel6(TR_tenTraceClass enTraceClass, tU32 u32Linenumber, tCString coszFilename,tCString coszFormat,...)
{
   va_list argList;

   OSAL_VarArgStart(argList, coszFormat); //lint !e1773 !e416 hem2hi unchanged varg
   trc_tclGlobalTrace::rfoGetTraceObject().vTracePure(enTraceClass, TR_tenTraceLevel(6), u32Linenumber,coszFilename, coszFormat, argList); 
   OSAL_VarArgEnd(argList);
}

tVoid trc_tclGlobalTrace::vTraceLevel7(TR_tenTraceClass enTraceClass, tU32 u32Linenumber, tCString coszFilename,tCString coszFormat,...)
{
   va_list argList;

   OSAL_VarArgStart(argList, coszFormat); //lint !e1773 !e416 hem2hi unchanged varg
   trc_tclGlobalTrace::rfoGetTraceObject().vTracePure(enTraceClass, TR_tenTraceLevel(7), u32Linenumber,coszFilename, coszFormat, argList); 
   OSAL_VarArgEnd(argList);
}

tVoid trc_tclGlobalTrace::vTraceLevel8(TR_tenTraceClass enTraceClass, tU32 u32Linenumber, tCString coszFilename,tCString coszFormat,...)
{
   va_list argList;

   OSAL_VarArgStart(argList, coszFormat); //lint !e1773 !e416 hem2hi unchanged varg

   trc_tclGlobalTrace::rfoGetTraceObject().vTracePure(enTraceClass, TR_tenTraceLevel(8), u32Linenumber,coszFilename, coszFormat, argList); 
   OSAL_VarArgEnd(argList);
}

tVoid trc_tclGlobalTrace::vLibTraceLevel0(TR_tenTraceClass enTraceClass, tU32 u32Linenumber, tCString coszFilename,tCString coszFormat,...)
{
   va_list argList;

   OSAL_VarArgStart(argList, coszFormat); //lint !e1773 !e416 hem2hi unchanged varg
   trc_tclGlobalTrace::rfoGetTraceObject().vTraceOutput(enTraceClass, TR_tenTraceLevel(0), u32Linenumber,coszFilename, coszFormat, argList); 
   OSAL_VarArgEnd(argList);
}

tVoid trc_tclGlobalTrace::vLibTraceLevel1(TR_tenTraceClass enTraceClass, tU32 u32Linenumber, tCString coszFilename,tCString coszFormat,...)
{
   va_list argList;

   OSAL_VarArgStart(argList, coszFormat); //lint !e1773 !e416 hem2hi unchanged varg
   trc_tclGlobalTrace::rfoGetTraceObject().vTraceOutput(enTraceClass, TR_tenTraceLevel(1), u32Linenumber,coszFilename, coszFormat, argList); 
   OSAL_VarArgEnd(argList);
}

tVoid trc_tclGlobalTrace::vLibTraceLevel2(TR_tenTraceClass enTraceClass, tU32 u32Linenumber, tCString coszFilename,tCString coszFormat,...)
{
   va_list argList;

   OSAL_VarArgStart(argList, coszFormat); //lint !e1773 !e416 hem2hi unchanged varg
   trc_tclGlobalTrace::rfoGetTraceObject().vTraceOutput(enTraceClass, TR_tenTraceLevel(2), u32Linenumber,coszFilename, coszFormat, argList); 
   OSAL_VarArgEnd(argList);
}

tVoid trc_tclGlobalTrace::vLibTraceLevel3(TR_tenTraceClass enTraceClass, tU32 u32Linenumber, tCString coszFilename,tCString coszFormat,...)
{
   va_list argList;

   OSAL_VarArgStart(argList, coszFormat); //lint !e1773 !e416 hem2hi unchanged varg
   trc_tclGlobalTrace::rfoGetTraceObject().vTraceOutput(enTraceClass, TR_tenTraceLevel(3), u32Linenumber,coszFilename, coszFormat, argList); 
   OSAL_VarArgEnd(argList);
}

tVoid trc_tclGlobalTrace::vLibTraceLevel4(TR_tenTraceClass enTraceClass, tU32 u32Linenumber, tCString coszFilename,tCString coszFormat,...)
{
   va_list argList;

   OSAL_VarArgStart(argList, coszFormat); //lint !e1773 !e416 hem2hi unchanged varg
   trc_tclGlobalTrace::rfoGetTraceObject().vTraceOutput(enTraceClass, TR_tenTraceLevel(4), u32Linenumber,coszFilename, coszFormat, argList); 
   OSAL_VarArgEnd(argList);
}

tVoid trc_tclGlobalTrace::vLibTraceLevel5(TR_tenTraceClass enTraceClass, tU32 u32Linenumber, tCString coszFilename,tCString coszFormat,...)
{
   va_list argList;

   OSAL_VarArgStart(argList, coszFormat); //lint !e1773 !e416 hem2hi unchanged varg
   trc_tclGlobalTrace::rfoGetTraceObject().vTraceOutput(enTraceClass, TR_tenTraceLevel(5), u32Linenumber,coszFilename, coszFormat, argList); 
   OSAL_VarArgEnd(argList);
}

tVoid trc_tclGlobalTrace::vLibTraceLevel6(TR_tenTraceClass enTraceClass, tU32 u32Linenumber, tCString coszFilename,tCString coszFormat,...)
{
   va_list argList;

   OSAL_VarArgStart(argList, coszFormat); //lint !e1773 !e416 hem2hi unchanged varg
   trc_tclGlobalTrace::rfoGetTraceObject().vTraceOutput(enTraceClass, TR_tenTraceLevel(6), u32Linenumber,coszFilename, coszFormat, argList); 
   OSAL_VarArgEnd(argList);
}

tVoid trc_tclGlobalTrace::vLibTraceLevel7(TR_tenTraceClass enTraceClass, tU32 u32Linenumber, tCString coszFilename,tCString coszFormat,...)
{
   va_list argList;

   OSAL_VarArgStart(argList, coszFormat); //lint !e1773 !e416 hem2hi unchanged varg
   trc_tclGlobalTrace::rfoGetTraceObject().vTraceOutput(enTraceClass, TR_tenTraceLevel(7), u32Linenumber,coszFilename, coszFormat, argList); 
   OSAL_VarArgEnd(argList);
}

tVoid trc_tclGlobalTrace::vLibTraceLevel8(TR_tenTraceClass enTraceClass, tU32 u32Linenumber, tCString coszFilename,tCString coszFormat,...)
{
   va_list argList;

   OSAL_VarArgStart(argList, coszFormat); //lint !e1773 !e416 hem2hi unchanged varg

   trc_tclGlobalTrace::rfoGetTraceObject().vTraceOutput(enTraceClass, TR_tenTraceLevel(8), u32Linenumber,coszFilename, coszFormat, argList); 
   OSAL_VarArgEnd(argList);
}
// restore lint !e530
//lint -restore
tU16 trc_tclGlobalTrace::u16Register( trc_tpfCallback pfCallback, const TR_tenTraceChan& Channel )
{
   tU16                       u16ClientId = trc_tclGlobalTrace::TRC_GLOBALTRACE_INVALID_CLIENT_ID;

   if (m_u16MaxClientIdx < trc_tclGlobalTrace::TRC_GLOBALTRACE_MAX_CLIENTS)
   {
      tS32                       s32Error;
      OSAL_trIOCtrlLaunchChannel oTraceChannel;

      oTraceChannel.enTraceChannel = Channel;
      oTraceChannel.pCallback = (OSAL_tpfCallback)pfCallback;

      s32Error = OSAL_s32IOControl( hTheGlobalTrace, OSAL_C_S32_IOCTRL_CALLBACK_REG, (intptr_t) &oTraceChannel);

      if (OSAL_OK == s32Error)
      {
         m_ClientList[m_u16MaxClientIdx].enTraceChannel = oTraceChannel.enTraceChannel;
         m_ClientList[m_u16MaxClientIdx].pCallback = oTraceChannel.pCallback;
         u16ClientId = m_u16MaxClientIdx;

         ++m_u16MaxClientIdx;
      }
   }

   return u16ClientId;
}


void trc_tclGlobalTrace::vDeregister( tU16 u16ClientId )
{
   if (u16ClientId < trc_tclGlobalTrace::TRC_GLOBALTRACE_MAX_CLIENTS)
   {
      OSAL_trIOCtrlLaunchChannel oTraceChannel;
      oTraceChannel.enTraceChannel = m_ClientList[u16ClientId].enTraceChannel; //lint !e661 !e662  Andres: checked by trc_tclGlobalTrace::TTRC_GLOBALTRACE_INVALID_CLIENT_ID 
      oTraceChannel.pCallback = m_ClientList[u16ClientId].pCallback; //lint !e661 !e662 Andres: checked by trc_tclGlobalTrace::TTRC_GLOBALTRACE_INVALID_CLIENT_ID    
      (void) OSAL_s32IOControl( hTheGlobalTrace , OSAL_C_S32_IOCTRL_CALLBACK_UNREG, (intptr_t) &oTraceChannel);
   }
}
