#ifndef TRC_MACRO_HEADER
#define TRC_MACRO_HEADER

/******************************************************************************

  FILE:           trc_macro.h

  PROJECT:        VASCO

  SW-COMPONENT:   general library

  DESCRIPTION:    macros for traceclass

  AUTHOR:         CM-DI/ESA2 Frank Wiedemann

  COPYRIGHT:      (c) 2002 Blaupunkt Werke GmbH

  HISTORY:
  $Log:   //hi230124/projects/Vasco/swnavi/archives/components/trace/trc_macro.h-arc  $
 * 
 *    Rev 1.2   Jul 11 2003 13:32:00   Zombetzki
 * new macro for level trace with variable count of parameters


  Date     | Rev. | Author                | Modification
  ----------------------------------------------------------------------------
  22.05.03 | 1.0  | CM-DI/ESA2-Wiedemann  | Initial revision

******************************************************************************/

#ifndef VARIANT_S_FTR_ENABLE_NO_TRACE

#define TRC_M_TRACE0(TRCClass, TRCLevel, FormatString) \
   if(trc_tclGlobalTrace::rfoGetTraceObject().bIsTraceActive(TRCClass, TRCLevel)) \
   { \
      trc_tclGlobalTrace::rfoGetTraceObject().vTrace(TRCClass, TRCLevel, __LINE__, __FILE__, FormatString); \
   } \

#define TRC_M_TRACE1(TRCClass, TRCLevel, FormatString, P1) \
   if(trc_tclGlobalTrace::rfoGetTraceObject().bIsTraceActive(TRCClass, TRCLevel)) \
   { \
      trc_tclGlobalTrace::rfoGetTraceObject().vTrace(TRCClass, TRCLevel, __LINE__, __FILE__, FormatString, P1); \
   } \

#define TRC_M_TRACE2(TRCClass, TRCLevel, FormatString, P1, P2) \
   if(trc_tclGlobalTrace::rfoGetTraceObject().bIsTraceActive(TRCClass, TRCLevel)) \
   { \
      trc_tclGlobalTrace::rfoGetTraceObject().vTrace(TRCClass, TRCLevel, __LINE__, __FILE__, FormatString, P1, P2); \
   } \

#define TRC_M_TRACE3(TRCClass, TRCLevel, FormatString, P1, P2, P3) \
   if(trc_tclGlobalTrace::rfoGetTraceObject().bIsTraceActive(TRCClass, TRCLevel)) \
   { \
      trc_tclGlobalTrace::rfoGetTraceObject().vTrace(TRCClass, TRCLevel, __LINE__, __FILE__, FormatString, P1, P2, P3); \
   } \

#define TRC_M_TRACE4(TRCClass, TRCLevel, FormatString, P1, P2, P3, P4) \
   if(trc_tclGlobalTrace::rfoGetTraceObject().bIsTraceActive(TRCClass, TRCLevel)) \
   { \
      trc_tclGlobalTrace::rfoGetTraceObject().vTrace(TRCClass, TRCLevel, __LINE__, __FILE__, FormatString, P1, P2, P3, P4); \
   } \

#define TRC_M_TRACE5(TRCClass, TRCLevel, FormatString, P1, P2, P3, P4, P5) \
   if(trc_tclGlobalTrace::rfoGetTraceObject().bIsTraceActive(TRCClass, TRCLevel)) \
   { \
      trc_tclGlobalTrace::rfoGetTraceObject().vTrace(TRCClass, TRCLevel, __LINE__, __FILE__, FormatString, P1, P2, P3, P4, P5); \
   } \

#define TRC_M_TRACE6(TRCClass, TRCLevel, FormatString, P1, P2, P3, P4, P5, P6) \
   if(trc_tclGlobalTrace::rfoGetTraceObject().bIsTraceActive(TRCClass, TRCLevel)) \
   { \
      trc_tclGlobalTrace::rfoGetTraceObject().vTrace(TRCClass, TRCLevel, __LINE__, __FILE__, FormatString, P1, P2, P3, P4, P5, P6); \
   } \

#define TRC_M_TRACE7(TRCClass, TRCLevel, FormatString, P1, P2, P3, P4, P5, P6, P7) \
   if(trc_tclGlobalTrace::rfoGetTraceObject().bIsTraceActive(TRCClass, TRCLevel)) \
   { \
      trc_tclGlobalTrace::rfoGetTraceObject().vTrace(TRCClass, TRCLevel, __LINE__, __FILE__, FormatString, P1, P2, P3, P4, P5, P6, P7); \
   } \

#define TRC_M_TRACE8(TRCClass, TRCLevel, FormatString, P1, P2, P3, P4, P5, P6, P7, P8) \
   if(trc_tclGlobalTrace::rfoGetTraceObject().bIsTraceActive(TRCClass, TRCLevel)) \
   { \
      trc_tclGlobalTrace::rfoGetTraceObject().vTrace(TRCClass, TRCLevel, __LINE__, __FILE__, FormatString, P1, P2, P3, P4, P5, P6, P7, P8); \
   } \

#define TRC_M_TRACE9(TRCClass, TRCLevel, FormatString, P1, P2, P3, P4, P5, P6, P7, P8, P9) \
   if(trc_tclGlobalTrace::rfoGetTraceObject().bIsTraceActive(TRCClass, TRCLevel)) \
   { \
      trc_tclGlobalTrace::rfoGetTraceObject().vTrace(TRCClass, TRCLevel, __LINE__, __FILE__, FormatString, P1, P2, P3, P4, P5, P6, P7, P8, P9); \
   } \





#define TRC_M_BTRACE_BEGIN(TRCClass, TRCLevel) \
   if(trc_tclGlobalTrace::rfoGetTraceObject().bIsTraceActive(TRCClass, TRCLevel)) \
   { \
      TR_tenTraceClass enTrcClass = TRCClass; \
      TR_tenTraceLevel enTrcLevel = TRCLevel;

#define TRC_M_BTRACE0(FormatString) \
      trc_tclGlobalTrace::rfoGetTraceObject().vTrace(enTrcClass, enTrcLevel, __LINE__, __FILE__, FormatString);

#define TRC_M_BTRACE1(FormatString, P1) \
      trc_tclGlobalTrace::rfoGetTraceObject().vTrace(enTrcClass, enTrcLevel, __LINE__, __FILE__, FormatString, P1);

#define TRC_M_BTRACE2(FormatString, P1, P2) \
      trc_tclGlobalTrace::rfoGetTraceObject().vTrace(enTrcClass, enTrcLevel, __LINE__, __FILE__, FormatString, P1, P2);

#define TRC_M_BTRACE3(FormatString, P1, P2, P3) \
      trc_tclGlobalTrace::rfoGetTraceObject().vTrace(enTrcClass, enTrcLevel, __LINE__, __FILE__, FormatString, P1, P2, P3);

#define TRC_M_BTRACE4(FormatString, P1, P2, P3, P4) \
      trc_tclGlobalTrace::rfoGetTraceObject().vTrace(enTrcClass, enTrcLevel, __LINE__, __FILE__, FormatString, P1, P2, P3, P4);

#define TRC_M_BTRACE5(FormatString, P1, P2, P3, P4, P5) \
      trc_tclGlobalTrace::rfoGetTraceObject().vTrace(enTrcClass, enTrcLevel, __LINE__, __FILE__, FormatString, P1, P2, P3, P4, P5);

#define TRC_M_BTRACE6(FormatString, P1, P2, P3, P4, P5, P6) \
      trc_tclGlobalTrace::rfoGetTraceObject().vTrace(enTrcClass, enTrcLevel, __LINE__, __FILE__, FormatString, P1, P2, P3, P4, P5, P6);

#define TRC_M_BTRACE7(FormatString, P1, P2, P3, P4, P5, P6, P7) \
      trc_tclGlobalTrace::rfoGetTraceObject().vTrace(enTrcClass, enTrcLevel, __LINE__, __FILE__, FormatString, P1, P2, P3, P4, P5, P6, P7);

#define TRC_M_BTRACE8(FormatString, P1, P2, P3, P4, P5, P6, P7, P8) \
      trc_tclGlobalTrace::rfoGetTraceObject().vTrace(enTrcClass, enTrcLevel, __LINE__, __FILE__, FormatString, P1, P2, P3, P4, P5, P6, P7, P8);

#define TRC_M_BTRACE9(FormatString, P1, P2, P3, P4, P5, P6, P7, P8, P9) \
      trc_tclGlobalTrace::rfoGetTraceObject().vTrace(enTrcClass, enTrcLevel, __LINE__, __FILE__, FormatString, P1, P2, P3, P4, P5, P6, P7, P8, P9);

#define TRC_M_BTRACE_END \
   }




/******************************************************************************

  MACRO:      TRC_M_TRACE_LEVEL(data)

  DESCRIPTION:
  
   This macro traces a variable count of parameters on specfifc level via global
   trace. 
   The usage is as follows:

      TRC_M_TRACE_FATAL ((TRC_SPECIAL_TRACE_CLASS, 
                          TRC_M_LINE,
                          TRC_M_FILE,
                          "fatal error: %d",
                          u16FatalError))

   Note:
      - a semicolon at the end of call is not needed
      - use double parenthesis because the whole term (with inner parenthesis)
        is used as function call

  PARAMETERS:

     TR_tenTraceClass enClass              traceclass
     tU32             u32Line              line (TRC_M_LINE)
     tCString         coszFile             specific file (TRC_M_FILE)
     tCString         coszFormat           formatstring
     ...                                   list of parameters

   
******************************************************************************/


#ifdef TRC_S_ENABLE_FATAL
   #define TRC_M_TRACE_FATAL(data)\
            trc_tclGlobalTrace::vTraceLevel0 data;
#else
  #define TRC_M_TRACE_FATAL(data)
#endif


#ifdef TRC_S_ENABLE_ERROR
   #define TRC_M_TRACE_ERROR(data)\
            trc_tclGlobalTrace::vTraceLevel1 data;
#else
  #define TRC_M_TRACE_ERROR(data)
#endif


#ifdef TRC_S_ENABLE_FULLSYSTEM
   #define TRC_M_TRACE_FULLSYSTEM(data)\
            trc_tclGlobalTrace::vTraceLevel3 data;
#else
  #define TRC_M_TRACE_FULLSYSTEM(data)
#endif


#ifdef TRC_S_ENABLE_MINIMIZED
   #define TRC_M_TRACE_MINIMIZED(data)\
            trc_tclGlobalTrace::vTraceLevel2 data;
#else
  #define TRC_M_TRACE_MINIMIZED(data)
#endif


#ifdef TRC_S_ENABLE_COMPONENT
   #define TRC_M_TRACE_COMPONENT(data)\
            trc_tclGlobalTrace::vTraceLevel4 data;
#else
  #define TRC_M_TRACE_COMPONENT(data)
#endif


#ifdef TRC_S_ENABLE_USER1
   #define TRC_M_TRACE_USER1(data)\
            trc_tclGlobalTrace::vTraceLevel5 data; 
#else
  #define TRC_M_TRACE_USER1(data)
#endif


#ifdef TRC_S_ENABLE_USER2
   #define TRC_M_TRACE_USER2(data)\
            trc_tclGlobalTrace::vTraceLevel6 data;
#else
  #define TRC_M_TRACE_USER2(data)
#endif


#ifdef TRC_S_ENABLE_USER3
   #define TRC_M_TRACE_USER3(data)\
            trc_tclGlobalTrace::vTraceLevel7 data;
#else
  #define TRC_M_TRACE_USER3(data)
#endif


#ifdef TRC_S_ENABLE_USER4
   #define TRC_M_TRACE_USER4(data)\
            trc_tclGlobalTrace::vTraceLevel8 data;
#else
  #define TRC_M_TRACE_USER4(data)
#endif

#else

#define TRC_M_TRACE0(TRCClass, TRCLevel, FormatString)
#define TRC_M_TRACE1(TRCClass, TRCLevel, FormatString, P1)
#define TRC_M_TRACE2(TRCClass, TRCLevel, FormatString, P1, P2)
#define TRC_M_TRACE3(TRCClass, TRCLevel, FormatString, P1, P2, P3)
#define TRC_M_TRACE4(TRCClass, TRCLevel, FormatString, P1, P2, P3, P4)
#define TRC_M_TRACE5(TRCClass, TRCLevel, FormatString, P1, P2, P3, P4, P5)
#define TRC_M_TRACE6(TRCClass, TRCLevel, FormatString, P1, P2, P3, P4, P5, P6)
#define TRC_M_TRACE7(TRCClass, TRCLevel, FormatString, P1, P2, P3, P4, P5, P6, P7)
#define TRC_M_TRACE8(TRCClass, TRCLevel, FormatString, P1, P2, P3, P4, P5, P6, P7, P8)
#define TRC_M_TRACE9(TRCClass, TRCLevel, FormatString, P1, P2, P3, P4, P5, P6, P7, P8, P9)
#define TRC_M_BTRACE_BEGIN(TRCClass, TRCLevel)
#define TRC_M_BTRACE0(FormatString)
#define TRC_M_BTRACE1(FormatString, P1)
#define TRC_M_BTRACE2(FormatString, P1, P2)
#define TRC_M_BTRACE3(FormatString, P1, P2, P3)
#define TRC_M_BTRACE4(FormatString, P1, P2, P3, P4)
#define TRC_M_BTRACE5(FormatString, P1, P2, P3, P4, P5)
#define TRC_M_BTRACE6(FormatString, P1, P2, P3, P4, P5, P6)
#define TRC_M_BTRACE7(FormatString, P1, P2, P3, P4, P5, P6, P7)
#define TRC_M_BTRACE8(FormatString, P1, P2, P3, P4, P5, P6, P7, P8)
#define TRC_M_BTRACE9(FormatString, P1, P2, P3, P4, P5, P6, P7, P8, P9)
#define TRC_M_BTRACE_END

#define TRC_M_TRACE_FATAL(data)
#define TRC_M_TRACE_ERROR(data)
#define TRC_M_TRACE_FULLSYSTEM(data)
#define TRC_M_TRACE_MINIMIZED(data)
#define TRC_M_TRACE_COMPONENT(data)
#define TRC_M_TRACE_USER1(data)
#define TRC_M_TRACE_USER2(data)
#define TRC_M_TRACE_USER3(data)
#define TRC_M_TRACE_USER4(data)

#endif

#endif  //TRC_MACRO_HEADER


