#ifndef TRC_DEF_HEADER
#define TRC_DEF_HEADER
/******************************************************************************

  FILE:           trc_def.h

  PROJECT:        VASCO

  SW-COMPONENT:   general library

  DESCRIPTION:    trace definitions

  AUTHOR:         CM-DI/ESA2 Mathias Schubert

  COPYRIGHT:      (c) 2002 Blaupunkt Werke GmbH

  HISTORY:
  $Log:   //hi230124/projects/Vasco/swnavi/archives/components/trace/trc_def.h-arc  $
 *
 *    Rev 1.4   Jul 11 2003 13:30:38   Zombetzki
 * add level USER4
 * activate USER4 if USER3 is set      change asap !!!!!
 *
 *    Rev 1.3   31 May 2002 11:00:28   UNM2HI
 * macros added
 *
 *    Rev 1.2   24 May 2002 15:41:24   SUM2HI
 * same little changes
 * LineNumber and FileName at  vTrace added.
 *
 *    Rev 1.1   24 Apr 2002 09:45:26   SUM2HI
 * Anpassung an Gesamtsystemkonzept Debug und Trace

  Date     | Rev. | Author                | Modification
  ----------------------------------------------------------------------------
  20.02.02 | 1.0  | CM-DI/ESA2-Schubert   | Initial revision

******************************************************************************/
/**************************************************************************/
/* general defines                                                        */
/**************************************************************************/

/**************************************************************************/
/* TTFisMessageRouter                                                     */
/**************************************************************************/

/* --Enable the defines for the trace levels.
   If a level is enabled, then the levels below will also be enabled (level inheritance).

   How to use:

   #ifdef TRC_S_ENABLE_COMPONENT
      ...Do some preprocessing work...
      ...Write string etc. into the trace data object...
   #endif

   The usage of the define (here: TRC_S_ENABLE_COMPONENT) depends on the level of the
   trace data. If you are using the real time framework (rtf), take a look at rtfstream.h for some
   easy-to-use c++ stream classes.

   The following levels are valid (TRC_S_ENABLE_...):

      0: FATAL
      1: ERROR
      2: MINIMIZED
      3: FULLSYSTEM
      4: COMPONENT
      5: USER0
      6: USER1
      7: USER2
      8: USER3

*/

#ifdef TRC_S_ENABLE_USER4
#define TRC_S_ENABLE_USER3
#endif
#ifdef TRC_S_ENABLE_USER3
   #ifndef TRC_S_ENABLE_USER4
#ifdef _WIN32
   #pragma message("trace level USER4 activated")
#endif
   #define TRC_S_ENABLE_USER4
   #endif
#define TRC_S_ENABLE_USER2
#endif
#ifdef TRC_S_ENABLE_USER2
#define TRC_S_ENABLE_USER1
#endif
#ifdef TRC_S_ENABLE_USER1
#define TRC_S_ENABLE_USER0
#endif
#ifdef TRC_S_ENABLE_USER0
#define TRC_S_ENABLE_COMPONENT
#endif
#ifdef TRC_S_ENABLE_COMPONENT
#define TRC_S_ENABLE_FULLSYSTEM
#endif
#ifdef TRC_S_ENABLE_FULLSYSTEM
#define TRC_S_ENABLE_MINIMIZED
#endif
#ifdef TRC_S_ENABLE_MINIMIZED
#define TRC_S_ENABLE_ERROR
#endif
#ifdef TRC_S_ENABLE_ERROR
#define TRC_S_ENABLE_FATAL
#endif

#ifndef TRC_S_ENABLE_FATAL
#error There is no trace level defined!
#endif

#endif
