#ifndef TRACE_CLASS_DEF_NAVAPP_H
#define TRACE_CLASS_DEF_NAVAPP_H
// ai_navigation/di_swnavi

#include "trace_comp_check_navapp.h"

/* -- navi_trace_class_def.h
   This file contains the definitions of trace classes for navapp.

   Author: wif2hi

   History:
*/

/*-------------------------------------
      definitions for trace class
  -------------------------------------

   A class definition describes a 16 bit value, which has two parts

   [  Component - ID   ][   Trace-Class-ID  ]
   15                  10                   0


   The component describes for which SW-parts the trace classes are defined for. For each component 2^10 = 1024
   classes are possible. (The first 24 classes are predefined for global issues. see below)


---------------------------------------*/
/*
   Defines for component-id:
*/

/* pccomp */
#define TR_CLASS_NAV_PC                         ((TR_tenTraceClass)(TR_COMP_NAVI + 0))
#define TR_CLASS_NAV_POSCALCDISPATCH            ((TR_tenTraceClass)(TR_COMP_NAVI + 1))
#define TR_CLASS_NAV_POSCALCDISPATCH_MSGFLOW    ((TR_tenTraceClass)(TR_COMP_NAVI + 2))
#define TR_CLASS_NAV_POSCALCDISPATCH_STATUS     ((TR_tenTraceClass)(TR_COMP_NAVI + 3))
#define TR_CLASS_NAV_DEADREC                    ((TR_tenTraceClass)(TR_COMP_NAVI + 4))
#define TR_CLASS_NAV_DEADREC_MSGFLOW            ((TR_tenTraceClass)(TR_COMP_NAVI + 5))
#define TR_CLASS_NAV_DEADREC_SENSORDATA         ((TR_tenTraceClass)(TR_COMP_NAVI + 6))
#define TR_CLASS_NAV_DEADREC_CALIBRATION        ((TR_tenTraceClass)(TR_COMP_NAVI + 7))
#define TR_CLASS_NAV_DEADREC_STATUS             ((TR_tenTraceClass)(TR_COMP_NAVI + 8))
#define TR_CLASS_NAV_MAPMATCHING                ((TR_tenTraceClass)(TR_COMP_NAVI + 9))
#define TR_CLASS_NAV_LDB                        ((TR_tenTraceClass)(TR_COMP_NAVI + 10))
#define TR_CLASS_NAV_LDB_MSGFLOW                ((TR_tenTraceClass)(TR_COMP_NAVI + 11))
#define TR_CLASS_NAV_LDB_STATUS                 ((TR_tenTraceClass)(TR_COMP_NAVI + 12))
#define TR_CLASS_NAV_PRESENTATION               ((TR_tenTraceClass)(TR_COMP_NAVI + 13))
#define TR_CLASS_NAV_PRESENTATION_MSGFLOW       ((TR_tenTraceClass)(TR_COMP_NAVI + 14))
#define TR_CLASS_NAV_PRESENTATION_STATUS        ((TR_tenTraceClass)(TR_COMP_NAVI + 15))
#define TR_CLASS_NAV_POSHORIZON                 ((TR_tenTraceClass)(TR_COMP_NAVI + 16))
#define TR_CLASS_NAV_POSHORIZON_MSGFLOW         ((TR_tenTraceClass)(TR_COMP_NAVI + 17))
#define TR_CLASS_NAV_POSHORIZON_STATUS          ((TR_tenTraceClass)(TR_COMP_NAVI + 18))
#define TR_CLASS_NAV_POSMSG_FLOW                ((TR_tenTraceClass)(TR_COMP_NAVI + 19))
#define TR_CLASS_NAV_PCCOMP_FFS_LOG             ((TR_tenTraceClass)(TR_COMP_NAVI + 20))
#define TR_CLASS_NAV_POSSELECTION               ((TR_tenTraceClass)(TR_COMP_NAVI + 21))
#define TR_CLASS_NAV_POSSELECTION_MSGFLOW       ((TR_tenTraceClass)(TR_COMP_NAVI + 22))
#define TR_CLASS_NAV_POSSELECTION_STATUS        ((TR_tenTraceClass)(TR_COMP_NAVI + 23))
#define TR_CLASS_NAV_NATSU                      ((TR_tenTraceClass)(TR_COMP_NAVI + 24))

/* rgcomp */
#define TR_CLASS_NAV_RG                         ((TR_tenTraceClass)(TR_COMP_NAVI + 32))
#define TR_CLASS_NAV_RG_RGIF                    ((TR_tenTraceClass)(TR_COMP_NAVI + 33))
#define TR_CLASS_NAV_RG_ROUTEGUIDANCE           ((TR_tenTraceClass)(TR_COMP_NAVI + 34))
#define TR_CLASS_NAV_RG_ACOUSTIC                ((TR_tenTraceClass)(TR_COMP_NAVI + 35))
#define TR_CLASS_NAV_RG_ACOUSTIC_LOADDEC        ((TR_tenTraceClass)(TR_COMP_NAVI + 36))
#define TR_CLASS_NAV_RG_ACOUSTIC_SPEECH         ((TR_tenTraceClass)(TR_COMP_NAVI + 37))
#define TR_CLASS_NAV_RG_CDB                     ((TR_tenTraceClass)(TR_COMP_NAVI + 38))
#define TR_CLASS_NAV_RG_PDB                     ((TR_tenTraceClass)(TR_COMP_NAVI + 39))
#define TR_CLASS_NAV_RG_IDB                     ((TR_tenTraceClass)(TR_COMP_NAVI + 40))
#define TR_CLASS_NAV_RG_HDB                     ((TR_tenTraceClass)(TR_COMP_NAVI + 41))

/* edmcomp */
#define TR_CLASS_NAV_EDM                        ((TR_tenTraceClass)(TR_COMP_NAVI + 64))
#define TR_CLASS_NAV_EDM_TASK                   ((TR_tenTraceClass)(TR_COMP_NAVI + 65))
#define TR_CLASS_NAV_EDM_TASK_MSGFLOW           ((TR_tenTraceClass)(TR_COMP_NAVI + 66))
#define TR_CLASS_NAV_EDM_TASK_ZOCDB             ((TR_tenTraceClass)(TR_COMP_NAVI + 67))
#define TR_CLASS_NAV_EDM_TASK_NTMM              ((TR_tenTraceClass)(TR_COMP_NAVI + 68))
#define TR_CLASS_NAV_EDM_TASK_TIMER             ((TR_tenTraceClass)(TR_COMP_NAVI + 69))
#define TR_CLASS_NAV_EDM_TASK_SC_SYSTEM         ((TR_tenTraceClass)(TR_COMP_NAVI + 70))
#define TR_CLASS_NAV_EDM_TASK_SC_COUNTRY        ((TR_tenTraceClass)(TR_COMP_NAVI + 71))
#define TR_CLASS_NAV_EDM_TASK_SC_POSITION       ((TR_tenTraceClass)(TR_COMP_NAVI + 72))
#define TR_CLASS_NAV_EDM_TASK_SC_RECTM          ((TR_tenTraceClass)(TR_COMP_NAVI + 73))
#define TR_CLASS_NAV_EDM_TASK_SC_PROCTM         ((TR_tenTraceClass)(TR_COMP_NAVI + 74))
#define TR_CLASS_NAV_EDM_TASK_SC_UTM            ((TR_tenTraceClass)(TR_COMP_NAVI + 75))
#define TR_CLASS_NAV_EDM_TASK_SC_MDB            ((TR_tenTraceClass)(TR_COMP_NAVI + 76))
#define TR_CLASS_NAV_EDM_TASK_SC_NCLIENTS       ((TR_tenTraceClass)(TR_COMP_NAVI + 77))
#define TR_CLASS_NAV_EDM_NTLDS                  ((TR_tenTraceClass)(TR_COMP_NAVI + 78))
#define TR_CLASS_NAV_EDM_NTLDS_MSGFLOW          ((TR_tenTraceClass)(TR_COMP_NAVI + 79))
#define TR_CLASS_NAV_EDM_NTLDS_RDBMAN           ((TR_tenTraceClass)(TR_COMP_NAVI + 80))
#define TR_CLASS_NAV_EDM_NTLDS_CONVERTTM        ((TR_tenTraceClass)(TR_COMP_NAVI + 81))
#define TR_CLASS_NAV_EDM_NTLDS_NTLIF            ((TR_tenTraceClass)(TR_COMP_NAVI + 82))
#define TR_CLASS_NAV_EDM_NTLDS_SC_SYSTEM        ((TR_tenTraceClass)(TR_COMP_NAVI + 83))
#define TR_CLASS_NAV_EDM_WORKER                 ((TR_tenTraceClass)(TR_COMP_NAVI + 84))

/* mdbcomp */
#define TR_CLASS_NAV_MDB                        ((TR_tenTraceClass)(TR_COMP_NAVI + 96))
#define TR_CLASS_NAV_MDB_DATAACCESS             ((TR_tenTraceClass)(TR_COMP_NAVI + 97))
#define TR_CLASS_NAV_MDB_STATES                 ((TR_tenTraceClass)(TR_COMP_NAVI + 98))
#define TR_CLASS_NAV_MDB_OPTIMIZER              ((TR_tenTraceClass)(TR_COMP_NAVI + 99))
#define TR_CLASS_NAV_MDB_ROADDATASERVER         ((TR_tenTraceClass)(TR_COMP_NAVI + 100))
#define TR_CLASS_NAV_MDB_ROADDATASTREAM         ((TR_tenTraceClass)(TR_COMP_NAVI + 101))
#define TR_CLASS_NAV_MDB_MSGFLOW                ((TR_tenTraceClass)(TR_COMP_NAVI + 102))

/* mapdataserver */
#define TR_CLASS_NAV_MADS                       ((TR_tenTraceClass)(TR_COMP_NAVI + 128))
#define TR_CLASS_NAV_MADS_DATASERVER            ((TR_tenTraceClass)(TR_COMP_NAVI + 129))
#define TR_CLASS_NAV_MADS_DISPLAYSERVER         ((TR_tenTraceClass)(TR_COMP_NAVI + 130))
#define TR_CLASS_NAV_MADS_MSGFLOW               ((TR_tenTraceClass)(TR_COMP_NAVI + 131))
#define TR_CLASS_NAV_MADS_STATES                ((TR_tenTraceClass)(TR_COMP_NAVI + 132))
#define TR_CLASS_NAV_MADS_EXTRAPOL              ((TR_tenTraceClass)(TR_COMP_NAVI + 133))
#define TR_CLASS_NAV_MADS_TRACE_FOR_MAP         ((TR_tenTraceClass)(TR_COMP_NAVI + 134))
#define TR_CLASS_NAV_MADS_TRACE_FOR_EXTRAPOL    ((TR_tenTraceClass)(TR_COMP_NAVI + 135))
#define TR_CLASS_NAV_MADS_MAPCONTROL            ((TR_tenTraceClass)(TR_COMP_NAVI + 136))
#define TR_CLASS_NAV_MADS_MAPCACHE              ((TR_tenTraceClass)(TR_COMP_NAVI + 137))

/* rccomp */
#define TR_CLASS_NAV_RCCOMP                                    ((TR_tenTraceClass)(TR_COMP_NAVI + 160))
#define TR_CLASS_NAV_RCCOMP_DLD                                ((TR_tenTraceClass)(TR_COMP_NAVI + 161))
#define TR_CLASS_NAV_RCCOMP_DLD_MSGFLOW                        ((TR_tenTraceClass)(TR_COMP_NAVI + 162))
#define TR_CLASS_NAV_RCCOMP_DLD_WORK                           ((TR_tenTraceClass)(TR_COMP_NAVI + 163))
#define TR_CLASS_NAV_RCCOMP_RIF                                ((TR_tenTraceClass)(TR_COMP_NAVI + 164))
#define TR_CLASS_NAV_RCCOMP_RIF_MSGFLOW                        ((TR_tenTraceClass)(TR_COMP_NAVI + 165))
#define TR_CLASS_NAV_RCCOMP_RIF_THDB                           ((TR_tenTraceClass)(TR_COMP_NAVI + 166))
#define TR_CLASS_NAV_RCCOMP_RIF_RIDB                           ((TR_tenTraceClass)(TR_COMP_NAVI + 167))
#define TR_CLASS_NAV_RCCOMP_RIF_RFOLLOW                        ((TR_tenTraceClass)(TR_COMP_NAVI + 168))
#define TR_CLASS_NAV_RCCOMP_RIF_ENABLE_LOG_NOROUTE_TO_FFS      ((TR_tenTraceClass)(TR_COMP_NAVI + 169))   /*This trace class enables the logging of NO ROUTE information to the ffs if the trace level USER4 is activ.*/
#define TR_CLASS_NAV_RCCOMP_RIF_DISABLE_LOG_NOROUTE_TO_FFS     ((TR_tenTraceClass)(TR_COMP_NAVI + 170))   /*This trace class disables the logging of NO ROUTE information to the ffs if the trace level USER4 is activ.*/
#define TR_CLASS_NAV_RCCOMP_RCALC                              ((TR_tenTraceClass)(TR_COMP_NAVI + 171))
#define TR_CLASS_NAV_RCCOMP_RCALC_MSGFLOW                      ((TR_tenTraceClass)(TR_COMP_NAVI + 172))
#define TR_CLASS_NAV_RCCOMP_RCALC_PROCESS                      ((TR_tenTraceClass)(TR_COMP_NAVI + 173))
#define TR_CLASS_NAV_RCCOMP_RCALC_GCL                          ((TR_tenTraceClass)(TR_COMP_NAVI + 174))
#define TR_CLASS_NAV_RCCOMP_RCALC_CALC                         ((TR_tenTraceClass)(TR_COMP_NAVI + 175))
#define TR_CLASS_NAV_RCCOMP_RCALC_ROUTELIST                    ((TR_tenTraceClass)(TR_COMP_NAVI + 176))
#define TR_CLASS_NAV_RCCOMP_RDB                                ((TR_tenTraceClass)(TR_COMP_NAVI + 177))
#define TR_CLASS_NAV_RCCOMP_RDB_READ                           ((TR_tenTraceClass)(TR_COMP_NAVI + 178))
#define TR_CLASS_NAV_RCCOMP_RDB_CONVERT                        ((TR_tenTraceClass)(TR_COMP_NAVI + 179))
#define TR_CLASS_NAV_RCCOMP_RDB_DATABASE                       ((TR_tenTraceClass)(TR_COMP_NAVI + 180))
#define TR_CLASS_NAV_RCCOMP_RDBLOADER                          ((TR_tenTraceClass)(TR_COMP_NAVI + 181))
#define TR_CLASS_NAV_RCCOMP_RDBLOADER_MSGFLOW                  ((TR_tenTraceClass)(TR_COMP_NAVI + 182))
#define TR_CLASS_NAV_RCCOMP_RDBLOADER_PROCESS                  ((TR_tenTraceClass)(TR_COMP_NAVI + 183))
#define TR_CLASS_NAV_RCCOMP_RI_WORKER                          ((TR_tenTraceClass)(TR_COMP_NAVI + 184))
#define TR_CLASS_NAV_RCCOMP_RI_WORKER_MSGFLOW                  ((TR_tenTraceClass)(TR_COMP_NAVI + 185))
#define TR_CLASS_NAV_RCCOMP_RI_WORKER_PROCESS                  ((TR_tenTraceClass)(TR_COMP_NAVI + 186))
#define TR_CLASS_NAV_RCCOMP_LFW                                ((TR_tenTraceClass)(TR_COMP_NAVI + 187))
#define TR_CLASS_NAV_RCCOMP_LFW_CAT                            ((TR_tenTraceClass)(TR_COMP_NAVI + 188)) /*CalcAreaTable*/
#define TR_CLASS_NAV_RCCOMP_LFW_RES                            ((TR_tenTraceClass)(TR_COMP_NAVI + 189)) /*ResultList*/

/* navi state manager */
#define TR_CLASS_NAV_NAVISTATEMANAGER                          ((TR_tenTraceClass)(TR_COMP_NAVI + 192))

#define TR_CLASS_NAV_LI                                        ((TR_tenTraceClass)(TR_COMP_NAVI + 200))
#define TR_CLASS_NAV_LI_MESSAGES                               ((TR_tenTraceClass)(TR_COMP_NAVI + 201))
#define TR_CLASS_NAV_LI_STATES                                 ((TR_tenTraceClass)(TR_COMP_NAVI + 202))

#define TR_CLASS_NAV_TRIP_DATA                                 ((TR_tenTraceClass)(TR_COMP_NAVI + 232))

#define TR_CLASS_NAV_SYSTESTTRACES                             ((TR_tenTraceClass)(TR_COMP_NAVI + 264))

/* class definitions for component = "DAPI"      */
#define TR_CLASS_DAPI_DEVMAN                                   ((TR_tenTraceClass)(TR_COMP_DAPI + 0))
#define TR_CLASS_DAPI_DEVMAN_DATA_AVAIL                        ((TR_tenTraceClass)(TR_COMP_DAPI + 1))
#define TR_CLASS_DAPI_DEVMAN_CPR                               ((TR_tenTraceClass)(TR_COMP_DAPI + 2))

#define TR_CLASS_DAPI_LISA                                     ((TR_tenTraceClass)(TR_COMP_DAPI + 16))
#define TR_CLASS_DAPI_SBS                                      ((TR_tenTraceClass)(TR_COMP_DAPI + 17))
#define TR_CLASS_DAPI_RAWDATA                                  ((TR_tenTraceClass)(TR_COMP_DAPI + 18))
#define TR_CLASS_DAPI_RESINFO                                  ((TR_tenTraceClass)(TR_COMP_DAPI + 19))
#define TR_CLASS_DAPI_COMM                                     ((TR_tenTraceClass)(TR_COMP_DAPI + 20))
#define TR_CLASS_DAPI_FRAMEWORK                                ((TR_tenTraceClass)(TR_COMP_DAPI + 21))
#define TR_CLASS_DAPI_ARCHIVE                                  ((TR_tenTraceClass)(TR_COMP_DAPI + 22))
#define TR_CLASS_DAPI_POI_SERVER                               ((TR_tenTraceClass)(TR_COMP_DAPI + 23))

#define TR_CLASS_DAPI_TMC                                      ((TR_tenTraceClass)(TR_COMP_DAPI + 32))
#define TR_CLASS_DAPI_TMC_ARCHIVE                              ((TR_tenTraceClass)(TR_COMP_DAPI + 33))
#define TR_CLASS_DAPI_TMC_ACCESS                               ((TR_tenTraceClass)(TR_COMP_DAPI + 34))
#define TR_CLASS_DAPI_TMC_HL_IF                                ((TR_tenTraceClass)(TR_COMP_DAPI + 35))
#define TR_CLASS_DAPI_TMC_KNIT                                 ((TR_tenTraceClass)(TR_COMP_DAPI + 36))

#define TR_CLASS_DAPI_RNW                                      ((TR_tenTraceClass)(TR_COMP_DAPI + 48))
#define TR_CLASS_DAPI_RNW_ARC_STORE                            ((TR_tenTraceClass)(TR_COMP_DAPI + 49))
#define TR_CLASS_DAPI_RNW_ARC_LISTS                            ((TR_tenTraceClass)(TR_COMP_DAPI + 50))
#define TR_CLASS_DAPI_RNW_ARC_CONTENT                          ((TR_tenTraceClass)(TR_COMP_DAPI + 51))
#define TR_CLASS_DAPI_RNW_ARC_CTRL                             ((TR_tenTraceClass)(TR_COMP_DAPI + 52))
#define TR_CLASS_DAPI_RNW_MAP                                  ((TR_tenTraceClass)(TR_COMP_DAPI + 53))
#define TR_CLASS_DAPI_RNW_ACCESS                               ((TR_tenTraceClass)(TR_COMP_DAPI + 54))
#define TR_CLASS_DAPI_RNW_HL_IF                                ((TR_tenTraceClass)(TR_COMP_DAPI + 55))
#define TR_CLASS_DAPI_RNW_KNIT                                 ((TR_tenTraceClass)(TR_COMP_DAPI + 56))
#define TR_CLASS_DAPI_RNW_PATCH                                ((TR_tenTraceClass)(TR_COMP_DAPI + 57))

#define TR_CLASS_DAPI_MAP                                      ((TR_tenTraceClass)(TR_COMP_DAPI + 64))
#define TR_CLASS_DAPI_MAP_STOPWATCH                            ((TR_tenTraceClass)(TR_COMP_DAPI + 65))
#define TR_CLASS_DAPI_MAP_CONVERTER                            ((TR_tenTraceClass)(TR_COMP_DAPI + 66))
#define TR_CLASS_DAPI_MAP_MANAGER                              ((TR_tenTraceClass)(TR_COMP_DAPI + 67))
#define TR_CLASS_DAPI_MAP_WORKER                               ((TR_tenTraceClass)(TR_COMP_DAPI + 68))
#define TR_CLASS_DAPI_MAP_ID_CONTROLLER                        ((TR_tenTraceClass)(TR_COMP_DAPI + 69))
#define TR_CLASS_DAPI_MAP_TCICACHE                             ((TR_tenTraceClass)(TR_COMP_DAPI + 70))
#define TR_CLASS_DAPI_MAP_TILELOADER                           ((TR_tenTraceClass)(TR_COMP_DAPI + 71))
#define TR_CLASS_DAPI_MAP_KNIT                                 ((TR_tenTraceClass)(TR_COMP_DAPI + 72))
#define TR_CLASS_DAPI_MAP_CONNECT                              ((TR_tenTraceClass)(TR_COMP_DAPI + 73))

#define TR_CLASS_DAP_RS                                        ((TR_tenTraceClass)(TR_COMP_DAPI + 80))
#define TR_CLASS_DAPI_RS_MANAGER                               ((TR_tenTraceClass)(TR_COMP_DAPI + 81))
#define TR_CLASS_DAPI_RS_WORKER                                ((TR_tenTraceClass)(TR_COMP_DAPI + 82))

/* class definitions for component = "SINA"      */
#define TR_CLASS_SINA                                          ((TR_tenTraceClass)(TR_COMP_SINA + 0))
#define TR_CLASS_SINA_ARCHIVESTRATEGY                          ((TR_tenTraceClass)(TR_COMP_SINA + 1))
#define TR_CLASS_SINA_ASTHREAD                                 ((TR_tenTraceClass)(TR_COMP_SINA + 2))
#define TR_CLASS_SINA_AS_MESSAGES                              ((TR_tenTraceClass)(TR_COMP_SINA + 3))
#define TR_CLASS_SINA_AS_STATECHART                            ((TR_tenTraceClass)(TR_COMP_SINA + 4))
#define TR_CLASS_SINA_AS_DEST_GLUE                             ((TR_tenTraceClass)(TR_COMP_SINA + 5))
#define TR_CLASS_SINA_AS_LOCINPUTCIRCLE                        ((TR_tenTraceClass)(TR_COMP_SINA + 6))
#define TR_CLASS_SINA_AS_POSITIONCIRCLE                        ((TR_tenTraceClass)(TR_COMP_SINA + 7))
#define TR_CLASS_SINA_AS_ROUTEONECELLS                         ((TR_tenTraceClass)(TR_COMP_SINA + 8))
#define TR_CLASS_SINA_AS_TMCSEGMENTS                           ((TR_tenTraceClass)(TR_COMP_SINA + 9))
#define TR_CLASS_SINA_AS_POSITIONDB                            ((TR_tenTraceClass)(TR_COMP_SINA + 10))
#define TR_CLASS_SINA_AS_TRIPDB                                ((TR_tenTraceClass)(TR_COMP_SINA + 11))
#define TR_CLASS_SINA_AS_REGPARAMETER                          ((TR_tenTraceClass)(TR_COMP_SINA + 12))
#define TR_CLASS_SINA_AS_TMCLOCATIONS                          ((TR_tenTraceClass)(TR_COMP_SINA + 13))
#define TR_CLASS_SINA_AS_PERFORMANCE                           ((TR_tenTraceClass)(TR_COMP_SINA + 14))
#define TR_CLASS_SINA_AS_POSITIONRING                          ((TR_tenTraceClass)(TR_COMP_SINA + 15))


/* class definitions for component = "TIMA"      */
#define TR_CLASS_TIMA                                          ((TR_tenTraceClass)(TR_COMP_TIMA + 0))

/* class definitions for component = "DATAPROVIDER" */
#define TR_CLASS_FC_DATAPROVIDER                               ((TR_tenTraceClass)(TR_COMP_DATAPROVIDER + 0))
#define TR_CLASS_DP_TEST_CLIENT                                ((TR_tenTraceClass)(TR_COMP_DATAPROVIDER + 4))

/* class definitions for component = "WDB"      */
#define TR_CLASS_WDB                                           ((TR_tenTraceClass)(TR_COMP_WDB + 0))

/* class definitions for component = "ADASIS"   */
#define TR_CLASS_FCVD_ADASIS                                   ((TR_tenTraceClass)(TR_COMP_FCADASIS + 4))
#define TR_CLASS_FCVD_ADASIS_STATUS                            ((TR_tenTraceClass)(TR_COMP_FCADASIS + 0))

/* class definitions for component = "ADASIS"   */
#define TR_CLASS_ADASIS                                        ((TR_tenTraceClass)(TR_COMP_FCADASIS + 14))
#define TR_CLASS_VD_ADASIS                                     ((TR_tenTraceClass)(TR_COMP_FCADASIS + 24))

/* class definitions for component = "LEARNDATACOMM" */
#define TR_CLASS_FC_LEARNDATACOMM                              ((TR_tenTraceClass)(TR_COMP_FC_LEARNDATACOMM + 4))
#define TR_CLASS_FC_LEARNDATACOMM_STATUS                       ((TR_tenTraceClass)(TR_COMP_FC_LEARNDATACOMM + 0))

/* class definitions for component = "STAT"      */
#define TR_CLASS_STAT                                          ((TR_tenTraceClass)(TR_COMP_STAT + 0))

/* class definitions for component = "TEA"      */
#define TR_CLASS_TEA                                           ((TR_tenTraceClass)(TR_COMP_TEA + 0))

/* class definitions for component = "FC_PROFILER"	*/
#define TR_CLASS_FC_PROFILER									((TR_tenTraceClass)(TR_COMP_PROFILER + 0))

/* class definitions for component = "FC__TRAFFICINFOPROVIDER"	*/
#define TR_CLASS_FC_TRAFFICINFOPROVIDER                         ((TR_tenTraceClass)(TR_COMP_FC_TRAFFICINFOPROVIDER + 0)) // needed for generated code
#define TR_CLASS_TIP_TEST_CLIENT                                ((TR_tenTraceClass)(TR_COMP_FC_TRAFFICINFOPROVIDER + 4)) // needed for generated code
#define TR_CLASS_TIP_TEST_MAPCLIENT                             ((TR_tenTraceClass)(TR_COMP_FC_TRAFFICINFOPROVIDER + 5)) // needed for generated code

/* class definition for component = "FC_LOCINPUT" */
#define TR_CLASS_FC_LOCINPUT                                    ((TR_tenTraceClass) TR_COMP_FC_LOCINPUT)

/*definition of parameter index*/
/* sec2hi, 13.06.03: tbc: May the definitions of parameter index be moved
to the local trace-headers of the components? */

#define TR_CALIBRATION_TYRE_SIZE           0x01
#define TR_CALIBRATION_DISTCAL_NORMAL      0x02
#define TR_CALIBRATION_DISTCAL_ENGR        0x03
#define TR_SENSOR_SIGN_SPEED_IN_KMH        0x04
#define TR_SENSOR_SIGN_SPEED_IN_MPH        0x05
#define TR_SENSOR_SIGN_ODOMETER            0x06
#define TR_SENSOR_SIGN_GYRO_VALUE          0x07
#define TR_SENSOR_SIGN_GPS_ANTEN_STATE     0x08
#define TR_SENSOR_SIGN_KL15_RFLS           0x09
#define TR_GPS_RECEIVER_POSITION           0x0a
#define TR_GPS_RECEIVER_GPS_STATE          0x0b
#define TR_GPS_RECEIVER_TIME_DATE          0x0c
#define TR_GPS_RECEIVER_SAT_STATE          0x0d
#define TR_GPS_RECEIVER_VERSION            0x0e
#define TR_GPS_RECEIVER_DATE               0x0f
#define TR_GPS_RECEIVER_SATCHAN_STATE      0x10
#define TR_LOCATION_INFO                   0x11
#define TR_TMC_8A_GROUP                    0x12
#define TR_TMC_FLAGS                       0x13
#define TR_TMC_SENDERNAME                  0x14
#define TR_TMC_V_INFOS                     0x15
#define TR_ROUTE_STREETNAME                0x16
#define TR_ROUTE_LIST_STREETNAME           0x17
#define TR_ROUTE_LISTE_CONGESTIONINFOS     0x18
#define TR_STATI_ROUTE_INFO                0x19
#define TR_STATI_SYSTEM_INFO               0x1a
#define TR_STATI_MAP_DISPLAY               0x1b
#define TR_STATI_DEST_LIST                 0x1c
#define TR_STATI_DEST_RECOMM               0x1d
#define TR_STATI_BARGRAPH                  0x1e
#define TR_STATI_ROUTE_GUIDANCE            0x1f


//trip related defines
#define TR_C_S32_MODE_NORMAL        (tS32)0
#define TR_C_S32_MODE_ENDLESS       (tS32)1
#define TR_C_S32_MODE_AUTOMATIC        (tS32)2

#endif  /*-- TRACE_CLASS_DEF_NAVAPP_H */


