#ifndef OSAL_IF_ETG_H
#define OSAL_IF_ETG_H

#ifndef NULL
#ifdef __cplusplus
#define NULL                   0
#else
#define NULL                   ((void *)0)
#endif
#endif
#ifndef FALSE
#define FALSE                  (0)
#endif
#ifndef TRUE
#define TRUE                   (1)
#endif

#ifndef ETG_NO_POSIX_INCLUDES
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#endif

// following defines are in generated header and here to allow independent integration
#ifndef ETG_DEF_DONE
#define ETG_DEF_DONE
#if defined (_WIN32)
#define ETG_FN_SNPRINTF _snprintf 
#else
#define ETG_FN_SNPRINTF snprintf
#endif
#define ETG_FN_MEMCPY(_DEST_,_SRC_,_NCNT_)  memcpy(_DEST_,_SRC_,_NCNT_)
typedef unsigned char           etg_tBool;
typedef char                    etg_tChar;
typedef float                   etg_tF32;
typedef double                  etg_tF64;
typedef signed char             etg_tS8; 
typedef signed short            etg_tS16;
typedef signed int              etg_tS32;
typedef signed long long        etg_tS64;
typedef unsigned char           etg_tU8;
typedef unsigned short          etg_tU16;
typedef unsigned int            etg_tU32;
typedef unsigned long long      etg_tU64;
typedef unsigned char           etg_tUChar;
#define etg_tVoid               void       
typedef etg_tVoid*              etg_tPVoid;
typedef void (*ETG_tpfCallback) ( etg_tPVoid );
#define ETG_DEF_CALLBACK        ETG_tpfCallback 
#endif // ETG_DEF_DONE


typedef const etg_tVoid*        etg_tPCVoid;        
typedef int                     etg_tInt;
typedef unsigned int            etg_tUInt;
typedef etg_tChar*              etg_tString;
typedef const etg_tChar*        etg_tCString;
typedef const etg_tU8*          etg_tPCU8;
typedef const etg_tU16*         etg_tPCU16;
typedef const etg_tU32*         etg_tPCU32;
typedef const etg_tU64*         etg_tPCU64;
#if defined (__APPLE__)
typedef etg_tU64                etg_tThreadID;
#else
typedef etg_tU32                etg_tThreadID;
#endif
typedef etg_tS32                etg_tIODescriptor;
#define ETG_RES_OK              ((etg_tS32)  0)
#define ETG_RES_ERROR           ((etg_tS32) -1)
#define ETG_FN_STRNCPY(_DEST_,_SRC_,_NCNT_) (etg_tString)strncpy((char*)(_DEST_),(const char*)(_SRC_),(_NCNT_))
#define ETG_FN_STRLEN(_STR_)             strlen((const char*)_STR_)
#define ETG_FN_MEMSET(_DEST_,_SRC_,_NCNT_)  memset(_DEST_,_SRC_,_NCNT_)
#define ETG_tVarArgList                   va_list
#define ETG_VarArgStart(_LIST_,_LASTARG_) va_start((_LIST_),(_LASTARG_))                        
#define ETG_VarArg(_LIST_,_TYPE_)         va_arg((_LIST_),_TYPE_)
#define ETG_VarArgEnd(_LIST_)             va_end(_LIST_)

#ifndef ETG_TELEVEL_DEFINED // hack for combining old etg.h and new trace independent generator
#define ETG_CONV_CHAN
#define ETG_TELEVEL_DEFINED
enum ETG_teLevel {
   ETG_LEVEL_FATAL        = 0, // assumed level for tracing always (most important)
   ETG_LEVEL_ERRORS       = 1,
   ETG_LEVEL_SYSTEM_MIN   = 2,
   ETG_LEVEL_SYSTEM       = 3,
   ETG_LEVEL_COMPONENT    = 4,
   ETG_LEVEL_USER_1       = 5,
   ETG_LEVEL_USER_2       = 6,
   ETG_LEVEL_USER_3       = 7,
   ETG_LEVEL_USER_4       = 8
};
#endif // ETG_TELEVEL_DEFINED

typedef enum
{
   etg_eErrmemEntryUndefined = 0,
   etg_eErrmemEntryNormal,
   /* Insert new type(s) here */
   etg_eErrmemEntryInfo   = 0x8000,
   etg_eErrmemValidRTCTime = 0xABBA,
   etg_eErrmemEntryFatal  = 0xFFFF
} etg_tenErrmemEntryType;

#endif // OSAL_IF_ETG_H
