/*****************************************************************************
* FILE:         vd_inputMain.h
* PROJECT:      G3G project
* SW-COMPONENT: __COMPONENT__
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) __YEAR__ Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef _vd_inputMAIN_H_
#define _vd_inputMAIN_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#define SYSTEM_S_IMPORT_INTERFACE_MAP
#define SYSTEM_S_IMPORT_INTERFACE_SET
#include "stl_pif.h"
#include "etg_trace.h"


#define VD_SERVICE_ID               0x00B5
#define VD_INPUT_FI_MAJOR_VERSION        1
#define VD_INPUT_FI_MINOR_VERSION        0

#define DIAGLIB_INCLUDE_SYSTEM_SET
#include "diaglib_if.h"

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

#define vd_input_NULL_POINTER_CHECK(poClass) \
   if (poClass == NULL) {\
   FATAL_M_ASSERT_ALWAYS();\
   return;\
   }

#define vd_input_NULL_POINTER_CHECK_VAL(poClass) \
   if (poClass == NULL) {\
   FATAL_M_ASSERT_ALWAYS();\
   return 0;\
   }


/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define MAX_MSG_SIZE 60 //Need to be discussed as per concept document it can be greater than 60
#define UINPUT_TEST //for testing uinput

class ahl_tclBaseOneThreadApp;
class vd_input_tclMain;
// vd_input_tclMainForwardDecl: user specific code start
class vd_input_INCAdapter;
class Ivd_input_tclServiceHandler;
class TouchSimApp;
class KeySimApp;
class EncSimApp;
class Input_tclSystemSetListener;
class EventObserver;
class UsrActionEmu;
// vd_input_tclMainForwardDecl: user specific code end

////////////////////////////////////////////////////////////////////////////////
// Base class for all Classes
class Ivd_inputBase
{
protected:
   const vd_input_tclMain*   _cpoMain;

public:
   typedef enum {
      //internal messages

      // vd_input_tclMainIMsgDef: user specific code start
      // vd_input_tclMainIMsgDef: user specific code end
      eMaxTypes
   }ECmdTypes;

   typedef struct TMsg{
      ECmdTypes  eCmd;
      tChar      strClassName[50];
      union {
         tU32  u32Data;
         struct TTrigger {
            tU32 u32TriggerType;
            tBool bActive;
         }; 
         TTrigger tTrigger;
         // vd_input_tclMainIMsgUnion: user specific code start
         // vd_input_tclMainIMsgUnion: user specific code end
      }u;
   } TMsg;


   Ivd_inputBase(const vd_input_tclMain* cpoMain):_cpoMain(cpoMain) {;} 
   Ivd_inputBase():_cpoMain(NULL){;}
   virtual ~Ivd_inputBase() {_cpoMain = NULL;}
   virtual const tChar* getName() const = 0;
   virtual const tChar* getIfName() const = 0;

   virtual tVoid vHandleMessage(TMsg* pMsg) = 0;
   virtual tVoid vGetReferences() = 0;
   virtual tVoid vStartCommunication() = 0;
   virtual tVoid vTraceInfo() = 0;
};


class vd_input_tclMain : public ahl_tclBaseOneThreadApp
{

private:
   static vd_input_tclMain*   _poMainAppInstance;
   OSAL_tMQueueHandle      _hWorkerMsgQueue;
   tBool                   _bTerminate;
   OSAL_tThreadID          _tThreadID;

   tVoid                   vCreateWorkerThread();
   static tVoid            dwThreadWork( tPVoid pvArg );
  
public:
   static vd_input_tclMain* theServer();    
   
   vd_input_tclMain(tVoid);
   virtual ~vd_input_tclMain(tVoid);

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'vd_input_tclMain' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   vd_input_tclMain& operator= (const vd_input_tclMain &oApp);

   /**************************************************************************
   * Copy Constructor, will not be implemented.
   * Avoids Lint Prio 3 warning:Info 1733: new in constructor for class 
   * 'vd_input_tclMain' which has no copy constructor.
   * NOTE: This is a technique to disable the copy constructor for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   vd_input_tclMain(const vd_input_tclMain &oApp); 

   /**************************************************************************
   * Overriding ahl_tclBaseOneThreadApp methods.
   **************************************************************************/
   virtual tBool bOnInit();
   virtual tVoid vOnApplicationClose();
   virtual tVoid vOnTimer(tU16 nTimerId);

   using ahl_tclBaseOneThreadApp::vOnLoopback;
   virtual tVoid vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage);

   virtual tVoid vDispatchInternalMsg(Ivd_inputBase::TMsg* pInternalMsg);
   virtual tVoid vPostInternalMessage(Ivd_inputBase::TMsg* pInternalMsg);

   //reference handling for __ created objects
private:
   bpstl::set<Ivd_inputBase*>  _oObjList;

   tVoid vAddObj(Ivd_inputBase* client) {
      _oObjList.insert(client);
   }

   tVoid vRemoveObj(Ivd_inputBase* client){
      if(_oObjList.find(client) != _oObjList.end()) {
         _oObjList.erase(_oObjList.find(client));
      }
   }

   tVoid vStartCommunication() const {
      bpstl::set<Ivd_inputBase*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         (*iter)->vStartCommunication();
      }
   }

   tVoid vGetReferences() const {
      bpstl::set<Ivd_inputBase*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         (*iter)->vGetReferences();
      }
   }

public:
   Ivd_inputBase*  getHandler(const tChar* cName) const{
      bpstl::set<Ivd_inputBase*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         if (0 == OSAL_s32StringCompare((*iter)->getIfName(), cName)) {
            return (*iter);
         }
      }
      return NULL;
   }


private:
//   ConfigurationDataHandler oConfigurationDataHandler;
   tVoid vTracePlugIn(tVoid);
   tVoid vTraceUnplug(tVoid);

   static tVoid vHandleTraceMessage(const tUChar* puchData);
   static tVoid vHandleTraceMessageGen(const tUChar* puchData);

// vd_input_tclMainDecl: user specific code start
   static tU32 m_u32VariantType; //This variable is used to store the value of variant type entered by TTFIS command vd_input_SetVariantType
   static tUChar m_u8INC_msg_buff[MAX_MSG_SIZE];
   //vd_input_INCAdapter* pvd_input_INCAdapter; //pointer of class adaptor used globally
   Ivd_input_tclServiceHandler* pCcaServiceHdl;

   TouchSimApp* _tpTouchSimApp;
   TouchSimApp* _tpTouchSimApp_Secondary;
   KeySimApp* _tpKeySimApp;
   EncSimApp* _tpEncSimApp;

   EventObserver* _poEventObserver;
   UsrActionEmu* _poUsrActionEmu;

   diaglib::tclServiceDiaglib* m_poServiceDiaglib;
   Input_tclSystemSetListener* m_poSystemSetListener;

   tU8 _mU8BrandType;
   tU8 _mU8DisplayOrientation;
public:
    // Methods User defined
	tVoid readKDS();
	static tVoid clearINCBuffer();

	tVoid printTargetConfiguredKeyList();
	//Set of Public Methods for Simulation through TTFIS or Diag Interfaces CCA
	inline tU8 getKeyDeviceType(tU16 Keycode);
	tBool simulateKey(tU16 Keycode, tS32 Status);
	tBool simulateEncoder(tU16 EncType, tS32 Steps);
	tBool simulateTouch(tS32 X, tS32 Y, tS32 SlotId, tS32 Status,tS32 Screen_No=1);
	tBool simulateTouchSlide(tS32 StartX, tS32 StartY, tS32 EndX, tS32 EndY, tS32 Speed,tS32 Screen_No=1);

	//Set of Methods to Get The Event Data from CCA service handler
	tVoid EnableEventObserver();
	tVoid DisableEventObserver();
	inline tU8 u8GetBrandType() const
	{
		return _mU8BrandType;
	}
	inline tU8 u8getDisplayOrientationType()
	{
		return _mU8DisplayOrientation;
	}
	tVoid printTouchDiagList();
	tVoid printTouchDiagList_PIVI();


// vd_input_tclMainDecl: user specific code end

}; 



#endif // _vd_inputMAIN_H_

