/*
 * KeySimApp.h
 *
 *  Created on: Aug 18, 2015
 *      Author: sgt4kor
 */

#ifndef KEYSIMAPP_H_
#define KEYSIMAPP_H_
#include "../vd_inputMain.h"
#include"../Gateway/uInputAdaptor/uInputAdaptor.h"
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

using namespace vd_input_uInputAdaptor;

class KeySimApp: public Ivd_inputBase {

public:
    //Constructor
	KeySimApp(vd_input_tclMain* poMain);
	//Destructor
	virtual ~KeySimApp();
	//Set Of Virtual Functions to be overriden from base class
	virtual const tChar* getName() const {return "KeySimApp"; }
	virtual const tChar* getIfName() const {return "KeySimApp"; }
	virtual tVoid vHandleMessage(TMsg* pMsg) {(tVoid)pMsg; } //--Lint Prio 2 Fix
	virtual tVoid vGetReferences(){; }
	virtual tVoid vStartCommunication() {; }
	virtual tVoid vTraceInfo(){; }

//User Define Code Starts
private:
	uInputAdaptor _KeyInputAdapter_HK;		//Device to be used for Hard key simulation
	uInputAdaptor _KeyInputAdapter_SWC;		//Device to be used for SWC simulation
	uInputAdaptor _KeyInputAdapter_ITCOMM;	// Device to be used for IT Commander key simulation

	uInputAdaptor _KeyInputAdapter_AllKeys; //This Device contains all keys which will be used by Guesture Replay and Diagnostics key injection
public:
	tBool simulateKey(E_UINPUT_EVENT_TYPE eKeyDeviceType, tU16 KeyCode, tS32 Value);
	tBool sendInputEvent(E_UINPUT_EVENT_TYPE eKeyDeviceType, struct input_event Event);
    E_UINPUT_EVENT_TYPE selectKeyDevice(tU16 KeyCode);

	tS32 getUInputFD(tString dev_name)
	{

		if(strcmp(dev_name,"HardKey") == 0)
		{
			return _KeyInputAdapter_HK.getFD();
		}
		else if(strcmp(dev_name,"SWCKey") == 0)
		{
			return _KeyInputAdapter_SWC.getFD();
		}
		else if(strcmp(dev_name,"ITCommKey") == 0)
		{
			return _KeyInputAdapter_ITCOMM.getFD();
		}
		else
		{
			return _KeyInputAdapter_AllKeys.getFD();
		}
	}

//User Define Code Ends
};

#endif /* KEYSIMAPP_H_ */
