/*
 * EncSimApp.cpp
 *
 *  Created on: Sep 30, 2015
 *      Author: sgt4kor
 */

#include "EncSimApp.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../etg_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_INPUT_APPLICATION
#include "trcGenProj/Header/EncSimApp.cpp.trc.h"
#endif

EncSimApp::EncSimApp(vd_input_tclMain* poMain):Ivd_inputBase(poMain), _EncInputAdapter(E_UINPUT_EV_ENCODER)
{
	if(TRUE == _EncInputAdapter.configureDevice(E_UINPUT_EV_ENCODER))
	{
		ETG_TRACE_USR4(("Constructor EncSimApp::EncSimApp():_EncInputAdapter(E_UINPUT_EV_ENCODER) Success"));
	}
}

EncSimApp::~EncSimApp()
{
	ETG_TRACE_USR4(("Destructor EncSimApp::~EncSimApp():_EncInputAdapter(E_UINPUT_EV_ENCODER)"));
}

tBool EncSimApp::simulateEncoderRotation(tU16 EncType, tS32 Steps)
{
	tBool bSimSuccess = FALSE;

	if(TRUE ==_EncInputAdapter.bIsuInputReady)
	{
		if(0 != _EncInputAdapter.sendEncoderEvent(EncType, Steps))
		{
			bSimSuccess = TRUE;
			ETG_TRACE_USR4(("EncSimApp::simulateEncoderRotation->Success"));
		}
		else
		{
			ETG_TRACE_USR4(("EncSimApp::simulateEncoderRotation:ERROR simulating Key"));
		}
	}

	return bSimSuccess;
}

tBool EncSimApp::sendInputEvent(struct input_event Event)
{
	tBool bSuccess = FALSE;
	if(TRUE == _EncInputAdapter.bIsuInputReady)
	{
		if( 0 != _EncInputAdapter.sendInputEvent(Event))
		{
			bSuccess = TRUE;
			ETG_TRACE_USR4(("EncSimApp::sendInputEvent->Simulation Success..!"));
		}
		else
		{
			ETG_TRACE_USR4(("EncSimApp::sendInputEvent->Simulation Failure..!"));
		}
	}
	return bSuccess;
}
