///////////////////////////////////////////////////////////
//  ConfigurationDataHandler.h
//  Implementation of the Class ConfigurationDataHandler
//  Created on:      05-Dez-2013 12:50:44
//  Original author: mor2hi
///////////////////////////////////////////////////////////

#if !defined(EA_94E801C9_B4C6_4bc5_99C3_EAA8AB1D2BFC__INCLUDED_)
#define EA_94E801C9_B4C6_4bc5_99C3_EAA8AB1D2BFC__INCLUDED_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../Gateway/KDS/KDSAdapter.h"

#include "../Gateway/PDD/DataMirrorItf.h"
#include "../Gateway/PDD/PDD_Adapter.h"
#include "../Gateway/PDD/PDDSWRCRenault.h"

class ConfigurationDataHandler
{
public:
   ConfigurationDataHandler();
   virtual ~ConfigurationDataHandler();
   tBool makeKeyMappingForV850Available();
   tU8 getBrandType();
   tU8 getSteeringSW();
   tU8 getDisplayOrientationType();
   typedef enum{
	   eSWRCVersion1 = 0,
	   eSWRCVersion2,
	   eSWRCVersion3,
	   eSWRCVersion4,
	   eSWRCVersion5,
	   eSWRCVersion6,
	   eSWRCInavlid,
   }eRadioSatelliteType;
private:
   KDSAdapter oFactorySettings;
   PDD_Adapter oDataMirrorAdapter;
   TDataPoolScc_InputDP m_PDDData;
   tU8 getRadioSatelliteSwitchType();
   tBool sendSatelliteSwitchDataToV850(tU32* pDataBegin);
   tBool sendITCommanderDataToV850(tU32* pDataBegin);
   tBool sendRSCDataToV850(tU32* pDataBegin);
};
#endif
