///////////////////////////////////////////////////////////
//  ConfigurationDataHandler.cpp
//  Implementation of the Class ConfigurationDataHandler
//  Created on:      05-Dez-2013 12:50:44
//  Original author: mor2hi
///////////////////////////////////////////////////////////

#include "ConfigurationDataHandler.h"
#include "../Macro.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../etg_trace.h"
//Import Datapool Interface to access KDS datapool for reading Customer Configuration
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
//Import VD_INPUT datapool and header to write into Datapool PDD
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_vd_input_if.h"
#include "DataPoolSCC.h"

#define VD_INPUT_S_IMPORT_INTERFACE_KEYCODES
#include "vd_input_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_INPUT_APPLICATION
#include "trcGenProj/Header/ConfigurationDataHandler.cpp.trc.h"
#endif

//*************************************************************************************************************
//This Section Includes Array For Nissan Key Mappings - START
//*************************************************************************************************************/

// NISSAN - IT Commander and JOYSTICK Table No 5 Key mapping Data
static const sKeyEntry NissanITCommander[DATAPOOL_SCC_ITCOMMANDERDATA_NUMBER] = {
//PDD data: [hw key], [reserved key], [low logic key],  [high logic Key]
		//Direction Keys
		{ 0,  0, LB(JOYSTICK_UP), 			HB(JOYSTICK_UP) }, 				//JOYSTICK_UP
		{ 1,  0, LB(JOYSTICK_UPPER_RIGHT), 	HB(JOYSTICK_UPPER_RIGHT) }, 	//JOYSTICK_UPPER_RIGHT
		{ 2,  0, LB(JOYSTICK_RIGHT), 		HB(JOYSTICK_RIGHT) }, 			//JOYSTICK_RIGHT
		{ 3,  0, LB(JOYSTICK_LOWER_RIGHT),	HB(JOYSTICK_LOWER_RIGHT) }, 	//JOYSTICK_LOWER_RIGHT
		{ 4,  0, LB(JOYSTICK_DOWN), 	  	HB(JOYSTICK_DOWN) }, 			//JOYSTICK_DOWN
		{ 5,  0, LB(JOYSTICK_LOWER_LEFT), 	HB(JOYSTICK_LOWER_LEFT) }, 		//JOYSTICK_LOWER_LEFT
		{ 6,  0, LB(JOYSTICK_LEFT), 	  	HB(JOYSTICK_LEFT)}, 			//JOYSTICK_LEFT
		{ 7,  0, LB(JOYSTICK_UPPER_LEFT), 	HB(JOYSTICK_UPPER_LEFT) }, 		//JOYSTICK_UPPER_LEFT
		//Joystick Keys or Switches
		{ 8,  0, LB(JOYSTICK_ENTER), 		HB(JOYSTICK_ENTER) }, 			//Menu/OK -> JOYSTICK_ENTER
		{ 9,  0, LB(JOYSTICK_BACK), 		HB(JOYSTICK_BACK) }, 			//Back -> Use JOYSTICK_BACK
		{ 10, 0, LB(JOYSTICK_MAP), 			HB(JOYSTICK_MAP) }, 			//Map -> use JOYSTICK_MAP
		{ 11, 0, LB(JOYSTICK_HOME), 		HB(JOYSTICK_HOME) }, 			//Home -> use JOYSTICK_HOME

		//Unused Keys
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) } //END OF ARRAY
};

// NISSAN - REAR SEAT Table No 6 Key mapping Data
static const sKeyEntry RearSeatData[DATAPOOL_SCC_RSCDATA_NUMBER] = {
// PDD data: [hw key], [reserved key], [low logic key],  [high logic Key]
		//leading zeros in short supress excessive shift
		{ 0, 0, LB(SYS_KEY_RSC_ON_OFF), HB(SYS_KEY_RSC_ON_OFF) },	//lint !e572 !e778	//ON/OFF -> Use SYS_KEY_POWER.
		{ 1, 0, LB(SWC_VOL_UP),    		HB(SWC_VOL_UP) },			//lint !e572 !e778  //Volume Up
		{ 2, 0, LB(SWC_VOL_DOWN),  		HB(SWC_VOL_DOWN) },			//lint !e572 !e778  //Volume Down
		{ 3, 0, LB(SWC_SEEK_UP),   		HB(SWC_SEEK_UP) },			//lint !e572 !e778  //Tune/Track Up
		{ 4, 0, LB(SWC_SEEK_DOWN), 		HB(SWC_SEEK_DOWN) },		//lint !e572 !e778  //Tune/Track Down
		{ 5, 0, LB(SWC_OK),        		HB(SWC_OK) },				//lint !e572 !e778  //SRC

		//Unused Keys
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) }
};

//*************************************************************************************************************
//This Section Includes Array For Renault Key Mappings
//*************************************************************************************************************/
#if 0
// Renault - Satellite Switch Table No 4 Key mapping Data; common for variant 1
static const sKeyEntry RenaultSWRCVariant1Data[DATAPOOL_SCC_TABLE4DATA_NUMBER] = {
// PDD data: [hw key], [reserved key], [low logic key],  [high logic Key]

		{1,    0, LB(SWC_VOL_UP), 		   		  HB(SWC_VOL_UP)},  				//lint !e572 !e778 //SWC_VOL_UP
		{2,    0, LB(SWC_VOL_DOWN), 	   		  HB(SWC_VOL_DOWN)},  				//lint !e572 !e778 //SWC_VOL_DOWN
		{3,    0, LB(SWC_MUTE), 		   		  HB(SWC_MUTE)},  					//lint !e572 !e778 //Mute Temporarily mapped to SWC_UP
		{4,    0, LB(SWC_AUDIO_SRC_UP),    		  HB(SWC_AUDIO_SRC_UP)},  			//lint !e572 !e778 //AUDIO_SRC_UP temporary mapped to SWC_OK
		{5,	   0, LB(SWC_AUDIO_SRC_DOWN),  		  HB(SWC_AUDIO_SRC_DOWN)},  		//lint !e572 !e778 //AUDIO_SRC_DOWN temporary mapped to SWC_TEL_HANGUP
		{6,    0, LB(SWC_MODE), 		   		  HB(SWC_MODE)},  					//lint !e572 !e778 //OK/MODE temporary mapped to SWC_TEL_VR
		{0x82, 0, LB(HK_VIRT_VOL_COMBI),   		  HB(HK_VIRT_VOL_COMBI)},
		{0x81, 0, LB(HK_VIRT_AUDIO_MODE_COMBI),   HB(HK_VIRT_AUDIO_MODE_COMBI)},
		//UNUSED KEYS
		//{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		//{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)}

};
#endif

#if 0
// Renault - Satellite Switch Table No 4 Key mapping Data; for variant 2
static const sKeyEntry RenaultSWRCVariant2Data[DATAPOOL_SCC_TABLE4DATA_NUMBER] = {
// PDD data: [hw key], [reserved key], [low logic key],  [high logic Key]

		{1,    0, LB(SWC_VOL_UP), 		   		 HB(SWC_VOL_UP)},  				//lint !e572 !e778 //SWC_VOL_UP
		{2,    0, LB(SWC_VOL_DOWN), 	   		 HB(SWC_VOL_DOWN)},  				//lint !e572 !e778 //SWC_VOL_DOWN
		{4,    0, LB(SWC_AUDIO_SRC_UP),   		 HB(SWC_AUDIO_SRC_UP)},  			//lint !e572 !e778 //AUDIO_SRC_UP temporary mapped to SWC_OK
		{5,    0, LB(SWC_AUDIO_SRC_DOWN),  		 HB(SWC_AUDIO_SRC_DOWN)},  		//lint !e572 !e778 //AUDIO_SRC_DOWN temporary mapped to SWC_TEL_HANGUP
		{6,    0, LB(SWC_MODE), 		   		 HB(SWC_MODE)},  					//lint !e572 !e778 //OK/MODE temporary mapped to SWC_TEL_VR
		{0x82, 0, LB(HK_VIRT_VOL_COMBI),  		 HB(HK_VIRT_VOL_COMBI)},
		{0x81, 0, LB(HK_VIRT_AUDIO_MODE_COMBI),  HB(HK_VIRT_AUDIO_MODE_COMBI)},
		//UNUSED KEYS
		//{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		//{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)}

};

#endif

#if 0

// Renault - Satellite Switch Table No 4 Key mapping Data; common for variant 3
static const sKeyEntry RenaultSWRCVariant3Data[DATAPOOL_SCC_TABLE4DATA_NUMBER] = {
// PDD data: [hw key], [reserved key], [low logic key],  [high logic Key]

		{1,    0, LB(SWC_VOL_UP), 		  		 HB(SWC_VOL_UP)},  				//lint !e572 !e778 //SWC_VOL_UP
		{2,    0, LB(SWC_VOL_DOWN), 	   		 HB(SWC_VOL_DOWN)},  				//lint !e572 !e778 //SWC_VOL_DOWN
		{3,    0, LB(SWC_PHONE_MUTE_DUO),  		 HB(SWC_PHONE_MUTE_DUO)},  		//lint !e572 !e778 //Mute and phone both
		{4,    0, LB(SWC_AUDIO_SRC_UP),   		 HB(SWC_AUDIO_SRC_UP)},  			//lint !e572 !e778 //AUDIO_SRC_UP temporary mapped to SWC_OK
		{5,    0, LB(SWC_AUDIO_SRC_DOWN), 		 HB(SWC_AUDIO_SRC_DOWN)},  		//lint !e572 !e778 //AUDIO_SRC_DOWN temporary mapped to SWC_TEL_HANGUP
		{6,    0, LB(SWC_MODE), 		   		 HB(SWC_MODE)},  					//lint !e572 !e778 //OK/MODE temporary mapped to SWC_TEL_VR
		{0x82, 0, LB(HK_VIRT_VOL_COMBI),  		 HB(HK_VIRT_VOL_COMBI)},
		{0x81, 0, LB(HK_VIRT_AUDIO_MODE_COMBI),  HB(HK_VIRT_AUDIO_MODE_COMBI)},
		//UNUSED KEYS
		//{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		//{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)}

};

// Renault - Satellite Switch Table No 4 Key mapping Data; common for variant 4
static const sKeyEntry RenaultSWRCVariant4Data[DATAPOOL_SCC_TABLE4DATA_NUMBER] = {
// PDD data: [hw key], [reserved key], [low logic key],  [high logic Key]

		{1,    0, LB(SWC_VOL_UP), 				   HB(SWC_VOL_UP)},  				//lint !e572 !e778 //SWC_VOL_UP
		{2,    0, LB(SWC_VOL_DOWN), 	  		   HB(SWC_VOL_DOWN)},  				//lint !e572 !e778 //SWC_VOL_DOWN
		{4,    0, LB(SWC_AUDIO_SRC_UP),    		   HB(SWC_AUDIO_SRC_UP)},  			//lint !e572 !e778 //AUDIO_SRC_UP temporary mapped to SWC_OK
		{5,    0, LB(SWC_TEL_HANG_UP),     		   HB(SWC_TEL_HANG_UP)},  				//lint !e572 !e778 //SWC_TEL_HANG_UP Phone
		{6,    0, LB(SWC_MODE), 		   		   HB(SWC_MODE)},  					//lint !e572 !e778 //OK/MODE temporary mapped to SWC_TEL_VR
		{0x82, 0, LB(HK_VIRT_VOL_COMBI),   		   HB(HK_VIRT_VOL_COMBI)},
		{0x81, 0, LB(HK_VIRT_AUDIO_MODE_COMBI),    HB(HK_VIRT_AUDIO_MODE_COMBI)},
		//UNUSED KEYS
		//{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		//{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)}

};

// Renault - Satellite Switch Table No 4 Key mapping Data; common for variant 5
static const sKeyEntry RenaultSWRCVariant5Data[DATAPOOL_SCC_TABLE4DATA_NUMBER] = {
// PDD data: [hw key], [reserved key], [low logic key],  [high logic Key]

		{1,    0, LB(SWC_VOL_UP), 		 		 HB(SWC_VOL_UP)},  				//lint !e572 !e778 //SWC_VOL_UP
		{2,    0, LB(SWC_VOL_DOWN), 	  	   	 HB(SWC_VOL_DOWN)},  				//lint !e572 !e778 //SWC_VOL_DOWN
		{3,    0, LB(SWC_TEL_HANG_UP),    	 	 HB(SWC_TEL_HANG_UP)},  			//lint !e572 !e778 //SWC_TEL_HANG_UP Phone
		{4,    0, LB(SWC_AUDIO_SRC_UP),    		 HB(SWC_AUDIO_SRC_UP)},  			//lint !e572 !e778 //AUDIO_SRC_UP temporary mapped to SWC_OK
		{5,    0, LB(SWC_AUDIO_SRC_DOWN),  	     HB(SWC_AUDIO_SRC_DOWN)},  		//lint !e572 !e778 //AUDIO_SRC_DOWN
		{6,    0, LB(SWC_TEL_VR), 		  		 HB(SWC_TEL_VR)},  				//lint !e572 !e778 //VR temporary mapped to SWC_TEL_VR
		{0x82, 0, LB(HK_VIRT_VOL_COMBI),  		 HB(HK_VIRT_VOL_COMBI)},
		{0x81, 0, LB(HK_VIRT_AUDIO_MODE_COMBI),  HB(HK_VIRT_AUDIO_MODE_COMBI)},
		//UNUSED KEYS
		//{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		//{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)}

};
#endif


#if 0

// Renault - Satellite Switch Table No 4 Key mapping Data; common for variant 6
static const sKeyEntry RenaultSWRCVariant6Data[DATAPOOL_SCC_TABLE4DATA_NUMBER] = {
// PDD data: [hw key], [reserved key], [low logic key],  [high logic Key]

		{1,    0, LB(SWC_VOL_UP), 				   HB(SWC_VOL_UP)},  				//lint !e572 !e778 //SWC_VOL_UP
		{2,    0, LB(SWC_VOL_DOWN), 	  		   HB(SWC_VOL_DOWN)},  				//lint !e572 !e778 //SWC_VOL_DOWN
		{4,    0, LB(SWC_AUDIO_SRC_UP),    		   HB(SWC_AUDIO_SRC_UP)},  			//lint !e572 !e778 //AUDIO_SRC_UP temporary mapped to SWC_OK
		{5,    0, LB(SWC_PHONE_VR),     		   HB(SWC_PHONE_VR)},  				//lint !e572 !e778 //SWC_TEL_HANG_UP Phone
		{6,    0, LB(SWC_MODE), 		   		   HB(SWC_MODE)},  					//lint !e572 !e778 //OK/MODE temporary mapped to SWC_TEL_VR
		{0x82, 0, LB(HK_VIRT_VOL_COMBI),   		   HB(HK_VIRT_VOL_COMBI)},
		{0x81, 0, LB(HK_VIRT_AUDIO_MODE_COMBI),    HB(HK_VIRT_AUDIO_MODE_COMBI)},
		//UNUSED KEYS
		//{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		//{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)},
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID)}

};

#endif
// Renault - Central Switch Table No 5 Key mapping Data
static const sKeyEntry RenaultCentralSwitchData[DATAPOOL_SCC_ITCOMMANDERDATA_NUMBER] = {
// PDD data: [hw key], [reserved key], [low logic key],  [high logic Key]
		//Need Short press and Long press Keys
		{ 0x00, 0, LB(JOYSTICK_BACK), 			  HB(JOYSTICK_BACK) },				//Back -> Use JOYSTICK_BACK
		{ 0x40, 0, LB(JOYSTICK_BACK_LONGPRESS),   HB(JOYSTICK_BACK_LONGPRESS) },	//LBack -> Use HMI HK_BACK key Long
		{ 0x01, 0, LB(JOYSTICK_HOME), 			  HB(JOYSTICK_HOME) },   			//Home -> use JOYSTICK_HOME
		{ 0x41, 0, LB(JOYSTICK_HOME_LONGPRESS),   HB(JOYSTICK_HOME_LONGPRESS) },   	//LHome -> use JOYSTICK_HOME LONG
		{ 0x02, 0, LB(JOYSTICK_OPTION), 		  HB(JOYSTICK_OPTION) },			//Option -> Use JOYSTICK_OPTION
		{ 0x42, 0, LB(JOYSTICK_OPTION_LONGPRESS), HB(JOYSTICK_OPTION_LONGPRESS) },	//LOption -> Use JOYSTICK_OPTION Long
		{ 0x03, 0, LB(JOYSTICK_ENTER), 			  HB(JOYSTICK_ENTER) },				//Menu/OK -> JOYSTICK_ENTER
		{ 0x43, 0, LB(JOYSTICK_ENTER_LONGPRESS),  HB(JOYSTICK_ENTER_LONGPRESS) },	//LMenu/OK -> JOYSTICK_ENTER LONG

		//Unused Keys
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) }
};

// Renault - Joystick Directional Switch Table No 6 Key mapping Data
static const sKeyEntry RenaultCSMJoystick[DATAPOOL_SCC_RSCDATA_NUMBER] = {
//PDD data: [hw key], [reserved key], [low logic key],  [high logic Key]
		//Need Short press and Long press Keys
		{ 0x01, 0, LB(JOYSTICK_UP),    HB(JOYSTICK_UP) }, 		//JOYSTICK_UP
		{ 0x02, 0, LB(JOYSTICK_DOWN),  HB(JOYSTICK_DOWN) }, 	//JOYSTICK_DOWN
		{ 0x03, 0, LB(JOYSTICK_LEFT),  HB(JOYSTICK_LEFT) }, 	//JOYSTICK_LEFT
		{ 0x04, 0, LB(JOYSTICK_RIGHT), HB(JOYSTICK_RIGHT) }, 	//JOYSTICK_RIGHT
		//LONG PRESS and Short Press have same meaning here
		{ 0x41, 0, LB(JOYSTICK_UP),    HB(JOYSTICK_UP) }, 		//JOYSTICK_UP Long
		{ 0x42, 0, LB(JOYSTICK_DOWN),  HB(JOYSTICK_DOWN) }, 	//JOYSTICK_DOWN Long
		{ 0x43, 0, LB(JOYSTICK_LEFT),  HB(JOYSTICK_LEFT) }, 	//JOYSTICK_LEFT Long
		{ 0x44, 0, LB(JOYSTICK_RIGHT), HB(JOYSTICK_RIGHT) }, 	//JOYSTICK_RIGHT Long

		//Unused Keys
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) }
};

//*************************************************************************************************************
//This Section Includes Array For Nissan and Renault IT Commander Mappings - END
//*************************************************************************************************************/
//Alok
//*************************************************************************************************************
//This Section Includes Array For PIVI IT Commander Key Mappings - START
//*************************************************************************************************************/
static const sKeyEntry PIVI_ITCommander[DATAPOOL_SCC_ITCOMMANDERDATA_NUMBER] = {
//PDD data: [hw key], [reserved key], [low logic key],  [high logic Key]
        //Direction keys
		{ 0x00, 0, LB(JOYSTICK_UP),    			HB(JOYSTICK_UP) }, 						//JOYSTICK_UP
		{ 0x01, 0, LB(JOYSTICK_UPPER_RIGHT), 	HB(JOYSTICK_UPPER_RIGHT) }, 			//JOYSTICK_UPPER_RIGHT
		{ 0x02, 0, LB(JOYSTICK_RIGHT),  	 	HB(JOYSTICK_RIGHT) }, 					//JOYSTICK_RIGHT
		{ 0x03, 0, LB(JOYSTICK_LOWER_RIGHT), 	HB(JOYSTICK_LOWER_RIGHT) }, 			//JOYSTICK_LOWER_RIGHT
		{ 0x04, 0, LB(JOYSTICK_DOWN),    	  	HB(JOYSTICK_DOWN) }, 					//JOYSTICK_DOWN
		{ 0x05, 0, LB(JOYSTICK_LOWER_LEFT),   	HB(JOYSTICK_LOWER_LEFT) }, 				//JOYSTICK_LOWER_LEFT
		{ 0x06, 0, LB(JOYSTICK_LEFT),  		  	HB(JOYSTICK_LEFT) }, 					//JOYSTICK_LEFT
		{ 0x07, 0, LB(JOYSTICK_UPPER_LEFT),   	HB(JOYSTICK_UPPER_LEFT) },				//JOYSTICK_UPPER_LEFT
		//Push Keys
		{ 0x80, 0, LB(JOYSTICK_ENTER), 		  	HB(JOYSTICK_ENTER) }, 					//JOYSTICK_ENTER
		{ 0x81, 0, LB(JOYSTICK_BACK), 		  	HB(JOYSTICK_BACK) },					//JOYSTICK_BACK
		{ 0x8C, 0, LB(JOYSTICK_MAP), 		  	HB(JOYSTICK_MAP) },						//JOYSTICK_MAP
		{ 0x9B, 0, LB(JOYSTICK_DAY_NIGHT), 		HB(JOYSTICK_DAY_NIGHT) },				//JOYSTICK_DAY_NIGHT
		{ 0xD3, 0, LB(JOYSTICK_DISP), 			HB(JOYSTICK_DISP) },					//JOYSTICK_DISP
		//Unused Keys
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) },
		{ LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID), LB(KEY_INVALID) }
};



//*************************************************************************************************************
//This Section Includes Array For PIVI IT Commander Key Mappings - END
//*************************************************************************************************************/

ConfigurationDataHandler::ConfigurationDataHandler():oFactorySettings((DataMirrorItf*) &oDataMirrorAdapter)
{
	ETG_TRACE_USR4(("vd_input ConfigurationDataHandler:ConfigurationDataHandler\n"));
	memset(&m_PDDData, 0, sizeof(m_PDDData));
}

ConfigurationDataHandler::~ConfigurationDataHandler()
{
	ETG_TRACE_USR4(("ConfigurationDataHandler::~ConfigurationDataHandler"));
	memset(&m_PDDData, 0, sizeof(m_PDDData));
}

tBool ConfigurationDataHandler::makeKeyMappingForV850Available()
{
   tBool Passed = TRUE;

   tBool Passed1 = TRUE;
   tBool Passed2 = TRUE;
   tBool Passed3 = TRUE;
   tBool Passed4 = TRUE;

   ETG_TRACE_FATAL((": vd_input ConfigurationDataHandler::makeKeyMappingForV850Available START"));

   tU8 u8BrandType = getBrandType();
   ETG_TRACE_FATAL(("KDSAdapter::Brand Type = %s\n", (u8BrandType==0)?"Renault":( (u8BrandType==1) ? "Nissan" :"Infiniti" ) ));
   //Load Key mappings from KDS
   Passed1 = oFactorySettings.getDataFromPersistantStorageAndProvideDataToV850(u8BrandType);

   //Loading Keymappings defined in Code
   if(u8BrandType == 0x00) //Renault
   {
	   ETG_TRACE_FATAL(("getBrandType(): Loading  Renault-0x%02x. Keymappings", u8BrandType));
	   //Loading Satellite Radio Switch Key mapping into Table4
	   //Depending on Variant
	   eRadioSatelliteType e8SWRCType = (eRadioSatelliteType)getRadioSatelliteSwitchType();
	   ETG_TRACE_FATAL(("The SWRCType is %d",e8SWRCType));
	   switch(e8SWRCType)
	   {
		   case eSWRCVersion1:{
			  // memcpy(m_PDDData.Table4Data.Table4Data, RenaultSWRCVariant1Data, sizeof(RenaultSWRCVariant1Data));
			   //Passed2 = sendSatelliteSwitchDataToV850(m_PDDData.Table4Data.Table4Data);
		   }
		   break;
		   case eSWRCVersion2:{
			//   memcpy(m_PDDData.Table4Data.Table4Data, RenaultSWRCVariant2Data, sizeof(RenaultSWRCVariant2Data));
			 //  Passed2 = sendSatelliteSwitchDataToV850(m_PDDData.Table4Data.Table4Data);
		   }
		   break;
		   case eSWRCVersion3:{
			//   memcpy(m_PDDData.Table4Data.Table4Data, RenaultSWRCVariant3Data, sizeof(RenaultSWRCVariant3Data));
			 //  Passed2 = sendSatelliteSwitchDataToV850(m_PDDData.Table4Data.Table4Data);
		   }
		   break;
		   case eSWRCVersion4:{
			//   memcpy(m_PDDData.Table4Data.Table4Data, RenaultSWRCVariant4Data, sizeof(RenaultSWRCVariant4Data));
			  // Passed2 = sendSatelliteSwitchDataToV850(m_PDDData.Table4Data.Table4Data);
		   }
		   break;
		   case eSWRCVersion5:{
			//   memcpy(m_PDDData.Table4Data.Table4Data, RenaultSWRCVariant5Data, sizeof(RenaultSWRCVariant5Data));
			 //  Passed2 = sendSatelliteSwitchDataToV850(m_PDDData.Table4Data.Table4Data);
		   }
		   break;
		   case eSWRCVersion6:{
		   	//	memcpy(m_PDDData.Table4Data.Table4Data, RenaultSWRCVariant6Data, sizeof(RenaultSWRCVariant6Data));
		   	//	Passed2 = sendSatelliteSwitchDataToV850(m_PDDData.Table4Data.Table4Data);
		   }
		   break;
		   default:{
			//   memcpy(m_PDDData.Table4Data.Table4Data, RenaultSWRCVariant1Data, sizeof(RenaultSWRCVariant1Data));
			//   Passed2 = sendSatelliteSwitchDataToV850(m_PDDData.Table4Data.Table4Data);
		   }
		   break;
	   }


	   //Load Renault Central Switch Key mapping Table
	   memcpy(m_PDDData.ITCommanderData.ITCommanderData, RenaultCentralSwitchData, sizeof(RenaultCentralSwitchData));
	   //Load Renault Central Switch Joystick Data
	   memcpy(m_PDDData.RSCData.RSCData, RenaultCSMJoystick, sizeof(RenaultCSMJoystick));

   }
   else if(u8BrandType == 0x01)		//Nissan
   {
	   ETG_TRACE_FATAL(("getBrandType(): Loading Nissan-0x%02x. Keymappings", u8BrandType)); 
	   //Load Nissan IT commander Key mapping Table
	   memcpy(m_PDDData.ITCommanderData.ITCommanderData, NissanITCommander, sizeof(NissanITCommander));

	   //Copy Contents from RearSeatData key mapping table
	   memcpy(m_PDDData.RSCData.RSCData, RearSeatData, sizeof(RearSeatData));
   }
   else if(u8BrandType == 0x02)		//PIVI
   {
	   ETG_TRACE_FATAL(("getBrandType(): Loading PIVI-0x%02x. Keymappings", u8BrandType));
	   //Load PIVI IT commander Key mapping Table
	   memcpy(m_PDDData.ITCommanderData.ITCommanderData, PIVI_ITCommander, sizeof(PIVI_ITCommander));

	   //Copy Contents from RearSeatData key mapping table(Nissan data loaded by default)
	   memcpy(m_PDDData.RSCData.RSCData, RearSeatData, sizeof(RearSeatData));
   }
   else
   {
	   ETG_TRACE_FATAL(("ERROR: No Brand Types has been selected"));
	   ETG_TRACE_FATAL(("getBrandType(): Loading Nissan-0x%02x. Keymappings", u8BrandType));
   }

   //Now send the Tables to DataPool
   Passed3 = sendITCommanderDataToV850(m_PDDData.ITCommanderData.ITCommanderData);
   Passed4 = sendRSCDataToV850(m_PDDData.RSCData.RSCData);

   if(Passed1==TRUE && Passed2==TRUE && Passed3==TRUE && Passed4==TRUE)
   {
	   Passed = TRUE;
	   ETG_TRACE_FATAL((": vd_input ConfigurationDataHandler::makeKeyMappingForV850Available SUCCESS !!\n"));
   }
   else
   {
       Passed = FALSE;
	   ETG_TRACE_FATAL((": vd_input ConfigurationDataHandler::makeKeyMappingForV850Available FAILED !!\n"));
   }
   return (Passed);
}

tU8 ConfigurationDataHandler::getDisplayOrientationType()
{
/* Display Orientation/Format :  Portrait -> 0x01
								 Landscape-> 0x00
*/
	tU8 u8Orientation=0xFF;
	//   DP_S32_NO_ERR == DP_s32GetConfigItem("AIVIVariantCoding", "DisplayOrientation", &u8Orientation, 1)
	if ( DP_S32_NO_ERR == DP_s32GetConfigItem("HMIConfig", "DisplayFormat", &u8Orientation, 1) )
	{
	   ETG_TRACE_USR4(("getDisplayOrientationType(): KDS Read:Display Orienation is 0x%02x.", u8Orientation));
	}
	else
	{
		ETG_TRACE_USR4(("getDisplayOrientationType(): KDS Read:Display Orienation ERROR."));
	}
	return u8Orientation;
}

// Element - SystemConfiguration1,  Item - TouchScreenConfiguration
// if ( DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1", "TouchScreenConfiguration", &u8Orientation, 1) )
	

tU8 ConfigurationDataHandler::getBrandType()
{
	/*AllianceBrandType 3 Bit
	* [0x00] Renault
	* [0x01] Nissan
	* [0x02] Infiniti*/
	tU8 u8Brand = 0x04; //set some invalid
	if ( DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1", "Brand", &u8Brand, 1) )
	{
	   ETG_TRACE_USR4(("_u8GetBrand(): KDS Region is 0x%02x.", u8Brand));
	}
	else
	{
	   // Set the Default Brand as Nissan
		u8Brand = 0x01;
	   ETG_TRACE_ERR(("_u8GetBrand(): KDS Region Read Failed. Setting region as USA"));
	}
	return u8Brand;
}

tU8 ConfigurationDataHandler::getSteeringSW()
{
	/*3 Bit
	 * [0x00] None (No steering wheel controls available.)
	 * [0x01] MCAN
	 * [0x02] L12F type
	 * [0x03] X12B type
	 * [0x04] RVLV 5 contacts
	 * [0x05] RVLV 4 contacts
	 * [0x06] reserved
	 * [0x07] reserved*/
	tU8 u8SteeringSWType = 0x07; //set some invalid
	if ( DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation", "SteeringSW", &u8SteeringSWType, 1) )
	{
		ETG_TRACE_FATAL(("_u8GetSteeringSW(): KDS Region is 0x%02x.", u8SteeringSWType));
	}
	else
	{
	   // Set the Default Steering Wheel = None
		u8SteeringSWType = 0x00;
	   ETG_TRACE_ERR(("_u8GetSteeringSW(): KDS Region Read Failed. Setting u8SteeringSWType as NONE"));
	}
	return u8SteeringSWType;
}


tU8 ConfigurationDataHandler::getRadioSatelliteSwitchType()
{
	/*3 Bit
	000 =Version 1
	001 =Version 2
	010 =Version 3
	011 =Version 4
	100 =Version 5
    101 =Version 6
	 */
	tU8 u8RadioSatSWType = 0x05; //set some Invalid value
	if ( DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation", "RADIOSATELLITESWITCH", &u8RadioSatSWType, 1) )
	{
		ETG_TRACE_FATAL(("_u8RadioSatSWType(): KDS Region is 0x%02x.", u8RadioSatSWType));
	}
	else
	{
	   // Set the Default Steering Wheel = None
		u8RadioSatSWType = 0x00; //set some Version 1
		ETG_TRACE_ERR(("_u8RadioSatSWType(): KDS Region Read Failed. Setting u8RadioSatSWType as NONE"));
	}
	return u8RadioSatSWType;
}


tBool ConfigurationDataHandler::sendSatelliteSwitchDataToV850(tU32* pDataBegin)
{
   ETG_TRACE_FATAL(("ConfigurationDataHandler::sendSatelliteSwitchDataToV850 -> V850 Table 4"));
   INP_POINTER_CHECK_CALL(pDataBegin);

   tBool Passed = FALSE;
   #if 0
  dp_tclInputDPTable4Data oDPData;

  if (oDPData.s32SetData(pDataBegin, DATAPOOL_SCC_TABLE4DATA_NUMBER) == DP_S32_NO_ERR)
  {
	 Passed = TRUE;
	 ETG_TRACE_FATAL(("PDD: Len: %d, 0x%*x.\n", DATAPOOL_SCC_TABLE4DATA_NUMBER,
			         ETG_LIST_LEN(sizeof(m_PDDData.Table4Data.Table4Data)),
					 ETG_LIST_PTR_T8(m_PDDData.Table4Data.Table4Data)));
  }
#endif
   return (Passed);
}

tBool ConfigurationDataHandler::sendITCommanderDataToV850(tU32* pDataBegin)
{
   ETG_TRACE_FATAL(("ConfigurationDataHandler::sendITCommanderDataToV850-> V850 Table 5"));
   INP_POINTER_CHECK_CALL(pDataBegin);

   tBool Passed = FALSE;
   dp_tclInputDPITCommanderData oDPData;

  if (oDPData.s32SetData(pDataBegin, DATAPOOL_SCC_ITCOMMANDERDATA_NUMBER) == DP_S32_NO_ERR)
  {
	 Passed = TRUE;
	 ETG_TRACE_FATAL(("PDD: Len: %d, 0x%*x.\n", DATAPOOL_SCC_ITCOMMANDERDATA_NUMBER,
			         ETG_LIST_LEN(sizeof(m_PDDData.ITCommanderData.ITCommanderData)),
					 ETG_LIST_PTR_T8(m_PDDData.ITCommanderData.ITCommanderData)));
  }

   return (Passed);
}

tBool ConfigurationDataHandler::sendRSCDataToV850(tU32* pDataBegin)
{
   ETG_TRACE_FATAL(("ConfigurationDataHandler::sendRSCDataToV850-> V850 Table 6"));
   INP_POINTER_CHECK_CALL(pDataBegin);

   tBool Passed = FALSE;
   dp_tclInputDPRSCData oDPData;

  if (oDPData.s32SetData(pDataBegin, DATAPOOL_SCC_RSCDATA_NUMBER) == DP_S32_NO_ERR)
  {
	 Passed = TRUE;
	 ETG_TRACE_FATAL(("PDD: Len: %d, 0x%*x.\n", DATAPOOL_SCC_RSCDATA_NUMBER,
			         ETG_LIST_LEN(sizeof(m_PDDData.RSCData.RSCData)),
					 ETG_LIST_PTR_T8(m_PDDData.RSCData.RSCData)));
  }

   return (Passed);
}

