/*
 * uInputAdaptor.h
 *
 *  Created on: Jul 30, 2015
 *      Author: sgt4kor
 */

#ifndef UINPUTADAPTOR_H_
#define UINPUTADAPTOR_H_

#include <stdio.h>
#include <stdlib.h>
//#include <string.h>		//Either string or string.h can be used
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <linux/input.h>
#include <linux/uinput.h>
#include <string>			//string used for std::string

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../../KeyMapping/KeyMappingCodes.h"

namespace vd_input_uInputAdaptor
{

typedef enum
{
	E_UINPUT_EV_TOUCH_B=0,
	E_UINPUT_EV_HARD_KEY,
	E_UINPUT_EV_SWC_KEY,
	E_UINPUT_EV_IT_COMMANDER_KEY,
	E_UINPUT_EV_ENCODER,
	E_UINPUT_EV_INJECT_KEY,
	E_UINPUT_EV_INVALID
}E_UINPUT_EVENT_TYPE;

class uInputAdaptor {
public:
	//uInputAdaptor(){};
	uInputAdaptor(E_UINPUT_EVENT_TYPE uInputEvType);			//Alok new constructor for all keys
	uInputAdaptor(E_UINPUT_EVENT_TYPE uInputEvType, std::string DeviceName);	//for touch only
	virtual ~uInputAdaptor();
	tBool configureDevice(E_UINPUT_EVENT_TYPE uInputEvType);
	tS32 sendInputEvent(struct input_event Event);
	tS32 sendTouchBEvent(tS32 X, tS32 Y, tS32 SlotID, tS32 Status);
	tS32 sendKeyEvent(tU16 KeyCode, tS32 Status);
	tS32 sendEncoderEvent(tU16 EncoderType, tS32 Steps);
	inline tVoid setTouchResolution(tS32 Max_X, tS32 Max_Y)
	{
		_Max_X = Max_X;
		_Max_Y = Max_Y;
	}
	tBool bIsuInputReady;
	tS32 getFD()
	{
		return _fd;
	}
private:
	tS32 _fd; //Member variable for file descriptor of uInput Device
    tS32 _Max_X;
    tS32 _Max_Y;
    tS32 init_UInputDevice(tCString cmd);
    tS32 open_UInputDevice();
    tBool configure(E_UINPUT_EVENT_TYPE uInputEvType);
    std::string _DeviceName;

};

}
#endif /* UINPUTADAPTOR_H_ */
