/*
 * uInputAdaptor.cpp
 *
 *  Created on: Jul 30, 2015
 *      Author: sgt4kor
 */

#include "uInputAdaptor.h"
using namespace vd_input_uInputAdaptor;

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define VD_INPUT_S_IMPORT_INTERFACE_KEYCODES
#include "vd_input_if.h"

//#define SYSTEM_INIT_COMMAND "modprobe uinput"
//#define SYSTEM_DE_INIT_COMMAND "rmmod uinput"
#define UINPUT_DEV_PATH "/dev/uinput"
//#define MAX_X 1280
//#define MAX_Y 768
//Alok++
uInputAdaptor::uInputAdaptor(E_UINPUT_EVENT_TYPE uInputEvType):bIsuInputReady(0), _fd(-1)
{
	_Max_X = 0;
	_Max_Y = 0;

}

//Alok--
uInputAdaptor::uInputAdaptor(E_UINPUT_EVENT_TYPE uInputEvType, std::string DeviceName):bIsuInputReady(0), _fd(-1)
{
	_Max_X = 0;
	_Max_Y = 0;
	_DeviceName = DeviceName;

}

tBool uInputAdaptor::configureDevice(E_UINPUT_EVENT_TYPE uInputEvType)
{
	tBool Status = TRUE;

	if(-1 == open_UInputDevice())
	{
		Status = FALSE;
	}
	else
	{
		Status = configure(uInputEvType);
	}
	bIsuInputReady = Status;

	return bIsuInputReady;
}

uInputAdaptor::~uInputAdaptor()
{
	//Destroy File descriptor and close the device
    if(ioctl(_fd, UI_DEV_DESTROY) >= 0)
    {
    	close(_fd);		//Successfully destroyed uinput device, so close fd
    }
    else
    	close(_fd);

    bIsuInputReady = FALSE;

}

//Public Member Functions --->
tS32 uInputAdaptor::sendInputEvent(struct input_event Event)
{
	tS32 Ret = -1;
	struct input_event EV;
	//gettimeofday(&EV.time, NULL);
	EV.time = Event.time;
	EV.code = Event.code;
	EV.type = Event.type;
	EV.value = Event.value;
    //Write into driver the no of events
	do {
		Ret = write(_fd, &EV, sizeof(struct input_event));
	}while ( (Ret == -1) && (errno == EINTR) );

	return Ret;
}

tS32 uInputAdaptor::sendTouchBEvent(tS32 X, tS32 Y, tS32 SlotID=0, tS32 Status=0)
{
	tS32 Ret;
	struct input_event ev[10];

	memset(&ev, 0, sizeof(ev));

	ev[0].type = EV_ABS;
	ev[0].code = ABS_MT_SLOT;
	ev[0].value = SlotID;

	ev[1].type = EV_ABS;
	ev[1].code = ABS_MT_TRACKING_ID;
	ev[1].value = (Status == 1)?(SlotID+1):-1;  // 1 for pressed and 0 for Released

	ev[2].type = EV_ABS;
	ev[2].code = ABS_MT_POSITION_X;
	ev[2].value = X;

	ev[3].type = EV_ABS;
	ev[3].code = ABS_MT_POSITION_Y;
	ev[3].value = Y;

	ev[4].type = EV_ABS;
	ev[4].code = ABS_MT_PRESSURE;
	ev[4].value = (Status==1)?30:0;  // 1 for pressed and 0 for Released

	ev[4].type = EV_ABS;
	ev[4].code = ABS_MT_TOUCH_MAJOR;
	ev[4].value = (Status==1)?2:0;  // 1 for pressed and 0 for Released

	ev[5].type = EV_KEY;
	ev[5].code = BTN_TOUCH;
	ev[5].value = Status; //1 for press and 0 for released

	ev[6].type = EV_ABS;
	ev[6].code = ABS_X;
	ev[6].value = X;

	ev[7].type = EV_ABS;
	ev[7].code = ABS_Y;
	ev[7].value = Y;

	ev[8].type = EV_ABS;
	ev[8].code = ABS_PRESSURE;
	ev[8].value = (Status==1)?30:0;  // 1 for pressed and 0 for Released

	ev[9].type = EV_SYN;
	ev[9].code = SYN_REPORT;
	ev[9].value = 0;

    //Write into driver the no of events
	Ret = write(_fd, ev, sizeof(ev));

	return Ret;
}

tS32 uInputAdaptor::sendKeyEvent(tU16 KeyCode, tS32 Status)
{
	tS32 Ret;
	struct input_event ev[2];

	memset(ev, 0, sizeof(ev));

	ev[0].type = EV_KEY;
	ev[0].code = KeyCode;
	ev[0].value = Status;

	ev[1].type = EV_SYN;
	ev[1].code = SYN_REPORT;
	ev[1].value = 0;
    //Write into driver the no of events
	Ret = write(_fd, ev, sizeof(ev));

	return Ret;
}

tS32 uInputAdaptor::sendEncoderEvent(tU16 EncoderType, tS32 Steps)
{
	tS32 Ret;
	struct input_event ev[2];

	memset(ev, 0, sizeof(ev));

	ev[0].type = EV_REL;
	ev[0].code = EncoderType;
	ev[0].value = Steps;

	ev[1].type = EV_SYN;
	ev[1].code = SYN_REPORT;
	ev[1].value = 0;
    //Write into driver the no of events
	Ret = write(_fd, ev, sizeof(ev));

	return Ret;
}

//Private Functions --->
tS32 uInputAdaptor::init_UInputDevice(tCString cmd)
{
   int ret =-1;
   int status =-1;

   ret = system(cmd);

   if (ret != -1)
   {
	   status = WEXITSTATUS(ret);
   }

   return status;
}

tS32 uInputAdaptor::open_UInputDevice()
{
    _fd = open(UINPUT_DEV_PATH, O_WRONLY | O_NONBLOCK);
    return _fd;
}

tBool uInputAdaptor::configure(E_UINPUT_EVENT_TYPE uInputEvType)
{
	tBool Status = TRUE;
	struct uinput_user_dev uidev; //Structure needed to configure uInput device
	memset(&uidev, 0, sizeof(uidev)); //initialize with 0

	switch(uInputEvType)
	{
		case E_UINPUT_EV_TOUCH_B:
		{
			//Configure uidev with touch B type event
			if(ioctl(_fd, UI_SET_EVBIT, EV_ABS) < 0)
				Status = FALSE;
			if(ioctl(_fd, UI_SET_ABSBIT, ABS_MT_POSITION_X) < 0)
				Status = FALSE;
			if(ioctl(_fd, UI_SET_ABSBIT, ABS_MT_POSITION_Y) < 0)
				Status = FALSE;
			if(ioctl(_fd, UI_SET_ABSBIT, ABS_MT_SLOT) < 0)
				Status = FALSE;
			if(ioctl(_fd, UI_SET_ABSBIT, ABS_MT_TRACKING_ID) < 0)
				Status = FALSE;
			if(ioctl(_fd, UI_SET_ABSBIT, ABS_MT_PRESSURE) < 0)
				Status = FALSE;
			if(ioctl(_fd, UI_SET_ABSBIT, ABS_X) < 0)
				Status = FALSE;
			if(ioctl(_fd, UI_SET_ABSBIT, ABS_Y) < 0)
				Status = FALSE;
			if(ioctl(_fd, UI_SET_ABSBIT, ABS_MT_TOUCH_MAJOR) < 0)
				Status = FALSE;
			if(ioctl(_fd, UI_SET_ABSBIT, ABS_PRESSURE) < 0)
				Status = FALSE;
			if(ioctl(_fd, UI_SET_EVBIT, EV_KEY) < 0)
				Status = FALSE;
			if(ioctl(_fd, UI_SET_KEYBIT, BTN_TOUCH) < 0)
				Status = FALSE;
			if(ioctl(_fd, UI_SET_EVBIT, EV_SYN) < 0)
				Status = FALSE;

			//If all above ioctl commands are successful then proceed
			if(FALSE != Status)
			{
				memset(&uidev, 0, sizeof(uidev));
				//Alok++
				snprintf(uidev.name, UINPUT_MAX_NAME_SIZE, _DeviceName.c_str());
				//Alok--
				uidev.id.bustype = BUS_USB;
				uidev.id.vendor  = 0x1;
				uidev.id.product = 0x1;
				uidev.id.version = 1;

//Alok++
				//configuring X axis parameters
				uidev.absmin[ABS_X] = 0;
				uidev.absmax[ABS_X] = _Max_X;			//Changed resolution to 1280x768 for PIVI
				uidev.absfuzz[ABS_X] = 0;
				uidev.absflat[ABS_X] = 0;
				//Configure Y axis parameters
				uidev.absmin[ABS_Y] = 0;
				uidev.absmax[ABS_Y] = _Max_Y;
				uidev.absfuzz[ABS_Y] = 0;
				uidev.absflat[ABS_Y] = 0;

				//configuring X axis parameters
				uidev.absmin[ABS_MT_POSITION_X] = 0;
				uidev.absmax[ABS_MT_POSITION_X] = _Max_X;
				uidev.absfuzz[ABS_MT_POSITION_X] = 0;
				uidev.absflat[ABS_MT_POSITION_X] = 0;
				//Configure Y axis parameters
				uidev.absmin[ABS_MT_POSITION_Y] = 0;
				uidev.absmax[ABS_MT_POSITION_Y] = _Max_Y;
				uidev.absfuzz[ABS_MT_POSITION_Y] = 0;
				uidev.absflat[ABS_MT_POSITION_Y] = 0;
//Alok--
				uidev.absmin[ABS_PRESSURE] = 0;
				uidev.absmax[ABS_PRESSURE] = 255;
				uidev.absmin[ABS_MT_PRESSURE] = 0;
				uidev.absmax[ABS_MT_PRESSURE] = 255;
				uidev.absmin[ABS_MT_SLOT]=0;
				uidev.absmax[ABS_MT_SLOT]=9; //Indicating 9 multi touch supported events
				uidev.absmin[ABS_MT_TOUCH_MAJOR]=0;
				uidev.absmax[ABS_MT_TOUCH_MAJOR]=255;
                //Creating a Device Now
			    if(write(_fd, &uidev, sizeof(uidev)) < 0)
			    	Status = FALSE;
			    if(ioctl(_fd, UI_DEV_CREATE) < 0)
			        Status = FALSE;
			}

		}
		break;
		case E_UINPUT_EV_HARD_KEY:
		{
			if(ioctl(_fd, UI_SET_EVBIT, EV_KEY) < 0)
				Status = FALSE;
			if(ioctl(_fd, UI_SET_EVBIT, EV_SYN) < 0)
				Status = FALSE;

			//-------------------------------------------------------------------------------------------
			//	Hard Keys Block Start
			//-------------------------------------------------------------------------------------------
			for(tU16 hardkeys=(HK_DUMMY_START+1); hardkeys<HK_DUMMY_END; hardkeys++)
			{
				if(ioctl(_fd, UI_SET_KEYBIT, hardkeys) < 0)
					Status = FALSE;
			}
			for(tU16 hardkeysL=HK_MENU_LONG; hardkeysL<HK_LONG_PRESS_RESERVED; hardkeysL++)
			{
				if(ioctl(_fd, UI_SET_KEYBIT, hardkeysL) < 0)
					Status = FALSE;
			}
		    //For Virtual Key Test Mode
			if(ioctl(_fd, UI_SET_KEYBIT, HK_VIRT_SRV_TESTMODE) < 0)
				Status = FALSE;
			//-------------------------------------------------------------------------------------------
			//	hard Keys Block END
			//-------------------------------------------------------------------------------------------

			//If all above ioctl commands are successful then proceed
			if(FALSE != Status)
			{
				memset(&uidev, 0, sizeof(uidev));
				snprintf(uidev.name, UINPUT_MAX_NAME_SIZE,  _DeviceName.c_str());
				uidev.id.bustype = BUS_USB;
				uidev.id.vendor  = 0x1;
				uidev.id.product = 0x1;
				uidev.id.version = 1;
                //Creating a Device Now
			    if(write(_fd, &uidev, sizeof(uidev)) < 0)
			    	Status = FALSE;
			    if(ioctl(_fd, UI_DEV_CREATE) < 0)
			        Status = FALSE;
			   // Status = configureNewDevice();
			}
		}
		break;
		case E_UINPUT_EV_SWC_KEY:
		{
			if(ioctl(_fd, UI_SET_EVBIT, EV_KEY) < 0)
				Status = FALSE;
			if(ioctl(_fd, UI_SET_EVBIT, EV_SYN) < 0)
				Status = FALSE;

			//-------------------------------------------------------------------------------------------
			//	SWC Keys Block Start
			//-------------------------------------------------------------------------------------------
			for(tU16 SWCs = (SWC_DUMMY_START+1); SWCs<SWC_DUMMY_END; SWCs++)
			{
				if(ioctl(_fd, UI_SET_KEYBIT, SWCs) < 0)
					Status = FALSE;
			}
			//-------------------------------------------------------------------------------------------
			//	SWC Keys Block End
			//-------------------------------------------------------------------------------------------

			//If all above ioctl commands are successful then proceed
			if(FALSE != Status)
			{
				memset(&uidev, 0, sizeof(uidev));
				snprintf(uidev.name, UINPUT_MAX_NAME_SIZE,  _DeviceName.c_str());
				uidev.id.bustype = BUS_USB;
				uidev.id.vendor  = 0x1;
				uidev.id.product = 0x1;
				uidev.id.version = 1;
                //Creating a Device Now
			    if(write(_fd, &uidev, sizeof(uidev)) < 0)
			    	Status = FALSE;
			    if(ioctl(_fd, UI_DEV_CREATE) < 0)
			        Status = FALSE;
			   // Status = configureNewDevice();
			}
		}
		break;
		case E_UINPUT_EV_IT_COMMANDER_KEY:
		{
			if(ioctl(_fd, UI_SET_EVBIT, EV_KEY) < 0)
				Status = FALSE;
			if(ioctl(_fd, UI_SET_EVBIT, EV_SYN) < 0)
				Status = FALSE;

		    //-------------------------------------------------------------------------------------------
		    // IT Commander Block Start
			//-------------------------------------------------------------------------------------------

		    for( tU16 Joystick = (JOYSTICK_DUMMY_START+1); Joystick<JOYSTICK_DUMMY_END; Joystick++)
		    {
				if(ioctl(_fd, UI_SET_KEYBIT, Joystick) < 0)
					Status = FALSE;
		    }
		    for( tU16 JoystickL = JOYSTICK_OPTION_LONGPRESS; JoystickL<JOYSTICK_LONGPRESS_RESERVED; JoystickL++)
		    {
				if(ioctl(_fd, UI_SET_KEYBIT, JoystickL) < 0)
					Status = FALSE;
		    }
			//-------------------------------------------------------------------------------------------
			//	IT Commander Keys Block End
			//-------------------------------------------------------------------------------------------

			//If all above ioctl commands are successful then proceed
			if(FALSE != Status)
			{
				memset(&uidev, 0, sizeof(uidev));
				snprintf(uidev.name, UINPUT_MAX_NAME_SIZE,  _DeviceName.c_str());
				uidev.id.bustype = BUS_USB;
				uidev.id.vendor  = 0x1;
				uidev.id.product = 0x1;
				uidev.id.version = 1;
                //Creating a Device Now
			    if(write(_fd, &uidev, sizeof(uidev)) < 0)
			    	Status = FALSE;
			    if(ioctl(_fd, UI_DEV_CREATE) < 0)
			        Status = FALSE;
			   // Status = configureNewDevice();
			}
		}
		break;
		case E_UINPUT_EV_INJECT_KEY:
		{
			if(ioctl(_fd, UI_SET_EVBIT, EV_KEY) < 0)
				Status = FALSE;
			if(ioctl(_fd, UI_SET_EVBIT, EV_SYN) < 0)
				Status = FALSE;


			//-------------------------------------------------------------------------------------------
			//	Hard Keys Block Start
			//-------------------------------------------------------------------------------------------
			for(tU16 hardkeys=(HK_DUMMY_START+1); hardkeys<HK_DUMMY_END; hardkeys++)
			{
				if(ioctl(_fd, UI_SET_KEYBIT, hardkeys) < 0)
					Status = FALSE;
			}
			for(tU16 hardkeysL=HK_MENU_LONG; hardkeysL<HK_LONG_PRESS_RESERVED; hardkeysL++)
			{
				if(ioctl(_fd, UI_SET_KEYBIT, hardkeysL) < 0)
					Status = FALSE;
			}
		    //For Virtual Key Test Mode
			if(ioctl(_fd, UI_SET_KEYBIT, HK_VIRT_SRV_TESTMODE) < 0)
				Status = FALSE;
			//-------------------------------------------------------------------------------------------
			//	hard Keys Block END
			//-------------------------------------------------------------------------------------------

			//-------------------------------------------------------------------------------------------
			//	SWC Keys Block Start
			//-------------------------------------------------------------------------------------------
			for(tU16 SWCs = (SWC_DUMMY_START+1); SWCs<SWC_DUMMY_END; SWCs++)
			{
				if(ioctl(_fd, UI_SET_KEYBIT, SWCs) < 0)
					Status = FALSE;
			}
			//-------------------------------------------------------------------------------------------
			//	SWC Keys Block End
			//-------------------------------------------------------------------------------------------

		    //-------------------------------------------------------------------------------------------
		    // IT Commander Block Start
			//-------------------------------------------------------------------------------------------

		    for( tU16 Joystick = (JOYSTICK_DUMMY_START+1); Joystick<JOYSTICK_DUMMY_END; Joystick++)
		    {
				if(ioctl(_fd, UI_SET_KEYBIT, Joystick) < 0)
					Status = FALSE;
		    }
		    for( tU16 JoystickL = JOYSTICK_OPTION_LONGPRESS; JoystickL<JOYSTICK_LONGPRESS_RESERVED; JoystickL++)
		    {
				if(ioctl(_fd, UI_SET_KEYBIT, JoystickL) < 0)
					Status = FALSE;
		    }
			//-------------------------------------------------------------------------------------------
			//	IT Commander Keys Block End
			//-------------------------------------------------------------------------------------------

			//If all above ioctl commands are successful then proceed
			if(FALSE != Status)
			{
				memset(&uidev, 0, sizeof(uidev));
				snprintf(uidev.name, UINPUT_MAX_NAME_SIZE,  _DeviceName.c_str());
				uidev.id.bustype = BUS_USB;
				uidev.id.vendor  = 0x1;
				uidev.id.product = 0x1;
				uidev.id.version = 1;
                //Creating a Device Now
			    if(write(_fd, &uidev, sizeof(uidev)) < 0)
			    	Status = FALSE;
			    if(ioctl(_fd, UI_DEV_CREATE) < 0)
			        Status = FALSE;
			   // Status = configureNewDevice();
			}
		}
		break;
		case E_UINPUT_EV_ENCODER:
		{
			if(ioctl(_fd, UI_SET_EVBIT, EV_REL) < 0)
				Status = FALSE;
			if(ioctl(_fd, UI_SET_EVBIT, EV_SYN) < 0)
				Status = FALSE;

			if(ioctl(_fd, UI_SET_RELBIT, REL_CENTRAL_SWITCH_ROTARY) < 0)
				Status = FALSE;
		    if(ioctl(_fd, UI_SET_RELBIT, REL_LEFT_ENCODER) < 0)
		    	Status = FALSE;
			if(ioctl(_fd, UI_SET_RELBIT, REL_CAN_VOLUME_ENCODER) < 0)
				Status = FALSE;
			if(ioctl(_fd, UI_SET_RELBIT, REL_RIGHT_ENCODER) < 0)
				Status = FALSE;
			if(ioctl(_fd, UI_SET_RELBIT, REL_SWRC_ENCODER) < 0)
				Status = FALSE;

			//If all above ioctl commands are successful then proceed
			if(FALSE != Status)
			{
				memset(&uidev, 0, sizeof(uidev));
				snprintf(uidev.name, UINPUT_MAX_NAME_SIZE, "uinput-AllEncoders");
				uidev.id.bustype = BUS_USB;
				uidev.id.vendor  = 0x1;
				uidev.id.product = 0x1;
				uidev.id.version = 1;
                //Creating a Device Now
			    if(write(_fd, &uidev, sizeof(uidev)) < 0)
			    	Status = FALSE;
			    if(ioctl(_fd, UI_DEV_CREATE) < 0)
			        Status = FALSE;
			    //Status = configureNewDevice();
			}

		}
		break;
		case E_UINPUT_EV_INVALID:
		{
			Status = FALSE;
		}
		break;
		default:
		{
			Status = FALSE;
		}
		break;
	}

	return Status;
}




