/*
 * PDDKeyMatrix.cpp
 *
 *  Created on: 20.12.2013
 *      Author: mor2hi
 */
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../etg_trace.h"

#include "../KDS/KDSDefines.h"

#include "PDDKeyMatrix.h"
#include "PDDElementHandler.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_vd_input_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_INPUT_APPLICATION
#include "trcGenProj/Header/PDDKeyMatrix.cpp.trc.h"
#endif

PDDKeyMatrix::PDDKeyMatrix(tU32 AmountOfEntities): 
PDDElementHandler(AmountOfEntities)
{
   ETG_TRACE_USR4(("PDDKeyMatrix::PDDKeyMatrix: Init: Amount of entities: %d", AmountOfEntities));
}

PDDKeyMatrix::~PDDKeyMatrix()
{
   ETG_TRACE_USR4(("PDDKeyMatrix::~PDDKeyMatrix"));
}

tBool PDDKeyMatrix::storeDataPool(PDD_DATA_TYPE* pDataBegin)
{
   ETG_TRACE_FATAL(("PDDKeyMatrix::storeDataPool"));
   INP_POINTER_CHECK_CALL(pDataBegin);
   tBool Passed = FALSE;
   dp_tclInputDPKeyMatrixData oDPData;

   if (oDPData.s32SetData(pDataBegin, m_AmountOfEntities) == DP_S32_NO_ERR)
   {
	  Passed = TRUE;
	  ETG_TRACE_FATAL(("PDD: Len: %d, 0x%*x.\n", m_AmountOfEntities,
			          ETG_LIST_LEN(sizeof(m_PDDData.KeyMatrixData.KeyMatrixData)),
					  ETG_LIST_PTR_T8(m_PDDData.KeyMatrixData.KeyMatrixData)));
   }
   return (Passed);
}

tBool PDDKeyMatrix::handleData(tU32 ElementData, tU8 Element, tU8 LastServerElement)
{
   tBool Passed = FALSE;
   tU32 DataSize = sizeof(m_PDDData.KeyMatrixData.KeyMatrixData);
   shareDataWithTheOtherSide(m_PDDData.KeyMatrixData.KeyMatrixData, ElementData, PDD_KEY_MATRIX_AMOUNT_OF_ENTITIES, Element, DataSize);
   Passed = writePDDWhenLastElementIsStored(m_PDDData.KeyMatrixData.KeyMatrixData, Element, LastServerElement);

   return (Passed);
}
