/*
 * PDDElementHandler.h
 *
 *  Created on: 20.12.2013
 *      Author: mor2hi
 */

#ifndef PDDELEMENTHANDLER_H_
#define PDDELEMENTHANDLER_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "PDD_Defines.h"
#include "DataPoolSCC.h"

#include "../../Macro.h"

class PDDElementHandler
{
public:
   PDDElementHandler(tU32 AmountOfEntities);
   virtual ~PDDElementHandler();
   virtual tBool allServerElementsRead(tU8 ActualTreatedElement, tU8 LastServerElement);
   tBool DPStoreRequestGranted(tU8 ActualTreatedElement, tU8 LastServerElement);
   tVoid fillBuffer(PDD_DATA_TYPE* pDataToBeFilledFirst,tU8 PositionInDataArrayOfFirstElementToBeSetToDefault);
   virtual tVoid fillRemainingElementsWithDefaultData(PDD_DATA_TYPE* pDataBegin, tU8 ActualTreatedElement);
   virtual tBool writePDDWhenLastElementIsStored(PDD_DATA_TYPE* pDataBegin, tU8 ActualTreatedElement, tU8 LastServerElement);
   virtual tVoid shareDataWithTheOtherSide(PDD_DATA_TYPE* pDataBegin, PDD_DATA_TYPE ElementData, tU8 LastElement, tU8 ActualTreatedElement, tU32 ArraySize);
   tU32 convertElement(tU32 ElementData);
   tU8 convertElement(tU8 ElementData);

   // Set Indianness of Bytes stored in KDS for mapping
   virtual tVoid setLogicKeyByteOrder(tU8 u8FirstByte)
   {
	   m_LogicKeyByteOrder = u8FirstByte;
	   //    		         [1]       [2]             [3]               [4]
	   // IF(u8FirstByte = 0)
	   // incoming data: [hw key], [reserved key], [high Logic Key], [low logic key]
	   // IF(u8FirstByte = 1)
	   // incoming data: [hw key], [reserved key], [low Logic Key], [high logic key]
   }
protected:
   tU32 m_AmountOfEntities;
   tU8 m_LogicKeyByteOrder;
public:
   TDataPoolScc_InputDP m_PDDData;
protected:
   virtual tBool storeDataPool(PDD_DATA_TYPE* pDataBegin)
   {
	   (tVoid*)pDataBegin; //lint fix
#if defined (__INPUT_UNIT_TESTING__)
      return (TRUE);
#else
      return (FALSE);
#endif
   }
   tU32 getSize (TPddScc_Header* pInputDpHeader);
   virtual tBool handleData(tU32 ElementData, tU8 Element, tU8 LastServerElement) //lint fix
   {
	   (tVoid)ElementData; //lint fix
	   (tVoid)Element; //lint fix
	   (tVoid)LastServerElement; //lint fix
      return (FALSE);
   }

private:
   tBool writePassed(tS32 ErrorCode);

};

#endif /* PDDELEMENTHANDLER_H_ */
