/*
 * KDSDeviceFrontend.cpp
 *
 *  Created on: 06.12.2013
 *      Author: mor2hi
 */

#include "KDSDeviceFrontend.h"

#include "../../Macro.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../etg_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_INPUT_APPLICATION
#include "trcGenProj/Header/KDSDeviceFrontend.cpp.trc.h"
#endif

KDSDeviceFrontend::KDSDeviceFrontend(tU16 KDSEntityCode, tU16 KDSMapSize)
{
   DeviceDescriptor = 0;
   m_KDSEntityCode = KDSEntityCode;
   m_KDSMapSize = KDSMapSize;
   ETG_TRACE_USR4(("KDSDeviceFrontend::KDSDeviceFrontend: KDSEntityCode: 0x%x, MapSize: %d<->%d Keys\n", m_KDSEntityCode, m_KDSMapSize, ((m_KDSMapSize-6)/4)));
}

KDSDeviceFrontend::~KDSDeviceFrontend()
{
   ETG_TRACE_USR4(("KDSDeviceFrontend::~KDSDeviceFrontend"));
}

tBool KDSDeviceFrontend::openDevice()
{
   tBool Passed = FALSE;
   ETG_TRACE_USR4(("KDSDeviceFrontend::openDevice KDS Code: 0x%x", m_KDSEntityCode));
   DeviceDescriptor = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS, OSAL_EN_READONLY);

   if (DeviceDescriptor != OSAL_ERROR)
   {
      Passed = TRUE;
   }
   else
   {
      ETG_TRACE_ERR(("KDSDeviceFrontend::openDevice: failed, OSAL error code: %d", DeviceDescriptor));
   }

   return (Passed);

}

tVoid KDSDeviceFrontend::closeDevice()
{
   ETG_TRACE_USR4(("KDSDeviceFrontend::closeDevice"));
   OSAL_s32IOClose(DeviceDescriptor);
}

tBool KDSDeviceFrontend::readStoredData(tPU8 pStorage)
{
   INP_POINTER_CHECK_CALL(pStorage);
   ETG_TRACE_USR4(("KDSDeviceFrontend::readStoredData: enter:  KDS Code: 0x%x, Map Size: 0x%x", m_KDSEntityCode, m_KDSMapSize));

   tBool DataFound = FALSE;

   tsKDSEntry entryData;

   entryData.u16Entry = m_KDSEntityCode;
   entryData.u16EntryLength = m_KDSMapSize;
   entryData.u16EntryFlags = M_KDS_ENTRY_FLAG_NONE;
   entryData.au8EntryData[0] = 0;

   if (TRUE == openDevice())
   {

      int ReadReturn = (int) OSAL_s32IORead(DeviceDescriptor, (tPS8) &entryData, sizeof(entryData));
      if (OSAL_ERROR != ReadReturn)
      {

         DataFound = TRUE;
         for (int i = 0; i < getKdsMapSize(); i++)
         {
            pStorage[i] = entryData.au8EntryData[i];
         }

         ETG_TRACE_USR4(("KDSDeviceFrontend::readStoredData: passed: data: 0x%*x.", ETG_LIST_LEN(m_KDSMapSize), ETG_LIST_PTR_T8(
               pStorage)));

      }
      else
      {
         ETG_TRACE_ERR(("KDSDeviceFrontend::readStoredData: failed, OSAL error code: %d(dez), Descriptor: 0x%x, KDSEntityCode: 0x%x, MapSize: %d\n", ReadReturn, DeviceDescriptor, m_KDSEntityCode, m_KDSMapSize));

      }
      closeDevice();
   }
   return (DataFound);
}
