///////////////////////////////////////////////////////////
//  KDSDataContainer.h
//  Implementation of the Class KDSDataContainer
//  Created on:      06-Dez-2013 13:43:13
//  Original author: mor2hi
///////////////////////////////////////////////////////////

#if !defined(EA_44828428_D957_4ac6_AF6B_E6F33ACB9930__INCLUDED_)
#define EA_44828428_D957_4ac6_AF6B_E6F33ACB9930__INCLUDED_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "KDSDeviceFrontend.h"
#include "../PDD/DataMirrorItf.h"

class KDSDataContainer
{

public:
	KDSDataContainer(DataMirrorItf* pDataMirrorAdapter, tU16 KDSEntityCode, tU16 KDSEntityLength);
	virtual ~KDSDataContainer();

	tBool readPersistandDataAndMakeThemAvailableForV850();
private:
   DataMirrorItf* m_pDataMirrorAdapter;
   tU8 m_PayloadSize;
   tU16 m_KDSEntityCode; // ToDo: It's used to give the DataMirror feedback where to write the data in. Better is to give the DataContainer a callback function for data storage.

   KDSDeviceFrontend oConfigurationDataFrontend;

   tU32 getElementStartPositionInMap(tU8 ElementNumber);
   tBool WriteElementsIntoMirror(tPU8 pConfigurationData);
   tBool readAndProvideData();
};
#endif // !defined(EA_44828428_D957_4ac6_AF6B_E6F33ACB9930__INCLUDED_)
