///////////////////////////////////////////////////////////
//  KDSDataContainer.cpp
//  Implementation of the Class KDSDataContainer
//  Created on:      06-Dez-2013 13:43:13
//  Original author: mor2hi
///////////////////////////////////////////////////////////
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../etg_trace.h"

#include "KDSDataContainer.h"
#include "../../Macro.h"
#include "ConfigurationDataConverter.h"
#include "KDSDefines.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_INPUT_APPLICATION
#include "trcGenProj/Header/KDSDataContainer.cpp.trc.h"
#endif

KDSDataContainer::KDSDataContainer(DataMirrorItf* pDataMirrorAdapter, tU16 KDSEntityCode, tU16 KDSEntityLength) :
      m_PayloadSize(KDSEntityLength), m_KDSEntityCode(KDSEntityCode), oConfigurationDataFrontend(KDSEntityCode, KDSEntityLength)
{
   ETG_TRACE_USR4(("KDSDataContainer::KDSDataContainer constructor KDS Address Code: 0x%x, KDS Entity Length 0x%x", KDSEntityCode, KDSEntityLength));

   m_pDataMirrorAdapter = NULL;
   INP_POINTER_CHECK_CALL_NO_RET_VALUE(pDataMirrorAdapter);

   m_pDataMirrorAdapter = pDataMirrorAdapter;
}

KDSDataContainer::~KDSDataContainer()
{
   ETG_TRACE_USR4(("KDSDataContainer::~KDSDataContainer: m_pDataMirrorAdapter: 0x%x", m_pDataMirrorAdapter));
   m_pDataMirrorAdapter = NULL; //lint fix
}

tBool KDSDataContainer::WriteElementsIntoMirror(tPU8 pConfigurationData)
{
   INP_POINTER_CHECK_CALL(pConfigurationData);
   tU32 ElementData = 0;
   ConfigurationDataConverter oDataConverter(pConfigurationData, m_PayloadSize);

   tU8 AmountOfEntities = oDataConverter.getAmountOfEntities();
   //call readbyteofMap function with 0 as argument to get first byte
   tU8 u8FirstByte = oDataConverter.readByteOfMap(0);
   //We need to send 1st Byte which is version info
   //if its 0x00 means KDS data is BIG Indian and if its 0x01 means KDS is Little Indian
   //[Big Indian] = MSB first and [Little Indian] = LSB First
   m_pDataMirrorAdapter->configureByteOrder(m_KDSEntityCode, u8FirstByte);

   tBool ReadWritePassed = TRUE;
   for (tU8 i = 1; i <= AmountOfEntities; i++)
   {

      ElementData = oDataConverter.getDataOfAnElement(i);
      //ETG_TRACE_USR4(("KDSDataContainer::WriteElementsIntoMirror: EnityNo: %d, Data: 0x%02x", i, ElementData));
      INP_POINTER_CHECK_CALL(m_pDataMirrorAdapter);
       if (FALSE == m_pDataMirrorAdapter->storeDataSet(ElementData, i, m_KDSEntityCode, AmountOfEntities))
      {
         ReadWritePassed = FALSE;
         ETG_TRACE_FATAL(("KDSDataContainer::WriteElementsIntoMirror: ReadWritePassed: %d, Data: 0x%02x FAILED", i, ElementData));
      }

   }
   return (ReadWritePassed);
}

tBool KDSDataContainer::readAndProvideData()
{
   ETG_TRACE_USR4(("KDSDataContainer::readAndProvideData: enter"));
   tBool WritePassed = FALSE;

   tU16 KDSMapSize = oConfigurationDataFrontend.getKdsMapSize();
   tU8 KDSData[KDSMapSize];

   if (TRUE == oConfigurationDataFrontend.readStoredData(KDSData))
   {
      ETG_TRACE_USR4(("KDSDataContainer::readAndProvideData: new data in KDS found"));
      WritePassed = WriteElementsIntoMirror(KDSData);
   }

   return (WritePassed);
}

tBool KDSDataContainer::readPersistandDataAndMakeThemAvailableForV850()
{
   tBool TestPassed = FALSE;
   if (TRUE == readAndProvideData())
   {
      TestPassed = TRUE;
   }
   else
   {
      ETG_TRACE_USR4(("KDSDataContainer::readPersistandDataAndMakeThemAvailableForV850: data read failed"));
   }

   return (TestPassed);
}

