///////////////////////////////////////////////////////////
//  KDSAdapter.h
//  Implementation of the Class KDSAdapter
//  Created on:      05-Dez-2013 12:50:54
//  Original author: mor2hi
///////////////////////////////////////////////////////////

#if !defined(EA_67DD4199_A40D_490d_BC4B_E8C78EDE8012__INCLUDED_)
#define EA_67DD4199_A40D_490d_BC4B_E8C78EDE8012__INCLUDED_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_KDS_DEF
#include "system_pif.h"

#include "../PDD/DataMirrorItf.h"
#include "KDSDataContainer.h"
#include "KDSDefines.h"

class KDSAdapter
{

public:
   KDSAdapter(DataMirrorItf* pDataMirrorAdapter);
   virtual ~KDSAdapter();
   tBool getDataFromPersistantStorageAndProvideDataToV850(tU8 u8BrandType);
private:
//   MapAdministration<tU8, MessageConverterItf*> oKDSDataSet; //ToDo: handle the KDS Objects within a map
   KDSDataContainer oKeyMatrixData;
   KDSDataContainer oSystemKeyData;
   KDSDataContainer oCarBusData;
   KDSDataContainer oRLadderData;

   tBool readAndProvideKeyMatrixData();
   tBool readAndProvideSystemKeyData();
   tBool readAndProvideCarBusData();
   tBool readAndProvideSwcRladderData();

   inline tU16 _KDSEntityLength(tU8 u8NoOfKeys)
   {
	   return(tU16)( (u8NoOfKeys*4) + (tU16)KDS_VERSION_NO_LENGTH + (tU16)(KDS_AMOUNT_OF_ENTITY_PLACEHOLDER_BYTE_LENGTH) );
   }
};
#endif
